#include "stdafx.h"
#include <Resource/Load.h>

namespace ActiveBasic { namespace Resource {

namespace {

template<typename Map, typename Key, typename AddValueFunctor>
typename Map::iterator GetCacheFromMap(Map& map, Key key, AddValueFunctor f)
{
	auto low = map.lower_bound(key);
	if (low != map.end() && map.key_comp()(key, low->first))
	{
		return low;
	}
	else
	{
		typedef typename Map::key_type key_type;
		typedef typename Map::value_type value_type;
		return map.insert(low, std::make_pair(std::move(key), f()));
	}
}

HICON LoadIconCursorImpl(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load, bool isIcon)
{
	auto hrsrc = FindResource(hinst, MAKEINTRESOURCE(id), isIcon ? RT_GROUP_ICON : RT_GROUP_CURSOR);
	auto pResource = LockResource(LoadResource(hinst, hrsrc));

	auto idIcon = LookupIconIdFromDirectoryEx(reinterpret_cast<PBYTE>(pResource), isIcon, cxDesired, cyDesired, load);
	auto hrsrcIcon = FindResource(hinst, MAKEINTRESOURCE(idIcon), isIcon ? RT_ICON : RT_CURSOR);
	auto pResourceIcon = LockResource(LoadResource(hinst, hrsrcIcon));

	return CreateIconFromResourceEx(reinterpret_cast<PBYTE>(pResourceIcon),
		SizeofResource(hinst, hrsrcIcon), isIcon, 0x00030000, cxDesired, cyDesired, load);
}

}

HICON LoadIcon(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load)
{
	return LoadIconCursorImpl(hinst, id, cxDesired, cyDesired, load, true);
}

HICON LoadIcon(HINSTANCE hinst, USHORT id)
{
	return LoadIconCursorImpl(hinst, id, 32, 32, LR_SHARED, true);
}

HCURSOR LoadCursor(HINSTANCE hinst, USHORT id)
{
	return LoadIconCursorImpl(hinst, id, 32, 32, LR_SHARED, false);
}

// 񃊃\[X̓ǂݍ݂ɂĂ͈ȉQƁB
// How To Use LoadResource to Load Strings from a String Table
// http://support.microsoft.com/kb/200893/en-us
boost::optional<std::wstring> LoadString(HINSTANCE hinst, USHORT id)
{
	UINT idRsrcBlk = id / 16 + 1;
	int strIndex  = id % 16;

	auto hrsrc = FindResourceEx(hinst, RT_STRING, MAKEINTRESOURCE(idRsrcBlk), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT));
	if (hrsrc == nullptr)
		return boost::none;

	auto hRes = LoadResource(hinst, hrsrc);
	if (hRes == nullptr)
		return boost::none;
	LPCWSTR p = static_cast<LPCWSTR>(LockResource(hRes));
	if (p == nullptr)
		return boost::none;

	for (int i = 0; i < strIndex; ++i)
	{
		UINT length = *p++;
		p += length;
	}

	UINT cch = *p++;
	if (cch == 0)
	{
		return boost::none;
	}
	else
	{
		return std::wstring(p, cch);
	}
}

}}

