#include "stdafx.h"
#include <map>
#include <tuple>
#include <Resource/Load.h>

namespace ActiveBasic { namespace Resource {

namespace {

template<typename Map, typename Key, typename AddValueFunctor>
typename Map::iterator GetCacheFromMap(Map& map, Key key, AddValueFunctor f)
{
	auto low = map.lower_bound(key);
	if (low != map.end() && map.key_comp()(key, low->first))
	{
		return low;
	}
	else
	{
		typedef typename Map::key_type key_type;
		typedef typename Map::value_type value_type;
		return map.insert(low, std::make_pair(std::move(key), f()));
	}
}

HICON LoadIconCursorImpl(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load, bool isIcon)
{
	auto hrsrc = FindResource(hinst, MAKEINTRESOURCE(id), isIcon ? RT_GROUP_ICON : RT_GROUP_CURSOR);
	auto pResource = LockResource(LoadResource(hinst, hrsrc));

	auto idIcon = LookupIconIdFromDirectoryEx(reinterpret_cast<PBYTE>(pResource), isIcon, cxDesired, cyDesired, load);
	auto hrsrcIcon = FindResource(hinst, MAKEINTRESOURCE(idIcon), isIcon ? RT_ICON : RT_CURSOR);
	auto pResourceIcon = LockResource(LoadResource(hinst, hrsrcIcon));

	return CreateIconFromResourceEx(reinterpret_cast<PBYTE>(pResourceIcon),
		SizeofResource(hinst, hrsrcIcon), isIcon, 0x00030000, cxDesired, cyDesired, load);
}

}

HICON LoadIcon(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load)
{
	return LoadIconCursorImpl(hinst, id, cxDesired, cyDesired, load, true);
}

HICON LoadIcon(HINSTANCE hinst, USHORT id)
{
	return LoadIconCursorImpl(hinst, id, 32, 32, LR_SHARED, true);
}

HCURSOR LoadCursor(HINSTANCE hinst, USHORT id)
{
	return LoadIconCursorImpl(hinst, id, 32, 32, LR_SHARED, false);
}

}}

