#pragma once

#include <memory>
#include <windows.h>

namespace ActiveBasic { namespace Resource {

HICON LoadIcon(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load = 0);

struct IconDeleter
{
	typedef HICON pointer;

	void operator ()(HICON hicon) const
	{
		::DestroyIcon(hicon);
	}
};

typedef std::unique_ptr<HICON, IconDeleter> UniqueHIcon;

}}
