#include "stdafx.h"

static OSVERSIONINFO GetVersionEx2()
{
	OSVERSIONINFO vi = {sizeof vi};
	GetVersionEx(&vi);
	return vi;
}

static OSVERSIONINFO const vi = GetVersionEx2();

#define KERNEL32 (GetModuleHandle(TEXT("kernel32")))

#define GET_PROC_ADDRESS(hmod, functionName) reinterpret_cast<decltype(functionName)*>(GetProcAddress((hmod), #functionName))

extern "C"
{
	BOOL WINAPI IsDebuggerPresent_Helper()
	{
		if (auto IsDebuggerPresent_Real = GET_PROC_ADDRESS(KERNEL32, IsDebuggerPresent))
		{
			return IsDebuggerPresent_Real();
		}
		else
		{
			return FALSE;
		}
	}

	void* WINAPI EncodePointer_Helper(void* p)
	{
		if (auto EncodePointer_Real = GET_PROC_ADDRESS(KERNEL32, EncodePointer))
		{
			return EncodePointer_Real(p);
		}
		else
		{
			return reinterpret_cast<void*>(reinterpret_cast<DWORD>(p) ^ GetCurrentProcessId());
		}
	}

	void* WINAPI DecodePointer_Helper(void* p)
	{
		if (auto DecodePointer_Real = GET_PROC_ADDRESS(KERNEL32, DecodePointer))
		{
			return DecodePointer_Real(p);
		}
		else
		{
			return reinterpret_cast<void*>(reinterpret_cast<DWORD>(p) ^ GetCurrentProcessId());
		}
	}

	BOOL WINAPI IsProcessorFeaturePresent_Helper(DWORD feture)
	{
		if (auto IsProcessorFeaturePresent_Real = GET_PROC_ADDRESS(KERNEL32, IsProcessorFeaturePresent))
		{
			return IsProcessorFeaturePresent_Real(feture);
		}
		else
		{
			assert(feture == PF_NX_ENABLED); // ATLĂ΂
			return FALSE;
		}
	}

	BOOL WINAPI HeapSetInformation_Helper(HANDLE hHeap, HEAP_INFORMATION_CLASS hic, void* information, SSIZE_T informationLength)
	{
		if (auto HeapSetInformation_Real = GET_PROC_ADDRESS(KERNEL32, HeapSetInformation))
		{
			return HeapSetInformation_Real(hHeap, hic, information, informationLength);
		}
		else
		{
			return TRUE;
		}
	}

	BOOL WINAPI InitializeCriticalSectionAndSpinCount_Helper(LPCRITICAL_SECTION lpcs, DWORD spinCount)
	{
		__try
		{
			if (auto InitializeCriticalSectionAndSpinCount_Real = GET_PROC_ADDRESS(KERNEL32, InitializeCriticalSectionAndSpinCount))
			{
				OSVERSIONINFO vi = {sizeof vi};
				::GetVersionEx(&vi);
				BOOL ret = InitializeCriticalSectionAndSpinCount_Real(lpcs, spinCount);
				return vi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS
					? TRUE
					: ret;
			}
			else
			{
				::InitializeCriticalSection(lpcs);
				return TRUE;
			}
		}
		__except(EXCEPTION_EXECUTE_HANDLER)
		{
		}
		return FALSE;
	}

	// Interlocked(Push|Pop)EntrySList́ANXLȏꍇ̂݌Ă΂B
	// Windows XPȑONXΉĂȂInterlocked(Push|Pop)EntrySListĂ΂邱Ƃ͂ȂB
	// ̂߁AGET_PROC_ADDRESSnullptrԂƂ͂ȂƉ肵ĂB
	// ȂAInterlocked(Push|Pop)EntrySListWindows XP瓋ڂĂB

	PSLIST_ENTRY WINAPI InterlockedPushEntrySList_Helper(PSLIST_HEADER head, PSLIST_ENTRY entry)
	{
		auto InterlockedPushEntrySList_Real = GET_PROC_ADDRESS(KERNEL32, InterlockedPushEntrySList);
		assert(InterlockedPushEntrySList_Real != nullptr);
		return InterlockedPushEntrySList_Real(head, entry);
	}

	PSLIST_ENTRY WINAPI InterlockedPopEntrySList_Helper(PSLIST_HEADER head)
	{
		auto InterlockedPopEntrySList_Real = GET_PROC_ADDRESS(KERNEL32, InterlockedPopEntrySList);
		assert(InterlockedPopEntrySList_Real != nullptr);
		return InterlockedPopEntrySList_Real(head);
	}
}
