#include "stdafx.h"

#include <GdiPlus.h>

#define BOOST_TEST_MAIN

#include <boost/test/unit_test.hpp>

#include <Resource/Load.h>

#include <res/resource.h>

namespace fs = boost::filesystem;

namespace abres = ActiveBasic::Resource;

struct HModuleDeleter
{
	typedef HMODULE pointer;

	void operator ()(pointer hmod) const
	{
		::FreeLibrary(hmod);
	}
};

typedef std::unique_ptr<HMODULE, HModuleDeleter> UniqueHModule;

bool IconEquals(HICON hiconL, HICON hiconR)
{
	return false;
}

BOOST_AUTO_TEST_CASE( ResourceLoading )
{
	TCHAR moduleName[MAX_PATH];
	::GetModuleFileName(nullptr, moduleName, MAX_PATH);

	auto systemDir = fs::path(moduleName).parent_path().parent_path() / "build/release/system";

	UniqueHModule hmodRes(::LoadLibraryExW((systemDir / "res.dll").wstring().c_str(), nullptr, LOAD_LIBRARY_AS_DATAFILE));
	BOOST_CHECK(hmodRes != nullptr);

	auto hBasicProgramIconTarget = (HICON)LoadImage(hmodRes.get(), MAKEINTRESOURCE(IDI_BASICPROGRAM), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	auto hBasicProgramIcon = abres::LoadIcon(hmodRes.get(), IDI_BASICPROGRAM, 16, 16, LR_DEFAULTCOLOR);

	BOOST_CHECK(hBasicProgramIconTarget != nullptr);
	BOOST_CHECK(hBasicProgramIcon != nullptr);

	BOOST_CHECK(IconEquals(hBasicProgramIconTarget, hBasicProgramIcon));

}
