#pragma once

#include <vector>
#include <string>

#include "../Type.h"

using namespace std;

class TypeDefCollection;

class TypeDef{
	friend TypeDefCollection;

	string newName;
	string baseName;
	Type baseType;
public:
	TypeDef( const string &newName, const string &baseName );
	~TypeDef();

	const string &GetNewName(){
		return newName;
	}
	const string &GetBaseName(){
		return baseName;
	}
	const Type &GetBaseType(){
		return baseType;
	}
};

class TypeDefCollection : public vector<TypeDef>
{
public:
	TypeDefCollection();
	~TypeDefCollection();

	void Add( const string &newName, const string &baseName );
	int GetIndex( const string &typeName ) const;

private:
	void Add( const string &expression, int nowLine );
public:
	void Init();
};
