#pragma warning(disable : 4996)

#include <map>
#include <string>
#include <vector>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <ios>
#include <streambuf>
#include <sstream>

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <commctrl.h>
#include <time.h>
#include <limits.h>
#include <shlobj.h>
#include <process.h>
#include <fcntl.h>
#include <io.h>
#include <shlwapi.h>
#include <tchar.h>
#include <stdarg.h>

//boost libraries
#include <boost/foreach.hpp>

#include <boost/archive/xml_oarchive.hpp>
#include <boost/archive/xml_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/serialization/string.hpp>
#include <boost/serialization/access.hpp>
#include <boost/serialization/level.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/version.hpp>

#include <jenga/include/jenga.h>

#include <abdev/ab_common/include/libs.h>

using namespace Jenga::Common;

template<class T_xml_schema> void BoostSerializationSupport<T_xml_schema>::echo( const char *msg ) const
{
	MessageBox( NULL, msg, "XMLVACY̗O", MB_OK );
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXml( std::istream& ifs, bool isShowExceptionMessage )
{
	bool isSuccessful = false;

	try{
		boost::archive::xml_iarchive ia(ifs);

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteXml( std::ostream& ofs, bool isShowExceptionMessage ) const
{
	bool isSuccessful = false;

	try{
		boost::archive::xml_oarchive oa(ofs);

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXml( const std::string &xmlFilePath, bool isShowExceptionMessage )
{
	// ̓A[JCu̍쐬
	std::ifstream ifs( xmlFilePath.c_str() );
	
	bool result = ReadXml(ifs,isShowExceptionMessage);

	// ͂
	ifs.close();

	return result;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteXml( const std::string &xmlFilePath, bool isShowExceptionMessage ) const
{
	// o̓A[JCu̍쐬
	std::ofstream ofs( xmlFilePath.c_str() );

	bool result = WriteXml(ofs,isShowExceptionMessage);

	// o͂
	ofs.close();

	return result;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXmlString( const std::string &xmlString )
{
	bool isSuccessful = false;

	// ̓A[JCu̍쐬
	std::istringstream iss( xmlString );

	try{
		boost::archive::xml_iarchive ia(iss);

		// Xg[Ǎ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch(...){
		// s
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteXmlString( std::string &xmlString ) const
{
	// o̓A[JCu̍쐬
	std::ostringstream oss;

	bool isSuccessful = false;
	try{
		boost::archive::xml_oarchive oa(oss);

		// Xg[ɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		echo( e.what() );
	}
	catch(...){
		echo( "archive_exceptionȊO̕sȗO" );
	}

	if( !isSuccessful )
	{
		return false;
	}

	xmlString = oss.str();

	return true;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadBinaryFile( const std::string &filePath, bool isShowExceptionMessage )
{
	// ̓A[JCu̍쐬
	std::ifstream ifs( filePath.c_str(), std::ios::in | std::ios::binary );

	bool isSuccessful = false;
	try{
		boost::archive::binary_iarchive ia(ifs);

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// ͂
	ifs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteBinaryFile( const std::string &filePath, bool isShowExceptionMessage ) const
{
	// o̓A[JCu̍쐬
	std::ofstream ofs( filePath.c_str(), std::ios::out | std::ios::binary );

	bool isSuccessful = false;
	try{
		boost::archive::binary_oarchive oa(ofs);

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// o͂
	ofs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadBinaryString( const std::string &binaryString )
{
	bool isSuccessful = false;

	// ̓A[JCu̍쐬
	std::istringstream iss( binaryString, std::ios::in | std::ios::binary );

	try{
		boost::archive::binary_iarchive ia(iss);

		// Xg[Ǎ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		echo( e.what() );
	}
	catch(...){
		echo( "archive_exceptionȊO̕sȗO" );
	}

	return isSuccessful;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteBinaryString( std::string &binaryString ) const
{
	// o̓A[JCu̍쐬
	std::ostringstream oss( "", std::ios::out | std::ios::binary );

	bool isSuccessful = false;
	try{
		boost::archive::binary_oarchive oa(oss);

		// Xg[ɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		echo( e.what() );
	}
	catch(...){
		echo( "archive_exceptionȊO̕sȗO" );
	}

	binaryString = oss.str();

	return isSuccessful;
}

/*
rhɎԂ̂ŊOĂ
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadText( const std::string &filePath, bool isShowExceptionMessage )
{
	// ̓A[JCu̍쐬
	std::ifstream ifs( filePath.c_str() );

	bool isSuccessful = false;
	try{
		boost::archive::text_iarchive ia(ifs);

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// ͂
	ifs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteText( const std::string &filePath, bool isShowExceptionMessage ) const
{
	// o̓A[JCu̍쐬
	std::ofstream ofs( filePath.c_str() );

	bool isSuccessful = false;
	try{
		boost::archive::text_oarchive oa(ofs);

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// o͂
	ofs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadTextString( const std::string &textString )
{
	bool isSuccessful = false;

	// ̓A[JCu̍쐬
	std::istringstream iss( textString );

	try{
		boost::archive::text_iarchive ia(iss);

		// Xg[Ǎ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch(...){
		// s
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteTextString( std::string &textString ) const
{
	// o̓A[JCu̍쐬
	std::ostringstream oss;

	bool isSuccessful = false;
	try{
		boost::archive::text_oarchive oa(oss);

		// Xg[ɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		echo( e.what() );
	}
	catch(...){
		echo( "archive_exceptionȊO̕sȗO" );
	}

	if( !isSuccessful )
	{
		return false;
	}

	textString = oss.str();

	return true;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXmlFromString( const std::string &textString )
{
	bool isSuccessful = false;

	// ̓A[JCu̍쐬
	std::istringstream iss( textString );

	try{
		boost::archive::xml_iarchive ia(iss);

		// Xg[Ǎ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch(...){
		// s
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
*/


#include <logger.h>
#include <Configuration.h>
#include <abdev/ab_common/include/Lexical/Source.h>

template class Jenga::Common::BoostSerializationSupport<LoggerSetting>;
template class Jenga::Common::BoostSerializationSupport<Configuration>;
template class Jenga::Common::BoostSerializationSupport<BasicSources>;
