#pragma once

#define STDX_DSTREAM_BUFFERING

namespace Jenga{
namespace Common{


class LoggerSetting : public BoostSerializationSupport<LoggerSetting>
{
public:
	int stopStep;

	LoggerSetting()
		: stopStep( -1 )
	{
	}

	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "loggerSetting";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( stopStep );
	}
};


// VC++  STLport  using std::char_traits; ݂Ȃ̂Kv
template <typename Ch_T, typename Tr_T = std::char_traits<Ch_T> >
class basic_dbg_streambuf: public std::basic_stringbuf<Ch_T, Tr_T>
{
protected:
	std::string saveFilePath;
	int count;
	LoggerSetting setting;

public:
	basic_dbg_streambuf( const std::string &saveFilePath, bool isOptionEnabled )
		: saveFilePath( saveFilePath )
		, count( 0 )
	{
#ifndef STDX_DSTREAM_BUFFERING
		setbuf(0,0);
#endif

		if( isOptionEnabled )
		{
			// ݒt@Cǂݍ
			char temporary[MAX_PATH];
			char temp2[MAX_PATH];
			char temp3[MAX_PATH];
			_splitpath(saveFilePath.c_str(),temporary,temp2,temp3,NULL);

			std::string settingXmlPath = (std::string)temporary + temp2 + temp3 + ".setting.xml";
			if( Jenga::Common::Path( settingXmlPath ).IsExistFile() )
			{
				setting.ReadXml( settingXmlPath, false );
			}
		}
	}

	virtual ~basic_dbg_streambuf()
	{
		sync();
	}

protected:
	int sync(void)
	{
		dbg_out(str().c_str());
		pbump(static_cast<int>(pbase() - pptr()));
		return 0;
	}

	void dbg_out(const Ch_T*);
};

template <>
inline void basic_dbg_streambuf<char>::dbg_out(const char *str)
{
	std::ofstream ofs( ( saveFilePath ).c_str(), std::ios_base::app );
	ofs << "[" << (count++) << "] " << str ;
	ofs.close();

	OutputDebugString( str );

	if( (count-1) == setting.stopStep )
	{
		DebugBreak();
	}
}

template <typename Ch_T, typename Tr_T = std::char_traits<Ch_T> >
class basic_dbg_ostream: public std::basic_ostream<Ch_T, Tr_T>
{
public:
	basic_dbg_ostream( const std::string &saveFilePath, bool isOptionEnabled )
		: std::basic_ostream<Ch_T, Tr_T>(new basic_dbg_streambuf<Ch_T, Tr_T>(saveFilePath,isOptionEnabled))
	{
		std::ofstream ofs( ( saveFilePath ).c_str(), std::ios_base::trunc );
		ofs.close();
	}


	virtual ~basic_dbg_ostream()
	{
		// flush(); // sv炵Dhttp://www.tietew.jp/cppll/archive/607
		delete rdbuf();
	}
};


typedef basic_dbg_ostream<_TCHAR>  Logger;


}}

BOOST_CLASS_IMPLEMENTATION(Jenga::Common::LoggerSetting, boost::serialization::object_serializable);
