#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif

extern HANDLE hHeap;

void CallConstructor( const char *ObjectName,const Subscripts &subscripts,const Type &type,const char *Parameter){
	if( !type.IsObject() ){
		return;
	}

	/////////////////////////////////////
	// NXIuWFNg̏ꍇ
	// RXgN^̌Ăяo
	/////////////////////////////////////

	const UserProc *pUserProc = GetMethodHash(ObjectName,type.GetClass().GetName().c_str(),Parameter);
	if(!pUserProc){
		if(Parameter[0]) compiler.errorMessenger.Output(113,type.GetClass().GetName().c_str(),cp);
		return;
	}


	char temporary[VN_SIZE];

	if( subscripts.size() > 0 ){
		int ss[MAX_ARRAYDIM];
		memset(ss,0,MAX_ARRAYDIM*sizeof(int));
		while(1){
			int i3;
			for(i3=0; i3<(int)subscripts.size(); i3++){
				if(ss[i3]>subscripts[i3]){
					ss[i3]=0;
					ss[i3+1]++;
				}
				else break;
			}
			if( i3 == subscripts.size() )
			{
				break;
			}
			sprintf(temporary,"%s[%d",ObjectName,ss[0]);
			for(i3=1; i3<(int)subscripts.size(); i3++){
				sprintf(temporary+lstrlen(temporary),",%d",ss[i3]);
			}
			lstrcat(temporary,"]");

			Type dummyType;
			sprintf(temporary+lstrlen(temporary),".%s",type.GetClass().GetName().c_str());
			CallProc( PROC_DEFAULT,
				pUserProc,
				temporary,
				Parameter,
				Type(),			// baseType͂Ȃ
				dummyType );

			ss[0]++;
		}
	}
	else{
		Type dummyType;
		sprintf(temporary,"%s.%s",ObjectName,type.GetClass().GetName().c_str());
		CallProc( PROC_DEFAULT,
			pUserProc,
			temporary,
			Parameter,
			Type(),			// baseType͂Ȃ
			dummyType );
	}
}

bool Operator_New( const char *expression, const Type &baseType, Type &resultType ){
	char CreateParameter[VN_SIZE],objectSizeStr[VN_SIZE];
	int i,i2;

	i=0;

	if(expression[0]=='['){
		i=GetStringInBracket(objectSizeStr,expression);

		SlideString(objectSizeStr+1,-1);
		objectSizeStr[i-2]=0;
	}
	else objectSizeStr[0]=0;

	char typeName[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(expression[i]=='('){
			typeName[i2]=0;

			//RXgN^ɓnp[^擾
			i2=GetStringInPare(CreateParameter,expression+i);
			RemoveStringPare(CreateParameter);
			i+=i2;
			if(expression[i]!='\0'){
				compiler.errorMessenger.Output(42,NULL,cp);
				return false;
			}
			break;
		}
		typeName[i2]=expression[i];
		if(expression[i]=='\0'){
			CreateParameter[0]=0;
			break;
		}
	}

	if( !compiler.StringToType( typeName, resultType ) ){
		compiler.errorMessenger.Output(3,typeName,cp);
		return false;
	}

	if( !resultType.IsObject() ){
		////////////////////////
		// ʏ̃f[^^̏ꍇ
		////////////////////////

		compiler.errorMessenger.Output(121,NULL,cp);
		return false;
	}

	Operator_New( resultType.GetClass(), objectSizeStr, CreateParameter, baseType );

	if( !baseType.IsObject() ){
		// IuWFNg|C^
		resultType.SetBasicType( DEF_PTR_OBJECT );
	}

	return true;
}
