#pragma once


namespace Jenga{
namespace Common{


#define MAX_HASHMAP 65535
template<class T> class Hashmap
{
	T* hashArray[MAX_HASHMAP];

public:
	virtual int GetHash( const char *keyName ) const
	{
		int key;
		for(key=0;*keyName!='\0';keyName++){
			key=((key<<8)+ *keyName )%MAX_HASHMAP;
		}
		return key;
	}

	Hashmap()
		: isIteratorReady( false )
	{
		memset( hashArray, 0, MAX_HASHMAP*sizeof(T*) );
	}
	~Hashmap()
	{
		Clear();
	}
	void Clear()
	{
		for( int i=0; i<MAX_HASHMAP; i++ )
		{
			T* temp = hashArray[i];
			if( temp )
			{
				delete temp;
			}
		}
		memset( hashArray, 0, MAX_HASHMAP*sizeof(T*) );
	}

	// ejɂׂĔ
	void PullOutAll()
	{
		memset( hashArray, 0, MAX_HASHMAP*sizeof(T*) );
	}

	bool Put( T* value )
	{
		int key = GetHash( value->GetKeyName().c_str() );

		if(hashArray[key]){
			T *temp = hashArray[key];
			while( true ){
				if( temp->IsDuplication( value ) )
				{
					// dĂ
					return false;
				}

				if( temp->GetChainNext() == NULL )
				{
					break;
				}
				temp = temp->GetChainNext();
			}
			temp->SetChainNext( value );
		}
		else{
			hashArray[key] = value;
		}

		return true;
	}

	T* GetHashArrayElement( const char *keyName )
	{
		return hashArray[GetHash(keyName)];
	}
	const T* GetHashArrayElement( const char *keyName ) const
	{
		return hashArray[GetHash(keyName)];
	}

	bool IsExistDuplicationKeyName( const std::string &keyName ) const
	{
		int key = GetHash( keyName.c_str() );

		if(hashArray[key]){
			const T *temp = hashArray[key];
			while( true ){
				if( temp->IsDuplication( keyName ) )
				{
					// dĂ
					return true;
				}

				if( temp->GetChainNext() == NULL )
				{
					break;
				}
				temp = temp->GetChainNext();
			}
		}

		return false;
	}

	bool IsExist( const T* value ) const
	{
		int key = GetHash( value->GetKeyName().c_str() );

		if(hashArray[key]){
			const T *temp = hashArray[key];
			while( true ){
				if( temp->IsDuplication( value ) )
				{
					// dĂ
					return true;
				}

				if( temp->GetChainNext() == NULL )
				{
					break;
				}
				temp = temp->GetChainNext();
			}
		}

		return false;
	}

	const T *FindLike( const T* value ) const
	{
		int key = GetHash( value->GetKeyName().c_str() );

		if(hashArray[key]){
			const T *temp = hashArray[key];
			while( true ){
				if( temp->IsDuplication( value ) )
				{
					// dĂ
					return temp;
				}

				if( temp->GetChainNext() == NULL )
				{
					break;
				}
				temp = temp->GetChainNext();
			}
		}

		return NULL;
	}


	/////////////////////////////////////////////////////////////////
	// Ce[^
	/////////////////////////////////////////////////////////////////
private:
	mutable std::vector<T*> iterator_Objects;
	mutable int iterator_CurrentNext;
	mutable bool isIteratorReady;
public:
	void Iterator_Init() const
	{
		iterator_Objects.clear();
		iterator_CurrentNext = 0;

		for( int i=0; i<MAX_HASHMAP; i++ ){
			if( hashArray[i] ){
				T* temp = hashArray[i];
				while( temp )
				{
					iterator_Objects.push_back( temp );

					temp = (T*)temp->GetChainNext();
				}
			}
		}

		isIteratorReady = true;
	}
	void Iterator_Reset() const
	{
		if( !isIteratorReady )
		{
			Jenga::Throw( "Ce[^̏łĂȂ" );
		}
		iterator_CurrentNext = 0;
	}
	bool Iterator_HasNext() const
	{
		return ( iterator_CurrentNext < (int)iterator_Objects.size() );
	}
	T *Iterator_GetNext() const
	{
		return iterator_Objects[iterator_CurrentNext++];
	}
	int Iterator_GetMaxCount() const
	{
		return (int)iterator_Objects.size();
	}


	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		std::vector<T *> objects;
		ar & BOOST_SERIALIZATION_NVP( objects );

		// ǂݍ݌̏
		Clear();
		BOOST_FOREACH( T *object, objects )
		{
			Put( object );
		}
		Iterator_Init();
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		// ۑ
		std::vector<T *> objects;
		objects.clear();
		Iterator_Reset();
		while( Iterator_HasNext() )
		{
			objects.push_back( Iterator_GetNext() );
		}

		ar & BOOST_SERIALIZATION_NVP( objects );
	}
};

template<class T> class ObjectInHashmap
{
	T *pNextObject;
public:

	ObjectInHashmap()
		: pNextObject( NULL )
	{
	}
	~ObjectInHashmap()
	{
		if( pNextObject )
		{
			delete pNextObject;
		}
	}

	virtual const std::string &GetKeyName() const = 0;
	virtual bool IsDuplication( const T *value ) const
	{
		return ( GetKeyName() == value->GetName() );
	}
	virtual bool IsDuplication( const std::string &keyName ) const
	{
		return ( GetKeyName() == keyName );
	}

	T *GetChainNext()
	{
		return pNextObject;
	}
	const T *GetChainNext() const
	{
		return pNextObject;
	}
	void SetChainNext( T *pNextObject )
	{
		this->pNextObject = pNextObject;
	}
};


}}
