#include "stdafx.h"

#include "common.h"

extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;

#define ADD_TAG_PARAM(str) AddComplimentInfo(str,ACCESS_HTML_PARAM);

int IsHtmlTagWord(char *str){
	if(str[0]=='a'||str[0]=='A'){
		if(lstrcmpi(str,"a")==0) return 1;
		if(lstrcmpi(str,"abbr")==0) return 1;
		if(lstrcmpi(str,"acronym")==0) return 1;
		if(lstrcmpi(str,"address")==0) return 1;
		if(lstrcmpi(str,"applet")==0) return 1;
		if(lstrcmpi(str,"area")==0) return 1;
	}
	else if(str[0]=='b'||str[0]=='B'){
		if(lstrcmpi(str,"b")==0) return 1;
		if(lstrcmpi(str,"base")==0) return 1;
		if(lstrcmpi(str,"basefont")==0) return 1;
		if(lstrcmpi(str,"bdo")==0) return 1;
		if(lstrcmpi(str,"bgsound")==0) return 1;
		if(lstrcmpi(str,"big")==0) return 1;
		if(lstrcmpi(str,"blink")==0) return 1;
		if(lstrcmpi(str,"blockquote")==0) return 1;
		if(lstrcmpi(str,"body")==0) return 1;
		if(lstrcmpi(str,"br")==0) return 1;
		if(lstrcmpi(str,"button")==0) return 1;
	}
	else if(str[0]=='c'||str[0]=='C'){
		if(lstrcmpi(str,"caption")==0) return 1;
		if(lstrcmpi(str,"center")==0) return 1;
		if(lstrcmpi(str,"cite")==0) return 1;
		if(lstrcmpi(str,"code")==0) return 1;
		if(lstrcmpi(str,"col")==0) return 1;
		if(lstrcmpi(str,"colgroup")==0) return 1;
		if(lstrcmpi(str,"comment")==0) return 1;
	}
	else if(str[0]=='d'||str[0]=='D'){
		if(lstrcmpi(str,"dd")==0) return 1;
		if(lstrcmpi(str,"del")==0) return 1;
		if(lstrcmpi(str,"dfn")==0) return 1;
		if(lstrcmpi(str,"dir")==0) return 1;
		if(lstrcmpi(str,"div")==0) return 1;
		if(lstrcmpi(str,"dl")==0) return 1;
		if(lstrcmpi(str,"dt")==0) return 1;
	}
	else if(str[0]=='e'||str[0]=='E'){
		if(lstrcmpi(str,"em")==0) return 1;
		if(lstrcmpi(str,"embed")==0) return 1;
	}
	else if(str[0]=='f'||str[0]=='F'){
		if(lstrcmpi(str,"fieldset")==0) return 1;
		if(lstrcmpi(str,"font")==0) return 1;
		if(lstrcmpi(str,"form")==0) return 1;
		if(lstrcmpi(str,"frame")==0) return 1;
		if(lstrcmpi(str,"frameset")==0) return 1;
	}
	else if(str[0]=='h'||str[0]=='H'){
		if(lstrcmpi(str,"h1")==0) return 1;
		if(lstrcmpi(str,"h2")==0) return 1;
		if(lstrcmpi(str,"h3")==0) return 1;
		if(lstrcmpi(str,"h4")==0) return 1;
		if(lstrcmpi(str,"h5")==0) return 1;
		if(lstrcmpi(str,"h6")==0) return 1;
		if(lstrcmpi(str,"head")==0) return 1;
		if(lstrcmpi(str,"hr")==0) return 1;
		if(lstrcmpi(str,"html")==0) return 1;
	}
	else if(str[0]=='i'||str[0]=='I'){
		if(lstrcmpi(str,"i")==0) return 1;
		if(lstrcmpi(str,"iframe")==0) return 1;
		if(lstrcmpi(str,"ilayer")==0) return 1;
		if(lstrcmpi(str,"img")==0) return 1;
		if(lstrcmpi(str,"input")==0) return 1;
		if(lstrcmpi(str,"ins")==0) return 1;
		if(lstrcmpi(str,"isindex")==0) return 1;
	}
	else if(str[0]=='k'||str[0]=='K'){
		if(lstrcmpi(str,"kbd")==0) return 1;
		if(lstrcmpi(str,"keygen")==0) return 1;
	}
	else if(str[0]=='l'||str[0]=='L'){
		if(lstrcmpi(str,"label")==0) return 1;
		if(lstrcmpi(str,"layer")==0) return 1;
		if(lstrcmpi(str,"legend")==0) return 1;
		if(lstrcmpi(str,"li")==0) return 1;
		if(lstrcmpi(str,"link")==0) return 1;
		if(lstrcmpi(str,"listing")==0) return 1;
	}
	else if(str[0]=='m'||str[0]=='M'){
		if(lstrcmpi(str,"map")==0) return 1;
		if(lstrcmpi(str,"marquee")==0) return 1;
		if(lstrcmpi(str,"menu")==0) return 1;
		if(lstrcmpi(str,"meta")==0) return 1;
		if(lstrcmpi(str,"multicol")==0) return 1;
	}
	else if(str[0]=='n'||str[0]=='N'){
		if(lstrcmpi(str,"nobr")==0) return 1;
		if(lstrcmpi(str,"noembed")==0) return 1;
		if(lstrcmpi(str,"noframes")==0) return 1;
		if(lstrcmpi(str,"nolayer")==0) return 1;
		if(lstrcmpi(str,"noscript")==0) return 1;
	}
	else if(str[0]=='o'||str[0]=='O'){
		if(lstrcmpi(str,"object")==0) return 1;
		if(lstrcmpi(str,"ol")==0) return 1;
		if(lstrcmpi(str,"optgroup")==0) return 1;
		if(lstrcmpi(str,"option")==0) return 1;
	}
	else if(str[0]=='p'||str[0]=='P'){
		if(lstrcmpi(str,"p")==0) return 1;
		if(lstrcmpi(str,"param")==0) return 1;
		if(lstrcmpi(str,"plaintext")==0) return 1;
		if(lstrcmpi(str,"pre")==0) return 1;
	}
	else if(str[0]=='q'||str[0]=='Q'){
		if(lstrcmpi(str,"q")==0) return 1;
	}
	else if(str[0]=='r'||str[0]=='R'){
		if(lstrcmpi(str,"rb")==0) return 1;
		if(lstrcmpi(str,"rp")==0) return 1;
		if(lstrcmpi(str,"rt")==0) return 1;
		if(lstrcmpi(str,"ruby")==0) return 1;
	}
	else if(str[0]=='s'||str[0]=='S'){
		if(lstrcmpi(str,"s")==0) return 1;
		if(lstrcmpi(str,"samp")==0) return 1;
		if(lstrcmpi(str,"script")==0) return 1;
		if(lstrcmpi(str,"select")==0) return 1;
		if(lstrcmpi(str,"server")==0) return 1;
		if(lstrcmpi(str,"small")==0) return 1;
		if(lstrcmpi(str,"span")==0) return 1;
		if(lstrcmpi(str,"strike")==0) return 1;
		if(lstrcmpi(str,"strong")==0) return 1;
		if(lstrcmpi(str,"style")==0) return 1;
		if(lstrcmpi(str,"sub")==0) return 1;
		if(lstrcmpi(str,"sup")==0) return 1;
	}
	else if(str[0]=='t'||str[0]=='T'){
		if(lstrcmpi(str,"table")==0) return 1;
		if(lstrcmpi(str,"tbody")==0) return 1;
		if(lstrcmpi(str,"td")==0) return 1;
		if(lstrcmpi(str,"textarea")==0) return 1;
		if(lstrcmpi(str,"tfoot")==0) return 1;
		if(lstrcmpi(str,"th")==0) return 1;
		if(lstrcmpi(str,"thead")==0) return 1;
		if(lstrcmpi(str,"title")==0) return 1;
		if(lstrcmpi(str,"tr")==0) return 1;
		if(lstrcmpi(str,"tt")==0) return 1;
	}
	else if(str[0]=='u'||str[0]=='U'){
		if(lstrcmpi(str,"u")==0) return 1;
		if(lstrcmpi(str,"ul")==0) return 1;
	}
	else if(str[0]=='v'||str[0]=='V'){
		if(lstrcmpi(str,"var")==0) return 1;
	}
	else if(str[0]=='w'||str[0]=='W'){
		if(lstrcmpi(str,"wbr")==0) return 1;
	}
	else if(str[0]=='x'||str[0]=='X'){
		if(lstrcmpi(str,"xmp")==0) return 1;
	}


	return 0;
}
int IsHtmlReservedWord(char *str){
	return IsHtmlTagWord(str);
}

void AddComplimentInfo(char *str,DWORD dwAccess){
	ComplementWndInfo.pMemberInfo=(MEMBERINFO *)HeapReAlloc(hHeap,0,
		ComplementWndInfo.pMemberInfo,
		(ComplementWndInfo.MemberNum+1)*sizeof(MEMBERINFO));

	ComplementWndInfo.pMemberInfo[ComplementWndInfo.MemberNum].pName=
		(char *)HeapAlloc(hHeap,0,lstrlen(str)+1);
	lstrcpy(
		ComplementWndInfo.pMemberInfo[ComplementWndInfo.MemberNum].pName,
		str);

	ComplementWndInfo.pMemberInfo[ComplementWndInfo.MemberNum].dwProc=0;

	ComplementWndInfo.pMemberInfo[ComplementWndInfo.MemberNum].dwAccess=dwAccess;

	ComplementWndInfo.MemberNum++;
}

BOOL GetNowTagInfo(char *buffer,int p){
	int i,i2,i3;
	for(i=p;i>0;i--){
		if(buffer[i]=='\r'&&buffer[i+1]=='\n') break;
	}

	int IsStr=0;
	char szTag[1024];
	szTag[0]=0;
	for(;i<p;i++){
		if(buffer[i]=='\0') break;
		if(buffer[i]=='<'){
			IsStr=0;

			i2=i+1;
			while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

			if(IsAlphabet(buffer[i2])){
				for(i3=0;;i2++,i3++){
					if(!IsAlphabet(buffer[i2])){
						szTag[i3]=0;
						break;
					}
					szTag[i3]=buffer[i2];
				}
			}
			else szTag[0]=0;
		}
		if(buffer[i]=='>'&&IsStr==0){
			szTag[0]=0;
		}

		if(buffer[i]=='\"'&&szTag[0]){
			//^Õ_uNH[g
			IsStr^=1;
		}
	}

	if(IsStr){
		//ł͕⊮Ȃ
		return 0;
	}

	if(!IsHtmlTagWord(szTag)){
		//o^̃^O̓T|[gȂ
		return 0;
	}

	ComplementWndInfo.pMemberInfo=(MEMBERINFO *)HeapAlloc(hHeap,0,1);
	ComplementWndInfo.MemberNum=0;

	BOOL bUseGeneralParam=1;
	if(lstrcmpi(szTag,"a")==0){
		ADD_TAG_PARAM("href");
		ADD_TAG_PARAM("name");
		ADD_TAG_PARAM("target");
	}
	else if(lstrcmpi(szTag,"applet")==0){
		ADD_TAG_PARAM("alt");
		ADD_TAG_PARAM("archive");
		ADD_TAG_PARAM("code");
		ADD_TAG_PARAM("codebase");
		ADD_TAG_PARAM("mayscript");
		ADD_TAG_PARAM("object");
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("vspace");
		ADD_TAG_PARAM("width");
	}
	else if(lstrcmpi(szTag,"area")==0){
		ADD_TAG_PARAM("shape");
		ADD_TAG_PARAM("coords");
		ADD_TAG_PARAM("href");
		ADD_TAG_PARAM("alt");
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("nohref");
		ADD_TAG_PARAM("hreflang");
		ADD_TAG_PARAM("methods");
		ADD_TAG_PARAM("rel");
		ADD_TAG_PARAM("rev");
		ADD_TAG_PARAM("tabindex");
		ADD_TAG_PARAM("target");
	}
	else if(lstrcmpi(szTag,"base")==0){
		ADD_TAG_PARAM("href");
		ADD_TAG_PARAM("target");

		bUseGeneralParam=0;
	}
	else if(lstrcmpi(szTag,"basefont")==0){
		ADD_TAG_PARAM("size");
		ADD_TAG_PARAM("color");
		ADD_TAG_PARAM("face");
	}
	else if(lstrcmpi(szTag,"bgsound")==0){
		ADD_TAG_PARAM("balance");
		ADD_TAG_PARAM("loop");
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("volume");
	}
	else if(lstrcmpi(szTag,"blockquote")==0){
		ADD_TAG_PARAM("cite");
	}
	else if(lstrcmpi(szTag,"body")==0){
		ADD_TAG_PARAM("text");
		ADD_TAG_PARAM("link");
		ADD_TAG_PARAM("vlink");
		ADD_TAG_PARAM("alink");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("background");
		ADD_TAG_PARAM("bgproperties");
		ADD_TAG_PARAM("marginheight");
		ADD_TAG_PARAM("marginwidth");
		ADD_TAG_PARAM("topmargin");
		ADD_TAG_PARAM("leftmargin");
		ADD_TAG_PARAM("bottommargin");
		ADD_TAG_PARAM("rightmargin");
		ADD_TAG_PARAM("scroll");
	}
	else if(lstrcmpi(szTag,"br")==0){
		ADD_TAG_PARAM("/");
		ADD_TAG_PARAM("clear");
	}
	else if(lstrcmpi(szTag,"button")==0){
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("disabled");
		ADD_TAG_PARAM("tabindex");
		ADD_TAG_PARAM("type");
		ADD_TAG_PARAM("value");
	}
	else if(lstrcmpi(szTag,"caption")==0){
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("valign");
	}
	else if(lstrcmpi(szTag,"col")==0){
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("char");
		ADD_TAG_PARAM("charoff");
		ADD_TAG_PARAM("span");
		ADD_TAG_PARAM("valign");
		ADD_TAG_PARAM("width");
	}
	else if(lstrcmpi(szTag,"colgroup")==0){
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("char");
		ADD_TAG_PARAM("charoff");
		ADD_TAG_PARAM("span");
		ADD_TAG_PARAM("valign");
		ADD_TAG_PARAM("width");
	}
	else if(lstrcmpi(szTag,"del")==0){
		ADD_TAG_PARAM("cite");
		ADD_TAG_PARAM("datetime");
	}
	else if(lstrcmpi(szTag,"div")==0){
		ADD_TAG_PARAM("align");
	}
	else if(lstrcmpi(szTag,"dl")==0){
		ADD_TAG_PARAM("compact");
	}
	else if(lstrcmpi(szTag,"embed")==0){
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("vspace");
		ADD_TAG_PARAM("compact");
		ADD_TAG_PARAM("units");
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("frameborder");
		ADD_TAG_PARAM("hidden");
		ADD_TAG_PARAM("alt");
		ADD_TAG_PARAM("code");
		ADD_TAG_PARAM("codebase");
		ADD_TAG_PARAM("type");
		ADD_TAG_PARAM("palette");
		ADD_TAG_PARAM("pluginspage");
		ADD_TAG_PARAM("pluginurl");
		ADD_TAG_PARAM("autostart");
		ADD_TAG_PARAM("autoplay");
		ADD_TAG_PARAM("control");
		ADD_TAG_PARAM("loop");
		ADD_TAG_PARAM("repeat");
		ADD_TAG_PARAM("textfocus");
	}
	else if(lstrcmpi(szTag,"fieldset")==0){
		ADD_TAG_PARAM("align");
	}
	else if(lstrcmpi(szTag,"font")==0){
		ADD_TAG_PARAM("size");
		ADD_TAG_PARAM("color");
		ADD_TAG_PARAM("face");
	}
	else if(lstrcmpi(szTag,"form")==0){
		ADD_TAG_PARAM("action");
		ADD_TAG_PARAM("method");
		ADD_TAG_PARAM("target");
		ADD_TAG_PARAM("accept");
		ADD_TAG_PARAM("accept-charset");
		ADD_TAG_PARAM("autocomplete");
		ADD_TAG_PARAM("enctype");
		ADD_TAG_PARAM("urn");
	}
	else if(lstrcmpi(szTag,"frame")==0){
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("bordercolor");
		ADD_TAG_PARAM("frameborder");
		ADD_TAG_PARAM("marginheight");
		ADD_TAG_PARAM("marginwidth");
		ADD_TAG_PARAM("noresize");
		ADD_TAG_PARAM("longdesc");
		ADD_TAG_PARAM("scrolling");
		ADD_TAG_PARAM("allowtransparency");
	}
	else if(lstrcmpi(szTag,"frameset")==0){
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("bordercolor");
		ADD_TAG_PARAM("cols");
		ADD_TAG_PARAM("frameborder");
		ADD_TAG_PARAM("framespacing");
		ADD_TAG_PARAM("rows");
	}
	else if(lstrcmpi(szTag,"h1")==0||
		lstrcmpi(szTag,"h2")==0||
		lstrcmpi(szTag,"h3")==0||
		lstrcmpi(szTag,"h4")==0||
		lstrcmpi(szTag,"h5")==0||
		lstrcmpi(szTag,"h6")==0){
		ADD_TAG_PARAM("align");
	}
	else if(lstrcmpi(szTag,"hr")==0){
		ADD_TAG_PARAM("/");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("color");
		ADD_TAG_PARAM("noshade");
		ADD_TAG_PARAM("size");
		ADD_TAG_PARAM("width");
	}
	else if(lstrcmpi(szTag,"iframe")==0){
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("vspace");
		ADD_TAG_PARAM("marginheight");
		ADD_TAG_PARAM("marginwidth");
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("bordercolor");
		ADD_TAG_PARAM("frameborder");
		ADD_TAG_PARAM("framespacing");
		ADD_TAG_PARAM("longdesc");
		ADD_TAG_PARAM("scrolling");
	}
	else if(lstrcmpi(szTag,"img")==0){
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("alt");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("galleryimg");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("longdesc");
		ADD_TAG_PARAM("lowsrc");
		ADD_TAG_PARAM("suppress");
		ADD_TAG_PARAM("vspace");
		ADD_TAG_PARAM("ismap");
		ADD_TAG_PARAM("usemap");
		ADD_TAG_PARAM("controls");
		ADD_TAG_PARAM("dynsrc");
		ADD_TAG_PARAM("loop");
		ADD_TAG_PARAM("start");
	}
	else if(lstrcmpi(szTag,"input")==0){
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("disabled");
		ADD_TAG_PARAM("tabindex");
		ADD_TAG_PARAM("type");
		ADD_TAG_PARAM("autocomplete");
		ADD_TAG_PARAM("istyle");
		ADD_TAG_PARAM("maxlength");
		ADD_TAG_PARAM("readonly");
		ADD_TAG_PARAM("value");
		ADD_TAG_PARAM("accept");
		ADD_TAG_PARAM("checked");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("alt");
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("dynsrc");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("ismap");
		ADD_TAG_PARAM("lowsrc");
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("width");
	}
	else if(lstrcmpi(szTag,"ins")==0){
		ADD_TAG_PARAM("cite");
		ADD_TAG_PARAM("datetime");
	}
	else if(lstrcmpi(szTag,"label")==0){
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("for");
	}
	else if(lstrcmpi(szTag,"legend")==0){
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("align");
	}
	else if(lstrcmpi(szTag,"li")==0){
		ADD_TAG_PARAM("type");
		ADD_TAG_PARAM("value");
	}
	else if(lstrcmpi(szTag,"link")==0){
		ADD_TAG_PARAM("rel");
		ADD_TAG_PARAM("href");
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("charset");
		ADD_TAG_PARAM("media");
		ADD_TAG_PARAM("type");
	}
	else if(lstrcmpi(szTag,"marquee")==0){
		ADD_TAG_PARAM("behavior");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("direction");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("loop");
		ADD_TAG_PARAM("scrollamount");
		ADD_TAG_PARAM("scrolldelay");
		ADD_TAG_PARAM("truespeed");
		ADD_TAG_PARAM("vspace");
		ADD_TAG_PARAM("width");
	}
	else if(lstrcmpi(szTag,"meta")==0){
		ADD_TAG_PARAM("name");
		ADD_TAG_PARAM("http-equiv");
		ADD_TAG_PARAM("content");
	}
	else if(lstrcmpi(szTag,"object")==0){
		ADD_TAG_PARAM("alt");
		ADD_TAG_PARAM("archive");
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("classid");
		ADD_TAG_PARAM("code");
		ADD_TAG_PARAM("codebase");
		ADD_TAG_PARAM("codetype");
		ADD_TAG_PARAM("data");
		ADD_TAG_PARAM("declare");
		ADD_TAG_PARAM("name");
		ADD_TAG_PARAM("standby");
		ADD_TAG_PARAM("tabindex");
		ADD_TAG_PARAM("type");
		ADD_TAG_PARAM("usemap");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("vspace");
	}
	else if(lstrcmpi(szTag,"ol")==0){
		ADD_TAG_PARAM("compact");
		ADD_TAG_PARAM("start");
		ADD_TAG_PARAM("type");
	}
	else if(lstrcmpi(szTag,"option")==0){
		ADD_TAG_PARAM("disabled");
		ADD_TAG_PARAM("label");
		ADD_TAG_PARAM("selected");
		ADD_TAG_PARAM("value");
	}
	else if(lstrcmpi(szTag,"p")==0){
		ADD_TAG_PARAM("align");
	}
	else if(lstrcmpi(szTag,"param")==0){
		ADD_TAG_PARAM("name");
		ADD_TAG_PARAM("value");
		ADD_TAG_PARAM("valuetype");
		ADD_TAG_PARAM("type");
	}
	else if(lstrcmpi(szTag,"pre")==0){
		ADD_TAG_PARAM("cols");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("wrap");
	}
	else if(lstrcmpi(szTag,"script")==0){
		ADD_TAG_PARAM("charset");
		ADD_TAG_PARAM("defer");
		ADD_TAG_PARAM("event");
		ADD_TAG_PARAM("for");
		ADD_TAG_PARAM("src");
		ADD_TAG_PARAM("type");
	}
	else if(lstrcmpi(szTag,"select")==0){
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("disabled");
		ADD_TAG_PARAM("multiple");
		ADD_TAG_PARAM("size");
		ADD_TAG_PARAM("tabindex");
	}
	else if(lstrcmpi(szTag,"style")==0){
		ADD_TAG_PARAM("disabled");
		ADD_TAG_PARAM("media");
		ADD_TAG_PARAM("type");
	}
	else if(lstrcmpi(szTag,"table")==0){
		ADD_TAG_PARAM("border");
		ADD_TAG_PARAM("bordercolor");
		ADD_TAG_PARAM("bordercolordark");
		ADD_TAG_PARAM("bordercolorlight");
		ADD_TAG_PARAM("frame");
		ADD_TAG_PARAM("rules");
		ADD_TAG_PARAM("background");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("cellpadding");
		ADD_TAG_PARAM("cellspacing");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("hspace");
		ADD_TAG_PARAM("vspace");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("cols");
		ADD_TAG_PARAM("summary");
	}
	else if(lstrcmpi(szTag,"tbody")==0||
		lstrcmpi(szTag,"tfoot")==0||
		lstrcmpi(szTag,"thead")==0){
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("char");
		ADD_TAG_PARAM("charoff");
		ADD_TAG_PARAM("valign");
	}
	else if(lstrcmpi(szTag,"td")==0||
		lstrcmpi(szTag,"th")==0){
		ADD_TAG_PARAM("bordercolor");
		ADD_TAG_PARAM("bordercolordark");
		ADD_TAG_PARAM("bordercolorlight");
		ADD_TAG_PARAM("background");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("valign");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("width");
		ADD_TAG_PARAM("nowrap");
		ADD_TAG_PARAM("char");
		ADD_TAG_PARAM("charoff");
		ADD_TAG_PARAM("colspan");
		ADD_TAG_PARAM("rowspan");
		ADD_TAG_PARAM("abbr");
		ADD_TAG_PARAM("axis");
		ADD_TAG_PARAM("headers");
		ADD_TAG_PARAM("scope");
	}
	else if(lstrcmpi(szTag,"textarea")==0){
		ADD_TAG_PARAM("accesskey");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("cols");
		ADD_TAG_PARAM("istyle");
		ADD_TAG_PARAM("readonly");
		ADD_TAG_PARAM("rows");
		ADD_TAG_PARAM("wrap");
		ADD_TAG_PARAM("tabindex");
	}
	else if(lstrcmpi(szTag,"title")==0){
		bUseGeneralParam=0;
	}
	else if(lstrcmpi(szTag,"tr")==0){
		ADD_TAG_PARAM("bordercolor");
		ADD_TAG_PARAM("bordercolordark");
		ADD_TAG_PARAM("bordercolorlight");
		ADD_TAG_PARAM("bgcolor");
		ADD_TAG_PARAM("align");
		ADD_TAG_PARAM("char");
		ADD_TAG_PARAM("charoff");
		ADD_TAG_PARAM("height");
		ADD_TAG_PARAM("valign");
	}
	else if(lstrcmpi(szTag,"ul")==0){
		ADD_TAG_PARAM("compact");
		ADD_TAG_PARAM("type");
	}




	if(bUseGeneralParam){
		//ʑ
		AddComplimentInfo("class",ACCESS_HTML_GENERAL_PARAM);
		AddComplimentInfo("id",ACCESS_HTML_GENERAL_PARAM);
		AddComplimentInfo("style",ACCESS_HTML_GENERAL_PARAM);
	}

	return 1;
}
