#pragma once

namespace ActiveBasic{ namespace Common{ namespace Lexical{


class NamespaceSupporter
{
	const NamespaceScopesCollection *allNamespaceScopesCollection;

	// ImportsꂽO
	NamespaceScopesCollection importedNamespaces;

	// ݂̖O
	NamespaceScopes livingNamespaceScopes;

public:
	NamespaceSupporter()
		: allNamespaceScopesCollection( NULL )
	{
	}

	void RegistAllNamespaceScopesCollection( const NamespaceScopesCollection *allNamespaceScopesCollection )
	{
		this->allNamespaceScopesCollection = allNamespaceScopesCollection;
	}

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}
	void SetImportedNamespaces( const NamespaceScopesCollection &namespaces )
	{
		this->importedNamespaces = namespaces;
	}
	void ClearImportedNamespaces()
	{
		this->importedNamespaces.clear();
	}
	bool ImportsNamespace( const NamespaceScopes &namespaceScopes );
	bool ImportsNamespace( const std::string &namespaceStr );

	NamespaceScopes &GetLivingNamespaceScopes()
	{
		return livingNamespaceScopes;
	}
	void SetLivingNamespaceScopes( const NamespaceScopes &namespaceScopes )
	{
		this->livingNamespaceScopes = namespaceScopes;
	}
	bool IsLiving( const NamespaceScopes &namespaceScopes ) const
	{
		return NamespaceScopes::IsBelong( namespaceScopes, livingNamespaceScopes );
	}


	// Ă邩`FbN
	// :
	// this =   "Discoversoft.ActiveBasic"
	// living = "Discoversoft.ActiveBasic"
	// entryName =   "ActiveBasic"
	// ̏ꍇAliving  entryName ĂB
	bool IsCoverd( const NamespaceScopes &base, const NamespaceScopes &entry ) const;


	// w肳ꂽOԂGAƌȂ邩ǂ`FbN
	bool IsSameAreaNamespace( const NamespaceScopes &baseNamespaceScopes, const NamespaceScopes &entryNamespaceScopes ) const;
};


}}}
