#pragma once

class UserProc;
class CClass;

class CMethod : public MemberPrototype
{
	const UserProc *pUserProc;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CMethod" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( MemberPrototype );
		ar & boost::serialization::make_nvp("pUserProc", const_cast<UserProc *&>(pUserProc));
	}

public:
	CMethod( const UserProc *pUserProc, Prototype::Accessibility accessibility )
		: MemberPrototype( accessibility )
		, pUserProc( pUserProc )
	{
	}
	CMethod()
	{
	}

	const UserProc &GetUserProc() const
	{
		return *pUserProc;
	}
	void SetUserProcPtr( const UserProc *pUserProc )
	{
		this->pUserProc = pUserProc;
	}

	virtual bool IsAbstract() const = 0;
	virtual void SetAbstractMark( bool isAbstractMark ) = 0;
	virtual bool IsVirtual() const = 0;
	virtual bool IsConst() const = 0;
	virtual bool IsDynamic() const = 0;
	virtual bool IsStatic() const = 0;
	virtual const CClass *GetInheritsClassPtr() const = 0;
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass ) = 0;
	virtual bool IsNotUse() const = 0;
	virtual void SetNotUseMark( bool isNotUse ) = 0;

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};

class DynamicMethod : public CMethod
{
public:
	struct OverrideResult
	{
		enum EnumType
		{
			Successful = 0,				// I[o[Chɐ
			NotVirtual,					// Virtual\bhɑ΂ăI[o[ChsƂ
			NotUseOverrideModifier,		// OverrideCq󋵂ŊNX̎̃\bhI[o[Ch悤Ƃ
			DifferentAccesibility,		// I[o[ChÃANZVreBɑႪ
		};

		EnumType enumType;
		const CMethod *pMethod;
	};

private:
	bool isAbstract;
	bool isVirtual;
	bool isConst;
	const CClass *pInheritsClass;

	// ̃C^[tFCX֎ڂꍇiNX\bh̃C^[tFCXj͂̃tOIɂ
	bool isNotUse;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - DynamicMethod" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( CMethod );
		ar & BOOST_SERIALIZATION_NVP( isAbstract );
		ar & BOOST_SERIALIZATION_NVP( isVirtual );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & boost::serialization::make_nvp("pInheritsClass", const_cast<CClass *&>(pInheritsClass));
		ar & BOOST_SERIALIZATION_NVP( isNotUse );
	}

public:
	DynamicMethod( UserProc *pUserProc, Prototype::Accessibility accessibility, bool isAbstract, bool isVirtual, bool isConst, const CClass *pInheritsClass = NULL )
		: CMethod( pUserProc, accessibility )
		, isAbstract( isAbstract )
		, isVirtual( isVirtual )
		, isConst( isConst )
		, pInheritsClass( pInheritsClass )
		, isNotUse( false )
	{
	}
	DynamicMethod( const CMethod &method )
		: CMethod( &method.GetUserProc(), method.GetAccessibility() )
		, isAbstract( method.IsAbstract() )
		, isVirtual( method.IsVirtual() )
		, isConst( method.IsConst() )
		, pInheritsClass( method.GetInheritsClassPtr() )
		, isNotUse( false )
	{
	}
	DynamicMethod()
	{
	}

	DynamicMethod::OverrideResult::EnumType Override( const UserProc *pUserProc, Prototype::Accessibility accessibility, bool isOverrideModifier );

	virtual bool IsAbstract() const
	{
		return isAbstract;
	}
	virtual void SetAbstractMark( bool isAbstract )
	{
		this->isAbstract = isAbstract;
	}
	virtual bool IsVirtual() const
	{
		return isVirtual;
	}
	virtual bool IsConst() const
	{
		return isConst;
	}
	virtual bool IsDynamic() const
	{
		return true;
	}
	virtual bool IsStatic() const
	{
		return false;
	}
	virtual const CClass *GetInheritsClassPtr() const
	{
		return pInheritsClass;
	}
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass )
	{
		this->pInheritsClass = pInheritsClass;
	}
	virtual bool IsNotUse() const
	{
		return isNotUse;
	}
	virtual void SetNotUseMark( bool isNotUse )
	{
		this->isNotUse = isNotUse;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
BOOST_CLASS_EXPORT( DynamicMethod );
class StaticMethod : public CMethod
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - StaticMethod" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( CMethod );
	}

public:

	// RXgN^
	StaticMethod( UserProc *pUserProc, Prototype::Accessibility accessibility )
		: CMethod( pUserProc, accessibility )
	{
	}

	// Rs[RXgN^
	StaticMethod( const StaticMethod &staticMethod );

	// fXgN^
	StaticMethod()
	{
	}

	virtual bool Override( const UserProc *pUserProc, Prototype::Accessibility accessibility, bool isOverrideModifier )
	{
		throw;
	}

	virtual bool IsAbstract() const
	{
		throw;
	}
	virtual void SetAbstractMark( bool isAbstract )
	{
		throw;
	}
	virtual bool IsVirtual() const{
		return false;
	}
	virtual bool IsConst() const
	{
		throw;
	}
	virtual bool IsDynamic() const
	{
		return false;
	}
	virtual bool IsStatic() const
	{
		return true;
	}
	virtual const CClass *GetInheritsClassPtr() const
	{
		throw;
	}
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass )
	{
		throw;
	}
	virtual bool IsNotUse() const
	{
		return false;
	}
	virtual void SetNotUseMark( bool isNotUse )
	{
		throw;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
BOOST_CLASS_EXPORT( StaticMethod );

class Methods : public std::vector<CMethod *>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Methods" );

		ar & boost::serialization::make_nvp("vector_CMethod", boost::serialization::base_object<vector<CMethod *>>(*this));
	}

public:
	// RXgN^
	Methods();

	// Rs[RXgN^
	Methods( const Methods &methods );

	// fXgN^
	~Methods();

	//oA\bh̒ǉ
	void Add( UserProc *pUserProc, Prototype::Accessibility accessibility, bool isConst, bool isAbstract, bool isVirtual );
	void AddStatic(UserProc *pUserProc,Prototype::Accessibility accessibility);

	/*!
	@brief	I[o[Cĥ߂̌
	@param	actualTypeParametersForThisMethods thisIuWFNgŕۗL郁\bhQΏۂƂ^p[^
			pUserProc Ƃ炵킹֐
	*/
	DynamicMethod *FindForOverride( const Types &actualTypeParametersForThisMethods, const UserProc *pUserProc );

	const CMethod *GetMethodPtr( const UserProc *pUserProc ) const;
	bool IsExist( const char *name ) const;
	virtual void Enum( const char *methodName, std::vector<const UserProc *> &subs ) const;
	virtual void Enum( BYTE idOperatorCalc, std::vector<const UserProc *> &subs ) const;

	// z\bȟ擾
	int GetVtblNum() const;
};
