#pragma once

class Meta
{
	// O
	NamespaceScopesCollection namespaceScopesCollection;

	// ֐E\bh
	UserProcs userProcs;

	// DLL֐
	DllProcs dllProcs;

	// NX
	Classes classesImpl;

	// O[oϐ
	GlobalVars globalVars;

	// O[o萔
	Consts globalConsts;

	// O[o萔}N
	ConstMacros globalConstMacros;

	// blittable^
	BlittableTypes blittableTypes;

	// TypeDef
	TypeDefCollection typeDefs;

	// ֐|C^
	ProcPointers procPointers;

	// fQ[g
	Delegates delegates;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Meta" );

		ar & BOOST_SERIALIZATION_NVP( namespaceScopesCollection );
		ar & BOOST_SERIALIZATION_NVP( userProcs );
		ar & BOOST_SERIALIZATION_NVP( dllProcs );
		ar & BOOST_SERIALIZATION_NVP( classesImpl );
		ar & BOOST_SERIALIZATION_NVP( globalVars );
		ar & BOOST_SERIALIZATION_NVP( globalConsts );
		ar & BOOST_SERIALIZATION_NVP( globalConstMacros );
		ar & BOOST_SERIALIZATION_NVP( blittableTypes );
		ar & BOOST_SERIALIZATION_NVP( typeDefs );
		ar & BOOST_SERIALIZATION_NVP( procPointers );
		ar & BOOST_SERIALIZATION_NVP( delegates );
	}

	Classes *pNowClassesForDebugger;

public:
	Meta()
		: classesImpl()
		, pNowClassesForDebugger( &classesImpl )
	{
	}

	// 
	void Clear();

	// ÓIN
	void StaticLink( Meta &meta, long dataSectionBaseOffset, const std::vector<int> &relationTable );

	const NamespaceScopesCollection &GetNamespaces() const
	{
		return namespaceScopesCollection;
	}
	NamespaceScopesCollection &GetNamespaces()
	{
		return namespaceScopesCollection;
	}

	const UserProcs &GetUserProcs() const
	{
		return userProcs;
	}
	UserProcs &GetUserProcs()
	{
		return userProcs;
	}

	const DllProcs &GetDllProcs() const
	{
		return dllProcs;
	}
	DllProcs &GetDllProcs()
	{
		return dllProcs;
	}

	const Classes &GetClasses() const
	{
		return *pNowClassesForDebugger;
	}
	Classes &GetClasses()
	{
		return *pNowClassesForDebugger;
	}
	void SetClasses( Classes *pClasses )
	{
		this->pNowClassesForDebugger = pClasses;
	}

	const GlobalVars &GetGlobalVars() const
	{
		return globalVars;
	}
	GlobalVars &GetGlobalVars()
	{
		return globalVars;
	}

	const Consts &GetGlobalConsts() const
	{
		return globalConsts;
	}
	Consts &GetGlobalConsts()
	{
		return globalConsts;
	}

	const ConstMacros &GetGlobalConstMacros() const
	{
		return globalConstMacros;
	}
	ConstMacros &GetGlobalConstMacros()
	{
		return globalConstMacros;
	}

	BlittableTypes &GetBlittableTypes()
	{
		return blittableTypes;
	}

	TypeDefCollection &GetTypeDefs()
	{
		return typeDefs;
	}

	ProcPointers &GetProcPointers()
	{
		return procPointers;
	}

	Delegates &GetDelegates()
	{
		return delegates;
	}

	const ::Delegate &ToDelegate( const CClass &_class );

	const CClass *FindClassSupportedTypeDef( const Symbol &symbol );

	void Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
