#include "stdafx.h"
#include <algorithm>

bool Jenga::Common::IsExistString( const Jenga::Common::Strings &strings, const std::string &findStr )
{
	return std::find( strings.begin(), strings.end(), findStr ) != strings.end();
}

std::string& Jenga::Common::StringReplace( std::string& str, const std::string &sb, const std::string &sa )
{
	std::string::size_type n, nb = 0;
	
	while ((n = str.find(sb,nb)) != std::string::npos)
	{
		str.replace(n,sb.size(),sa);
		nb = n + sa.size();
	}
	
	return str;
}

std::string Jenga::Common::ToString( int n )
{
	char temp[255];
	wsprintf( temp, "%d", n );
	return temp;
}

std::string Jenga::Common::ToString( const std::wstring &wstr )
{
	int needSize = 	WideCharToMultiByte(
		CP_THREAD_ACP,
		0,
		wstr.data(), static_cast<int>(wstr.size()),
		NULL, NULL,
		NULL, NULL );

	char *pstr = (char *)calloc( needSize, 1 );
	WideCharToMultiByte(
		CP_THREAD_ACP,
		0,
		wstr.data(), static_cast<int>(wstr.size()),
		pstr, needSize,
		NULL, NULL );

	std::string result(pstr, needSize);

	free( pstr );

	return result;
}

std::wstring Jenga::Common::ToWString( const std::string &str )
{
	int size = MultiByteToWideChar(
		CP_ACP,
		0,
		str.data(), static_cast<int>(str.size()),
		NULL, 0 );

	LPWSTR pwstr = (LPWSTR)calloc( size, sizeof (wchar_t) );

	MultiByteToWideChar(
		CP_ACP,
		0,
		str.data(), static_cast<int>(str.size()),
		pwstr, size );

	std::wstring wstr( pwstr, size );

	free( pwstr );

	return wstr;
}

bool Jenga::Common::IsIdentifierTopChar( char c )
{
	return ( isalpha( c ) || c == '_' );
}

bool Jenga::Common::IsIdentifierChar( char c )
{
	return ( IsIdentifierTopChar( c ) || isdigit( c ) );
}
