#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

#include "FunctionValue.h"

void Opcode_Func_ObjPtr( const char *Parameter, Type &resultType, bool isCallOn );

int GetFunctionFromName(char *FuncName){
	if( lstrcmpi( FuncName, "CUDbl" ) == 0 )			return FUNC_CUDBL;
	if( lstrcmpi( FuncName, "Fix" ) == 0 )				return FUNC_FIX;
	if( lstrcmpi( FuncName, "Len" ) == 0 )				return FUNC_LEN;
	if( lstrcmpi( FuncName, "AddressOf" ) == 0 )		return FUNC_ADDRESSOF;
	if( lstrcmpi( FuncName, "SizeOf" ) == 0 )			return FUNC_SIZEOF;
	if( lstrcmpi( FuncName, "__ClassSizeOf" ) == 0 )			return FUNC_CLASS_SIZEOF;
	if( lstrcmpi( FuncName, "VarPtr" ) == 0 )			return FUNC_VARPTR;
	if( lstrcmpi( FuncName, "ObjPtr" ) == 0 )			return FUNC_OBJPTR;
	if( lstrcmpi( FuncName, "__delegate_dynamicmethod_call" ) == 0 )	return FUNC_DELEGATE_DYNAMICMETHOD_CALL;
	if( lstrcmpi( FuncName, "__delegate_staticmethod_call" ) == 0 )		return FUNC_DELEGATE_STATICMETHOD_CALL;
	if( lstrcmpi( FuncName, "_System_GetNowScopeCatchAddresses" ) == 0 )return FUNC_SYSTEM_GET_NOW_SCOPE_CATCH_ADDRESS;
	if( lstrcmpi( FuncName, "_System_GetNowScopeFinallyAddresses" ) == 0 )return FUNC_SYSTEM_GET_NOW_SCOPE_FINALLY_ADDRESS;
	if( lstrcmpi( FuncName, "_System_GetBp" ) == 0 )	return FUNC_SYSTEM_GET_BP;
	if( lstrcmpi( FuncName, "_System_GetSp" ) == 0 )	return FUNC_SYSTEM_GET_SP;
	if( lstrcmp( FuncName, "_System_GetComVtbl" ) == 0 )		return FUNC_SYSTEM_GET_COM_VTBL;
	if( lstrcmp( FuncName, "_System_GetVtblList" ) == 0 )		return FUNC_SYSTEM_GET_VTBL_LIST;
	if( lstrcmp( FuncName, "_System_GetDefaultConstructor" ) == 0 )	return FUNC_SYSTEM_GET_DEFAULT_CONSTRUCTOR;
	if( lstrcmp( FuncName, "_System_GetDestructor" ) == 0 )			return FUNC_SYSTEM_GET_DESTRUCTOR;
	if( lstrcmpi( FuncName, "GetDouble" ) == 0 )		return FUNC_GETDOUBLE;
	if( lstrcmpi( FuncName, "GetSingle" ) == 0 )		return FUNC_GETSINGLE;
	if( lstrcmpi( FuncName, "GetQWord" ) == 0 )			return FUNC_GETQWORD;
	if( lstrcmpi( FuncName, "GetDWord" ) == 0 )			return FUNC_GETDWORD;
	if( lstrcmpi( FuncName, "GetWord" ) == 0 )			return FUNC_GETWORD;
	if( lstrcmpi( FuncName, "GetByte" ) == 0 )			return FUNC_GETBYTE;
	return 0;
}

void Opcode_Func_Fix(const char *lpszParms){
	Type resultType;
	if( !NumOpe( lpszParms, Type(), resultType ) ){
		return;
	}

	if( resultType.IsDouble() ){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//fnstcw word ptr[esp]
		compiler.codeGenerator.PutOld(
			(char)0xD9,
			(char)0x3C,
			(char)0x24
		);

		//mov ax,word ptr[esp]
		compiler.codeGenerator.op_mov_RM( sizeof(short), REG_EAX, REG_ESP, 0, MOD_BASE );

		//or ah,0Ch
		compiler.codeGenerator.PutOld(
			(char)0x80,
			(char)0xCC,
			(char)0x0C
		);

		//mov word ptr[esp-2],ax
		compiler.codeGenerator.op_mov_MR( sizeof(short), REG_EAX, REG_ESP, -2, MOD_BASE_DISP8 );

		//fldcw word ptr[esp-2]
		compiler.codeGenerator.PutOld(
			(char)0xD9,
			(char)0x6C,
			(char)0x24,
			(char)0xFE
		);

		//fistp dword ptr[esp+4]
		compiler.codeGenerator.PutOld(
			(char)0xDB,
			(char)0x5C,
			(char)0x24,
			(char)0x04
		);

		//fldcw word ptr[esp]
		compiler.codeGenerator.PutOld(
			(char)0xD9,
			(char)0x2C,
			(char)0x24
		);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);
	}
	else if( resultType.IsSingle() ){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//fnstcw word ptr[esp]
		compiler.codeGenerator.PutOld(
			(char)0xD9,
			(char)0x3C,
			(char)0x24
		);

		//mov ax,word ptr[esp]
		compiler.codeGenerator.op_mov_RM( sizeof(short), REG_EAX, REG_ESP, 0, MOD_BASE );

		//or ah,0Ch
		compiler.codeGenerator.PutOld(
			(char)0x80,
			(char)0xCC,
			(char)0x0C
		);

		//mov word ptr[esp-2],ax
		compiler.codeGenerator.op_mov_MR( sizeof(short), REG_EAX, REG_ESP, -2, MOD_BASE_DISP8 );

		//fldcw word ptr[esp-2]
		compiler.codeGenerator.PutOld(
			(char)0xD9,
			(char)0x6C,
			(char)0x24,
			(char)0xFE
		);

		//fistp dword ptr[esp+4]
		compiler.codeGenerator.PutOld(
			(char)0xDB,
			(char)0x5C,
			(char)0x24,
			(char)0x04
		);

		//fldcw word ptr[esp]
		compiler.codeGenerator.PutOld(
			(char)0xD9,
			(char)0x2C,
			(char)0x24
		);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);
	}
	else if( resultType.Is64() ){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);
}

void Opcode_Func_CUDbl(const char *Parameter){
	Type resultType;
	if( !NumOpe(Parameter,Type(),resultType) ){
		return;
	}
	ChangeTypeToLong(resultType.GetBasicType());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//push 0
	compiler.codeGenerator.op_push_V( 0 );

	//push eax
	compiler.codeGenerator.op_push(REG_EAX);

	//fild qword ptr[esp]
	compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

	//add esp,8
	compiler.codeGenerator.op_add_esp(8);
}
void Opcode_Func_Len(const char *Parameter){
	BOOL bArrayHead;

	const char *tempParm=Parameter;
	char temporary[VN_SIZE];
	char temp2[32];
	Type type;
	if( !GetVarType(Parameter,type,0) ){
		sprintf(temporary,"_System_DummyStr2=%s",Parameter);
		OpcodeCalc(temporary);

		lstrcpy(temp2,"_System_DummyStr2");
		tempParm=temp2;

		type.SetType( DEF_OBJECT, compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr() );
	}

	if( type.IsStringClass() ){
		//StringIuWFNg̏ꍇ
		sprintf(temporary,"%s.Length",tempParm);

		int reg=REG_RAX;
		NumOpe(temporary,Type(),Type());

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		return;
	}

	Subscripts subscripts;
	RELATIVE_VAR RelativeVar;
	if(!GetVarOffsetReadOnly(tempParm,&RelativeVar,type,&subscripts)) return;

	if(type.GetBasicType()&FLAG_PTR){
		type.SetBasicType( type.GetBasicType() & ( ~FLAG_PTR ) );

		bArrayHead=1;
	}
	else bArrayHead=0;

	int typeSize = type.GetSize();

	if(bArrayHead) typeSize*=JumpSubScripts(subscripts);

	//mov eax,typeSize
	compiler.codeGenerator.op_mov_RV( REG_EAX, typeSize );
}

void _Opcode_Func_AddressOf( const char *methodInstanceName, const UserProc &userProc )
{
	if( userProc.IsVirtual() ){
		///////////////////////////////
		// z֐̏ꍇ
		// this|C^rcxɃRs[
		///////////////////////////////

		const CClass *pobj_c;

		char ObjectName[VN_SIZE];
		ReferenceKind referenceKind;
		SplitObjectName( methodInstanceName, ObjectName, referenceKind );

		if(ObjectName[0]){
			if(lstrcmpi(ObjectName,"Super")==0) goto InClassMember;
			else{
				RELATIVE_VAR RelativeVar;
				Type type;
				if(!GetVarOffsetReadOnly(ObjectName,&RelativeVar,type)) return;
				SetVarPtrToEax(&RelativeVar);

				//mov ecx,eax
				compiler.codeGenerator.op_mov_RR(REG_ECX,REG_EAX);

				//Qƃ^CvĂ邩`FbN
				if( !( type.IsObject() && referenceKind == RefDot
					|| type.IsObjectPtr() && referenceKind == RefPointer ) )
				{
					compiler.errorMessenger.Output(104,ObjectName,cp);
				}

				if(type.IsObjectPtr()){
					//mov ecx,dword ptr[ecx]
					compiler.codeGenerator.op_mov_RM(sizeof(long),REG_ECX,REG_ECX,0,MOD_BASE);
				}
			}
		}
		else{
InClassMember:
			//g̃IuWFNgThis|C^rcxɃRs[
			SetThisPtrToReg(REG_RCX);

			pobj_c = &compiler.GetCompilingClass();
		}


		int vtblIndex;
		if( pobj_c->IsInterface() )
		{
			// C^[tFCX\bhĂяo

			int offset_vtbl = compiler.GetObjectModule().meta.GetClasses().GetInterfaceInfoClassPtr()->GetMemberOffset( "__vtbl" );


			// vtbl̃|C^擾
			//mov edx,dword ptr[ecx+offset_vtbl]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, offset_vtbl, MOD_BASE_DISP8 );

			int offset_this = compiler.GetObjectModule().meta.GetClasses().GetInterfaceInfoClassPtr()->GetMemberOffset( "__this" );



			// C^[tFCX̏ꍇ͍X__this擾
			//mov rcx,qword ptr[rcx+offset_this]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_ECX, REG_ECX, offset_this, MOD_BASE_DISP8 );

			int vtblMasterListIndex;
			pobj_c->GetVtblMasterListIndexAndVtblIndex( &userProc, vtblMasterListIndex, vtblIndex );
			if( vtblMasterListIndex != 0 )
			{
				compiler.errorMessenger.OutputFatalError();
			}
		}
		else if( pobj_c->IsComInterface() )
		{
			// COMC^[tFCX \bhĂяo

			//z֐iIuWFNg\bhjĂяo
			// pObj -> vtbl1 -> func1
			//               -> func2
			//               -> func3

			int vtblMasterListIndex;
			pobj_c->GetVtblMasterListIndexAndVtblIndex( &userProc, vtblMasterListIndex, vtblIndex );

			// vtbl̃|C^擾
			//mov edx,dword ptr[ecx]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, 0, MOD_BASE );
		}
		else
		{
			//z֐iIuWFNg\bhjĂяo
			// pObj -> vtbl_master_list -> vtbl1 -> func1
			//                                   -> func2
			//                                   -> func3
			//                          -> vtbl2 -> func1
			//                                   -> func2
			//                                   -> func3

			int vtblMasterListIndex;
			pobj_c->GetVtblMasterListIndexAndVtblIndex( &userProc, vtblMasterListIndex, vtblIndex );

			// vtbl}X^[Xg̃|C^擾
			//mov edx,dword ptr[ecx+sizeof(com_vtbl)]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, PTR_SIZE, MOD_BASE_DISP8 );
			
			// vtbl̃|C^擾
			//mov edx,dword ptr[edx+vtblMasterListIndex]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_EDX, vtblMasterListIndex*PTR_SIZE, MOD_BASE_DISP32 );
		}

		//mov eax,dword ptr[edx+func_index]
		if( vtblIndex * PTR_SIZE <= 0x7F )
		{
			compiler.codeGenerator.op_mov_RM(sizeof(long),REG_EAX,REG_EDX,vtblIndex*PTR_SIZE,MOD_BASE_DISP8);
		}
		else{
			compiler.codeGenerator.op_mov_RM(sizeof(long),REG_EAX,REG_EDX,vtblIndex*PTR_SIZE,MOD_BASE_DISP32);
		}
	}
	else{
		//ʂ̊֐

		//mov eax,ProcAddr
		compiler.codeGenerator.op_addressof( REG_EAX, &userProc );
	}

	userProc.Using();
}
void Opcode_CreateDelegate( const CClass &dgClass, const char *methodInstanceName, const UserProc &userProc )
{
	/////////////////////////////////////////////////////////////////
	// ֐|C^push
	/////////////////////////////////////////////////////////////////

	//push AddressOf(userProc)
	_Opcode_Func_AddressOf( methodInstanceName, userProc );
	compiler.codeGenerator.op_push( REG_EAX );


	if( userProc.HasParentClass() && userProc.GetMethod().IsDynamic() )
	{
		/////////////////////////////////////////////////////////////////
		// IuWFNg |C^push
		/////////////////////////////////////////////////////////////////

		// IuWFNg擾
		char objectName[VN_SIZE];
		char memberName[VN_SIZE];
		char *thisPtrName = "This";
		Type type;
		if( SplitMemberName( methodInstanceName, objectName, memberName ) )
		{
			if( GetVarType( objectName, type, false ) )
			{
				thisPtrName = objectName;
			}
		}

		// IuWFNg |C^擾
		Opcode_Func_ObjPtr( thisPtrName, type, true );

		//push eax
		compiler.codeGenerator.op_push( REG_EAX );
	}


	/////////////////////////////////////////////////////////////////
	// call _CreateDynamicDelegate/_CreateStaticDelegate
	/////////////////////////////////////////////////////////////////

	std::vector<const UserProc *> subs;
	if( userProc.HasParentClass() && userProc.GetMethod().IsDynamic() )
	{
		dgClass.GetStaticMethods().Enum( "_CreateDynamicDelegate", subs );
	}
	else
	{
		dgClass.GetStaticMethods().Enum( "_CreateStaticDelegate", subs );
	}

	// call _CreateDynamicDelegate
	compiler.codeGenerator.op_call( subs[0] );
}
void Opcode_Func_AddressOf( const char *name, const Type &baseType, bool isCallOn, Type &resultType )
{
	extern int cp;

	const Parameters *pBaseParams = NULL;
	const Type *pBaseReturnType = NULL;
	if( baseType.IsProcPtr() )
	{
		// ӂŊ֐|C^vĂƂ
		const ProcPointer *pTempProcPointer = compiler.GetObjectModule().meta.GetProcPointers()[baseType.GetIndex()];
		pBaseParams = &pTempProcPointer->Params();
		pBaseReturnType = &pTempProcPointer->ReturnType();
	}
	else if( baseType.IsDelegate() )
	{
		// ӂŃfQ[gvĂƂ
		const Delegate *pTempDelegate = &compiler.GetObjectModule().meta.ToDelegate( baseType.GetClass() );
		pBaseParams = &pTempDelegate->Params();
		pBaseReturnType = &pTempDelegate->ReturnType();
	}

	const UserProc *pUserProc;
	if( pBaseParams && pBaseReturnType )
	{
		//ӂ̌^ɂ̂ƂAI[o[[h

		std::vector<const UserProc *> subs;
		GetOverloadSubHash( name, subs );
		if( subs.size() == 0 ){
			compiler.errorMessenger.Output(27,name,cp);
			return;
		}

		//I[o[[h
		pUserProc=OverloadSolution( name, subs, *pBaseParams, Type(), Type() );

		if( isCallOn )
		{
			// R[h𔺂ꍇ̓G[`FbNs

			if( baseType.IsDelegate() )
			{
				// fQ[g
				// ϖ߂lAψT|[g
				if( !(
					pBaseParams->Equals( pUserProc->Params(), true )
					&& ( pBaseReturnType->Equals( pUserProc->ReturnType() ) || pBaseReturnType->IsCovariant( pUserProc->ReturnType() ) )
					) )
				{
					compiler.errorMessenger.Output(67, name, cp );
				}
			}
			else
			{
				// ֐|C^
				if( !(
					pBaseParams->Equals( pUserProc->Params() )
					&& pBaseReturnType->Equals( pUserProc->ReturnType() )
					) )
				{
					compiler.errorMessenger.Output(66, name, cp );
				}
			}
		}

		if(!pUserProc){
			compiler.errorMessenger.Output(27,name,cp);
			return;
		}
	}
	else{
		pUserProc=GetSubHash(name);
		if(!pUserProc){
			compiler.errorMessenger.Output(27,name,cp);
			return;
		}
	}

	if( baseType.IsDelegate() )
	{
		if( isCallOn )
		{
			// fQ[ĝƂ
			Opcode_CreateDelegate( baseType.GetClass(), name, *pUserProc );
		}
		resultType = baseType;
	}
	else
	{
		if( isCallOn )
		{
			// ֐|C^̂Ƃ
			_Opcode_Func_AddressOf( name, *pUserProc );
		}
		resultType.SetBasicType( DEF_PTR_VOID );
	}
}
void Opcode_Func_SizeOf( const std::string &typeName )
{
	Type tempType;
	if( !compiler.StringToType( typeName, tempType ) ){
		compiler.errorMessenger.Output(3,typeName,cp);
		return;
	}

	//mov eax,size
	compiler.codeGenerator.op_mov_RV( REG_EAX, compiler.SizeOf( tempType ) );
}
void Opcode_Func_ClassSizeOf( const std::string &typeName )
{
	Type tempType;
	if( !compiler.StringToType( typeName, tempType ) ){
		compiler.errorMessenger.Output(3,typeName,cp);
		return;
	}

	if( !tempType.IsObject() )
	{
		compiler.errorMessenger.Output(1,typeName,cp);
		return;
	}

	//mov eax,size
	compiler.codeGenerator.op_mov_RV( REG_EAX, tempType.GetClass().GetSize() );
}
void Opcode_Func_VarPtr( const char *Parameter, Type &resultType, bool isCallOn )
{
	if( isCallOn == false )
	{
		// ߂ľ^擾邾

		//ϐ̃AhX擾
		if(!GetVarType( Parameter, resultType, true )) return;

		resultType.PtrLevelUp();

		return;
	}

	if( lstrcmpi( Parameter, "This" )==0 )
	{
		compiler.errorMessenger.Output( 144, "", cp );
	}

	RELATIVE_VAR RelativeVar;

	//ϐ̃AhX擾
	if(!GetVarOffsetReadOnly( Parameter, &RelativeVar, resultType )) return;

	int beforeType = resultType.GetBasicType();

	resultType.PtrLevelUp();

	SetVarPtrToEax(&RelativeVar);
}
void Opcode_Func_ObjPtr( const char *Parameter, Type &resultType, bool isCallOn ){
	if( isCallOn == false ){
		// ߂ľ^擾邾

		//ϐ̃AhX擾
		if(!GetVarType( Parameter, resultType, true )) return;

		resultType.PtrLevelUp();

		return;
	}

	RELATIVE_VAR RelativeVar;

	//ϐ̃AhX擾
	if(!GetVarOffsetReadOnly( Parameter, &RelativeVar, resultType )) return;

	int beforeType = resultType.GetBasicType();

	resultType.PtrLevelUp();

	SetVarPtrToEax(&RelativeVar);

	if( lstrcmpi( Parameter, "This" )==0 ){
		// This̏ꍇ͓ʂɃIuWFNg|C^ԂĂ̂ŁAɔ
	}
	else if( beforeType == DEF_OBJECT ){
		//QƂIuWFNg|C^ɕύX

		//mov eax,dword ptr[eax]
		compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_EAX, 0, MOD_BASE );
	}
	else{
		compiler.errorMessenger.Output(134,NULL,cp );
	}
}

void Opcode_Func_delegate_call( const char *paramsStr, Type &resultType, bool isDynamicCall, bool isCallOn )
{
	if( isCallOn )
	{
		int i = 0;
		char methodPtrParamStr[VN_SIZE];
		i = GetOneParameter( paramsStr, i, methodPtrParamStr );

		char objPtrValueStr[VN_SIZE]="";
		if( isDynamicCall )
		{
			i = GetOneParameter( paramsStr, i, objPtrValueStr );
		}

		Opcode_CallDelegate( compiler.GetObjectModule().meta.ToDelegate( compiler.GetCompilingClass() ), methodPtrParamStr, objPtrValueStr, paramsStr + i );
	}

	resultType = compiler.GetCompilingUserProc().ReturnType();
}
void Opcode_Func_System_Get_Bp()
{
	//mov eax,ebp
	compiler.codeGenerator.op_mov_RR(REG_EAX,REG_EBP);
}
void Opcode_Func_System_Get_Sp()
{
	//mov eax,esp
	compiler.codeGenerator.op_mov_RR(REG_EAX,REG_ESP);
}

void Opcode_Func_System_GetComVtbl( const char *parameter )
{
	Type classType;
	compiler.StringToType( parameter, classType );

	// mov eax,com_vtbl
	compiler.codeGenerator.op_mov_RV_com_vtbl( REG_EAX, &classType.GetClass() );
}
void Opcode_Func_System_GetVtblList( const char *parameter )
{
	Type classType;
	compiler.StringToType( parameter, classType );

	// mov eax,com_vtbl
	compiler.codeGenerator.op_mov_RV_vtbl( REG_EAX, &classType.GetClass() );
}
void Opcode_Func_System_GetDefaultConstructor( const char *parameter )
{
	Type classType;
	compiler.StringToType( parameter, classType );

	if( classType.GetClass().GetConstructorMethod() )
	{
		//mov eax,ProcAddr
		compiler.codeGenerator.op_addressof( REG_EAX, &classType.GetClass().GetConstructorMethod()->GetUserProc() );
	}
	else
	{
		// ftHgRXgN^Ȃ

		//xor eax,eax
		compiler.codeGenerator.op_zero_reg( REG_EAX );
	}
}
void Opcode_Func_System_GetDestructor( const char *parameter )
{
	Type classType;
	compiler.StringToType( parameter, classType );

	//mov eax,ProcAddr
	compiler.codeGenerator.op_addressof( REG_EAX, &classType.GetClass().GetDestructorMethod()->GetUserProc() );
}

void Opcode_Func_GetPtrData(const char *Parameter,const int type){
	Type tempType;
	if( !NumOpe(Parameter,Type(),tempType) ){
		return;
	}
	if(!tempType.IsWhole()){
		compiler.errorMessenger.Output(11,Parameter,cp);
		return;
	}
	ChangeTypeToLong(tempType.GetBasicType());

	if(type==DEF_DOUBLE){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//fld qword ptr[eax]
		compiler.codeGenerator.PutOld(
			(char)0xDD,
			(char)0x00
		);
	}
	else if(type==DEF_SINGLE||type==DEF_DWORD){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov eax,dword ptr[eax]
		compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_QWORD){
		//pop ecx
		compiler.codeGenerator.op_pop(REG_ECX);

		//mov eax,dword ptr[ecx]
		compiler.codeGenerator.op_mov_RM(sizeof(long),REG_EAX,REG_ECX,0,MOD_BASE);

		//mov edx,dword ptr[ecx+sizeof(long)]
		compiler.codeGenerator.op_mov_RM(sizeof(long),REG_EDX,REG_ECX,sizeof(long),MOD_BASE_DISP8);
	}
	else if(type==DEF_WORD){
		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//xor eax,eax
		compiler.codeGenerator.op_xor_RR(REG_EAX);

		//mov ax,word ptr[ebx]
		compiler.codeGenerator.op_mov_RM( sizeof(short), REG_EAX, REG_EBX, 0, MOD_BASE );
	}
	else if(type==DEF_BYTE){
		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//xor eax,eax
		compiler.codeGenerator.op_xor_RR(REG_EAX);

		//mov al,byte ptr[ebx]
		compiler.codeGenerator.op_mov_RM( sizeof(char), REG_EAX, REG_EBX, 0, MOD_BASE );
	}
}

bool Opcode_CallFunc( const char *Parameter, const int FuncNum, const Type &baseType, Type &resultType, bool isCallOn )
{
	switch(FuncNum){
		case FUNC_FIX:
			if( isCallOn ) Opcode_Func_Fix(Parameter);
			resultType.SetBasicType( DEF_LONG );
			break;
		case FUNC_CUDBL:
			if( isCallOn ) Opcode_Func_CUDbl(Parameter);
			resultType.SetBasicType( DEF_DOUBLE );
			break;
		case FUNC_LEN:
			if( isCallOn ) Opcode_Func_Len(Parameter);
			resultType.SetBasicType( DEF_LONG );
			break;
		case FUNC_ADDRESSOF:
			Opcode_Func_AddressOf( Parameter, baseType, isCallOn, resultType );
			break;
		case FUNC_SIZEOF:
			if( isCallOn ) Opcode_Func_SizeOf(Parameter);
			resultType.SetBasicType( DEF_LONG );
			break;
		case FUNC_CLASS_SIZEOF:
			if( isCallOn ) Opcode_Func_ClassSizeOf(Parameter);
			resultType.SetBasicType( DEF_LONG );
			break;
		case FUNC_VARPTR:
			Opcode_Func_VarPtr( Parameter, resultType, isCallOn );
			break;
		case FUNC_OBJPTR:
			Opcode_Func_ObjPtr( Parameter, resultType, isCallOn );
			break;
		case FUNC_DELEGATE_DYNAMICMETHOD_CALL:
			Opcode_Func_delegate_call( Parameter, resultType, true, isCallOn );
			break;
		case FUNC_DELEGATE_STATICMETHOD_CALL:
			Opcode_Func_delegate_call( Parameter, resultType, false, isCallOn );
			break;
		case FUNC_SYSTEM_GET_NOW_SCOPE_CATCH_ADDRESS:
			if( isCallOn ) Exception::Opcode_Func_System_GetNowScopeCatchAddress();
			resultType.SetBasicType( DEF_PTR_VOID );
			break;
		case FUNC_SYSTEM_GET_NOW_SCOPE_FINALLY_ADDRESS:
			if( isCallOn ) Exception::Opcode_Func_System_GetNowScopeFinallyAddress();
			resultType.SetBasicType( DEF_PTR_VOID );
			break;
		case FUNC_SYSTEM_GET_BP:
			if( isCallOn ) Opcode_Func_System_Get_Bp();
			resultType.SetBasicType( DEF_LONG );
			break;
		case FUNC_SYSTEM_GET_SP:
			if( isCallOn ) Opcode_Func_System_Get_Sp();
			resultType.SetBasicType( DEF_LONG );
			break;
		case FUNC_SYSTEM_GET_COM_VTBL:
			if( isCallOn ) Opcode_Func_System_GetComVtbl( Parameter );
			resultType.SetBasicType( DEF_PTR_VOID );
			break;
		case FUNC_SYSTEM_GET_VTBL_LIST:
			if( isCallOn ) Opcode_Func_System_GetVtblList( Parameter );
			resultType.SetBasicType( DEF_PTR_VOID );
			break;
		case FUNC_SYSTEM_GET_DEFAULT_CONSTRUCTOR:
			if( isCallOn ) Opcode_Func_System_GetDefaultConstructor( Parameter );
			resultType.SetBasicType( DEF_PTR_VOID );
			break;
		case FUNC_SYSTEM_GET_DESTRUCTOR:
			if( isCallOn ) Opcode_Func_System_GetDestructor( Parameter );
			resultType.SetBasicType( DEF_PTR_VOID );
			break;

		case FUNC_GETDOUBLE:
			if( isCallOn ) Opcode_Func_GetPtrData(Parameter,DEF_DOUBLE);
			resultType.SetBasicType( DEF_DOUBLE );
			break;
		case FUNC_GETSINGLE:
			if( isCallOn ) Opcode_Func_GetPtrData(Parameter,DEF_SINGLE);
			resultType.SetBasicType( DEF_SINGLE );
			break;
		case FUNC_GETQWORD:
			if( isCallOn ) Opcode_Func_GetPtrData(Parameter,DEF_QWORD);
			resultType.SetBasicType( DEF_QWORD );
			break;
		case FUNC_GETDWORD:
			if( isCallOn ) Opcode_Func_GetPtrData(Parameter,DEF_DWORD);
			resultType.SetBasicType( DEF_DWORD );
			break;
		case FUNC_GETWORD:
			if( isCallOn ) Opcode_Func_GetPtrData(Parameter,DEF_WORD);
			resultType.SetBasicType( DEF_WORD );
			break;
		case FUNC_GETBYTE:
			if( isCallOn ) Opcode_Func_GetPtrData(Parameter,DEF_BYTE);
			resultType.SetBasicType( DEF_BYTE );
			break;
		default:
			return false;
	}
	return true;
}
