#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"


void SetXmmReg_DoubleVariable(RELATIVE_VAR *pRelativeVar,int xmm_reg){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//movlpd xmm_reg,qword ptr[r11+offset]
			compiler.codeGenerator.op_movlpd_RM( xmm_reg, REG_R11, (long)pRelativeVar->offset, MOD_BASE_DISP32, Schedule::GlobalVar );
		}
		else{
			//movlpd xmm_reg,qword ptr[offset]
			compiler.codeGenerator.op_movlpd_RM( xmm_reg, 0, (long)pRelativeVar->offset, MOD_DISP32, Schedule::GlobalVar );
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		compiler.errorMessenger.Output(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//movlpd xmm_reg,qword ptr[rsp+r11+offset]
			compiler.codeGenerator.PutOld(
				(char)0x66,
				(char)0x42,
				(char)0x0F,
				(char)0x12,
				(char)(0x84 | REGISTER_OPERAND(xmm_reg)<<3),
				(char)0x1C
			);
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.PutOld( (long)pRelativeVar->offset, true )
			);
		}
		else{
			//movlpd xmm_reg,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_movlpd_RM( xmm_reg, REG_RSP, (long)pRelativeVar->offset, MOD_BASE_DISP32, Schedule::None, true )
			);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//movlpd xmm_reg,qword ptr[r11]
		compiler.codeGenerator.op_movlpd_RM( xmm_reg, REG_R11, 0, MOD_BASE);
	}
}
void SetXmmReg_SingleVariable(RELATIVE_VAR *pRelativeVar,int xmm_reg){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//movss xmm_reg,dword ptr[r11+offset]
			compiler.codeGenerator.op_movss_RM( xmm_reg, REG_R11, (long)pRelativeVar->offset, MOD_BASE_DISP32, Schedule::GlobalVar );
		}
		else{
			//movss xmm_reg,dword ptr[offset]
			compiler.codeGenerator.op_movss_RM( xmm_reg, 0, (long)pRelativeVar->offset, MOD_DISP32, Schedule::GlobalVar );
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		compiler.errorMessenger.Output(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//movss xmm_reg,dword ptr[rsp+r11+offset]
			compiler.codeGenerator.PutOld(
				(char)0xF3,
				(char)0x42,
				(char)0x0F,
				(char)0x10,
				(char)(0x84 | REGISTER_OPERAND(xmm_reg)<<3),
				(char)0x1C
			);
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.PutOld( (long)pRelativeVar->offset, true )
			);
		}
		else{
			//movss xmm_reg,dword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_movss_RM( xmm_reg, REG_RSP, (long)pRelativeVar->offset, MOD_BASE_DISP32, Schedule::None, true )
			);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//movss xmm_reg,dword ptr[r11]
		compiler.codeGenerator.op_movss_RM( xmm_reg, REG_R11, 0, MOD_BASE);
	}
}


void SetReg_WholeVariable( const Type &type, RELATIVE_VAR *pRelativeVar,int reg)
{
	int varSize = type.GetSize();

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[r11+offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,REG_R11,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov reg, ptr[offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,0,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[offset]
			compiler.codeGenerator.op_add_RM(sizeof(_int64),REG_R11,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov r11,qword ptr[offset]
			compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[rsp+r11+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM_ex(varSize,reg,REG_RSP,REG_R11,(int)pRelativeVar->offset,USE_OFFSET, Schedule::None, true )
			);
		}
		else{
			//mov reg, ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(varSize,reg,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//mov reg, ptr[r11]
		compiler.codeGenerator.op_mov_RM(varSize,reg,REG_R11,0,MOD_BASE);
	}
}
