#include "stdafx.h"

using namespace ActiveBasic::Common;


void ResourceManager::Clear()
{
	this->cursorResources.clear();
	this->bitmapResources.clear();
	this->iconResources.clear();
	this->manifestFilePath.clear();
}

bool ResourceManager::Load( const std::string &resourceFilePath )
{
	// ܂̓NA
	this->Clear();


	int i2,i3;
	char temp2[MAX_PATH];
	HANDLE hFile;

	hFile=CreateFile(resourceFilePath.c_str(),GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE)
	{
		return false;
	}
	i2=GetFileSize(hFile,NULL);
	char *_buf = (char *)malloc(i2*2+1);
	ReadFile(hFile,_buf,i2,(DWORD *)&i3,NULL);
	CloseHandle(hFile);
	_buf[i3]=0;
	std::string buffer = _buf;
	free(_buf);

	// sR[hCRLFLFɕϊ
	Jenga::Common::StringReplace( buffer, "\r\n", "\n" );

	std::string baseDir = Jenga::Common::Path::ExtractDirPath( resourceFilePath );

	i2=0;
	while(1){
		//ID
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

		std::string _idname = Jenga::Common::EasyToken::GetIdentifierToken( buffer, i2 );

		if( _idname.size() == 0 )
		{
			break;
		}

		//Type
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		char temporary[MAX_PATH];
		lstrcpy( temporary, Jenga::Common::EasyToken::GetIdentifierToken( buffer, i2 ).c_str() );

		//FileName
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		if(buffer[i2]!='\"'){
			//G[
			return false;
		}
		for(i2++,i3=0;;i2++,i3++){
			if(buffer[i2]=='\"'){
				temp2[i3]=0;
				break;
			}
			temp2[i3]=buffer[i2];
		}
		lstrcpy( temp2, Jenga::Common::Directory( baseDir ).GetFullPath( temp2 ).c_str() );

		ResourceItem item;
		item.idName = _idname;
		item.filepath = temp2;

		if(lstrcmpi(temporary,"CURSOR")==0)
		{
			this->cursorResources.push_back( item );
		}
		else if(lstrcmpi(temporary,"BITMAP")==0)
		{
			this->bitmapResources.push_back( item );
		}
		else if(lstrcmpi(temporary,"ICON")==0)
		{
			this->iconResources.push_back( item );
		}
		else if(lstrcmpi(temporary,"RT_MANIFEST")==0)
		{
			if( !this->manifestFilePath.empty() )
			{
				// ߍ݃}jtFXg2ȏw肳ꂽ
				return false;
			}

			this->manifestFilePath = temp2;
		}
		else
		{
			return false;
		}

		i2++;
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		if(buffer[i2]=='\0') break;
		else if(buffer[i2]!='\n')
		{
			return false;
		}
		i2++;
	}

	return true;
}

bool ResourceManager::HasManifest() const
{
	return !this->manifestFilePath.empty();
}
