#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SetReg_RealVariable(int type,RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//fld ptr[ecx+offset]
			compiler.codeGenerator.op_fld_base_offset(type,REG_ECX,(int)pRelativeVar->offset, Schedule::GlobalVar );
		}
		else{
			//mov ecx,offset
			compiler.codeGenerator.op_mov_RV(REG_ECX,(int)pRelativeVar->offset, Schedule::GlobalVar );

			//fld ptr[ecx]
			compiler.codeGenerator.op_fld_basereg(type,REG_ECX);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		compiler.errorMessenger.Output(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//fld ptr[ebp+ecx+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_fld_base_offset_ex(type,REG_EBP,REG_ECX,(int)pRelativeVar->offset,USE_OFFSET, Schedule::None, true )
			);
		}
		else{
			//fld ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_fld_base_offset(type,REG_EBP,(int)pRelativeVar->offset, Schedule::None, true )
			);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RM(sizeof(long),REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			//mov ecx,qword ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(sizeof(long),REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//fld ptr[ecx]
		compiler.codeGenerator.op_fld_basereg(type,REG_ECX);
	}
}
void SetReg_WholeVariable( const Type &type, RELATIVE_VAR *pRelativeVar,int reg, bool is64Head)
{
	int varSize;

	varSize = type.GetSize();

	if(varSize==sizeof(_int64)){
		//64rbg̏ꍇedx:eaxɃ[h
		if(reg!=REG_EAX){
			compiler.errorMessenger.Output(300,NULL,cp);
			return;
		}

		//32rbgeaxɃ[h
		SetReg_WholeVariable( Type(DEF_LONG),pRelativeVar,REG_EAX);

		//32rbgedxɃ[h
		SetReg_WholeVariable( Type(DEF_LONG),pRelativeVar,REG_EDX, true);

		return;
	}

	int offsetOf64Head = 0;
	if( is64Head ){
		offsetOf64Head = sizeof(long);
	}

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[ecx+offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,REG_ECX,(int)pRelativeVar->offset + offsetOf64Head,MOD_BASE_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov reg, ptr[offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,0,(int)pRelativeVar->offset + offsetOf64Head,MOD_DISP32, Schedule::GlobalVar );
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[offset]
			compiler.codeGenerator.op_add_RM(varSize,REG_ECX,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov ecx,qword ptr[offset]
			compiler.codeGenerator.op_mov_RM(varSize,REG_ECX,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[ebp+ecx+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM_ex(varSize,reg,REG_EBP,REG_ECX,(int)pRelativeVar->offset + offsetOf64Head,USE_OFFSET, Schedule::None, true )
			);
		}
		else{
			//mov reg, ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(varSize,reg,REG_EBP,(int)pRelativeVar->offset + offsetOf64Head,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RM(varSize,REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			//mov ecx,qword ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(varSize,REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		if( is64Head ){
			//mov reg, ptr[ecx]
			compiler.codeGenerator.op_mov_RM(varSize,reg,REG_ECX,offsetOf64Head,MOD_BASE_DISP8);
		}
		else{
			//mov reg, ptr[ecx]
			compiler.codeGenerator.op_mov_RM(varSize,reg,REG_ECX,0,MOD_BASE);
		}
	}
}



void PushLongVariable(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//push dword ptr[ecx+offset]
			compiler.codeGenerator.op_push_M( REG_ECX, pRelativeVar->offset, Schedule::GlobalVar );
		}
		else{
			//push dword ptr[offset]
			compiler.codeGenerator.op_push_M( REG_NON, pRelativeVar->offset, Schedule::GlobalVar );
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		//mov eax,dword ptr[offset]
		compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32, Schedule::GlobalVar );

		if(pRelativeVar->bOffsetOffset){
			//add eax,ecx
			compiler.codeGenerator.op_add_RR( REG_EAX, REG_ECX );
		}

		//push dword ptr[eax]
		compiler.codeGenerator.op_push_M( REG_EAX );
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RV( REG_ECX, pRelativeVar->offset, Schedule::None, true )
			);

			//push dword ptr[ebp+ecx]
			compiler.codeGenerator.PutOld(
				(char)0xFF,
				(char)0x74,
				(char)0x0D,
				(char)0x00
			);
		}
		else{
			//push dword ptr[ebp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_push_M( REG_EBP, pRelativeVar->offset, Schedule::None, true )
			);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov eax,dword ptr[ebp+offset]
		compiler.codeGenerator.localVarPertialSchedules.push_back(
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_EBP, pRelativeVar->offset, MOD_BASE_DISP32, Schedule::None, true )
		);

		if(pRelativeVar->bOffsetOffset){
			//add eax,ecx
			compiler.codeGenerator.op_add_RR( REG_EAX, REG_ECX );
		}

		//push dword ptr[eax]
		compiler.codeGenerator.op_push_M( REG_EAX );
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//push dword ptr[ecx]
		compiler.codeGenerator.op_push_M( REG_ECX );
	}
}
