#include "stdafx.h"

#include "common.h"

void TextEditEvent_LButtonDown(HWND hwnd,POINT *pMousePos){
	POINT pos;
	int i;

	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	if((GetKeyState(VK_CONTROL)&0x8000)&&pobj_nv->bCtrlKeyHyperLink){
		//CtrlL[ĂƂ
		if(MdiInfo[WndNum]->pMdiTextEdit->iUnderStart!=-1){
			//PꂪI\ȂƂ

			//pȊSpƂ̃YC
			int start,end;
			start=MdiInfo[WndNum]->pMdiTextEdit->iUnderStart;
			end=MdiInfo[WndNum]->pMdiTextEdit->iUnderEnd;
			GetCaretPosFromBufferIndex(MdiInfo[WndNum]->pMdiTextEdit->buffer,start,&pos);
			start=GetBufferIndexFromCaretPos(MdiInfo[WndNum]->pMdiTextEdit->buffer,pos.x,pos.y);
			GetCaretPosFromBufferIndex(MdiInfo[WndNum]->pMdiTextEdit->buffer,end,&pos);
			end=GetBufferIndexFromCaretPos(MdiInfo[WndNum]->pMdiTextEdit->buffer,pos.x,pos.y);

			int length;
			length=end-start;
			if(length<=0) return;

			char *pTemp;
			pTemp=(char *)HeapAlloc(hHeap,0,length+1);
			memcpy(
				pTemp,
				MdiInfo[WndNum]->pMdiTextEdit->buffer+start,
				length);
			pTemp[length]=0;

			obj_WebStrings.add(pTemp);

			extern HWND hWebSearchCombo;
			SetWindowText(GetWindow(hWebSearchCombo,GW_CHILD),obj_WebStrings.GetBuffer());

			SendMessage(GetWindow(hWebSearchCombo,GW_CHILD),WM_CHAR,VK_RETURN,0);

			HeapDefaultFree(pTemp);

			return;
		}
	}

	SetFocus(hwnd);
	SetCapture(hwnd);

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;

	if(MdiInfo[WndNum]->IndentStr){
		//Cfg̃Cfg𖳌ɂ
		CancelBeforeAutoIndent(WndNum);
	}

	MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll=0;

	//㉺Lbgړ̍Eʒuێ@\
	MdiInfo[WndNum]->pMdiTextEdit->Temp_UpDown_CaretXPos=-1;

	if(0<=(pMousePos->x) && (pMousePos->x)<iControlTabSpace){
		//Rg[^uNbNƂ̏

		//J[\}[Nɂ
		SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_ARROW_TO_RIGHT)));

		GetNaturalCaretPos_Click(WndNum,
			0,
			pMousePos->y,
			&MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos);
		MdiInfo[WndNum]->pMdiTextEdit->EndCaretPos=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos;

		////////////
		// sI
		////////////

		char *pBuf;
		pBuf=MdiInfo[WndNum]->pMdiTextEdit->buffer;
		CHARRANGE CharRange;
		TextEdit_GetSel(WndNum,&CharRange);
		i=CharRange.cpMin;
		for(;;i++){
			if(pBuf[i]=='\0') break;
			if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
				i+=2;
				break;
			}
		}
		TextEdit_SetSel(WndNum,
			i,
			CharRange.cpMin);
	}
	else{
		GetNaturalCaretPos_Click(WndNum,
			pMousePos->x-iControlTabSpace,
			pMousePos->y,
			&MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos);

		if(!(GetKeyState(VK_SHIFT)&0x8000)){
			//VtgL[ĂȂAʏ펞
			MdiInfo[WndNum]->pMdiTextEdit->EndCaretPos=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos;
		}

		ResetCaretPos(WndNum);

		if(!TextEdit_ScrollCaret(WndNum,0)){
			//ĕ`iI̔]\ꂽƂlj
			UpdateWindow(hwnd);	//h~
			InvalidateRect(hwnd,NULL,0);
		}
	}
}

void TextEditEvent_LButtonUp(HWND hwnd,POINT *pMousePos){
	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;

	if(0<=(pMousePos->x) && (pMousePos->x)<iControlTabSpace){
		//Rg[^uNbNƂ̏

		//J[\}[Nɂ
		SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_ARROW_TO_RIGHT)));
	}

	if(GetCapture()==hwnd){
		//////////////////////////
		// hbOIƂ
		//////////////////////////

		ReleaseCapture();

		//I[gXN[Xbh~
		MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll=0;

		//ҏWj[Zbg
		ResetState_EditMenu();
	}
}

void AutoScrollThread(HWND hwnd){
	//////////////////////////////
	// EɃI[gXN[
	//////////////////////////////

	int WndNum;
	POINT pos;

	WndNum=GetWndNum(GetParent(hwnd));

	
	//GfB^ʍ[̃Rg[^u
	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;


	while(MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll){
		GetCursorPos(&pos);
		ScreenToClient(hwnd,&pos);

		GetNaturalCaretPos_Click(WndNum,
			pos.x-iControlTabSpace,
			pos.y,
			&pos);

		//݂Lbgʒuɕϊ
		CaretPos_LooseToNatural(WndNum,
			pos.x,
			pos.y,
			&MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos);

		if(!TextEdit_ScrollCaret(WndNum,1))
			InvalidateRect(hwnd,NULL,0);

		//ʃXbhResetCaretPosĂяo
		SendMessage(hwnd,WM_RESETCARETPOS,0,0);

		Sleep(70);
	}

	_endthread();
}
void TextEditEvent_MouseMove(HWND hwnd,POINT *pMousePos){
	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));
	if(WndNum==-1) return;

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;

	if(GetCapture()==hwnd){
		//////////////
		// hbO
		//////////////

		RECT rect;
		GetClientRect(hwnd,&rect);

		if(
			(short)pMousePos->y<0||				//փI[gXN[
			rect.bottom<=(short)pMousePos->y||	//փI[gXN[
			(short)pMousePos->x<iControlTabSpace||	//փI[gXN[
			rect.right<=(short)pMousePos->x		//EփI[gXN[
			){
			////////////////////////////
			// I[gXN[
			////////////////////////////

			if(MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll){
				//łɃI[gXN[Xbh쓮̂Ƃ͔o
				return;
			}

			//I[gXN[XbhN
			MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll=1;

			_beginthread((void (__cdecl *)(void *))AutoScrollThread,0,(void *)hwnd);

			return;
		}
		else if(MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll){
			//I[gXN[
			MdiInfo[WndNum]->pMdiTextEdit->bAutoScroll=0;
		}


		//////////////////////
		// ʏ̃hbOI
		//////////////////////

		POINT pos;
		GetNaturalCaretPos_Click(WndNum,
			pMousePos->x-iControlTabSpace,
			pMousePos->y,
			&pos);

		if(pos.x!=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.x||pos.y!=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.y){
			MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos=pos;

			InvalidateRect(hwnd,NULL,0);
			ResetCaretPos(WndNum);
		}
	}
	else{
		if(0<=pMousePos->x&&pMousePos->x<iControlTabSpace){
			//Rg[^ȕɃ|C^Ƃ

			//J[\}[Nɂ
			SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_ARROW_TO_RIGHT)));

			return;
		}

		if(pobj_nv->bCtrlKeyHyperLink){
			if(GetKeyState(VK_CONTROL)&0x8000){
				//CtrlL[ĂƂ

				POINT pos;
				GetNaturalCaretPos_Click(WndNum,
					pMousePos->x-iControlTabSpace,
					pMousePos->y,
					&pos);

				TextEdit_GetWordCaret(
					MdiInfo[WndNum]->pMdiTextEdit->hEdit,
					WndNum,
					&pos,
					&MdiInfo[WndNum]->pMdiTextEdit->iUnderStart,&MdiInfo[WndNum]->pMdiTextEdit->iUnderEnd,
					WORDCARET_AFTER);

				SetCursor(LoadCursor(0,IDC_ARROW));

				InvalidateRect(hwnd,NULL,0);
				UpdateWindow(hwnd);
			}
			else{
				if(MdiInfo[WndNum]->pMdiTextEdit->iUnderStart!=-1){
					MdiInfo[WndNum]->pMdiTextEdit->iUnderStart=-1;
					MdiInfo[WndNum]->pMdiTextEdit->iUnderEnd=-1;

					InvalidateRect(hwnd,NULL,0);
					UpdateWindow(hwnd);
				}
			}
		}
	}
}

void TextEdit_WordSelect(HWND hwnd,int WndNum){
	////////////////////////////////////
	// _uNbNɂPZNg
	////////////////////////////////////

	int start,end;
	TextEdit_GetWordCaret(hwnd,WndNum,&MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos,&start,&end,WORDCARET_AFTER);

	//ZNg
	TextEdit_SetSel(WndNum,start,end);

	//ĕ`
	InvalidateRect(hwnd,NULL,0);
	ResetCaretPos(WndNum);
}
void TextEditEvent_LButtonDblClk(HWND hwnd,POINT *pMousePos){
	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;

	if(0<=(pMousePos->x) && (pMousePos->x)<iControlTabSpace){
		//Rg[^u_uNbNƂ̏

		//J[\}[NiftHgjɂ
		SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_ARROW_TO_RIGHT)));

		return;
	}
	else{
		TextEdit_WordSelect(hwnd,WndNum);

		//ҏWj[Zbg
		ResetState_EditMenu();
	}
}
