#include "stdafx.h"

#include "Common.h"

#if defined(JPN)
//{
#include "rad_msg_jpn.h"
#else
//p
#include "rad_msg_eng.h"
#endif

int GetMenuInfoNum(const std::string &name){
	int i;
	for(i=0;i<projectInfo.NumberOfMenu;i++){
		if(lstrcmpi(name.c_str(),projectInfo.pMenuInfo[i].IdName)==0) return i;
	}
	return -1;
}
void HeapMenuDataFree(MENU_INFO *pMenuInfo,int ItemNum,int *NumberOfFreedItem){
	extern HANDLE hHeap;
	int i;
	for(i=0;i<ItemNum;i++){
		if(NumberOfFreedItem) (*NumberOfFreedItem)++;
		if(pMenuInfo[i].caption) HeapDefaultFree(pMenuInfo[i].caption);
		if(pMenuInfo[i].IdName) HeapDefaultFree(pMenuInfo[i].IdName);
		if(pMenuInfo[i].pMenuInfo){
			HeapMenuDataFree(pMenuInfo[i].pMenuInfo,pMenuInfo[i].NumberOfMenu,NumberOfFreedItem);
			HeapDefaultFree(pMenuInfo[i].pMenuInfo);
		}
	}
}

BOOL CALLBACK DlgProject_MenuID_Input(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern char NewIdName[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			if(lParam==0){
				//"VKj["
				SetWindowText(hwnd,STRING_MENUEDIT_MAKE_NEWMENU);
			}
			else{
				//"j[ID̕ύX"
				SetWindowText(hwnd,STRING_MENUEDIT_RENAME_MENUID);
				SetDlgItemText(hwnd,IDC_IDNAME,(char *)lParam);
			}
			SetPosCenter(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_IDNAME,NewIdName,MAX_PATH);
					if(!NewIdName[0]){
						//"ID͂ĉB"
						MessageBox(hwnd,STRING_ERROR_MUST_IDNAME,STRING_ERROR,MB_OK);
						return 1;
					}
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
void Project_Menu_Insert(void){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	int i;
	char temporary[MAX_PATH];
	MENU_INFO *MenuInfo;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_MenuID_Input,0)) return;

	//d`FbN
	for(i=0;i<projectInfo.NumberOfMenu;i++){
		if(lstrcmpi(NewIdName,projectInfo.pMenuInfo[i].IdName)==0){
			//"\"%s\" j[͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_MENUEDIT_DUPLICATIONERROR,projectInfo.pMenuInfo[i].IdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	projectInfo.pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,0,projectInfo.pMenuInfo,(projectInfo.NumberOfMenu+1)*sizeof(MENU_INFO));
	MenuInfo=&projectInfo.pMenuInfo[projectInfo.NumberOfMenu];

	MenuInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(MenuInfo->IdName,NewIdName);

	MenuInfo->caption=0;

	MenuInfo->NumberOfMenu=0;
	MenuInfo->pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);


	//////////////////////
	//c[r[ɒǉ

	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=3;
	tv.item.iSelectedImage=3;
	tv.hParent=projectInfo.hMenuTreeItem;
	tv.item.pszText=MenuInfo->IdName;

	MenuInfo->hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,MenuInfo->hTreeItem);


	projectInfo.NumberOfMenu++;
	projectInfo.ModifyOfMaterial=1;


	////////////////////////////////
	// EBhE vpeBXV
	for(i=0;i<MdiInfo.size();i++){
		if(MdiInfo[i]->hwnd&&MdiInfo[i]->DocType==WNDTYPE_RAD){
			if(MdiInfo[i]->MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i,GetWndInfoNum(MdiInfo[i]->path));
		}
	}

	NewMenuWindow(&projectInfo.pMenuInfo[projectInfo.NumberOfMenu-1]);
}
void Project_Menu_Delete(int MenuInfoNum){
	extern HANDLE hHeap;
	int i;

	//EBhEJĂꍇ͕
	for(i=0;i<MdiInfo.size();i++){
		if(MdiInfo[i]->hwnd&&lstrcmpi(projectInfo.pMenuInfo[MenuInfoNum].IdName,MdiInfo[i]->path.c_str())==0){
			SendMessage(MdiInfo[i]->hwnd,WM_CLOSE,0,0);
			break;
		}
	}

	//j[̃
	HeapMenuDataFree(projectInfo.pMenuInfo[MenuInfoNum].pMenuInfo,projectInfo.pMenuInfo[MenuInfoNum].NumberOfMenu,0);
	HeapDefaultFree(projectInfo.pMenuInfo[MenuInfoNum].pMenuInfo);
	HeapDefaultFree(projectInfo.pMenuInfo[MenuInfoNum].IdName);

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.pMenuInfo[MenuInfoNum].hTreeItem);

	//projectInfo.pMenuInfo\̂폜
	projectInfo.NumberOfMenu--;
	for(i=MenuInfoNum;i<projectInfo.NumberOfMenu;i++) projectInfo.pMenuInfo[i]=projectInfo.pMenuInfo[i+1];
	if(projectInfo.NumberOfMenu==0){
		HeapDefaultFree(projectInfo.pMenuInfo);
		projectInfo.pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
	}
	else projectInfo.pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,0,projectInfo.pMenuInfo,projectInfo.NumberOfMenu*sizeof(MENU_INFO));

	projectInfo.ModifyOfMaterial=1;


	////////////////////////////////
	// EBhE vpeBXV
	for(i=0;i<MdiInfo.size();i++){
		if(MdiInfo[i]->hwnd&&MdiInfo[i]->DocType==WNDTYPE_RAD){
			if(MdiInfo[i]->MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i,GetWndInfoNum(MdiInfo[i]->path.c_str()));
		}
	}
}

void SetMenuDataList(HWND hList,MENU_INFO *pMenuInfo,int GradeNum){
	int i;
	char temporary[MAX_PATH];
	for(i=0;i<pMenuInfo->NumberOfMenu;i++){
		memset(temporary,' ',GradeNum*4);
		temporary[GradeNum*4]=0;
		if(pMenuInfo->pMenuInfo[i].type==MFT_SEPARATOR)
			lstrcpy(temporary+GradeNum*4,"-");
		else
			lstrcpy(temporary+GradeNum*4,pMenuInfo->pMenuInfo[i].caption);
		SendMessage(hList,LB_ADDSTRING,0,(long)temporary);
		if(pMenuInfo->pMenuInfo[i].pMenuInfo)
			SetMenuDataList(hList,&pMenuInfo->pMenuInfo[i],GradeNum+1);
	}
}
void NewMenuWindow(MENU_INFO *pMenuInfo){
	extern HINSTANCE hInst;
	extern HWND hDocCombo;
	int i;
	HWND hChild,hListWnd,hMenuEdit;
	RECT rect;
	MDICREATESTRUCT mdic;

	//łɎw肳ꂽt@CJĂꍇ
	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		i=GetWndNum(hChild);
		if(MdiInfo[i]->DocType==WNDTYPE_MENU){
			if(lstrcmpi(MdiInfo[i]->path.c_str(),pMenuInfo->IdName)==0) break;
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}
	if(hChild){
		BringWindowToTop(hChild);
		return;
	}

	mdic.szTitle=pMenuInfo->IdName;
	mdic.szClass="MDIClientWindow_Menu";
	mdic.hOwner=hInst;
	mdic.x=CW_USEDEFAULT;
	mdic.y=CW_USEDEFAULT;
	mdic.cx=CW_USEDEFAULT;
	mdic.cy=CW_USEDEFAULT;

	hChild=GetWindow(hClient,GW_CHILD);
	if(IsWindow(hChild)){
		if(IsZoomed(hChild)) mdic.style=WS_MAXIMIZE;
		else mdic.style=0;
	}
	else{
		if(pobj_nv->bMDIZoomed) mdic.style=WS_MAXIMIZE;
		else mdic.style=0;
	}

	mdic.lParam=0;
	mdic.style |= WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_SYSMENU | WS_CAPTION | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
	hChild=(HWND)SendMessage(hClient,WM_MDICREATE,0,(LPARAM)&mdic);	//EBhE쐬


	////////////////////
	//qEBhE쐬

	//_CAỎn쐬
	hMenuEdit=CreateWindowEx(WS_EX_CLIENTEDGE,"MenuEditWindow",NULL,
		WS_CHILD|WS_VSCROLL|WS_VISIBLE,
		0,0,0,0,
		hChild,NULL,hInst,NULL);

	//j[ Xg EBhE쐬
	hListWnd=CreateWindowEx(WS_EX_CLIENTEDGE,"LISTBOX",NULL,
		WS_CHILD|WS_HSCROLL|WS_VSCROLL|WS_VISIBLE|LBS_NOTIFY|LBS_NOINTEGRALHEIGHT,
		0,0,0,0,
		hChild,NULL,hInst,NULL);


	//EBhEIDo^
	MdiInfo.push_back( new MDIINFO() );
	i = MdiInfo.size()-1;
	MdiInfo[i]->hwnd=hChild;
	MdiInfo[i]->DocType=WNDTYPE_MENU;
	MdiInfo[i]->title = pMenuInfo->IdName;
	MdiInfo[i]->path = pMenuInfo->IdName;


	/////////////////////
	//MENU EBhE

	MdiInfo[i]->MdiMenuInfo=(MDIMENUINFO *)GlobalAlloc(GPTR,sizeof(MDIMENUINFO));

	MdiInfo[i]->MdiMenuInfo->hList=hListWnd;

	MdiInfo[i]->MdiMenuInfo->hMenuEdit=hMenuEdit;
	MdiInfo[i]->MdiMenuInfo->hEdit_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_PROJECT_MENUEDIT),hMenuEdit,(DLGPROC)MenuEditDlg);

	SCROLLINFO ScrollInfo;
	ScrollInfo.cbSize=sizeof(SCROLLINFO);
	ScrollInfo.fMask=SIF_POS;
	ScrollInfo.nPos=0;
	SetScrollInfo(MdiInfo[i]->MdiMenuInfo->hMenuEdit,SB_VERT,&ScrollInfo,1);

	SendMessage(hListWnd,LB_RESETCONTENT,0,0);
	SetMenuDataList(hListWnd,pMenuInfo,0);
	if(pMenuInfo->NumberOfMenu){
		SendMessage(hListWnd,LB_SETCURSEL,0,0);
		SendMessage(hChild,WM_COMMAND,MAKELONG(0,LBN_SELCHANGE),(long)hListWnd);
	}


	//EBhEʒu
	GetClientRect(hChild,&rect);
	MoveWindow(MdiInfo[i]->MdiMenuInfo->hMenuEdit,0,0,172,rect.bottom,1);
	MoveWindow(MdiInfo[i]->MdiMenuInfo->hList,172,0,rect.right-172,rect.bottom,1);

	//DocR{{bNXɒǉ
	i=SendMessage(hDocCombo,CB_ADDSTRING,0,(long)pMenuInfo->IdName);
	SendMessage(hDocCombo,CB_SETCURSEL,i,0);

	//^uɒǉ
	pobj_MainTab->InsertItem( hChild, pMenuInfo->IdName, true );

	SetFocus(hListWnd);

	//j[Ԃݒ
	ResetState_DocMenu();
}

int GetNumberOfMenu(MENU_INFO *pMenuInfo){
	int i,i2;
	for(i=0,i2=0;i<pMenuInfo->NumberOfMenu;i++,i2++){
		if(pMenuInfo->pMenuInfo[i].pMenuInfo) i2+=GetNumberOfMenu(&pMenuInfo->pMenuInfo[i]);
	}
	return i2;
}
MENU_INFO *GetMenuInfoFromList(MENU_INFO *pMenuInfo,int *pPos,int index,int *GradeNum){
	int i;
	MENU_INFO *pRetMenuInfo;
	for(i=0;i<pMenuInfo->NumberOfMenu;i++){
		if((*pPos)==index){
			*pPos=i;
			return pMenuInfo;
		}
		(*pPos)++;
		if(pMenuInfo->pMenuInfo[i].pMenuInfo){
			(*GradeNum)++;
			pRetMenuInfo=GetMenuInfoFromList(&pMenuInfo->pMenuInfo[i],pPos,index,GradeNum);
			if(pRetMenuInfo) return pRetMenuInfo;
			(*GradeNum)--;
		}
	}
	return 0;
}
BOOL CALLBACK DlgMenuProperty_Rename(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern HWND hClient,hOwner;
	int i;
	char temporary[MAX_PATH];
	static MENU_INFO *pMenuInfo;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			i=GetWndNum(GetWindow(hClient,GW_CHILD));
			GetDlgItemText(MdiInfo[i]->MdiMenuInfo->hEdit_Dlg,IDC_IDNAME,temporary,MAX_PATH);
			SetDlgItemText(hwnd,IDC_IDNAME,temporary);
			GetDlgItemText(MdiInfo[i]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTION,temporary,MAX_PATH);
			SetDlgItemText(hwnd,IDC_CAPTION,temporary);

			pMenuInfo=(MENU_INFO *)lParam;
			if(pMenuInfo->pMenuInfo){
				EnableWindow(GetDlgItem(hwnd,IDC_IDSTATIC),0);
				EnableWindow(GetDlgItem(hwnd,IDC_IDNAME),0);
			}
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					i=GetWndNum(GetWindow(hClient,GW_CHILD));

					if(!pMenuInfo->pMenuInfo){
						//ID
						GetDlgItemText(hwnd,IDC_IDNAME,temporary,MAX_PATH);
						if(!temporary[0]){
							//"ID͂ĉB"
							MessageBox(hOwner,STRING_ERROR_MUST_IDNAME,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
							break;
						}
						HeapDefaultFree(pMenuInfo->IdName);
						pMenuInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->IdName,temporary);
					}

					//LvV
					GetDlgItemText(hwnd,IDC_CAPTION,temporary,MAX_PATH);
					if(!temporary[0]){
						//"LvV͂ĉB"
						MessageBox(hOwner,STRING_ERROR_MUST_CAPTION,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
						break;
					}
					HeapDefaultFree(pMenuInfo->caption);
					pMenuInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
					lstrcpy(pMenuInfo->caption,temporary);

					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
BOOL CALLBACK MenuEditDlg(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	int i,i2,i3,i4,WndNum,MenuInfoNum;
	char temporary[MAX_PATH];
	MENU_INFO *pMenuInfo,tempMenuInfo;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_RENAME:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR) return 1;
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					pMenuInfo=&pMenuInfo->pMenuInfo[i2];

					if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_PROJECT_MENURENAME),hOwner,(DLGPROC)DlgMenuProperty_Rename,(long)pMenuInfo)) return 1;
					GetDlgItemText(hwnd,IDC_IDNAME,temporary,MAX_PATH);

					if(!pMenuInfo->pMenuInfo){
						//ID
						SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDNAME,pMenuInfo->IdName);
					}

					//LvV
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTION,pMenuInfo->caption);

					//XgփLvV𔽉f
					SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_DELETESTRING,i4,0);
					memset(temporary,' ',i3*4);
					lstrcpy(temporary+i3*4,pMenuInfo->caption);
					SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_INSERTSTRING,i4,(long)temporary);

					SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,i4,0);
					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_POPUP:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR) return 1;
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					pMenuInfo=&pMenuInfo->pMenuInfo[i2];

					if(pMenuInfo->pMenuInfo){
						if(pMenuInfo->NumberOfMenu){
							//"̑sƃ|bvAbv郁j[ ACe폜܂B"
							if(MessageBox(hOwner,STRING_MENUEDIT_DELETECHECK,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)==IDCANCEL) return 1;
						}
						i=0;
						HeapMenuDataFree(pMenuInfo->pMenuInfo,pMenuInfo->NumberOfMenu,&i);

						for(i2=0;i2<i;i2++)
							SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_DELETESTRING,i4+1,0);

						HeapDefaultFree(pMenuInfo->pMenuInfo);
						pMenuInfo->pMenuInfo=0;
						lstrcpy(temporary,"IDM_name");
						pMenuInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->IdName,temporary);
					}
					else{
						if(pMenuInfo->type==MFT_STRING){
							HeapDefaultFree(pMenuInfo->IdName);
							pMenuInfo->IdName=0;
						}
						else if(pMenuInfo->type==MFT_SEPARATOR){
							lstrcpy(temporary,"caption text");
							pMenuInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
							lstrcpy(pMenuInfo->caption,temporary);
						}
						pMenuInfo->NumberOfMenu=0;
						pMenuInfo->pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
						pMenuInfo->type=MFT_STRING;
					}
					SendMessage(MdiInfo[WndNum]->hwnd,WM_COMMAND,MAKELONG(0,LBN_SELCHANGE),(long)MdiInfo[WndNum]->MdiMenuInfo->hList);
					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_SEPARATOR:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR) return 1;
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					pMenuInfo=&pMenuInfo->pMenuInfo[i2];

					if(SendDlgItemMessage(hwnd,IDC_SEPARATOR,BM_GETCHECK,0,0)){
						HeapDefaultFree(pMenuInfo->caption);
						pMenuInfo->caption=0;
						HeapDefaultFree(pMenuInfo->IdName);
						pMenuInfo->IdName=0;
						pMenuInfo->type=MFT_SEPARATOR;

						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_DELETESTRING,i4,0);
						memset(temporary,' ',i3*4);
						lstrcpy(temporary+i3*4,"-");
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_INSERTSTRING,i4,(long)temporary);
					}
					else{
						lstrcpy(temporary,"caption text");
						pMenuInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->caption,temporary);
						lstrcpy(temporary,"IDM_name");
						pMenuInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->IdName,temporary);
						pMenuInfo->type=MFT_STRING;

						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_DELETESTRING,i4,0);
						memset(temporary,' ',i3*4);
						lstrcpy(temporary+i3*4,pMenuInfo->caption);
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_INSERTSTRING,i4,(long)temporary);
					}
					SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,i4,0);
					SendMessage(MdiInfo[WndNum]->hwnd,WM_COMMAND,MAKELONG(0,LBN_SELCHANGE),(long)MdiInfo[WndNum]->MdiMenuInfo->hList);
					return 1;
				case IDC_CHECKED:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR) return 1;
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					pMenuInfo=&pMenuInfo->pMenuInfo[i2];

					if(SendDlgItemMessage(hwnd,IDC_CHECKED,BM_GETCHECK,0,0))
						pMenuInfo->state|=MFS_CHECKED;
					else
						pMenuInfo->state&=~MFS_CHECKED;

					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_DISABLED:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR) return 1;
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					pMenuInfo=&pMenuInfo->pMenuInfo[i2];

					if(SendDlgItemMessage(hwnd,IDC_DISABLED,BM_GETCHECK,0,0))
						pMenuInfo->state|=MFS_DISABLED;
					else
						pMenuInfo->state&=~MFS_DISABLED;

					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_INSERTMENUITEM:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					if(projectInfo.pMenuInfo[MenuInfoNum].NumberOfMenu==0){
						projectInfo.pMenuInfo[MenuInfoNum].pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,projectInfo.pMenuInfo[MenuInfoNum].pMenuInfo,(projectInfo.pMenuInfo[MenuInfoNum].NumberOfMenu+1)*sizeof(MENU_INFO));
						pMenuInfo=&projectInfo.pMenuInfo[MenuInfoNum].pMenuInfo[projectInfo.pMenuInfo[MenuInfoNum].NumberOfMenu];

						sprintf(temporary,"caption text");
						pMenuInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->caption,temporary);

						sprintf(temporary,"IDM_name");
						pMenuInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->IdName,temporary);

						pMenuInfo->state=0;
						pMenuInfo->type=MFT_STRING;
						pMenuInfo->pMenuInfo=0;

						projectInfo.pMenuInfo[MenuInfoNum].NumberOfMenu++;

						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_INSERTSTRING,0,(long)pMenuInfo->caption);
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,0,0);
						SendMessage(GetParent(MdiInfo[WndNum]->MdiMenuInfo->hMenuEdit),WM_COMMAND,MAKELONG(0,LBN_SELCHANGE),(long)MdiInfo[WndNum]->MdiMenuInfo->hList);
					}
					else{
						i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
						if(i4==LB_ERR){
							//"Vj[ ACȇ}ʒuIĉ"
							MessageBox(hOwner,STRING_MENUEDIT_MUSTSELECT_NEW_ITEM,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
							return 1;
						}
						i2=0;
						i3=0;
						pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
						if(pMenuInfo->pMenuInfo[i2].pMenuInfo){
							//"|bvAbv ACe쐬ꍇ \"͂\" A|bvAbvƓKwɃj[ ACe쐬ꍇ \"\" ĉB"
							i=MessageBox(hOwner,STRING_MENUEDIT_INSERTTYPE_YESNO,APPLICATION_NAME,MB_YESNOCANCEL);
							if(i==IDYES){
								pMenuInfo=&pMenuInfo->pMenuInfo[i2];
								i2=0;
								i3++;
							}
							else if(i==IDNO){
								i4+=GetNumberOfMenu(&pMenuInfo->pMenuInfo[i2]);
								i2++;
							}
							else return 1;
						}
						else i2++;
						i4++;
						pMenuInfo->pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,0,pMenuInfo->pMenuInfo,(pMenuInfo->NumberOfMenu+1)*sizeof(MENU_INFO));
						for(i=pMenuInfo->NumberOfMenu;i>i2;i--){
							pMenuInfo->pMenuInfo[i]=pMenuInfo->pMenuInfo[i-1];
						}
						memset(&pMenuInfo->pMenuInfo[i2],0,sizeof(MENU_INFO));

						sprintf(temporary,"caption text");
						pMenuInfo->pMenuInfo[i2].caption=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->pMenuInfo[i2].caption,temporary);

						sprintf(temporary,"IDM_name");
						pMenuInfo->pMenuInfo[i2].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(pMenuInfo->pMenuInfo[i2].IdName,temporary);

						memset(temporary,' ',i3*4);
						lstrcpy(temporary+i3*4,pMenuInfo->pMenuInfo[i2].caption);

						pMenuInfo->NumberOfMenu++;

						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_INSERTSTRING,i4,(long)temporary);
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,i4,0);
						SendMessage(GetParent(MdiInfo[WndNum]->MdiMenuInfo->hMenuEdit),WM_COMMAND,MAKELONG(0,LBN_SELCHANGE),(long)MdiInfo[WndNum]->MdiMenuInfo->hList);
					}
					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_DELETEMENUITEM:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR){
						//"폜郁j[ ACeIĉ"
						MessageBox(hOwner,STRING_MENUEDIT_MUSTSELECT_DELETE_MENUITEM,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						return 1;
					}
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);

					i3=1;
					if(pMenuInfo->pMenuInfo[i2].pMenuInfo){
						if(pMenuInfo->pMenuInfo[i2].NumberOfMenu){
							//"̑sƃ|bvAbv郁j[ ACe폜܂B"
							if(MessageBox(hOwner,STRING_MENUEDIT_DELETECHECK,APPLICATION_NAME,MB_OKCANCEL)==IDCANCEL) return 1;
						}
						HeapMenuDataFree(pMenuInfo->pMenuInfo[i2].pMenuInfo,pMenuInfo->pMenuInfo[i2].NumberOfMenu,&i3);
						HeapDefaultFree(pMenuInfo->pMenuInfo[i2].pMenuInfo);
					}
					else HeapDefaultFree(pMenuInfo->pMenuInfo[i2].IdName);

					if(pMenuInfo->pMenuInfo[i2].type!=MFT_SEPARATOR)
						HeapDefaultFree(pMenuInfo->pMenuInfo[i2].caption);

					for(i=i2;i<pMenuInfo->NumberOfMenu-1;i++)
						pMenuInfo->pMenuInfo[i]=pMenuInfo->pMenuInfo[i+1];

					pMenuInfo->NumberOfMenu--;
					pMenuInfo->pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,0,pMenuInfo->pMenuInfo,pMenuInfo->NumberOfMenu*sizeof(MENU_INFO));

					for(i=0;i<i3;i++)
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_DELETESTRING,i4,0);

					i=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCOUNT,0,0)-1;
					if(i){
						if(i<i4) i4=i;
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,i4,0);
					}

					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_UP:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR){
						//"ړ郁j[ ACeIĉ"
						MessageBox(hOwner,STRING_MENUEDIT_MUSTSELECT_MOVE_MENUITEM,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						return 1;
					}
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					if(i2==0) return 1;
					i2--;

					memcpy(&tempMenuInfo,&pMenuInfo->pMenuInfo[i2],sizeof(MENU_INFO));
					memcpy(&pMenuInfo->pMenuInfo[i2],&pMenuInfo->pMenuInfo[i2+1],sizeof(MENU_INFO));
					memcpy(&pMenuInfo->pMenuInfo[i2+1],&tempMenuInfo,sizeof(MENU_INFO));

					SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_RESETCONTENT,0,0);
					SetMenuDataList(MdiInfo[WndNum]->MdiMenuInfo->hList,&projectInfo.pMenuInfo[MenuInfoNum],0);
					if(!pMenuInfo->pMenuInfo[i2].pMenuInfo)
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,i4-1,0);

					projectInfo.ModifyOfMaterial=1;
					return 1;
				case IDC_DOWN:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(WndNum==-1) return 1;
					MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);

					i4=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
					if(i4==LB_ERR){
						//"ړ郁j[ ACeIĉ"
						MessageBox(hOwner,STRING_MENUEDIT_MUSTSELECT_MOVE_MENUITEM,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						return 1;
					}
					i2=0;
					i3=0;
					pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i4,&i3);
					if(pMenuInfo->NumberOfMenu<=i2+1) return 1;

					memcpy(&tempMenuInfo,&pMenuInfo->pMenuInfo[i2],sizeof(MENU_INFO));
					memcpy(&pMenuInfo->pMenuInfo[i2],&pMenuInfo->pMenuInfo[i2+1],sizeof(MENU_INFO));
					memcpy(&pMenuInfo->pMenuInfo[i2+1],&tempMenuInfo,sizeof(MENU_INFO));

					SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_RESETCONTENT,0,0);
					SetMenuDataList(MdiInfo[WndNum]->MdiMenuInfo->hList,&projectInfo.pMenuInfo[MenuInfoNum],0);
					if(!pMenuInfo->pMenuInfo[i2].pMenuInfo)
						SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_SETCURSEL,i4+1,0);

					projectInfo.ModifyOfMaterial=1;
					return 1;
			}
			break;
	}
	return 0;
}

LRESULT CALLBACK MenuEditWindow(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HINSTANCE hInst;
	int i;
	RECT rect;
	SCROLLINFO ScrollInfo;

	switch(message){
		case WM_MOUSEACTIVATE:
			BringWindowToTop(GetParent(hwnd));
			return 0;
		case WM_VSCROLL:
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(LOWORD(wParam)==SB_LINEUP) i=-20;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=20;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-ScrollInfo.nPos;
			else i=0;
			GetClientRect(hwnd,&rect);
			i=max(-ScrollInfo.nPos,min(i,ScrollInfo.nMax-rect.bottom-ScrollInfo.nPos));
			if(i!=0){
				ScrollInfo.nPos+=i;
				SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);
				ScrollWindow(hwnd,0,-i,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
		case WM_SIZE:
			i=GetWndNum(GetParent(hwnd));
			if(i==-1) return 0;	//EBhEԂ̏ꍇ
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_PAGE|SIF_RANGE|SIF_POS;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			GetClientRect(MdiInfo[i]->MdiMenuInfo->hEdit_Dlg,&rect);
			ScrollInfo.nMin=0;
			ScrollInfo.nMax=rect.bottom;
			ScrollInfo.nPage=HIWORD(lParam);
			SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);

			i=ScrollInfo.nPos;
			ScrollInfo.fMask=SIF_POS;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(i>ScrollInfo.nPos){
				ScrollWindow(hwnd,0,i-ScrollInfo.nPos,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
LRESULT CALLBACK MDIClientWindow_Menu(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HWND hDocCombo;
	int i,i2,i3,WndNum,MenuInfoNum;
	MENU_INFO *pMenuInfo;

	switch(message){
		case WM_COMMAND:
			WndNum=GetWndNum(hwnd);
			if(WndNum==-1) return 0;
			MenuInfoNum=GetMenuInfoNum(MdiInfo[WndNum]->path);
			if((HWND)lParam==MdiInfo[WndNum]->MdiMenuInfo->hList&&HIWORD(wParam)==LBN_SELCHANGE){
				i=SendMessage(MdiInfo[WndNum]->MdiMenuInfo->hList,LB_GETCURSEL,0,0);
				i2=0;
				i3=0;
				pMenuInfo=GetMenuInfoFromList(&projectInfo.pMenuInfo[MenuInfoNum],&i2,i,&i3);
				pMenuInfo=&pMenuInfo->pMenuInfo[i2];

				if(pMenuInfo->pMenuInfo){
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTION,pMenuInfo->caption);
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDNAME,"");
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDSTATIC),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_RENAME),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_POPUP),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_SEPARATOR),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CHECKED),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_DISABLED),1);
					SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_POPUP,BM_SETCHECK,BST_CHECKED,0);
					SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_SEPARATOR,BM_SETCHECK,BST_UNCHECKED,0);
				}
				else if(pMenuInfo->type==MFT_STRING){
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTION,pMenuInfo->caption);
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDNAME,pMenuInfo->IdName);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDSTATIC),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTIONSTATIC),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_RENAME),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_POPUP),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_SEPARATOR),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CHECKED),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_DISABLED),1);
					SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_POPUP,BM_SETCHECK,BST_UNCHECKED,0);
					SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_SEPARATOR,BM_SETCHECK,BST_UNCHECKED,0);
				}
				else if(pMenuInfo->type==MFT_SEPARATOR){
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTION,"");
					SetDlgItemText(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDNAME,"");
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_IDSTATIC),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CAPTIONSTATIC),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_RENAME),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_POPUP),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_SEPARATOR),1);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CHECKED),0);
					EnableWindow(GetDlgItem(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_DISABLED),0);
					SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_POPUP,BM_SETCHECK,BST_UNCHECKED,0);
					SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_SEPARATOR,BM_SETCHECK,BST_CHECKED,0);
				}

				if(pMenuInfo->state&MFS_CHECKED) i2=BST_CHECKED;
				else i2=BST_UNCHECKED;
				SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_CHECKED,BM_SETCHECK,i2,0);
				if(pMenuInfo->state&MFS_DISABLED) i2=BST_CHECKED;
				else i2=BST_UNCHECKED;
				SendDlgItemMessage(MdiInfo[WndNum]->MdiMenuInfo->hEdit_Dlg,IDC_DISABLED,BM_SETCHECK,i2,0);
			}
			return 0;
		case WM_MDIACTIVATE:
			if(!lParam) return 0;
			i=GetWndNum((HWND)lParam);
			if(i==-1) return 0;	//EBhEԂ̏ꍇ

			i=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[i]->title.c_str());
			SendMessage(hDocCombo,CB_SETCURSEL,i,0);
			SetStatusText(NULL);
			ResetState_EditMenu();
			return 0;
		case WM_SIZE:
			WndNum=GetWndNum(hwnd);
			if(WndNum==-1) break;
			MoveWindow(MdiInfo[WndNum]->MdiMenuInfo->hMenuEdit,0,0,172,HIWORD(lParam),1);
			MoveWindow(MdiInfo[WndNum]->MdiMenuInfo->hList,172,0,LOWORD(lParam)-172,HIWORD(lParam),1);
			break;
		case WM_CLOSE:
			CloseDocWindow(GetWndNum(hwnd));
			pobj_nv->bMDIZoomed=IsZoomed(hwnd);
			i=DefMDIChildProc(hwnd,message,wParam,lParam);

			//j[Ԃݒ
			ResetState_DocMenu();

			return i;
	}
	return DefMDIChildProc(hwnd,message,wParam,lParam);
}
