#include "Type.h"

#ifndef _ACTIVEBASIC_COMPILER_PARAMETER_H
#define _ACTIVEBASIC_COMPILER_PARAMETER_H

class Parameter;
typedef vector<Parameter *> Parameters;

class Parameter : public Type
{
	string varName;
	bool isRef;
	bool isArray;
	int subScripts[MAX_ARRAYDIM];

	const string initValue;

public:
	Parameter( const string &varName, const Type &type, bool isRef = false, const string initValue = "" ):
		Type( type ),
		varName( varName ),
		isRef( isRef ),
		isArray( false ),
		initValue( initValue )
	{
		subScripts[0] = -1;
	}
	Parameter( const Parameter &param ):
		Type( param ),
		varName( param.varName ),
		isRef( param.isRef ),
		isArray( false ),
		initValue( param.initValue )
	{
		subScripts[0] = -1;
		if( param.isArray ){
			SetArray( param.subScripts );
		}
	}
	~Parameter(){}

	void SetArray( const int *pSubScripts ){
		isArray = true;
		memcpy( this->subScripts, pSubScripts, sizeof(int) * MAX_ARRAYDIM );
	}

	const string &GetVarName() const
	{
		return varName;
	}

	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray(){
		return isArray;
	}
	int *GetSubScriptsPtr(){
		return subScripts;
	}

	const string &GetInitValue() const
	{
		return initValue;
	}

	bool Equals( const Parameter &param ) const
	{
		if( Type::Equals( param ) ){
			return true;
		}
		else{

			if( this->isRef && this->GetBasicType() == DEF_ANY &&
				param.isRef == false && param.IsPointer()
				||
				this->isRef == false && this->IsPointer() &&
				param.isRef && param.GetBasicType() == DEF_ANY ){
					/* ByRef var As Any
							
						var As VoidPtr
						͓
					*/
					return true;
			}
		}

		return false;
	}


	static bool Equals( const Parameters &paramsA, const Parameters paramsB ){
		if( paramsA.size() != paramsB.size() ){
			return false;
		}

		int max = (int)paramsA.size();
		for( int i=0; i<max; i++ ){
			if( !paramsA[i]->Equals( *paramsB[i] ) ){
				return false;
			}
		}

		return true;
	}
};

#endif //_ACTIVEBASIC_COMPILER_PARAMETER_H
