#pragma once
#pragma warning(disable : 4996)


namespace Jenga{
namespace Common{


class File
{
	const std::string filePath;
public:
	File( const std::string &filePath )
		: filePath( filePath )
	{
	}

	std::string Read()
	{
		HANDLE hFile = CreateFile( filePath.c_str(), GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
		if( hFile == INVALID_HANDLE_VALUE )
		{
			Jenga::Throw( filePath + " I[vł܂" );
		}
		int size = GetFileSize( hFile, NULL );

		char *temp = static_cast<char *>(calloc( size + 1, 1 ));
		DWORD dummy;
		ReadFile( hFile, temp, size, &dummy, NULL );
		CloseHandle(hFile);

		std::string result = temp;
		free( temp );

		return result;
	}

	bool ReadBinary( Binary &binary )
	{
		HANDLE hFile = CreateFile( filePath.c_str(), GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
		if( hFile == INVALID_HANDLE_VALUE )
		{
			return false;
		}
		int size = GetFileSize( hFile, NULL );

		char *temp = static_cast<char *>(calloc( size + 1, 1 ));
		DWORD dummy;
		ReadFile( hFile, temp, size, &dummy, NULL );
		CloseHandle(hFile);

		binary.Put( temp, size );

		return true;
	}

	bool WriteBinary( const Binary &binary )
	{
		HANDLE hFile = CreateFile(filePath.c_str(),GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE)
		{
			return false;
		}
		DWORD dw;
		WriteFile(hFile,binary.GetBuffer(),binary.GetSize(),&dw,NULL);
		CloseHandle(hFile);

		return true;
	}
};


}}
