
typedef void (CALLBACK *GetNkfVersion)(LPSTR verStr);
typedef int (CALLBACK *SetNkfOption)(LPCSTR optStr);
typedef void (CALLBACK *NkfConvert)(LPSTR outStr, LPCSTR inStr);
typedef int (CALLBACK *NkfGetKanjiCode)(VOID);

class CNkf{
	HINSTANCE hLib;
public:
	CNkf();
	~CNkf();
	GetNkfVersion pGetNkfVersion;
	SetNkfOption pSetNkfOption;
	NkfConvert pNkfConvert;
	NkfGetKanjiCode pNkfGetKanjiCode;

	char *RestoreBuffer(char *buffer,int iCharCode);
	void GetCharCodeName(int iCharCode,char *name);

	char *ToCRLF(int iLfCode,char *buffer);
	void ToLF(char *buffer);
	void ToCR(char *buffer);
	void GetLfCodeName(int iLfCode,char *name);
};
extern CNkf nkf;


//R[h
#define NKF_SHIFT_JIS		0
#define NKF_EUC				1
#define NKF_ISO_2022_JP		2
#define NKF_UTF_8			3

#define NKF_CODE_MIN		NKF_SHIFT_JIS
#define NKF_CODE_MAX		NKF_UTF_8


//sR[h
#define LFCODE_CRLF	0	//Windows
#define LFCODE_LF	1	//Unix
#define LFCODE_CR	2	//Macintosh


//֐S
INT_PTR CALLBACK nkfDlgCodeSave(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);
