#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

//ϐ
Variables globalVars;
int AllGlobalVarSize;
int AllInitGlobalVarSize;

int AllLocalVarSize;


void SetRelativeOffset( Type &resultType, RELATIVE_VAR *pRelativeVar,const char *lpPtrOffset){
	/////////////////////////////////////////////
	// 擪|C^r12Ɏ擾ă֑ޔ
	/////////////////////////////////////////////

	SetReg_WholeVariable(DEF_INT64,pRelativeVar,REG_R11);

	//mov qword ptr[rsp+offset],r11     X^bNt[𗘗p
	pobj_sf->push(REG_R11);


	////////////////////////////////
	// YvZ
	////////////////////////////////

	int reg=REG_NON;
	Type type;
	NumOpe( &reg, lpPtrOffset, Type(), type );
	if( !type.IsWhole() ){
		SetError(46,NULL,cp);
	}
	ExtendTypeTo64(type.GetBasicType(),reg);

	if(reg==REG_R14){
		//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R14);
	}

	if( resultType.PtrLevel() ){
		resultType.PtrLevelDown();

		int typeSize = resultType.GetSize();
		if(typeSize>=2){
			//imul reg,i2
			op_imul_RV(sizeof(_int64),reg,typeSize);
		}
	}
	else{
		//G[
		SetError(1,NULL,cp);
		return;
	}


	//////////////////////////////
	// 擪|C^ɓYZ
	//////////////////////////////

	//mov r11,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R11);

	//add r11,reg
	op_add64_reg(REG_R11,reg);
}
void SetRelativeOffset( RELATIVE_VAR &relativeVar ){
	if(relativeVar.dwKind==VAR_DIRECTMEM){
		//mov r11,qword ptr[r11]
		op_mov_RM(sizeof(_int64),REG_R11,REG_R11,0,MOD_BASE);
	}
	else{
		//ڎQƂɐ؂ւ
		SetVarPtrToReg(REG_R12,&relativeVar);
		relativeVar.dwKind=VAR_DIRECTMEM;

		//mov r11,qword ptr[r12]
		op_mov_RM(sizeof(_int64),REG_R11,REG_R12,0,MOD_BASE);
	}
}
bool GetArrayOffset(const int *SubScripts,char *array, const Type &type){
	extern HANDLE hHeap;
	int i,i2,i3,i4;
	char temporary[VN_SIZE],*pParm[MAX_PARMS];

	for(i=0,i2=0,i3=0;;i++,i2++){
		if(array[i]=='('){
			i4=GetStringInPare(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]=='['){
			i4=GetStringInBracket(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]==','||array[i]=='\0'){
			if(SubScripts[i3]==-1){
				for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
				return false;
			}

			temporary[i2]=0;

			pParm[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(pParm[i3],temporary);

			i3++;

			if(array[i]=='\0'){
				if(SubScripts[i3]!=-1){
					for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
					return false;
				}
				break;
			}

			i2=-1;
			continue;
		}
		temporary[i2]=array[i];
	}

	//mov qword ptr[rsp+offset],r11     X^bNt[𗘗p
	pobj_sf->push(REG_R11);

	//xor r12,r12
	op_zero_reg(REG_R12);

	for(i=i3-1;i>=0;i--){
		//mov qword ptr[rsp+offset],r12     X^bNt[𗘗p
		pobj_sf->push(REG_R12);

		int reg=REG_NON;
		Type type;
		BOOL bUseHeap;
		NumOpe( &reg, pParm[i], Type( DEF_LONG ), type, &bUseHeap );
		if( type.IsObject() ){
			//LXgZq̃I[o[[hɑΉ
			CallCastOperatorProc(reg,
				type,
				bUseHeap, Type(DEF_LONG) );
			type.SetBasicType( DEF_LONG );
		}

		if( !type.IsWhole() ){
			SetError(46,NULL,cp);
		}
		ExtendTypeTo64( type.GetBasicType(), reg );

		if(reg==REG_R14){
			//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
			pobj_sf->pop(REG_R14);
		}

		//mov r12,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R12);

		for(i2=i+1,i4=1;i2<i3;i2++) i4*=SubScripts[i2]+1;

		//imul reg,i4
		op_imul_RV(sizeof(_int64),reg,i4);

		//add r12,reg
		op_add64_reg(REG_R12,reg);

		HeapDefaultFree(pParm[i]);
	}

	//imul r12,TypeSize
	OpBuffer[obp++]=(char)0x4D;
	OpBuffer[obp++]=(char)0x69;
	OpBuffer[obp++]=(char)0xE4;
	*((long *)(OpBuffer+obp))=type.GetSize();
	obp+=sizeof(long);

	//mov r11,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R11);

	//add r11,r12
	OpBuffer[obp++]=(char)0x4D;
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)0xDC;

	return true;
}
bool _member_offset(bool isErrorEnabled, bool isWriteAccess, const CClass &objClass, const char *member, RELATIVE_VAR *pRelativeVar, Type &resultType, BOOL bPrivateAccess){
	int i;


	//////////////////////////////////////
	// NXAz̍\vf͂
	//////////////////////////////////////

	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];	//2z
	char NestMember[VN_SIZE];	//qo
	CClass::RefType refType;
	lstrcpy(VarName,member);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember,refType)) return false;


	////////////////////////////
	// oItZbg擾
	////////////////////////////

	int offset = objClass.GetMemberOffset( VarName, &i );
	if(i==objClass.iMemberNum){
		if(isErrorEnabled) SetError(103,VarName,cp);
		return false;
	}

	CMember *pMember=objClass.ppobj_Member[i];


	//ANZVreB`FbN
	if(&objClass==pobj_CompilingClass){
		//NXIuWFNg̏ꍇ̓vCx[gANZXeF
		if(pMember->dwAccess==ACCESS_NON){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return false;
		}
	}
	else{
		if((bPrivateAccess==0&&pMember->dwAccess==ACCESS_PRIVATE)||
			pMember->dwAccess==ACCESS_NON){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return false;
		}
		else if(bPrivateAccess==0&&pMember->dwAccess==ACCESS_PROTECTED){
			if(isErrorEnabled) SetError(108,VarName,cp);
			return false;
		}
	}

	//Const`̏ꍇ͏݃ANZX𐧌
	//RXgN^RpC̏ꍇ͗OIɋ
	if( pMember->IsConst() &&		//萔oł
		isWriteAccess &&							//݃ANZXvĂ
		objClass.IsCompilingConstructor() == false	//RXgN^ RpC
		){
			//Const`̕ϐɏ݃ANZX悤Ƃꍇ
			SetError(61,VarName,cp);
	}

	resultType = *pMember;

	//|C^ϐ̏ꍇ
	if( resultType.IsPointer() ){
		if(pMember->SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(isErrorEnabled) SetError(16,member,cp);
			return false;
		}
	}

	if(offset){
		//add r11,offset
		OpBuffer[obp++]=(char)0x49;
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xC3;
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}

	if(array[0]){
		//zItZbg
		if(!GetArrayOffset(pMember->SubScripts,array,*pMember)){
			if(isErrorEnabled) SetError(14,member,cp);
		}
	}
	else if(pMember->SubScripts[0]!=-1){
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
	}

	if(NestMember[0]){
		//q\̏ꍇ

		if( resultType.IsObject() || resultType.IsStruct() ){
			if( refType != CClass::Dot ){
				if(isErrorEnabled) SetError(104,member,cp);
				return false;
			}

			if( resultType.IsObject() ){
				// QƓeւ̃|C^𒊏o
				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.IsObjectPtr() || resultType.IsStructPtr() ){
			//\̃|C^^oϐ

			if(lpPtrOffset[0]){
				//pObj[n].member
				if( ( resultType.IsObjectPtr() || resultType.IsStructPtr() )
					&& refType != CClass::Dot ){
						if(isErrorEnabled) SetError(104,member,cp);
						return false;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;
			}
			else{
				//pObj->member
				if( (resultType.IsObjectPtr() || resultType.IsStructPtr() )
					&& refType != CClass::Pointer ){
						if(isErrorEnabled) SetError(104,member,cp);
						return false;
				}

				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.GetBasicType() == MAKE_PTR_TYPE(DEF_OBJECT,2)
			|| resultType.GetBasicType() == MAKE_PTR_TYPE(DEF_STRUCT,2)){
			//\̃|C^̃|C^^oϐ

			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if( refType != CClass::Pointer ){
					if(isErrorEnabled) SetError(104,member,cp);
					return false;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;

				//mov r11,qword ptr[r11]
				op_mov_RM(sizeof(_int64),REG_R11,REG_R11,0,MOD_BASE);
			}
			else{
				if(isErrorEnabled) SetError(104,member,cp);
				return false;
			}
		}

		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			pMember->GetClass(),
			NestMember,
			pRelativeVar,
			resultType,
			0)) return false;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return true;
}
void GetWithName(char *buffer){
	extern WITHINFO WithInfo;
	int i;

	buffer[0]=0;
	for(i=0;i<WithInfo.num;i++)
		lstrcat(buffer,WithInfo.ppName[i]);
}

int LocalVar_ThisPtrOffset;
void SetThisPtrToReg(int reg){
	//g̃IuWFNgThis|C^regɃRs[

	RELATIVE_VAR RelativeVar;
	RelativeVar.dwKind=VAR_LOCAL;
	RelativeVar.bOffsetOffset=0;
	RelativeVar.offset=-LocalVar_ThisPtrOffset;

	SetReg_WholeVariable(DEF_PTR_VOID,&RelativeVar,reg);
}
bool GetVarOffset(bool isErrorEnabled,bool isWriteAccess,const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType,int *pss){
	int i;
	char variable[VN_SIZE],member[VN_SIZE],VarName[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];

	if(NameBuffer[0]=='.'){
		GetWithName(variable);
		lstrcat(variable,NameBuffer);
	}
	else lstrcpy(variable,NameBuffer);

	CClass::RefType refType;
	if( FormatUseProcReturnObject( variable, VarName, array, refType, member ) ){
		// ߂lIuWFNg̃o𒼐ڎQƂĂƂ
		//: func().member

		void *pInfo;
		int idProc=GetProc(VarName,(void **)&pInfo);

		if(idProc){
			pRelativeVar->dwKind=VAR_DIRECTMEM;

			Type type;

			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////

				////////////////
				// Ăяo
				////////////////

				CallProc(idProc,pInfo,VarName,array,type);

				//߂lr11ɃRs[
				op_mov_RR( REG_R11, REG_RAX );

			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////

			if(!_member_offset(
				isErrorEnabled,
				isWriteAccess,
				type.GetClass(),
				member,pRelativeVar,resultType,0)) return false;

			return true;
		}
	}



	lstrcpy(VarName,variable);
	GetVarFormatString(VarName,array,lpPtrOffset,member,refType);

	const int *pSubScripts;
	bool bConst = false;


	if( UserProc::IsLocalAreaCompiling() ){
		//////////////////
		// [Jϐ
		//////////////////

		const Variable *pVar = UserProc::CompilingUserProc().localVars.BackSearch( VarName );
		if( pVar ){
			//|C^ϐ̏ꍇ
			if( pVar->IsPointer() ){
				if( !pVar->IsArray() ){
					lstrcpy(lpPtrOffset,array);
					array[0]=0;
				}
			}
			else{
				if(lpPtrOffset[0]){
					SetError(16,variable,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}
			}

			pRelativeVar->offset=-pVar->offset;
			pRelativeVar->bOffsetOffset=0;
			if( pVar->IsRef() ){
				// Qƌ^
				pRelativeVar->dwKind = VAR_REFLOCAL;
			}
			else pRelativeVar->dwKind=VAR_LOCAL;
			resultType = *pVar;
			pSubScripts=pVar->GetSubScriptsPtr();
			bConst = pVar->IsConst();

			goto ok;
		}
	}


	if(pobj_CompilingClass){
		//////////////////////
		// NXo̎Q
		//////////////////////

		if(lstrcmpi(variable,"This")==0){
			//g̃IuWFNgThis|C^r11ɃRs[
			SetThisPtrToReg(REG_R11);

			pRelativeVar->dwKind=VAR_DIRECTMEM;

			resultType.SetType( DEF_OBJECT, pobj_CompilingClass );
			return true;
		}

		if(memicmp(variable,"This.",5)==0){
			//ThisIuWFNg̃oQƂƂ
			SlideString(variable+5,-5);
			lstrcpy(VarName,variable);
		}
		else{
			//NXoQƂƂiʏj

			for(i=0;i<pobj_CompilingClass->iMemberNum;i++){
				if(lstrcmp(VarName,pobj_CompilingClass->ppobj_Member[i]->name)==0) break;
			}
			if(i==pobj_CompilingClass->iMemberNum) goto NonClassMember;
		}

		//ConstCq̃\bhŃo݃ANZXƂ
		//iRXgN^AfXgN^j
		CMethod *pMethod = pobj_DBClass->GetNowCompilingMethodInfo();
		if( isWriteAccess &&
			pMethod->isConst &&
			pobj_CompilingClass->IsCompilingConstructor() == false &&
			pobj_CompilingClass->IsCompilingDestructor() == false
			){
				SetError(131, NULL, cp );
		}

		//g̃IuWFNgThis|C^r11ɃRs[
		SetThisPtrToReg(REG_R11);

		pRelativeVar->dwKind=VAR_DIRECTMEM;
		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			*pobj_CompilingClass,
			variable,
			pRelativeVar,
			resultType,1)) return false;
		return true;
	}

NonClassMember:

	{
		const Variable *pVar;

		//////////////////////////
		// ÓI[Jϐ
		// "Static.Object.Method.Variable"
		//////////////////////////

		char temporary[VN_SIZE];
		if( UserProc::IsLocalAreaCompiling() ){
			GetNowStaticVarFullName(VarName,temporary);

			pVar = globalVars.Find( temporary );
			if( pVar ){
				goto GlobalOk;
			}
		}


		//////////////////////////
		// NX̐ÓIo
		//////////////////////////

		if(member[0]){
			lstrcpy(temporary,member);

			char tempMember[VN_SIZE];
			char tempArray[VN_SIZE];
			{
				CClass::RefType refType;
				GetVarFormatString(temporary,tempArray,lpPtrOffset,tempMember, refType );
			}

			char temp2[VN_SIZE];
			sprintf(temp2,"%s.%s",VarName,temporary);
			pVar = globalVars.Find( temp2 );
			if( pVar ){
				lstrcpy(member,tempMember);
				lstrcpy(array,tempArray);
				goto GlobalOk;
			}
		}

		if(pobj_CompilingClass){
			//g̃NXÓIoQƂꍇ
			char temp2[VN_SIZE];
			sprintf(temp2,"%s.%s",pobj_CompilingClass->name,VarName);
			pVar = globalVars.Find( temp2 );
			if( pVar ){
				goto GlobalOk;
			}
		}

		/////////////////////
		// O[oϐ
		/////////////////////

		pVar = globalVars.BackSearch( VarName );
		if( pVar ){
			goto GlobalOk;
		}

		if(isErrorEnabled) SetError(3,variable,cp);
		pRelativeVar->dwKind=NON_VAR;
		return false;



GlobalOk:
		//|C^ϐ̏ꍇ
		if( pVar->IsPointer() ){
			if( !pVar->IsArray() ){
				lstrcpy(lpPtrOffset,array);
				array[0]=0;
			}
		}
		else{
			if(lpPtrOffset[0]){
				SetError(16,variable,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}
		}

		pRelativeVar->offset=pVar->offset;
		pRelativeVar->bOffsetOffset=0;
		if( pVar->IsRef() ){
			// Qƌ^
			pRelativeVar->dwKind = VAR_REFGLOBAL;
		}
		else pRelativeVar->dwKind=VAR_GLOBAL;
		resultType = *pVar;
		pSubScripts=pVar->GetSubScriptsPtr();
		bConst = pVar->IsConst();
	}



ok:

	if( bConst && isWriteAccess ){
		//Const`̕ϐɏ݃ANZX悤Ƃꍇ
		if( resultType.IsObject() ){
			//IuWFNg萔
			SetError(130, VarName, cp );
		}
		else{
			//ʂConstϐ
			SetError(61,VarName,cp);
		}
	}

	if(array[0]==0&&pSubScripts[0]!=-1){
		//z̐擪|C^ꍇ
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
		if(pss) memcpy(pss,pSubScripts,MAX_ARRAYDIM);
		return true;
	}

	if( array[0] || member[0] ){
		//xor r11,r11ir110ɏj
		//r11͕ϐx[XAhX̑΃ItZbg
		op_zero_reg(REG_R11);

		pRelativeVar->bOffsetOffset=1;
	}
	if(array[0]){
		if(!GetArrayOffset(pSubScripts,array,resultType)){
			SetError(14,variable,cp);
			pRelativeVar->dwKind=NON_VAR;
			return false;
		}
	}
	if(member[0]){
		if( resultType.IsObject() || resultType.IsStruct() ){
			//ԃIuWFNg̃oQƁiobj.memberj
			if( refType != CClass::Dot ){
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}

			if( resultType.IsObject() ){
				// QƓeւ̃|C^𒊏o
				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.IsObjectPtr() || resultType.IsStructPtr() ){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//pObj[n].member
				if( refType != CClass::Dot ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;
			}
			else{
				//pObj->member
				if( refType != CClass::Pointer ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}

				SetVarPtrToReg(REG_R12,pRelativeVar);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				//mov r11,qword ptr[r12]
				op_mov_RM(sizeof(_int64),REG_R11,REG_R12,0,MOD_BASE);
			}
		}
		else if( resultType.GetBasicType()==MAKE_PTR_TYPE(DEF_OBJECT,2) || resultType.GetBasicType()==MAKE_PTR_TYPE(DEF_STRUCT,2)){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if( refType != CClass::Pointer ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}

				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;


				SetVarPtrToReg(REG_R12,pRelativeVar);

				//mov r11,qword ptr[r12]
				op_mov_RM(sizeof(_int64),REG_R11,REG_R12,0,MOD_BASE);
			}
			else{
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}
		}
		else{
			SetError(102,VarName,cp);
			pRelativeVar->dwKind=NON_VAR;
			return false;
		}

		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			resultType.GetClass(),
			member,pRelativeVar,resultType,0)) return false;

		return true;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return true;
}

bool SetInitGlobalData(int offset,const Type &type,const int *SubScripts,char *InitBuf){
	extern BYTE *initGlobalBuf;
	int i,i2,i3;
	char temporary[VN_SIZE];

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		int typeSize = type.GetSize();

		if(SubScripts[0]!=-1){
			typeSize*=JumpSubScripts(SubScripts+1);
			i=0;
			i2=0;
			while(1){
				if(SubScripts[0]<i2){
					SetError(41,0,cp);
					return 0;
				}
				i=GetOneParameter(InitBuf,i,temporary);
				if(!SetInitGlobalData(
					offset+i2*typeSize,
					type,
					SubScripts+1,
					temporary)) return false;
				i2++;
				if(InitBuf[i]=='\0') break;
			}
			return true;
		}

		if(type.IsStruct()){
			const CClass &objClass = type.GetClass();

			for(i=0,i2=0;i2<objClass.iMemberNum;i2++){
				i=GetOneParameter(InitBuf,i,temporary);

				i3=objClass.GetMemberOffset( objClass.ppobj_Member[i2]->name, NULL );

				if(!SetInitGlobalData(offset+i3,
					*objClass.ppobj_Member[i2],
					objClass.ppobj_Member[i2]->SubScripts,
					temporary)) return false;

				if(InitBuf[i]=='\0') break;
			}
			if(i2+1!=objClass.iMemberNum){
				SetError(41,0,cp);
				return false;
			}
			return true;
		}

		SetError(41,0,cp);
		return false;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if( type.IsObject() || type.IsStruct() ){
		//IuWFNg܂͍\̂̏ꍇ͂肦Ȃ
		SetError(300,NULL,cp);
		return false;
	}

	if(SubScripts[0]!=-1){
		SetError(41,0,cp);
		return false;
	}

	double dbl;
	_int64 i64data;
	Type calcType;

	if( !StaticCalculation(false, InitBuf,type.GetBasicType(),&i64data,calcType) ){
		//If[^ꍇ
		return false;
	}
	if( calcType.IsReal() ){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		calcType,
		0,0);

	if( type.IsDouble() ){
		*(double *)(initGlobalBuf+offset)=(double)dbl;
	}
	else if( type.IsSingle() ){
		*(float *)(initGlobalBuf+offset)=(float)dbl;
	}
	else if( type.Is64() || type.IsPointer() ){
		if(type.GetBasicType()==typeOfPtrChar && type.GetIndex()==LITERAL_STRING){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=dataTable.AddString( temp );
			HeapDefaultFree(temp);

			//mov rax,DataPos
			op_mov_RV(sizeof(_int64),REG_RAX,i2);
			obp-=sizeof(long);
			pobj_DataTableSchedule->add();
			obp+=sizeof(long);

			//mov qword ptr[offset],rax
			op_mov_MR(sizeof(_int64),REG_RAX,0,offset,MOD_DISP32);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			*(_int64 *)(initGlobalBuf+offset)=i64data;
		}
	}
	else if( type.IsDWord() || type.IsLong() ){
		*(DWORD *)(initGlobalBuf+offset)=(DWORD)i64data;
	}
	else if( type.IsWord() || type.IsInteger() ){
		*(WORD *)(initGlobalBuf+offset)=(WORD)i64data;
	}
	else if( type.IsSByte() || type.IsByte() || type.IsBoolean() ){
		*(BYTE *)(initGlobalBuf+offset)=(BYTE)i64data;
	}

	return true;
}
bool InitLocalVar(int offset,const Type &type,const int *SubScripts,char *InitBuf){
	int i,i2,i3;
	char temporary[VN_SIZE];

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		int typeSize = type.GetSize();

		if(SubScripts[0]!=-1){
			typeSize*=JumpSubScripts(SubScripts+1);
			i=0;
			i2=0;
			while(1){
				if(SubScripts[0]<i2){
					SetError(41,0,cp);
					return false;
				}
				i=GetOneParameter(InitBuf,i,temporary);
				if(!InitLocalVar(
					offset+i2*typeSize,
					type,
					SubScripts+1,
					temporary)) return false;
				i2++;
				if(InitBuf[i]=='\0') break;
			}
			return true;
		}

		if(type.IsStruct()){
			const CClass &objClass = type.GetClass();

			for(i=0,i2=0;i2<objClass.iMemberNum;i2++){
				i=GetOneParameter(InitBuf,i,temporary);

				i3=objClass.GetMemberOffset( objClass.ppobj_Member[i2]->name, NULL );

				if(!InitLocalVar(offset+i3,
					*objClass.ppobj_Member[i2],
					objClass.ppobj_Member[i2]->SubScripts,
					temporary)) return false;

				if(InitBuf[i]=='\0') break;
			}
			if(i2+1!=objClass.iMemberNum){
				SetError(41,0,cp);
				return 0;
			}
			return true;
		}

		SetError(41,0,cp);
		return false;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if(SubScripts[0]!=-1){
		SetError(41,0,cp);
		return false;
	}

	double dbl;
	_int64 i64data;
	Type calcType;

	if( !StaticCalculation(false, InitBuf,type.GetBasicType(),&i64data,calcType) ){
		//If[^ꍇ
		return false;
	}
	if( calcType.IsReal() ){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		calcType,
		0,0);

	if( type.IsDouble() ){
		memcpy(&i64data,&dbl,sizeof(double));

		//mov rax,i64data
		op_mov64_ToReg(REG_RAX,i64data);

		//mov qword ptr[rsp+offset],rax
		op_mov_MR(sizeof(_int64),REG_RAX,REG_RSP,offset,MOD_BASE_DISP32);
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if( type.IsSingle() ){
		float flt;
		flt=(float)dbl;

		//mov dword ptr[rsp+offset],value
		op_mov_MV(sizeof(long),REG_RSP,offset,USE_OFFSET,*(int *)&flt);
		obp-=sizeof(long)+sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long)+sizeof(long);
	}
	else if( type.Is64() || type.IsPointer() ){
		if(type.GetBasicType()==typeOfPtrChar && type.GetIndex()==LITERAL_STRING){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=dataTable.AddString( temp );
			HeapDefaultFree(temp);

			//mov rax,i2
			op_mov_RV(sizeof(_int64),REG_RAX,i2);
			obp-=sizeof(long);
			pobj_DataTableSchedule->add();
			obp+=sizeof(long);

			//mov qword ptr[rsp+offset],rax
			op_mov_MR(sizeof(_int64),REG_RAX,REG_RSP,offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			if(i64data&0xFFFFFFFF00000000){
				//mov rax,i64data
				op_mov64_ToReg(REG_RAX,i64data);

				//mov qword ptr[rsp+offset],rax
				op_mov_MR(sizeof(_int64),REG_RAX,REG_RSP,offset,MOD_BASE_DISP32);
				obp-=sizeof(long);
				AddLocalVarAddrSchedule();
				obp+=sizeof(long);
			}
			else{
				//mov qword ptr[rsp+offset],value
				op_mov_MV(sizeof(_int64),REG_RSP,offset,USE_OFFSET,(int)i64data);
				obp-=sizeof(long)+sizeof(long);
				AddLocalVarAddrSchedule();
				obp+=sizeof(long)+sizeof(long);
			}
		}
	}
	else if( type.IsDWord() || type.IsLong() ){
		//mov dword ptr[rsp+offset],value
		op_mov_MV(sizeof(long),REG_RSP,offset,USE_OFFSET,(int)i64data);
		obp-=sizeof(long)+sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long)+sizeof(long);
	}
	else if( type.IsWord() || type.IsInteger() ){
		//mov word ptr[rsp+offset],value
		op_mov_MV(sizeof(short),REG_RSP,offset,USE_OFFSET,(int)i64data);
		obp-=sizeof(long)+sizeof(short);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long)+sizeof(short);
	}
	else if( type.IsSByte() || type.IsByte() || type.IsBoolean() ){
		//mov byte ptr[rsp+offset],value
		op_mov_MV(sizeof(char),REG_RSP,offset,USE_OFFSET,(int)i64data);
		obp-=sizeof(long)+sizeof(char);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long)+sizeof(char);
	}
	return true;
}

void dim(bool isRef, char *VarName,int *SubScripts,Type &type,char *InitBuf,char *ConstractParameter,DWORD dwFlags){
	if( UserProc::IsGlobalAreaCompiling() ){
		/////////////////////////
		// O[oϐ
		/////////////////////////

		AddGlobalVariable(isRef,VarName,SubScripts,type,InitBuf,ConstractParameter,dwFlags);
	}
	else{
		/////////////////
		// [Jϐ
		/////////////////

		if( UserProc::CompilingUserProc().localVars.DuplicateCheck( VarName ) ){
			//Qd`̃G[
			SetError(15,VarName,cp);
			return;
		}

		bool isConst = ( dwFlags & DIMFLAG_CONST ) ? true:false;

		Variable *pVar = new Variable( VarName, type, isConst, isRef );

		if( SubScripts[0] != -1 ){
			//z񂠂
			pVar->SetArray( SubScripts );
		}

		//RXgN^pp[^
		pVar->paramStrForConstructor = ConstractParameter;

		//LVJXR[v
		pVar->ScopeLevel=obj_LexScopes.GetNowLevel();
		pVar->ScopeStartAddress=obj_LexScopes.GetStartAddress();
		pVar->bLiving=TRUE;

		//G[p
		pVar->source_code_address=cp;

		// ϐǉ
		UserProc::CompilingUserProc().localVars.push_back( pVar );

		//ACgl
		if( pVar->IsStruct() ){
			int alignment = pVar->GetClass().iAlign;
			if( alignment ){
				if( AllLocalVarSize % alignment ){
					AllLocalVarSize += alignment - (AllLocalVarSize % alignment);
				}
			}
		}

		AllLocalVarSize += pVar->GetMemorySize();
		pVar->offset = AllLocalVarSize;

		//LVJXR[v
		pVar->ScopeLevel=obj_LexScopes.GetNowLevel();
		pVar->ScopeStartAddress=obj_LexScopes.GetStartAddress();
		pVar->bLiving=TRUE;

		if(InitBuf[0]){
			//̂݁A݃ANZX
			if( isConst ){
				pVar->ConstOff();
			}

			int result = 0;
			if( !pVar->IsObject() ){
				result = InitLocalVar(-pVar->offset,
					*pVar,
					pVar->GetSubScriptsPtr(),
					InitBuf);
			}

			if(!result){
				//IȎꍇ͑Zs
				char temporary[8192];
				sprintf(temporary,"%s=%s",VarName,InitBuf);
				OpcodeCalc(temporary);
			}

			if( isConst ){
				pVar->ConstOn();
			}
		}
		else{
			//0

			//mov r8, 0
			op_zero_reg( REG_R8 );

			//mov rdx, VarSize
			op_mov_RV( sizeof(_int64), REG_RDX, pVar->GetMemorySize() );

			//mov rcx, rsp
			op_mov_RR( REG_RCX, REG_RSP );

			//add rcx, offset
			op_add_RV( REG_RCX, -pVar->offset );
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//call FillMemory
			DllProc *pDllProc;
			pDllProc=GetDeclareHash("FillMemory");
			op_call( pDllProc );
		}
	}

	//RXgN^Ăяo
	if( type.IsObject() &&(dwFlags&DIMFLAG_NONCALL_CONSTRACTOR)==0&&InitBuf[0]=='\0'){
		char objectSize[255];
		if( SubScripts[0] == -1 ){
			objectSize[0] = 0;
		}
		else{
			if( SubScripts[1] != -1 ){
				SetError(300,NULL,cp);
			}
			sprintf( objectSize, "%d", SubScripts[0] );
		}
		Operator_New( type.GetClass(), objectSize, ConstractParameter, type );

		Type tempType;
		RELATIVE_VAR RelativeVar;
		GetVarOffset( true, false, VarName, &RelativeVar, tempType );
		if( RelativeVar.dwKind == VAR_DIRECTMEM ){
			SetError();
		}
		SetVariableFromRax( DEF_OBJECT, DEF_OBJECT, &RelativeVar );
	}

	if( type.IsObject() ){
		if( type.GetClass().IsAbstract() ){
			//ۃNXƂ
			SetError(125,type.GetClass().name,cp);
		}
	}
}
void SetVarPtrToReg(int reg,RELATIVE_VAR *pRelativeVar){
	if(!IsGeneralReg(reg)) SetError(300,NULL,cp);

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//add r11,offset
			OpBuffer[obp++]=(char)0x49;
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC3;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov reg,r11
			op_mov_RR(reg,REG_R11);
		}
		else{
			//mov reg,offset
			op_mov64_ToReg(reg,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[offset]
			op_add_RM( sizeof(_int64), REG_R11, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov r11,qword ptr[offset]
			op_mov_RM(sizeof(_int64),REG_R11,REG_NON,(int)pRelativeVar->offset,MOD_DISP32);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add r11,offset
			OpBuffer[obp++]=(char)0x49;
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC3;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//add r11,rsp
			op_add64_reg(REG_R11,REG_RSP);

			//mov reg,r11
			op_mov_RR(reg,REG_R11);
		}
		else{
			//mov reg,rsp
			op_mov_RR(reg,REG_RSP);

			//add reg,offset
			op_add_RV(reg,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			OpBuffer[obp++]=(char)0x4C;
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x9C;
			OpBuffer[obp++]=(char)0x24;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//mov reg,r11
		op_mov_RR(reg,REG_R11);
	}
}
