#pragma once

class UserProc;
class UserProcs;
class Delegate;
class Classes;

class ClassPrototype : public Prototype, public DynamicMethodsPrototype
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Prototype );
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( DynamicMethodsPrototype );
	}

public:
	ClassPrototype( const Symbol &symbol )
		: Prototype( symbol )
		, DynamicMethodsPrototype()
	{
	}
	ClassPrototype()
		: Prototype()
		, DynamicMethodsPrototype()
	{
	}
};

class CClass: public ClassPrototype, public Jenga::Common::ObjectInHashmap<CClass>
{
public:
	// ^̎
	enum ClassType{
		Class,
		Interface,
		ComInterface,
		Enum,
		Delegate,
		Structure,
	};

private:
	ClassType classType;

	// importĂ閼O
	NamespaceScopesCollection importedNamespaces;

	// ^p[^
	GenericTypes formalGenericTypes;

	// NX
	const CClass *pSuperClass;

	// NX̌^p[^ip[^j
	Types superClassActualTypeParameters;

	// Blittable^
	Type blittableType;

	// C^[tFCX
	Interfaces interfaces;

	// Io
	Members dynamicMembers;

	// ÓIo
	Members staticMembers;

	// I\bh
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;
	int vtblNum;					// z֐̐

	// ÓI\bh
	Methods staticMethods;

	//ACgl
	int fixedAlignment;

public:
	ActiveBasic::Common::Lexical::ExpandedTemplateClasses expandedTemplateClasses;
	Types expandedClassActualTypeParameters;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CClass" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( ClassPrototype );

		if( ActiveBasic::Common::Environment::IsRemoveExternal() )
		{
			if( this->IsExternal() )
			{
				this->NeedResolve();
				return;
			}
		}

		ar & BOOST_SERIALIZATION_NVP( classType );
		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		ar & BOOST_SERIALIZATION_NVP( formalGenericTypes );
		ar & boost::serialization::make_nvp( "pSuperClass", const_cast<CClass *&>(pSuperClass) );
		ar & BOOST_SERIALIZATION_NVP( superClassActualTypeParameters );
		ar & BOOST_SERIALIZATION_NVP( blittableType );
		ar & BOOST_SERIALIZATION_NVP( interfaces );
		ar & BOOST_SERIALIZATION_NVP( dynamicMembers );
		ar & BOOST_SERIALIZATION_NVP( staticMembers );
		ar & BOOST_SERIALIZATION_NVP( ConstructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( DestructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( vtblNum );
		ar & BOOST_SERIALIZATION_NVP( staticMethods );
		ar & BOOST_SERIALIZATION_NVP( fixedAlignment );
		ar & BOOST_SERIALIZATION_NVP( expandedTemplateClasses );
		ar & BOOST_SERIALIZATION_NVP( expandedClassActualTypeParameters );
	}

	bool isReady;
public:

	CClass( const Symbol &symbol, const NamespaceScopesCollection &importedNamespaces );
	CClass( const Symbol &symbol,
		const NamespaceScopesCollection &importedNamespaces,
		ClassType classType,
		const GenericTypes &formalGenericTypes,
		const Types &superClassActualTypeParameters,
		int ConstructorMemberSubIndex,
		int DestructorMemberSubIndex,
		int vtblNum,
		int fixedAlignment,
		const Types &expandedClassActualTypeParameters );
	CClass();
	~CClass();

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}
	virtual bool IsDuplication( const CClass *pClass ) const
	{
		if( pClass->IsEqualSymbol( *this ) )
		{
			return true;
		}
		return false;
	}
	bool Equals( const CClass *pClass ) const
	{
		// |C^ǂĂ݂
		if( this == pClass )
		{
			return true;
		}
		else if( this->IsNeedResolve() || pClass->IsNeedResolve() )
		{
			// ˑ֌WȌԂł΁ApXǂĂ݂
			if( this->IsDuplication( pClass ) )
			{
				return true;
			}
		}
		return false;
	}

	virtual void Using() const;

	void Readed(){
		isReady = true;
	}
	bool IsReady() const{
		return isReady;
	}

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	// ^p[^
	const GenericTypes &GetFormalGenericTypes() const
	{
		return formalGenericTypes;
	}
	void AddFormalGenericType( GenericType genericType )
	{
		this->formalGenericTypes.push_back( genericType );
	}
	int GetFormalGenericTypeParameterIndex( const std::string &name ) const
	{
		int i = 0;
		foreach( const GenericType &genericType, formalGenericTypes )
		{
			if( genericType.GetName() == name )
			{
				return i;
			}
			i++;
		}
		return -1;
	}
	bool IsExistFormalGenericTypeParameter( const std::string &name ) const
	{
		foreach( const GenericType &genericType, formalGenericTypes )
		{
			if( genericType.GetName() == name )
			{
				return true;
			}
		}
		return false;
	}
	bool IsGeneric() const
	{
		return ( this->formalGenericTypes.size() != 0 );
	}

	// pNX
	bool HasSuperClass() const
	{
		return ( pSuperClass != NULL );
	}
	const CClass &GetSuperClass() const
	{
		return *pSuperClass;
	}
	void SetSuperClass( const CClass *pSuperClass )
	{
		this->pSuperClass = pSuperClass;
	}
	const Types &GetSuperClassActualTypeParameters() const
	{
		return superClassActualTypeParameters;
	}
	void SetSuperClassActualTypeParameters( const Types &actualTypeParameters )
	{
		this->superClassActualTypeParameters = actualTypeParameters;
	}

	// Blittable^
	bool IsBlittableType() const
	{
		return !blittableType.IsNull();
	}
	const Type &GetBlittableType() const
	{
		return blittableType;
	}
	void SetBlittableType( const Type &type ){
		blittableType = type;
	}

	bool IsClass() const;
	bool IsInterface() const;
	bool IsComInterface() const;
	bool IsEnum() const;
	bool IsDelegate() const;
	bool IsStructure() const;
	void SetClassType( ClassType classType )
	{
		this->classType = classType;
	}
	ClassType GetClassType() const
	{
		return classType;
	}


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile() const;
	void NotifyFinishConstructorCompile() const;
	bool IsCompilingConstructor() const;

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile() const;
	void NotifyFinishDestructorCompile() const;
	bool IsCompilingDestructor() const;


	//g̔hNXǂmF
	bool IsSubClass( const CClass *pClass ) const;

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( const CClass *pClass ) const;

	// gƓ܂͔hNXANXǂmF
	bool IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const;

	// C^[tFCX
	bool HasInterfaces() const
	{
		return ( interfaces.size() != 0 );
	}
	void AddInterface( ::Interface *pInterface )
	{
		interfaces.push_back( pInterface );
	}
	const Interfaces &GetInterfaces() const
	{
		return interfaces;
	}
	Interfaces &GetInterfaces()
	{
		return interfaces;
	}
	bool IsInheritsInterface( const CClass *pInterfaceClass ) const;

	// NXp
	bool InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine );

	// C^[tFCXp
	bool InheritsInterface( const CClass &inheritsInterfaceClass, const Types &actualTypeParameters, int nowLine );

	//oA\bh̒ǉ
	void AddDynamicMember( Member *pMember );
	void AddStaticMember( Member *pMember );

	//d`FbN
	bool DupliCheckAll(const char *name) const;
	bool DupliCheckMember(const char *name) const;

	const Members &GetDynamicMembers() const
	{
		return dynamicMembers;
	}
	const Members &GetStaticMembers() const
	{
		return staticMembers;
	}
	Members &GetDynamicMembers()
	{
		return dynamicMembers;
	}
	Members &GetStaticMembers()
	{
		return staticMembers;
	}
	
	const Member *FindDynamicMember( const char *memberName ) const;
	bool HasDynamicMember( const char *memberName ) const
	{
		return ( FindDynamicMember( memberName ) != NULL );
	}

	void EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const;
	const CMethod *GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const;

	const Methods &GetStaticMethods() const
	{
		return staticMethods;
	}
	Methods &GetStaticMethods()
	{
		return staticMethods;
	}

	//ftHg RXgN^
	const CMethod *GetConstructorMethod() const
	{
		if( ConstructorMemberSubIndex == -1 ) return NULL;
		return GetDynamicMethods()[ConstructorMemberSubIndex];
	}
	void SetConstructorMemberSubIndex( int constructorMemberSubIndex )
	{
		this->ConstructorMemberSubIndex = constructorMemberSubIndex;
	}
	int GetConstructorMemberSubIndex() const
	{
		return ConstructorMemberSubIndex;
	}

	//fXgN^ \bh擾
	const CMethod *GetDestructorMethod() const
	{
		if( DestructorMemberSubIndex == -1 ) return NULL;
		return GetDynamicMethods()[DestructorMemberSubIndex];
	}
	void SetDestructorMemberSubIndex( int destructorMemberSubIndex )
	{
		this->DestructorMemberSubIndex = destructorMemberSubIndex;
	}
	int GetDestructorMemberSubIndex() const
	{
		return DestructorMemberSubIndex;
	}

	// [Uw̃ACgŒl
	int GetFixedAlignment() const
	{
		return fixedAlignment;
	}
	void SetFixedAlignment( int fixedAlignment )
	{
		this->fixedAlignment = fixedAlignment;
	}

	// WJ̌^p[^
	bool IsExpanded() const
	{
		return !expandedClassActualTypeParameters.empty();
	}
	void ResolveExpandedClassActualTypeParameter( Type &type ) const;

	// ȏTCY擾
private:
	int cacheSize;
public:
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName ) const;
private:
	// ACgl擾
	int GetAlignment() const;


	/////////////////////////////////////////////////////////////////
	// vtbl
	/////////////////////////////////////////////////////////////////
public:
	// vtblɑ݂鉼z֐̐
	int GetVtblNum() const
	{
		return vtblNum;
	}
	void SetVtblNum( int vtblNum )
	{
		this->vtblNum = vtblNum;
	}
	void AddVtblNum( int vtblNum )
	{
		this->vtblNum += vtblNum;
	}
	bool IsExistVirtualFunctions() const
	{
		// \̈ȊO͉z֐
		return !IsStructure();
	}
	
private:
	int vtbl_offset;
	int comVtblOffset;
	int vtblMasterListOffset;
public:
	std::vector<long> vtblMasterList;
	int GetVtblOffset() const
	{
		return vtbl_offset;
	}
	void SetVtblOffset( int vtblOffset )
	{
		this->vtbl_offset = vtblOffset;
	}
	int GetComVtblOffset() const
	{
		return comVtblOffset;
	}
	void SetComVtblOffset( int comVtblOffset )
	{
		this->comVtblOffset = comVtblOffset;
	}
	void GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const;
	int GetVtblMasterListIndex( const CClass *pClass ) const;
	long GetVtblMasterListOffset() const;
	void SetVtblMasterListOffset( int vtblMasterListOffset )
	{
		this->vtblMasterListOffset = vtblMasterListOffset;
	}
	bool IsAbstract() const;


	// TypeInfop
	mutable int typeInfoDataTableOffset;
	void SetTypeInfoDataTableOffset( int typeInfoDataTableOffset ) const
	{
		this->typeInfoDataTableOffset = typeInfoDataTableOffset;
	}
	int GetTypeInfoDataTableOffset() const
	{
		return typeInfoDataTableOffset;
	}

	// I^f[^p̃of[^擾
	std::string GetStaticDefiningStringAsMemberNames() const;
	std::string GetStaticDefiningStringAsMemberOffsets() const;
	void GetReferenceOffsetsInitializeBuffer( std::string &referenceOffsetsBuffer, int &numOfReference, int baseOffset = 0 ) const;

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};

class Classes : public Jenga::Common::Hashmap<CClass>
{
	// XMLVACYp
public:
	Classes()
		: pStringClass( NULL )
		, pObjectClass( NULL )
		, pInterfaceInfo( NULL )
	{
	}
	~Classes()
	{
	}

	bool Insert( CClass *pClass, int nowLine );
	CClass *Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine);

	const CClass *FindEx( const Symbol &symbol ) const;


	/////////////////////////////
	// NX
	/////////////////////////////
	mutable const CClass *pStringClass;
	mutable const CClass *pObjectClass;
	mutable const CClass *pInterfaceInfo;
	const CClass *GetStringClassPtr() const;
	const CClass *GetObjectClassPtr() const;
	const CClass *GetInterfaceInfoClassPtr() const;
};
