#include "stdafx.h"

#include "common.h"

extern HFONT hFont_TextEdit,hFont_HyperLink_TextEdit;
extern int font_width,font_height;

void TextEditEvent_IME_StartComposition(HWND hwnd){
	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;

	HIMC hIMC;
	hIMC=ImmGetContext(hwnd);

	//R|WVZbg
	POINT pos;
	COMPOSITIONFORM CompForm;
	CompForm.dwStyle=CFS_POINT;
	pos=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos;
	GetScrollBaseCaretPos(MdiInfo[WndNum],(int *)&pos.x,(int *)&pos.y);
	CompForm.ptCurrentPos.x=pos.x*font_width+iControlTabSpace;
	CompForm.ptCurrentPos.y=pos.y*font_height;
	ImmSetCompositionWindow(hIMC, &CompForm);

	//tHgZbg
	ImmSetCompositionFont(hIMC,&pobj_nv->lf);

	ImmReleaseContext(hwnd,hIMC);
}

namespace
{
	void SetNextCompositionWindowPos(HIMC himc, int WndNum){
		int iControlTabSpace;
		iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;
		COMPOSITIONFORM CompForm;
		CompForm.dwStyle=CFS_POINT;
		POINT pos=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos;
		GetScrollBaseCaretPos(MdiInfo[WndNum],(int *)&pos.x,(int *)&pos.y);
		CompForm.ptCurrentPos.x=pos.x*font_width+iControlTabSpace;
		CompForm.ptCurrentPos.y=pos.y*font_height;
		ImmSetCompositionWindow(himc, &CompForm);
	}
}

BOOL TextEditEvent_IME_Composition(HWND hwnd,LPARAM lParam){
	if(lParam&GCS_RESULTSTR){
		int WndNum;
		WndNum=GetWndNum(GetParent(hwnd));

		////////////////////
		// m蕶擾
		////////////////////

		//ReLXg擾
		HIMC hIMC;
		hIMC=ImmGetContext(hwnd);

		int i;
		char temporary[4096];
		i=ImmGetCompositionString(hIMC, GCS_RESULTSTR, temporary,4096);
		if(i==0) return 0;
		temporary[i]=0;

		//obt@vCX
		TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);
		UpdateWindow(hwnd);

		//R|WVZbgiđIME͂sꍇlj
		SetNextCompositionWindowPos(hIMC, WndNum);

		//ReLXg
		ImmReleaseContext(hwnd,hIMC);

		return 0; //DefWindowProc֓nȂ悤TextEditProc֎w
	}

	return 1;
}

namespace
{
	//PCSTR󂯓n悤ɂ_mbschr̃bp
	inline PCSTR cmbschr(PCSTR p, UINT c)
	{
		return reinterpret_cast<PCSTR>(_mbschr(reinterpret_cast<UCHAR const*>(p), c));
	}

	//chPosڂ܂܂s̐擪ւ̃ItZbgԂB
	ptrdiff_t FindLineStartPos(PCSTR pBufStart, LONG CharPos)
	{
		//sT
		PCSTR pBufLineStart = pBufStart+CharPos;
		for(;;){
			PCSTR p = CharPrev(pBufStart, pBufLineStart);
			if (*p=='\n' || pBufLineStart==pBufStart)
				break;
			pBufLineStart = p;
		}
		return pBufLineStart-pBufStart;
	}
}

LRESULT TextEditEvent_IME_RecomvertString(HWND hwnd, RECONVERTSTRING* prcs){
	int WndNum = GetWndNum(GetParent(hwnd));
	CHARRANGE SelRange;
	TextEdit_GetSel(WndNum, &SelRange);
	//Í͈iLbgj܂ލsTi̍sŜԂ߁j
	PCSTR pBufStart = MdiInfo[WndNum]->pMdiTextEdit->buffer;
	ptrdiff_t LineStartPos = FindLineStartPos(pBufStart, SelRange.cpMin);

	ptrdiff_t LineEndPos;
	//sT
	if(PCSTR pEnd = cmbschr(pBufStart+SelRange.cpMax,'\r')){
		LineEndPos = pEnd-pBufStart;
	}
	else{
		LineEndPos = static_cast<ptrdiff_t>(strlen(pBufStart));
	}
	ptrdiff_t SelStrLen = LineEndPos-LineStartPos; //I𕔕̒iI͈͂Ȃ΂̂܂0ŗǂj
	LRESULT lr = sizeof (RECONVERTSTRING)+SelStrLen+1;
	if(prcs){
		//Kvȏ̐ݒ
		//1s̕ƕϊ̃ItZbgn悤ɂĂ
		PSTR pszBuf = reinterpret_cast<LPSTR>(&prcs[1]);
		memcpy(pszBuf, pBufStart+LineStartPos, static_cast<size_t>(SelStrLen));
		pszBuf[SelStrLen] = '\0';

		DWORD StrLen = SelRange.cpMax-SelRange.cpMin;
		DWORD StrOffset = SelRange.cpMin-LineStartPos;
		prcs->dwStrLen = SelStrLen;
		prcs->dwStrOffset = sizeof(*prcs);
		prcs->dwCompStrLen = StrLen;
		prcs->dwCompStrOffset = StrOffset;
		prcs->dwTargetStrLen = StrLen;
		prcs->dwTargetStrOffset = StrOffset;
	}
	return lr;
}

BOOL TextEditEvent_IME_ConfirmRecomvertString(HWND hwnd, RECONVERTSTRING* prcs){
	int WndNum = GetWndNum(GetParent(hwnd));
	CHARRANGE SelRange;
	TextEdit_GetSel(WndNum, &SelRange);
	//Í͈iLbgj܂ލsTi̍sŜԂ߁j
	PCSTR pBufStart = MdiInfo[WndNum]->pMdiTextEdit->buffer;
	ptrdiff_t LineStartPos = FindLineStartPos(pBufStart, SelRange.cpMin);

	//ĕϊʒm̂ŁAIԂɂB
	int ReconvStartPos = static_cast<int>(LineStartPos+prcs->dwCompStrOffset);
	TextEdit_SetSel(WndNum, ReconvStartPos, ReconvStartPos+static_cast<int>(prcs->dwCompStrLen));
	//EBhËʒu̐ݒ
	if (HIMC himc = ImmGetContext(hwnd)){
		SetNextCompositionWindowPos(himc, WndNum);
		ImmReleaseContext(hwnd, himc);
	}
	return TRUE;
}
