#include "stdafx.h"

#include <CodeGenerator.h>

#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif


void CodeGenerator::PutWithSchedule( long l, Schedule::Type scheduleType )
{
	if( scheduleType == Schedule::CatchAddress )
	{
		const UserProc *pCurrentUserProc = compiler.IsGlobalAreaCompiling()
			? UserProc::pGlobalProc
			: &compiler.GetCompilingUserProc();

		this->pNativeCode->PutCatchAddressSchedule( pCurrentUserProc, l );
	}
	else
	{
		this->pNativeCode->PutEx( l, scheduleType );
	}
}

void CodeGenerator::ResolveExitSubSchedule()
{
	foreach( long exitSubCodePosition, exitSubCodePositions )
	{
		pNativeCode->Overwrite( exitSubCodePosition, (long)( pNativeCode->GetSize()-(exitSubCodePosition+sizeof(long)) ) );
	}
}

void CodeGenerator::CheckUnresolveSchedule()
{
	if( pertialSchedules.size() > 0 )
	{
		compiler.errorMessenger.OutputFatalError();
	}
}

void CodeGenerator::opfix( const PertialSchedule *pPertialSchedule, _int64 newValue )
{
	bool isSuccessful = false;

	PertialSchedules::iterator it = pertialSchedules.begin();
	while( it != pertialSchedules.end() )
	{
		if( (*it) == pPertialSchedule )
		{
			if( pPertialSchedule->GetTypeSize() == sizeof(char) )
			{
				if( newValue < -128 || 127 < newValue )
				{
					// ͈͊O
					compiler.errorMessenger.OutputFatalError();
				}

				pNativeCode->Overwrite( pPertialSchedule->GetCodePos(), (char)newValue );
			}
			else if( pPertialSchedule->GetTypeSize() == sizeof(long) )
			{
				pNativeCode->Overwrite( pPertialSchedule->GetCodePos(), static_cast<long>(newValue) );
			}
			else if( pPertialSchedule->GetTypeSize() == sizeof(_int64) )
			{
				pNativeCode->Overwrite( pPertialSchedule->GetCodePos(), newValue );
			}
			else
			{
				compiler.errorMessenger.OutputFatalError();
			}

			it = pertialSchedules.erase( it );
			delete pPertialSchedule;

			isSuccessful = true;
			break;
		}
		else
		{
			it++;
		}
	}

	if( isSuccessful == false )
	{
		compiler.errorMessenger.OutputFatalError();
	}
}

void CodeGenerator::opfix_offset( const PertialSchedule *pPertialSchedule, long offset )
{
	bool isSuccessful = false;

	PertialSchedules::iterator it = pertialSchedules.begin();
	while( it != pertialSchedules.end() )
	{
		if( (*it) == pPertialSchedule )
		{
			if( pPertialSchedule->GetTypeSize() == sizeof(long) )
			{
				pNativeCode->Overwrite(
					pPertialSchedule->GetCodePos(),
					pNativeCode->GetLong(pPertialSchedule->GetCodePos()) + offset
				);
			}
			else
			{
				compiler.errorMessenger.OutputFatalError();
			}

			it = pertialSchedules.erase( it );
			delete pPertialSchedule;

			isSuccessful = true;
			break;
		}
		else
		{
			it++;
		}
	}

	if( isSuccessful == false )
	{
		compiler.errorMessenger.OutputFatalError();
	}
}


// ֘A
void CodeGenerator::opfix_JmpPertialSchedule( const PertialSchedule *pPertialSchedule )
{
	bool isSuccessful = false;

	PertialSchedules::iterator it = pertialSchedules.begin();
	while( it != pertialSchedules.end() )
	{
		if( (*it) == pPertialSchedule )
		{
			long newValue = pNativeCode->GetSize() - (pPertialSchedule->GetCodePos()+pPertialSchedule->GetTypeSize());

			if( pPertialSchedule->GetTypeSize() == sizeof(char) )
			{
				if( newValue < -128 || 127 < newValue )
				{
					// ͈͊O
					compiler.errorMessenger.OutputFatalError();
				}

				pNativeCode->Overwrite( pPertialSchedule->GetCodePos(), (char)newValue );
			}
			else if( pPertialSchedule->GetTypeSize() == sizeof(long) )
			{
				pNativeCode->Overwrite( pPertialSchedule->GetCodePos(), newValue );
			}
			else
			{
				compiler.errorMessenger.OutputFatalError();
			}

			it = pertialSchedules.erase( it );
			delete pPertialSchedule;

			isSuccessful = true;
		}
		else
		{
			it++;
		}
	}

	if( isSuccessful == false )
	{
		compiler.errorMessenger.OutputFatalError();
	}
}
const PertialSchedule *CodeGenerator::__jmp_op_format( char opcode, long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	long beginCodePos = pNativeCode->GetSize();

	if( opcode == (char)0xEB )
	{
		// jmp߂̂Ƃ
		if( op_size == sizeof(char) )
		{
			pNativeCode->Put( (char)opcode );
		}
		else if( op_size == sizeof(long) )
		{
			pNativeCode->Put( (char)0xE9 );
		}
		else
		{
			compiler.errorMessenger.OutputFatalError();
		}
	}
	else
	{
		if( op_size == sizeof(char) )
		{
			pNativeCode->Put( (char)((char)0x70 | opcode) );
		}
		else if( op_size == sizeof(long) )
		{
			pNativeCode->Put( (char)0x0F );
			pNativeCode->Put( (char)((char)0x80 | opcode) );
		}
		else
		{
			compiler.errorMessenger.OutputFatalError();
		}
	}

	const PertialSchedule *pPertialSchedule = NULL;
	if( isPertialSchedule )
	{
		pertialSchedules.push_back( new PertialSchedule( pNativeCode->GetSize(), op_size ) );
		pPertialSchedule = pertialSchedules.back();
	}

	if( isSelfOpcodeOffset )
	{
		// g̖߃TCYlꍇ
		offset -= ( pNativeCode->GetSize() - beginCodePos ) + op_size;
	}

	if( op_size == sizeof(char) )
	{
		pNativeCode->Put( (char)offset );
	}
	else if( op_size == sizeof(long) )
	{
		pNativeCode->Put( offset );
	}
	else
	{
		compiler.errorMessenger.OutputFatalError();
	}

	return pPertialSchedule;
}
const PertialSchedule *CodeGenerator::op_jle( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x0E, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jbe( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x06, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jge( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x0D, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jae( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x03, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jl( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x0C, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jb( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x02, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jg( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x0F, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_ja( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x07, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jne( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x05, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_je( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0x04, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
const PertialSchedule *CodeGenerator::op_jmp( long offset, int op_size, bool isPertialSchedule, bool isSelfOpcodeOffset )
{
	return __jmp_op_format( (char)0xEB, offset, op_size, isPertialSchedule, isSelfOpcodeOffset );
}
void CodeGenerator::op_jmp_continue()
{
	if( GetContinueCodePos() == -1 )
	{
		compiler.errorMessenger.Output(12,"Continue",cp);
		return;
	}
	op_jmp( GetContinueCodePos() - pNativeCode->GetSize(), sizeof(long), false, true );
}
void CodeGenerator::op_jmp_exitsub()
{
	// IyR[h
	pNativeCode->Put( (char)0xE9 );

	exitSubCodePositions.push_back( pNativeCode->GetSize() );

	pNativeCode->Put( (long)0 );
}
void CodeGenerator::op_jmp_goto_schedule( const std::string &name, int lineNum, int sourceCodePos )
{
	// IyR[h
	pNativeCode->Put( (char)0xE9 );

	const GotoLabelSchedule *pGotoLabelSchedule = NULL;
	if( name.size() == 0 )
	{
		pGotoLabelSchedule = new GotoLabelSchedule( name, pNativeCode->GetSize(), sourceCodePos );
	}
	else
	{
		pGotoLabelSchedule = new GotoLabelSchedule( name, pNativeCode->GetSize(), sourceCodePos );
	}
	gotoLabelSchedules.push_back( pGotoLabelSchedule );

	pertialSchedules.push_back( pGotoLabelSchedule );

	pNativeCode->Put( (long)0 );
}

void CodeGenerator::op_AddNeedFreeTempStructure( int reg )
{
#ifdef _AMD64_
	//////////////////////////////////////////////////////
	/////    WX^̃obNAbv
	{	BACKUP_REGISTER_RESOURCE
	//////////////////////////////////////////////////////

		//mov rcx,reg
		op_mov_RR( REG_RCX, reg );

		//call _System_AddNeedFreeTempStructure
		extern const UserProc *pSub_System_AddNeedFreeTempStructure;
		op_call( pSub_System_AddNeedFreeTempStructure );

	/////////////////////////////////////////////
	//////   WX^𕜌
		RESTORE_REGISTER_RESOURCE
	}////////////////////////////////////////////
#else

	//push useRegip邽߁AޔĂj
	compiler.codeGenerator.op_push( reg );

	//push useReg
	compiler.codeGenerator.op_push( reg );

	//call _System_AddNeedFreeTempStructure
	extern const UserProc *pSub_System_AddNeedFreeTempStructure;
	compiler.codeGenerator.op_call( pSub_System_AddNeedFreeTempStructure );

	//pop useRegij
	compiler.codeGenerator.op_pop( reg );
#endif

	isNeedFreeTempStructureInCurrentStep = true;
}
void CodeGenerator::op_FreeTempStructure()
{
	if( !isNeedFreeTempStructureInCurrentStep )
	{
		// ̕Kv͂Ȃ
		return;
	}

	// call _System_FreeTempStructure
	extern const UserProc *pSub_System_FreeTempStructure;
	op_call( pSub_System_FreeTempStructure );

	isNeedFreeTempStructureInCurrentStep = false;
}
