#include "stdafx.h"

std::string ActiveBasic::Common::Environment::rootPath;
bool ActiveBasic::Common::Environment::isRemoveExternal = false;

using namespace ActiveBasic::Common;

void Environment::SetAbdevRootPath( const std::string &rootPath )
{
	Environment::rootPath = Jenga::Common::Path::MakeFullPath( rootPath, Jenga::Common::Environment::GetAppDir() );
}
const std::string Environment::GetAbdevRootPath()
{
	if( rootPath.empty() )
	{
		SetAbdevRootPath( "" );
	}
	return rootPath;
}

const std::string Environment::GetUserAppDir()
{
	return Jenga::Common::Environment::GetUserAppDir() + "\\ActiveBasic";
}

const std::string Environment::GetCompilerExePath( Platform::EnumType platform )
{
	switch( platform )
	{
	case Platform::X86:
		return rootPath + "\\bin\\x86\\abc.exe";
	case Platform::X64:
		return rootPath + "\\bin\\x64\\abc.exe";
	}
	throw;
}

void* operator new( std::size_t n )
{
	if ( void* p = dlmalloc(n) ){
		return p;
	}
	else{
		throw std::bad_alloc();
	}
}

void* operator new[]( std::size_t n )
{
	return ::operator new( n );
}

void operator delete( void* p )
{
	dlfree( p );
}

void operator delete[]( void* p )
{
	::operator delete( p );
}
