#pragma once

class CClass;

class Member : public MemberPrototype
{
	std::string name;
	Type type;
	bool isConst;
	Subscripts subscripts;

	std::string initializeExpression;
	std::string constructParameter;

	// XMLVACYp
	// TODO: xml
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Member" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( MemberPrototype );
		ar & BOOST_SERIALIZATION_NVP( name );
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & BOOST_SERIALIZATION_NVP( subscripts );
		ar & BOOST_SERIALIZATION_NVP( initializeExpression );
		ar & BOOST_SERIALIZATION_NVP( constructParameter );
	}

public:

	int source_code_address;

	Member( Prototype::Accessibility accessibility, const std::string &name, const Type &newType, bool isConst, const Subscripts &subscripts, const std::string &initializeExpression, const std::string &constructParameter );
	Member( const Member &member, const Type &actualType );
	Member( const Member &member );
	Member();
	~Member();

	const std::string &GetName() const
	{
		return name;
	}
	void SetName( const std::string &name )
	{
		this->name = name;
	}

	const Type &GetType() const
	{
		return type;
	}
	void ResetType( const Type &type )
	{
		this->type = type;
	}

	bool IsConst() const
	{
		return isConst;
	}

	const Subscripts &GetSubscripts() const
	{
		return subscripts;
	}

	const std::string &GetInitializeExpression() const
	{
		return initializeExpression;
	}
	const std::string &GetConstructParameter() const
	{
		return constructParameter;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
typedef std::vector<Member *> Members;
