#include "stdafx.h"

#include <LexicalScope.h>
#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void OpcodeOthers( const char *Command ){
	int i,i2;

	char leftTerm[8192];
	int lastParePos = 0;
	for(i=0;;i++){
		if(Command[i]=='\"'){
			//_uNH[g͕sȂ̂ŃG[
			leftTerm[i]=0;
			compiler.errorMessenger.Output(3,leftTerm,cp);
			return;
		}

		if(Command[i]=='('){
			lastParePos = i;
			i2=GetStringInPare(leftTerm+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='['){
			i2=GetStringInBracket(leftTerm+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='\0'){
			leftTerm[i] = 0;
			break;
		}

		if( IsNumCalcMark( Command, i ) ){
			leftTerm[i] = 0;
			break;
		}

		leftTerm[i]=Command[i];
	}
	if(!(
		IsVariableTopChar(leftTerm[0])||
		leftTerm[0]=='.'||
		(leftTerm[0]==1&&leftTerm[1]==ESC_PSMEM)
		)){
		compiler.errorMessenger.Output(1,NULL,cp);
		return;
	}


	if(Command[i]=='\0' && lastParePos == 0){
		//////////////////////////////
		// p[^̃}N
		//////////////////////////////

		const UserProc *pUserProc = GetSubHash(Command);

		//GetSubHashŃG[񎦂sꂽꍇ
		if(pUserProc==(UserProc *)-1) return;

		if(pUserProc==0){
			char temporary[VN_SIZE];
			lstrcpy(temporary,Command);

			CharUpper(temporary);
			pUserProc=GetSubHash(temporary);

			//GetSubHashŃG[񎦂sꂽꍇ
			if(pUserProc==(UserProc *)-1) return;
		}

		if(pUserProc){
			if( !pUserProc->IsMacro() ){
				compiler.errorMessenger.Output(10,Command,cp);
			}

			Opcode_CallProc("",pUserProc,0,"");

			return;
		}
	}
	else if(IsNumCalcMark(Command,i)){
		//Z
		OpcodeCalc(Command);
		return;
	}

	Type resultType;
	bool isLiteral, isNeedHeapFreeStructure = false;
	bool result = TermOpe( leftTerm, Type(), resultType, isLiteral, isNeedHeapFreeStructure, NULL, true );
	if( result ){

		/////////////////////
		// ߂l̏
		/////////////////////

		if( resultType.IsReal() ){
			//fstp st(0)
			compiler.codeGenerator.PutOld(
				(char)0xDD,
				(char)0xD8
			);
		}
		else if( resultType.IsStruct() ){
			//mov ebx,eax
			compiler.codeGenerator.op_mov_RR(REG_EBX,REG_EAX);

			FreeTempObject(REG_EBX,&resultType.GetClass());
		}

		return;
	}

	// ǂɂĂ͂܂Ȃ߁As
	compiler.errorMessenger.Output(1,NULL,cp);
}

void OpcodeIf(char *Parameter){
	int i,i2;
	Type tempType;

	for(i=0;;i++){
		if(Parameter[i]=='\0'){
			compiler.errorMessenger.Output(21,NULL,cp);
			return;
		}
		if(Parameter[i]==1&&Parameter[i+1]==ESC_THEN){
			Parameter[i]=0;
			break;
		}
	}

	const PertialSchedule *pIfPertialSchedule = NULL;
	bool isNeedHeapFreeStructure;
	if( NumOpe( Parameter, Type(DEF_BOOLEAN), tempType, &isNeedHeapFreeStructure ) )
	{
		if( tempType.IsObject() )
		{
			// Boolean^ɃLXg
			Type booleanType( DEF_BOOLEAN );
			CallCastOperatorProc( tempType, isNeedHeapFreeStructure, booleanType );
			tempType = booleanType;
		}

		if( tempType.IsDouble() ){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//push 0
			compiler.codeGenerator.op_push_V(0);

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,sizeof(double)+sizeof(long)
			compiler.codeGenerator.op_add_esp(sizeof(double)+sizeof(long));

			//fcompp
			compiler.codeGenerator.op_fcompp();

			//fnstsw ax
			compiler.codeGenerator.op_fnstsw_ax();

			//test ah,40
			compiler.codeGenerator.op_test_ah( (char)0x40 );

			//jne (endifA܂ else ܂)
			pIfPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
		}
		else if( tempType.IsSingle() ){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//push 0
			compiler.codeGenerator.op_push_V(0);

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,sizeof(float)+sizeof(long)
			compiler.codeGenerator.op_add_esp(sizeof(float)+sizeof(long));

			//fcompp
			compiler.codeGenerator.op_fcompp();

			//fnstsw ax
			compiler.codeGenerator.op_fnstsw_ax();

			//test ah,40
			compiler.codeGenerator.op_test_ah( (char)0x40 );

			//jne (endifA܂ else ܂)
			pIfPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
		}
		else if( tempType.Is64() ){
			//64rbg^

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop ebx
			compiler.codeGenerator.op_pop(REG_EBX);

			//cmp eax,0
			compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

			//jne
			const PertialSchedule *pTempPertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

			//cmp ebx,0
			compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EBX, 0 );

			//jne
			const PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

			//jmp (endifA܂ else ܂ŃWv)
			pIfPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

			compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule1 );
			compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );
		}
		else{
			//32rbg^

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//cmp eax,0
			compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

			//je (endifA܂ else ܂ŏWv)
			pIfPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );
		}
	}


	/////////////////////////
	// IfR[h
	/////////////////////////

	//LVJXR[vxAbv
	compiler.codeGenerator.lexicalScopes.Start(
		compiler.codeGenerator.GetNativeCodeSize(),
		LexicalScope::SCOPE_TYPE_IF
	);

	i2=CompileBuffer(ESC_ENDIF,0);

	//LVJXR[vx_E
	compiler.codeGenerator.lexicalScopes.End();


	if( pIfPertialSchedule == NULL ) return;

	if(i2==ESC_ELSE){
		//jmp (endif܂)
		const PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

		compiler.codeGenerator.opfix_JmpPertialSchedule( pIfPertialSchedule );


		/////////////////////////
		// ElseR[h
		/////////////////////////

		//LVJXR[vxAbv
		compiler.codeGenerator.lexicalScopes.Start(
			compiler.codeGenerator.GetNativeCodeSize(),
			LexicalScope::SCOPE_TYPE_IF
		);

		CompileBuffer(ESC_ENDIF,0);

		//LVJXR[vx_E
		compiler.codeGenerator.lexicalScopes.End();


		compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );
	}
	else{
		compiler.codeGenerator.opfix_JmpPertialSchedule( pIfPertialSchedule );
	}
}

int GetLabelAddress(char *LabelName,int LineNum){
	if(LabelName){
		foreach( const GotoLabel &label, compiler.codeGenerator.gotoLabels )
		{
			if( label.name.size() > 0 )
			{
				if( label.name == LabelName )
				{
					return label.address;
				}
			}
		}
	}
	else{
		foreach( const GotoLabel &label, compiler.codeGenerator.gotoLabels )
		{
			if( label.name.size() == 0 )
			{
				if( label.line == LineNum )
				{
					return label.address;
				}
			}
		}
	}
	return -1;
}
void OpcodeGoto(char *Parameter){
	extern HANDLE hHeap;
	int i,LineNum;

	if(Parameter[0]=='*'){
		i=GetLabelAddress(Parameter+1,0);

		if( i == -1 )
		{
			//jmp ...(schedule)
			compiler.codeGenerator.op_jmp_goto_schedule( (const std::string)(Parameter + 1), 0, cp );
		}
		else
		{
			//jmp ...
			compiler.codeGenerator.op_jmp(
				i-compiler.codeGenerator.GetNativeCodeSize(),
				sizeof(long),
				false,
				true
			);
		}
	}
	else{
		LineNum=atoi(Parameter);
		i=GetLabelAddress(0,LineNum);

		if( i == -1 )
		{
			//jmp ...(schedule)
			compiler.codeGenerator.op_jmp_goto_schedule( "", LineNum, cp );
		}
		else
		{
			//jmp ...
			compiler.codeGenerator.op_jmp(
				i-compiler.codeGenerator.GetNativeCodeSize(),
				sizeof(long),
				false,
				true
			);
		}
	}
}
void OpcodeWhile(char *Parameter){
	extern HANDLE hHeap;

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	if(!Parameter[0]) compiler.errorMessenger.Output(10,"While",cp);

	const PertialSchedule *pWhilePertialSchedule = NULL;
	Type tempType;
	bool isNeedHeapFreeStructure;
	if( NumOpe( Parameter, Type(), tempType, &isNeedHeapFreeStructure ) )
	{
		if( tempType.IsObject() )
		{
			// Boolean^ɃLXg
			Type booleanType( DEF_BOOLEAN );
			CallCastOperatorProc( tempType, isNeedHeapFreeStructure, booleanType );
			tempType = booleanType;
		}

		if( tempType.IsDouble() ){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//push 0
			compiler.codeGenerator.op_push_V(0);

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,sizeof(double)+sizeof(long)
			compiler.codeGenerator.op_add_esp(sizeof(double)+sizeof(long));

			//fcompp
			compiler.codeGenerator.op_fcompp();

			//fnstsw ax
			compiler.codeGenerator.op_fnstsw_ax();

			//test ah,40
			compiler.codeGenerator.op_test_ah( (char)0x40 );

			//jne (Wend ܂)
			pWhilePertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
		}
		else if( tempType.IsSingle() ){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//push 0
			compiler.codeGenerator.op_push_V(0);

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,sizeof(float)+sizeof(long)
			compiler.codeGenerator.op_add_esp(sizeof(float)+sizeof(long));

			//fcompp
			compiler.codeGenerator.op_fcompp();

			//fnstsw ax
			compiler.codeGenerator.op_fnstsw_ax();

			//test ah,40h
			compiler.codeGenerator.op_test_ah( (char)0x40 );

			//jne (Wend ܂)
			pWhilePertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
		}
		else if( tempType.Is64() ){
			//64rbg^

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop ebx
			compiler.codeGenerator.op_pop(REG_EBX);

			//cmp eax,0
			compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

			//jne
			const PertialSchedule *pTempPertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

			//cmp ebx,0
			compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EBX, 0 );

			//jne
			const PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

			//jmp (Wend܂ŃWv)
			pWhilePertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

			compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule1 );
			compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );
		}
		else{
			//̑^

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//cmp eax,0
			compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

			//je (Wend ܂)
			pWhilePertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );
		}
	}

	//LVJXR[vxAbv
	compiler.codeGenerator.lexicalScopes.Start( compiler.codeGenerator.GetNativeCodeSize(), LexicalScope::SCOPE_TYPE_WHILE );

	//WhileRpC
	CompileBuffer(0,COM_WEND);

	compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

	//jmp ...
	compiler.codeGenerator.op_jmp_continue();

	//LVJXR[vx_E
	compiler.codeGenerator.lexicalScopes.End();

	if( pWhilePertialSchedule )
	{
		compiler.codeGenerator.opfix_JmpPertialSchedule( pWhilePertialSchedule );
	}

	compiler.codeGenerator.ContinueAreaEnd();
}

char szNextVariable[VN_SIZE];
void OpcodeFor(char *Parameter){
	extern HANDLE hHeap;
	int i,i2;
	char temporary[VN_SIZE],variable[VN_SIZE],JudgeNum[VN_SIZE],StepNum[VN_SIZE];

	//Pp[^擾
	i=GetOneParameter(Parameter,0,temporary);
	if(!Parameter[i]){
		compiler.errorMessenger.Output(12,"For",cp);
		goto ErrorStep;
	}

	for(i2=0;;i2++){
		if(temporary[i2]=='='){
			variable[i2]=0;

			//JE^
			OpcodeCalc(temporary);
			break;
		}
		if(temporary[i2]=='\0'){
			compiler.errorMessenger.Output(12,"For",cp);
			goto ErrorStep;
		}
		variable[i2]=temporary[i2];
	}

	//jmp ...
	const PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	//Qp[^擾ito`j
	i=GetOneParameter(Parameter,i,JudgeNum);

	//Rp[^擾istep`j
	if(Parameter[i]){
		i=GetOneParameter(Parameter,i,StepNum);
		if(Parameter[i]) compiler.errorMessenger.Output(12,"For",cp);
	}
	else lstrcpy(StepNum,"1");

	//JE^𑝉
	sprintf(temporary,"%s=(%s)+(%s)",variable,variable,StepNum);
	OpcodeCalc(temporary);

	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//ʂ
	sprintf(temporary,"(%s)>=0",StepNum);
	NumOpe(temporary,Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//cmp eax,0
	compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

	//je [JE^̏ꍇ̔]
	pTempPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );

	//iJE^̏ꍇj
	sprintf(temporary,"%s<=(%s)",variable,JudgeNum);
	NumOpe(temporary,Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//jmp [JE^̏ꍇ̔щz]
	const PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

	//jeWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//iJE^̏ꍇj
	sprintf(temporary,"%s>=(%s)",variable,JudgeNum);
	NumOpe(temporary,Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//jmpWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );

	//cmp eax,0
	compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

ErrorStep:

	//je ...
	pTempPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );

	//LVJXR[vxAbv
	compiler.codeGenerator.lexicalScopes.Start( compiler.codeGenerator.GetNativeCodeSize(), LexicalScope::SCOPE_TYPE_FOR );

	//ForRpC
	CompileBuffer(0,COM_NEXT);

	compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

	if(szNextVariable[0]){
		if(lstrcmp(szNextVariable,variable)!=0){
			compiler.errorMessenger.Output(55,szNextVariable,cp);
		}
	}

	//jmp ...
	compiler.codeGenerator.op_jmp_continue();

	//LVJXR[vx_E
	compiler.codeGenerator.lexicalScopes.End();

	//jeWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//ContinueAhX𕜌
	compiler.codeGenerator.ContinueAreaEnd();
}

void OpcodeForeach( const char *Parameter )
{
	Type resultType;
	char temporary[VN_SIZE],variable[VN_SIZE],collectionVar[VN_SIZE];
	bool isError = false;
	std::string elementTypeName;

	//Pp[^擾
	int i = 0;
	GetCustomToken( variable, Parameter, i, ESC_IN, true );
	if(!Parameter[i]){
		compiler.errorMessenger.Output(12,"Foreach",cp);
		isError = true;
		goto ErrorStep;
	}
	i++;

	//Qp[^擾iin`j
	lstrcpy( collectionVar, Parameter + i );


	Exception::TryCommand(); //Finally_System_ForeachEnumerator.Dispose邽

	//Enumerator̎擾
	sprintf(temporary,"_System_ForeachEnumerator=%s.GetEnumerator()", collectionVar );
	OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);

	//LVJXR[vxAbv
	compiler.codeGenerator.lexicalScopes.Start( compiler.codeGenerator.GetNativeCodeSize(), LexicalScope::SCOPE_TYPE_FOR );

	{
		Type collectionType;
		if( !NumOpe_GetType( collectionVar, Type(), collectionType ) )
		{
			isError = true;
			goto ErrorStep;
		}

		Type elementType;
		if( collectionType.GetClass().IsExpanded() )
		{
			// ev[gWJꂽWFlbNNX
			elementType = collectionType.GetClass().expandedClassActualTypeParameters[0];
		}
		else
		{
			// ʏ̃WFlbNNX
			elementType = collectionType.GetActualGenericType(0);
		}

		elementTypeName = compiler.TypeToString( elementType );
	}

	if( !GetVarType( variable, resultType, false ) )
	{

		// `̏ꍇ͎Iɒ`
		sprintf(temporary,"%s=Nothing%c%c%s", variable, 1, ESC_AS, elementTypeName.c_str() );
		OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
	}

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	// MoveNext\bhĂяo
	NumOpe("_System_ForeachEnumerator.MoveNext()",Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//cmp eax,0
	compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

ErrorStep:

	//je ...
	const PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );

	if( !isError )
	{
		// CurrentvpeB猻݂̒l擾
		sprintf( temporary, "%s=_System_ForeachEnumerator.Current%c%c%s", variable, 1, ESC_AS, elementTypeName.c_str() );
		Compile( temporary );
	}

	//ForRpC
	CompileBuffer(0,COM_NEXT);

	compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

	if(szNextVariable[0]){
		if(lstrcmp(szNextVariable,variable)!=0){
			compiler.errorMessenger.Output(55,szNextVariable,cp);
		}
	}

	if( !isError )
	{
		//jmp ...
		compiler.codeGenerator.op_jmp_continue();
	}

	//LVJXR[vx_E
	compiler.codeGenerator.lexicalScopes.End();

	//jeWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//DisposeĂTryXR[vI
	Exception::FinallyCommand();
	Compile( "_System_ForeachEnumerator.Dispose()" );
	Exception::EndTryCommand();

	//ContinueAhX𕜌
	compiler.codeGenerator.ContinueAreaEnd();
}

void OpcodeDo(char *Parameter){
	extern HANDLE hHeap;
	int i,i2,i3;

	if(Parameter[0]) compiler.errorMessenger.Output(10,"Do",cp);

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	//LVJXR[vxAbv
	compiler.codeGenerator.lexicalScopes.Start( compiler.codeGenerator.GetNativeCodeSize(), LexicalScope::SCOPE_TYPE_DO );

	//DoRpC
	CompileBuffer(0,COM_LOOP);

	compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

	const PertialSchedule *pDoPertialSchedule = NULL;

	extern char *basbuf;
	char temporary[VN_SIZE];
	for(i=cp-1;;i--){
		if(IsCommandDelimitation(basbuf[i])){
			i+=3;
			if(!(basbuf[i]=='0'||basbuf[i]=='1')){
				//[v
				break;
			}
			i3=i;

			for(i+=2,i2=0;;i++,i2++){
				if(IsCommandDelimitation(basbuf[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}

			Type tempType;
			bool isNeedHeapFreeStructure;
			NumOpe( temporary, Type(), tempType, &isNeedHeapFreeStructure );

			if( tempType.IsObject() )
			{
				// Boolean^ɃLXg
				Type booleanType( DEF_BOOLEAN );
				CallCastOperatorProc( tempType, isNeedHeapFreeStructure, booleanType );
				tempType = booleanType;
			}

			if( tempType.IsDouble() ){
				//fld qword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

				//push 0
				compiler.codeGenerator.op_push_V(0);

				//fild dword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

				//add esp,sizeof(double)+sizeof(long)
				compiler.codeGenerator.op_add_esp(sizeof(double)+sizeof(long));

				//fcompp
				compiler.codeGenerator.op_fcompp();

				//fnstsw ax
				compiler.codeGenerator.op_fnstsw_ax();

				//test ah,40
				compiler.codeGenerator.op_test_ah( (char)0x40 );

				if(basbuf[i3]=='0'){
					//While

					//jne 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(char), true );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//je 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(char), true );
				}
			}
			else if( tempType.IsSingle() ){
				//fld dword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

				//push 0
				compiler.codeGenerator.op_push_V(0);

				//fild dword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

				//add esp,sizeof(float)+sizeof(long)
				compiler.codeGenerator.op_add_esp(sizeof(float)+sizeof(long));

				//fcompp
				compiler.codeGenerator.op_fcompp();

				//fnstsw ax
				compiler.codeGenerator.op_fnstsw_ax();

				//test ah,40
				compiler.codeGenerator.op_test_ah( (char)0x40 );

				if(basbuf[i3]=='0'){
					//While

					//jne 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(char), true );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//je 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(char), true );
				}
			}
			else if( tempType.Is64() ){
				//64rbg^

				//pop eax
				compiler.codeGenerator.op_pop(REG_EAX);

				//pop ebx
				compiler.codeGenerator.op_pop(REG_EBX);

				//cmp eax,0
				compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

				//jne
				const PertialSchedule *pTempPertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

				//cmp ebx,0
				compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EBX, 0 );

				//jne
				const PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

				if(basbuf[i3]=='0'){
					//While

					//jmp 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(char), true );

					compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule1 );
					compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//jmp 2i[v𑱂j
					const PertialSchedule *pTempPertialSchedule3 = compiler.codeGenerator.op_jmp( 0, sizeof(char), true );

					compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule1 );
					compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );

					//jmp 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(char), true );

					compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule3 );
				}
			}
			else{
				//pop eax
				compiler.codeGenerator.op_pop(REG_EAX);

				//cmp eax,0
				compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

				if(basbuf[i3]=='0'){
					//While

					//je 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(char), true );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//jne 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(char), true );
				}
			}
			break;
		}
	}

	//jmp ...
	compiler.codeGenerator.op_jmp_continue();

	if( pDoPertialSchedule )
	{
		compiler.codeGenerator.opfix_JmpPertialSchedule( pDoPertialSchedule );
	}

	//jmp ...
	const PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

	//LVJXR[vx_E
	compiler.codeGenerator.lexicalScopes.End();

	//jmpWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//ContinueAhX𕜌
	compiler.codeGenerator.ContinueAreaEnd();
}
void OpcodeContinue(void){
	//jmp ...(Continue addr)
	compiler.codeGenerator.op_jmp_continue();
}

void OpcodeExitSub(void){
	if( compiler.IsGlobalAreaCompiling() ){
		compiler.errorMessenger.Output(12,"Exit Sub/Function",cp);
		return;
	}

	//̃[JIuWFNg̃fXgN^Ăяo
	compiler.codeGenerator.lexicalScopes.CallDestructorsOfReturn();

	//jmp ...(End Sub/Function)
	compiler.codeGenerator.op_jmp_exitsub();
}

//CaseXPW[
class SelectSchedule
{
public:
	SelectSchedule( int typeSize )
		: typeSize( typeSize )
		, nowCaseSchedule( 0 )
	{
	}

	PertialSchedules casePertialSchedules;
	int typeSize;
	int nowCaseSchedule;
};
std::vector<SelectSchedule> selectSchedules;

void OpcodeSelect(const char *lpszParms)
{
	extern HANDLE hHeap;
	extern char *basbuf;
	int i,i2,i3,sw,NowCaseCp;
	char temporary[VN_SIZE];
	
	Type type1;
	bool result = NumOpe(lpszParms,Type(), type1 );

	selectSchedules.push_back( SelectSchedule( type1.GetSize() ) );

	if( result )
	{
		if( selectSchedules.back().typeSize < sizeof(long) ){
			selectSchedules.back().typeSize = sizeof(long);
		}

		for(i=cp,sw=0;;i++){
			if(basbuf[i]=='\0'){
				selectSchedules.pop_back();
				compiler.errorMessenger.Output(22,"Select",cp);
				return;
			}
			if(basbuf[i]==1&&basbuf[i+1]==ESC_SELECTCASE){
				for(i2=0;;i++){
					if(basbuf[i]==1&&basbuf[i+1]==ESC_SELECTCASE) i2++;
					if(basbuf[i]==1&&basbuf[i+1]==ESC_ENDSELECT){
						i2--;
						if(i2==0) break;
					}
				}
				continue;
			}
			if(basbuf[i]==1&&basbuf[i+1]==ESC_ENDSELECT){
				if(sw==0){
					//add esp,CaseTypeSize
					compiler.codeGenerator.op_add_esp( selectSchedules.back().typeSize );
				}
				break;
			}
			if(basbuf[i]==1&&basbuf[i+1]==ESC_CASE){
				NowCaseCp=i;

				i++;
				while(1){
					for(i++,i2=0;;i++,i2++){
						if(basbuf[i]=='\"'){
							i3=GetStringInQuotation(temporary+i2,basbuf+i);
							i+=i3-1;
							i2+=i3-1;
							continue;
						}
						if(basbuf[i]=='('){
							i3=GetStringInPare(temporary+i2,basbuf+i);
							i+=i3-1;
							i2+=i3-1;
							continue;
						}
						if(basbuf[i]=='['){
							i3=GetStringInBracket(temporary+i2,basbuf+i);
							i+=i3-1;
							i2+=i3-1;
							continue;
						}

						if(IsCommandDelimitation(basbuf[i])){
							temporary[i2]=0;
							break;
						}
						if(basbuf[i]==','){
							temporary[i2]=0;
							break;
						}

						temporary[i2]=basbuf[i];
					}

					//G[p
					i2=cp;
					cp=NowCaseCp;

					Type type2;
					if( !NumOpe(temporary,type1,type2) ){
						return;
					}

					cp=i2;

					if(type1.IsObject()){
						std::vector<const UserProc *> subs;
						type1.GetClass().GetDynamicMethods().Enum( CALC_EQUAL, subs );
						if( subs.size() == 0 ){
							return;
						}

						Parameters params;
						params.push_back( new Parameter( "", Type( type2 ) ) );

						//I[o[[h
						const UserProc *pUserProc = OverloadSolution( "==", subs, params, Type( DEF_BOOLEAN ), type1 );

						delete params[0];

						if(!pUserProc){
							//G[
							return;
						}


						//pop edx
						compiler.codeGenerator.op_pop(REG_EDX);

						//mov ecx,dword ptr[esp]
						compiler.codeGenerator.op_mov_RM(sizeof(long),REG_ECX,REG_ESP,0,MOD_BASE);

						//push edx
						compiler.codeGenerator.op_push(REG_EDX);

						//push ecx
						compiler.codeGenerator.op_push(REG_ECX);

						//call operator_proc	 ==Zq
						compiler.codeGenerator.op_call(pUserProc);

						//test eax,eax
						compiler.codeGenerator.op_test(REG_EAX,REG_EAX);

						//jne ...
						selectSchedules.back().casePertialSchedules.push_back(
							compiler.codeGenerator.op_jne( 0, sizeof(long), true )
						);
					}
					else if(type1.IsDouble()){
						ChangeTypeToDouble(type2.GetBasicType());

						//fld qword ptr[esp]
						compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

						//add esp,CaseTypeSize
						compiler.codeGenerator.op_add_esp(selectSchedules.back().typeSize);

						//fld qword ptr[esp]
						compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

						//fcompp
						compiler.codeGenerator.op_fcompp();

						//fnstsw ax
						compiler.codeGenerator.op_fnstsw_ax();

						//test ah,40
						compiler.codeGenerator.op_test_ah( (char)0x40 );

						//jne ...
						selectSchedules.back().casePertialSchedules.push_back(
							compiler.codeGenerator.op_jne( 0, sizeof(long), true )
						);
					}
					else if(type1.IsSingle()){
						ChangeTypeToSingle(type2.GetBasicType());

						//fld dword ptr[esp]
						compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

						//add esp,CaseTypeSize
						compiler.codeGenerator.op_add_esp(selectSchedules.back().typeSize);

						//fld dword ptr[esp]
						compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

						//fcompp
						compiler.codeGenerator.op_fcompp();

						//fnstsw ax
						compiler.codeGenerator.op_fnstsw_ax();

						//test ah,40
						compiler.codeGenerator.op_test_ah( (char)0x40 );

						//jne ...
						selectSchedules.back().casePertialSchedules.push_back(
							compiler.codeGenerator.op_jne( 0, sizeof(long), true )
						);
					}
					else{
						//̑^

						//pop ebx
						compiler.codeGenerator.op_pop(REG_EBX);

						//mov eax,dword ptr[esp]
						compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );

						//cmp eax,ebx
						compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

						//je ...
						selectSchedules.back().casePertialSchedules.push_back(
							compiler.codeGenerator.op_je( 0, sizeof(long), true )
						);
					}

					if(basbuf[i]!=',') break;
				}
			}
			if(basbuf[i]==1&&basbuf[i+1]==ESC_CASEELSE){
				sw=1;

				//jmp ...
				selectSchedules.back().casePertialSchedules.push_back(
					compiler.codeGenerator.op_jmp( 0, sizeof(long), true )
				);
			}
		}
	}

	//LVJXR[vxAbv
	compiler.codeGenerator.lexicalScopes.Start( compiler.codeGenerator.GetNativeCodeSize(), LexicalScope::SCOPE_TYPE_SELECT );

	//Select CaseRpC
	CompileBuffer(ESC_ENDSELECT,0);

	//jmp EndSelect
	selectSchedules.back().casePertialSchedules.push_back(
		compiler.codeGenerator.op_jmp( 0, sizeof(long), true )
	);

	//ŏIXPW[
	for(i=selectSchedules.back().nowCaseSchedule;i<(int)selectSchedules.back().casePertialSchedules.size();i++){
		compiler.codeGenerator.opfix_JmpPertialSchedule( selectSchedules.back().casePertialSchedules[i] );
	}

	//LVJXR[vx_E
	compiler.codeGenerator.lexicalScopes.End();

	selectSchedules.pop_back();
}
void OpcodeCase(char *Parameter){
	int i;

	if(selectSchedules.back().typeSize==-1){
		compiler.errorMessenger.Output(30,"Case",cp);
		return;
	}

	//jmp EndSelect
	selectSchedules.back().casePertialSchedules.push_back(
		compiler.codeGenerator.op_jmp( 0, sizeof(long), true )
	);

	i=0;
	while(1){
		//CaseXPW[
		compiler.codeGenerator.opfix_JmpPertialSchedule( selectSchedules.back().casePertialSchedules[selectSchedules.back().nowCaseSchedule] );
		selectSchedules.back().nowCaseSchedule++;

		i=JumpOneParameter(Parameter,i);
		if(Parameter[i]=='\0') break;
	}

	//add esp,CaseTypeSize
	compiler.codeGenerator.op_add_esp(selectSchedules.back().typeSize);
}

void OpcodeGosub(char *Parameter){
	extern HANDLE hHeap;
	int i,LineNum;

	if(Parameter[0]=='*'){
		i=GetLabelAddress(Parameter+1,0);

		if( i == -1 )
		{
			//jmp ...(schedule)
			compiler.codeGenerator.op_jmp_goto_schedule( (const std::string)(Parameter + 1), 0, cp );
		}
		else
		{
			//jmp ...
			compiler.codeGenerator.op_jmp(
				i-compiler.codeGenerator.GetNativeCodeSize(),
				sizeof(long),
				false,
				true
			);
		}
	}
	else{
		LineNum=atoi(Parameter);
		i=GetLabelAddress(0,LineNum);

		if( i == -1 )
		{
			//jmp ...(schedule)
			compiler.codeGenerator.op_jmp_goto_schedule( "", LineNum, cp );
		}
		else
		{
			//jmp ...
			compiler.codeGenerator.op_jmp(
				i-compiler.codeGenerator.GetNativeCodeSize(),
				sizeof(long),
				false,
				true
			);
		}
	}
}
void OpcodeReturn(char *Parameter){
	if( compiler.IsGlobalAreaCompiling() ){
		//Gosub`ReturnƂĈ

		//ret
		compiler.codeGenerator.op_ret();
	}
	else{
		//߂lZbg
		if(Parameter[0]){
			const UserProc &proc = compiler.GetCompilingUserProc();

			const char *temp = "_System_ReturnValue";
			if(proc.GetName()[0]==1&&proc.GetName()[1]==ESC_OPERATOR)
			{
			}
			else{
				temp=proc.GetName().c_str();
			}

			char temporary[VN_SIZE];
			sprintf(temporary,"%s=%s",temp,Parameter);
			OpcodeCalc(temporary);
		}

		//vV[W𔲂oiCreturnƓl̏sj
		OpcodeExitSub();
	}
}


////////////
// |C^

void OpcodeSetPtrData(char *Parameter,int type){
	int i;
	char temporary[VN_SIZE];

	if(Parameter[0]=='('){
		i=JumpStringInPare(Parameter,1);
		if(Parameter[i+1]=='\0'){
			for(i=0;;i++){
				Parameter[i]=Parameter[i+1];
				if(Parameter[i]=='\0') break;
			}
			Parameter[i-1]=0;
		}
	}

	//Pp[^擾
	i=GetOneParameter(Parameter,0,temporary);
	if(!Parameter[i]){
		compiler.errorMessenger.Output(1,NULL,cp);
		return;
	}

	Type resultType;
	if( !NumOpe(temporary,Type(),resultType) ){
		return;
	}
	if(!resultType.IsWhole()){
		compiler.errorMessenger.Output(11,Parameter,cp);
		return;
	}

	ChangeTypeToLong( resultType.GetBasicType() );

	//Qp[^擾
	i=GetOneParameter(Parameter,i,temporary);
	if(Parameter[i]){
		compiler.errorMessenger.Output(1,NULL,cp);
		return;
	}

	if( !NumOpe(temporary,Type(),resultType) ){
		return;
	}

	if(type==DEF_DOUBLE){
		ChangeTypeToDouble_ToFpuReg( resultType.GetBasicType() );

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//fstp qword ptr[eax]
		compiler.codeGenerator.PutOld(
			(char)0xDD,
			(char)0x18
		);
	}
	else if(type==DEF_SINGLE){
		ChangeTypeToSingle( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov dword ptr[eax],ebx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_QWORD){
		ChangeTypeToInt64( resultType.GetBasicType() );

		//pop ecx
		compiler.codeGenerator.op_pop(REG_ECX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov dword ptr[eax],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_EAX, 0, MOD_BASE );

		//mov dword ptr[eax+sizeof(long)],ebx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EBX, REG_EAX, 0x04, MOD_BASE_DISP8 );
	}
	else if(type==DEF_DWORD){
		ChangeTypeToLong( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov dword ptr[eax],ebx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_WORD){
		ChangeTypeToLong( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov word ptr[eax],bx
		compiler.codeGenerator.op_mov_MR( sizeof(short), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_BYTE){
		ChangeTypeToLong( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov byte ptr[eax],bl
		compiler.codeGenerator.op_mov_MR( sizeof(char), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
}
