#include "stdafx.h"

void Meta::Clear()
{
	// O
	namespaceScopesCollection.clear();

	// ֐E\bh
	userProcs.Clear();

	// DLL֐
	dllProcs.Clear();

	// NX
	classesImpl.Clear();

	// O[oϐ
	globalVars.Clear();

	// O[o萔
	globalConsts.Clear();

	// O[o萔}N
	globalConstMacros.Clear();

	// blittable^
	blittableTypes.clear();

	// TypeDef
	typeDefs.clear();

	// ֐|C^
	procPointers.Clear();
}

void Meta::StaticLink( Meta &meta, long dataSectionBaseOffset, const std::vector<int> &relationTable )
{
	// O
	BOOST_FOREACH( NamespaceScopes &namespaceScopes, meta.namespaceScopesCollection )
	{
		if( !this->namespaceScopesCollection.IsExist( namespaceScopes ) )
		{
			this->namespaceScopesCollection.push_back( namespaceScopes );
		}
	}

	// ֐E\bh
	meta.GetUserProcs().Iterator_Reset();
	while( meta.GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = meta.GetUserProcs().Iterator_GetNext();
		if( pUserProc->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pUserProc->ResetRelationalObjectModuleIndex( relationTable );

		pUserProc->GetNativeCode().ResetDataSectionBaseOffset( dataSectionBaseOffset );

		this->userProcs.Put( pUserProc );
	}
	meta.GetUserProcs().PullOutAll();

	// DLL֐
	meta.GetDllProcs().Iterator_Reset();
	while( meta.GetDllProcs().Iterator_HasNext() )
	{
		DllProc *pDllProc = meta.GetDllProcs().Iterator_GetNext();
		if( pDllProc->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pDllProc->ResetRelationalObjectModuleIndex( relationTable );
		this->dllProcs.Put( pDllProc );
	}
	meta.GetDllProcs().PullOutAll();

	// NX
	meta.GetClasses().Iterator_Reset();
	while( meta.GetClasses().Iterator_HasNext() )
	{
		CClass *pClass = meta.GetClasses().Iterator_GetNext();
		if( pClass->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pClass->ResetRelationalObjectModuleIndex( relationTable );
		pClass->Readed();
		this->GetClasses().Put( pClass );
	}
	meta.GetClasses().PullOutAll();

	// O[oϐ
	long initAreaBaseOffset = this->globalVars.initAreaBuffer.GetSize();
	foreach( Variable *pVar, meta.globalVars )
	{
		if( pVar->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		// XR[vx̃O[oϐ̐lIɂ
		if( pVar->GetScopeLevel() == 0 )
		{
			pVar->isLiving = true;
		}

		bool isResetOffsetAddress = true;
		if( pVar->HasInitData() )
		{
			// obt@Ƃ̓f[^e[uItZbgKp
			pVar->SetOffsetAddress( pVar->GetOffsetAddress() + initAreaBaseOffset );

			isResetOffsetAddress = false;
		}

		pVar->ResetRelationalObjectModuleIndex( relationTable );
		this->globalVars.Add( pVar, isResetOffsetAddress );
	}
	meta.globalVars.PullOutAll();
	this->globalVars.initAreaBuffer.Put(
		meta.globalVars.initAreaBuffer.GetBuffer(),
		meta.globalVars.initAreaBuffer.GetSize()
	);

	// O[o萔
	meta.GetGlobalConsts().Iterator_Reset();
	while( meta.GetGlobalConsts().Iterator_HasNext() )
	{
		CConst *pConst = meta.GetGlobalConsts().Iterator_GetNext();
		if( pConst->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pConst->ResetRelationalObjectModuleIndex( relationTable );
		this->GetGlobalConsts().Put( pConst );
	}
	meta.GetGlobalConsts().PullOutAll();

	// O[o萔}N
	meta.GetGlobalConstMacros().Iterator_Reset();
	while( meta.GetGlobalConstMacros().Iterator_HasNext() )
	{
		ConstMacro *pConstMacro = meta.GetGlobalConstMacros().Iterator_GetNext();
		if( pConstMacro->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pConstMacro->ResetRelationalObjectModuleIndex( relationTable );
		this->GetGlobalConstMacros().Put( pConstMacro );
	}
	meta.GetGlobalConstMacros().PullOutAll();

	// blittable^
	BOOST_FOREACH( BlittableType &blittableType, meta.blittableTypes )
	{
		// TODO: coreW[ȊOłBlittable^p̃NXW[`ł悤ɂׂ
		this->blittableTypes.push_back( blittableType );
	}
	meta.blittableTypes.clear();

	// TypeDef
	BOOST_FOREACH( TypeDef &typeDef, meta.typeDefs )
	{
		if( typeDef.IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		typeDef.ResetRelationalObjectModuleIndex( relationTable );
		this->typeDefs.push_back( typeDef );
	}
	meta.typeDefs.clear();

	// ֐|C^
	foreach( ProcPointer *pProcPointer, meta.procPointers )
	{
		if( pProcPointer->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pProcPointer->ResetRelationalObjectModuleIndex( relationTable );
		this->procPointers.push_back( pProcPointer );
	}
	meta.procPointers.PullOutAll();

	// fQ[g
	meta.GetDelegates().Iterator_Reset();
	while( meta.GetDelegates().Iterator_HasNext() )
	{
		Delegate *pDelegate = meta.GetDelegates().Iterator_GetNext();
		if( pDelegate->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pDelegate->ResetRelationalObjectModuleIndex( relationTable );
		this->GetDelegates().Put( pDelegate );
	}
	meta.GetDelegates().PullOutAll();
}

const ::Delegate &Meta::ToDelegate( const CClass &_class )
{
	const ::Delegate *dg = this->GetDelegates().GetHashArrayElement( _class.GetName().c_str() );
	while( dg )
	{
		if( dg->IsEqualSymbol( _class.GetNamespaceScopes(), _class.GetName() ) ){
			//OԂƃNXv
			return *dg;
		}
		dg = dg->GetChainNext();
	}

	throw;
}

const CClass *Meta::FindClassSupportedTypeDef( const Symbol &symbol )
{
	const CClass *pClass = this->GetClasses().FindEx( symbol );
	if( pClass )
	{
		return pClass;
	}

	// TypeDef
	const TypeDef *pTypeDef = this->GetTypeDefs().Find( symbol );
	if( pTypeDef )
	{
		Type type = pTypeDef->GetBaseType();
		if( type.IsObject() )
		{
			return &type.GetClass();
		}
	}

	return NULL;
}

void Meta::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	// ֐E\bh
	this->GetUserProcs().Iterator_Init();
	this->GetUserProcs().Iterator_Reset();
	while( this->GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = this->GetUserProcs().Iterator_GetNext();
		pUserProc->Resolve( resolver, resolveErrors );
	}

	// DLL֐
	this->GetDllProcs().Iterator_Init();
	this->GetDllProcs().Iterator_Reset();
	while( this->GetDllProcs().Iterator_HasNext() )
	{
		DllProc *pDllProc = this->GetDllProcs().Iterator_GetNext();
		pDllProc->Resolve( resolver, resolveErrors );
	}

	// NX
	this->GetClasses().Iterator_Init();
	this->GetClasses().Iterator_Reset();
	while( this->GetClasses().Iterator_HasNext() )
	{
		CClass *pClass = this->GetClasses().Iterator_GetNext();
		pClass->Resolve( resolver, resolveErrors );
	}

	// O[oϐ
	foreach( Variable *pVar, globalVars )
	{
		pVar->Resolve( resolver, resolveErrors );
	}

	// O[o萔
	this->GetGlobalConsts().Iterator_Init();
	this->GetGlobalConsts().Iterator_Reset();
	while( this->GetGlobalConsts().Iterator_HasNext() )
	{
		CConst *pConst = this->GetGlobalConsts().Iterator_GetNext();
		pConst->Resolve( resolver, resolveErrors );
	}

	// O[o萔}N
	this->GetGlobalConstMacros().Iterator_Init();
	this->GetGlobalConstMacros().Iterator_Reset();
	while( this->GetGlobalConstMacros().Iterator_HasNext() )
	{
		ConstMacro *pConstMacro = this->GetGlobalConstMacros().Iterator_GetNext();
		pConstMacro->Resolve( resolver, resolveErrors );
	}

	// blittable^
	BOOST_FOREACH( BlittableType &blittableType, blittableTypes )
	{
		blittableType.Resolve( resolver, resolveErrors );
	}

	// TypeDef
	BOOST_FOREACH( TypeDef &typeDef, typeDefs )
	{
		typeDef.Resolve( resolver, resolveErrors );
	}

	// ֐|C^
	foreach( ProcPointer *pProcPointer, procPointers )
	{
		pProcPointer->Resolve( resolver, resolveErrors );
	}

	// fQ[g
	this->GetDelegates().Iterator_Init();
	this->GetDelegates().Iterator_Reset();
	while( this->GetDelegates().Iterator_HasNext() )
	{
		Delegate *pDelegate = this->GetDelegates().Iterator_GetNext();
		pDelegate->Resolve( resolver, resolveErrors );
	}
}
