#include "stdafx.h"

#include "../BasicCompiler_Common/common.h"

#ifndef RT_MANIFEST
#define RT_MANIFEST                        MAKEINTRESOURCE(24)
#endif

//\[XAhXXPW[
DWORD *lpdwRSrcAddrSchedule;
int RSrcAddrScheduleNum;

void AddRSrcAddrSchedule(DWORD pos){
	extern HANDLE hHeap;

	//O[oϐAhXXPW[ɒǉ
	lpdwRSrcAddrSchedule=(DWORD *)HeapReAlloc(hHeap,0,lpdwRSrcAddrSchedule,(RSrcAddrScheduleNum+1)*sizeof(DWORD));
	lpdwRSrcAddrSchedule[RSrcAddrScheduleNum]=pos;
	RSrcAddrScheduleNum++;
}

char *PermutationString(char *buffer,char *lpszSearch,char *lpszRewrite){
	//obt@
	int length;
	length=lstrlen(buffer);

	//T[`̒
	int search_length;
	search_length=lstrlen(lpszSearch);

	//u̒
	int write_length;
	write_length=lstrlen(lpszRewrite);

	//uItZbg
	int offset;
	offset=lstrlen(lpszRewrite)-search_length;

	int i;
	for(i=0;i<length-search_length;i++){
		if(memcmp(buffer+i,lpszSearch,search_length)==0){
			if(offset>0){
				length+=offset;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,length+1);
			}

			SlideString(buffer+i+search_length,offset);
			memcpy(buffer+i,lpszRewrite,write_length);
			i+=write_length-1;
		}
	}

	return buffer;
}

char *GetRSrcSectionBuffer(int *pLen){
	extern HANDLE hHeap;
	char *buffer,*temporary;
	int i2,i3,i4,i5,i6,i7,sw,BufSize,TypeNum,NextBase;
	HANDLE hFile;

	//J[\\[X
	int CursorNum;
	CURSORDIR *pCursorDir;
	CURSORDIRENTRY *pCursorDirEntry;
	CURSORDIRENTRY_RES CursorDirEntry_Res;
	CursorNum=0;

	//ACR\[X
	int IconNum;
	ICONDIR *pIconDir;
	ICONDIRENTRY *pIconDirEntry;
	ICONDIRENTRY_RES IconDirEntry_Res;
	IconNum=0;

	BufSize=8192*2;
	buffer=(char *)HeapAlloc(hHeap,0,BufSize);
	i2=0;
	NextBase=0;

	//\[XAhXXPW[
	lpdwRSrcAddrSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	RSrcAddrScheduleNum=0;

	*pLen=0;

	if( compiler.resourceManager.cursorResources.empty()
		&& compiler.resourceManager.bitmapResources.empty()
		&& compiler.resourceManager.iconResources.empty()
		&& compiler.resourceManager.manifestFilePath.empty() )
	{
		return buffer;
	}

	sw=0;

	//J[\̖vZiCursorNumɊi[j
	foreach( const ActiveBasic::Common::ResourceItem &resourceItem, compiler.resourceManager.cursorResources )
	{
		hFile=CreateFile(resourceItem.filepath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(23,resourceItem.filepath.c_str(),-1);
			sw=1;
			continue;
		}
		i4=GetFileSize(hFile,NULL);
		temporary=(char *)HeapAlloc(hHeap,0,i4);
		ReadFile(hFile,temporary,i4,(DWORD *)&i5,NULL);
		CloseHandle(hFile);

		pCursorDir=(CURSORDIR *)temporary;
		CursorNum+=pCursorDir->idCount;

		HeapDefaultFree(temporary);
	}

	//rbg}bṽt@C̗LmF
	foreach( const ActiveBasic::Common::ResourceItem &resourceItem, compiler.resourceManager.bitmapResources )
	{
		hFile=CreateFile(resourceItem.filepath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(23,resourceItem.filepath.c_str(),-1);
			sw=1;
			continue;
		}
		CloseHandle(hFile);
	}

	//ACR̖vZiIconNumɊi[j
	foreach( const ActiveBasic::Common::ResourceItem &resourceItem, compiler.resourceManager.iconResources )
	{
		hFile=CreateFile(resourceItem.filepath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(23,resourceItem.filepath.c_str(),-1);
			sw=1;
			continue;
		}
		i4=GetFileSize(hFile,NULL);
		temporary=(char *)HeapAlloc(hHeap,0,i4);
		ReadFile(hFile,temporary,i4,(DWORD *)&i5,NULL);
		CloseHandle(hFile);

		pIconDir=(ICONDIR *)temporary;
		IconNum+=pIconDir->idCount;

		HeapDefaultFree(temporary);
	}

	//t@C̓ǂݍ݂Ɏsꍇ
	if(sw) return buffer;


	/////////////////////////
	// fBNg Gg
	/////////////////////////
	TypeNum=0;
	if( !compiler.resourceManager.cursorResources.empty() ) TypeNum+=2;
	if( !compiler.resourceManager.bitmapResources.empty() ) TypeNum++;
	if( !compiler.resourceManager.iconResources.empty() ) TypeNum+=2;
	if( !compiler.resourceManager.manifestFilePath.empty() ) TypeNum++;

	NextBase=sizeof(IMAGE_RESOURCE_DIRECTORY)+
		sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)*TypeNum;

	//1Kw
	IMAGE_RESOURCE_DIRECTORY ImgResDir;
	ImgResDir.Characteristics=0;
	ImgResDir.TimeDateStamp=0;
	ImgResDir.MajorVersion=0;
	ImgResDir.MinorVersion=0;
	ImgResDir.NumberOfNamedEntries=0;
	ImgResDir.NumberOfIdEntries=TypeNum;
	memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
	i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

	i6=0;
	IMAGE_RESOURCE_DIRECTORY_ENTRY ImgDirEntry;
	if(CursorNum){
		//RT_CURSOR
		ImgDirEntry.Name=(DWORD)(LONG_PTR)RT_CURSOR;
		ImgDirEntry.OffsetToData=(NextBase+i6)|0x80000000;
		memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);

		//2Kw̃TCY
		i6+=	sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)*CursorNum;
	}
	if( !compiler.resourceManager.bitmapResources.empty() ){
		//RT_BITMAP
		ImgDirEntry.Name=(DWORD)(LONG_PTR)RT_BITMAP;
		ImgDirEntry.OffsetToData=(NextBase+i6)|0x80000000;
		memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);

		//2Kw̃TCY
		i6+=	sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY) * compiler.resourceManager.bitmapResources.size();
	}
	if(IconNum){
		//RT_ICON
		ImgDirEntry.Name=(DWORD)(LONG_PTR)RT_ICON;
		ImgDirEntry.OffsetToData=(NextBase+i6)|0x80000000;
		memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);

		//2Kw̃TCY
		i6+=	sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)*IconNum;
	}
	if( !compiler.resourceManager.cursorResources.empty() )
	{
		//RT_GROUP_CURSOR
		ImgDirEntry.Name=(DWORD)(LONG_PTR)RT_GROUP_CURSOR;
		ImgDirEntry.OffsetToData=(NextBase+i6)|0x80000000;
		memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);

		//2Kw̃TCY
		i6+=	sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)*CursorNum;
	}
	if( !compiler.resourceManager.iconResources.empty() )
	{
		//RT_GROUP_ICON
		ImgDirEntry.Name=(DWORD)(LONG_PTR)RT_GROUP_ICON;
		ImgDirEntry.OffsetToData=(NextBase+i6)|0x80000000;
		memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);

		//2Kw̃TCY
		i6+=	sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY) * compiler.resourceManager.iconResources.size();
	}
	if( !compiler.resourceManager.manifestFilePath.empty() )
	{
		//RT_MANIFEST
		ImgDirEntry.Name=(DWORD)(LONG_PTR)RT_MANIFEST;
		ImgDirEntry.OffsetToData=(NextBase+i6)|0x80000000;
		memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);

		//2Kw̃TCY
		i6+=	sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY) * 1/*XPManiResourceNum*/ ;
	}

	NextBase+=i6;

	//2Kw
	i6=0;
	i7=0;
	if(CursorNum){
		//RT_CURSOR
		ImgResDir.Characteristics=0;
		ImgResDir.TimeDateStamp=0;
		ImgResDir.MajorVersion=0;
		ImgResDir.MinorVersion=0;
		ImgResDir.NumberOfNamedEntries=0;
		ImgResDir.NumberOfIdEntries=CursorNum;
		memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

		for(i3=0;i3<CursorNum;i3++,i7++){
			ImgDirEntry.Name=i7+1;
			ImgDirEntry.OffsetToData=(NextBase+i6+
				(sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*i3)
				|0x80000000;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		//3Kw̃TCY
		i6+=(sizeof(IMAGE_RESOURCE_DIRECTORY)+
			sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*CursorNum;
	}
	if( !compiler.resourceManager.bitmapResources.empty() ){
		//RT_BITMAP
		ImgResDir.Characteristics=0;
		ImgResDir.TimeDateStamp=0;
		ImgResDir.MajorVersion=0;
		ImgResDir.MinorVersion=0;
		ImgResDir.NumberOfNamedEntries=0;
		ImgResDir.NumberOfIdEntries = compiler.resourceManager.bitmapResources.size();
		memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

		for(i3=0;i3<static_cast<int>(compiler.resourceManager.bitmapResources.size());i3++)
		{
			ImgDirEntry.Name = static_cast<DWORD>(compiler.GetObjectModule().meta.GetGlobalConsts().GetWholeData(
				ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol(
					compiler.resourceManager.bitmapResources[i3].idName
				)
			));
			ImgDirEntry.OffsetToData=(NextBase+i6+
				(sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*i3)
				|0x80000000;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=(sizeof(IMAGE_RESOURCE_DIRECTORY)+
			sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)) * compiler.resourceManager.bitmapResources.size();
	}
	if(IconNum){
		//RT_ICON
		ImgResDir.Characteristics=0;
		ImgResDir.TimeDateStamp=0;
		ImgResDir.MajorVersion=0;
		ImgResDir.MinorVersion=0;
		ImgResDir.NumberOfNamedEntries=0;
		ImgResDir.NumberOfIdEntries=IconNum;
		memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

		for(i3=0;i3<IconNum;i3++,i7++){
			ImgDirEntry.Name=i7+1;
			ImgDirEntry.OffsetToData=(NextBase+i6+
				(sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*i3)
				|0x80000000;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		//3Kw̃TCY
		i6+=(sizeof(IMAGE_RESOURCE_DIRECTORY)+
			sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*IconNum;
	}
	if( !compiler.resourceManager.cursorResources.empty() )
	{
		//RT_GROUP_CURSOR
		ImgResDir.Characteristics=0;
		ImgResDir.TimeDateStamp=0;
		ImgResDir.MajorVersion=0;
		ImgResDir.MinorVersion=0;
		ImgResDir.NumberOfNamedEntries=0;
		ImgResDir.NumberOfIdEntries = compiler.resourceManager.cursorResources.size();
		memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

		for(i3=0;i3<static_cast<int>(compiler.resourceManager.cursorResources.size());i3++){
			ImgDirEntry.Name = static_cast<DWORD>(compiler.GetObjectModule().meta.GetGlobalConsts().GetWholeData(
				ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol(
					compiler.resourceManager.cursorResources[i3].idName
				)
			));
			ImgDirEntry.OffsetToData=(NextBase+i6+
				(sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*i3)
				|0x80000000;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		//3Kw̃TCY
		i6+=(sizeof(IMAGE_RESOURCE_DIRECTORY)+
			sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)) * compiler.resourceManager.cursorResources.size();
	}
	if( !compiler.resourceManager.iconResources.empty() )
	{
		//RT_GROUP_ICON
		ImgResDir.Characteristics=0;
		ImgResDir.TimeDateStamp=0;
		ImgResDir.MajorVersion=0;
		ImgResDir.MinorVersion=0;
		ImgResDir.NumberOfNamedEntries=0;
		ImgResDir.NumberOfIdEntries = compiler.resourceManager.iconResources.size();
		memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

		for(i3=0;i3<static_cast<int>(compiler.resourceManager.iconResources.size());i3++){
			ImgDirEntry.Name = static_cast<DWORD>(compiler.GetObjectModule().meta.GetGlobalConsts().GetWholeData(
				ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol(
					compiler.resourceManager.iconResources[i3].idName
				)
			));
			ImgDirEntry.OffsetToData=(NextBase+i6+
				(sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*i3)
				|0x80000000;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		//3Kw̃TCY
		i6+=(sizeof(IMAGE_RESOURCE_DIRECTORY)+
			sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)) * compiler.resourceManager.iconResources.size();
	}
	if( !compiler.resourceManager.manifestFilePath.empty() )
	{
		//RT_MANIFEST
		ImgResDir.Characteristics=0;
		ImgResDir.TimeDateStamp=0;
		ImgResDir.MajorVersion=0;
		ImgResDir.MinorVersion=0;
		ImgResDir.NumberOfNamedEntries=0;
		ImgResDir.NumberOfIdEntries = 1 /*XPManiResourceNum*/ ;
		memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
		i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

		i3 = 0;
		{
			ImgDirEntry.Name=i3+1;
			ImgDirEntry.OffsetToData=(NextBase+i6+
				(sizeof(IMAGE_RESOURCE_DIRECTORY)+
				sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY))*i3)
				|0x80000000;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=(sizeof(IMAGE_RESOURCE_DIRECTORY)+
			sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY)) * 1 /*XPManiResourceNum*/ ;
	}


	NextBase+=i6;

	while(i2+8192>BufSize){
		BufSize+=8192;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
	}

	//3Kw
	i6=0;
	if(CursorNum){
		//RT_CURSOR
		for(i3=0;i3<CursorNum;i3++){
			ImgResDir.Characteristics=0;
			ImgResDir.TimeDateStamp=0;
			ImgResDir.MajorVersion=0;
			ImgResDir.MinorVersion=0;
			ImgResDir.NumberOfNamedEntries=0;
			ImgResDir.NumberOfIdEntries=1;
			memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

			ImgDirEntry.Name=0x411;
			ImgDirEntry.OffsetToData=NextBase+i6+
				sizeof(IMAGE_RESOURCE_DATA_ENTRY)*i3;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=sizeof(IMAGE_RESOURCE_DATA_ENTRY)*CursorNum;
	}
	if( !compiler.resourceManager.bitmapResources.empty() ){
		//RT_BITMAP
		for(i3=0;i3<static_cast<int>(compiler.resourceManager.bitmapResources.size());i3++){
			ImgResDir.Characteristics=0;
			ImgResDir.TimeDateStamp=0;
			ImgResDir.MajorVersion=0;
			ImgResDir.MinorVersion=0;
			ImgResDir.NumberOfNamedEntries=0;
			ImgResDir.NumberOfIdEntries=1;
			memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

			ImgDirEntry.Name=0x411;
			ImgDirEntry.OffsetToData=NextBase+i6+
				sizeof(IMAGE_RESOURCE_DATA_ENTRY)*i3;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=sizeof(IMAGE_RESOURCE_DATA_ENTRY) * compiler.resourceManager.bitmapResources.size();
	}
	if(IconNum){
		//RT_ICON
		for(i3=0;i3<IconNum;i3++){
			ImgResDir.Characteristics=0;
			ImgResDir.TimeDateStamp=0;
			ImgResDir.MajorVersion=0;
			ImgResDir.MinorVersion=0;
			ImgResDir.NumberOfNamedEntries=0;
			ImgResDir.NumberOfIdEntries=1;
			memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

			ImgDirEntry.Name=0x411;
			ImgDirEntry.OffsetToData=NextBase+i6+
				sizeof(IMAGE_RESOURCE_DATA_ENTRY)*i3;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=sizeof(IMAGE_RESOURCE_DATA_ENTRY)*IconNum;
	}
	if( !compiler.resourceManager.cursorResources.empty() )
	{
		//RT_GROUP_CURSOR
		for(i3=0;i3<static_cast<int>(compiler.resourceManager.cursorResources.size());i3++){
			ImgResDir.Characteristics=0;
			ImgResDir.TimeDateStamp=0;
			ImgResDir.MajorVersion=0;
			ImgResDir.MinorVersion=0;
			ImgResDir.NumberOfNamedEntries=0;
			ImgResDir.NumberOfIdEntries=1;
			memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

			ImgDirEntry.Name=0x411;
			ImgDirEntry.OffsetToData=NextBase+i6+
				sizeof(IMAGE_RESOURCE_DATA_ENTRY)*i3;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=sizeof(IMAGE_RESOURCE_DATA_ENTRY) * compiler.resourceManager.cursorResources.size();
	}
	if( !compiler.resourceManager.iconResources.empty() )
	{
		//RT_GROUP_ICON
		for(i3=0;i3<static_cast<int>(compiler.resourceManager.iconResources.size());i3++){
			ImgResDir.Characteristics=0;
			ImgResDir.TimeDateStamp=0;
			ImgResDir.MajorVersion=0;
			ImgResDir.MinorVersion=0;
			ImgResDir.NumberOfNamedEntries=0;
			ImgResDir.NumberOfIdEntries=1;
			memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

			ImgDirEntry.Name=0x411;
			ImgDirEntry.OffsetToData=NextBase+i6+
				sizeof(IMAGE_RESOURCE_DATA_ENTRY)*i3;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=sizeof(IMAGE_RESOURCE_DATA_ENTRY)*compiler.resourceManager.iconResources.size();
	}
	if( !compiler.resourceManager.manifestFilePath.empty() ){
		//RT_MANIFEST
		i3 = 0;
		{
			ImgResDir.Characteristics=0;
			ImgResDir.TimeDateStamp=0;
			ImgResDir.MajorVersion=0;
			ImgResDir.MinorVersion=0;
			ImgResDir.NumberOfNamedEntries=0;
			ImgResDir.NumberOfIdEntries=1;
			memcpy(buffer+i2,&ImgResDir,sizeof(IMAGE_RESOURCE_DIRECTORY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY);

			ImgDirEntry.Name=0x411;
			ImgDirEntry.OffsetToData=NextBase+i6+
				sizeof(IMAGE_RESOURCE_DATA_ENTRY)*i3;
			memcpy(buffer+i2,&ImgDirEntry,sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY));
			i2+=sizeof(IMAGE_RESOURCE_DIRECTORY_ENTRY);
		}

		i6+=sizeof(IMAGE_RESOURCE_DATA_ENTRY) * 1 /*XPManiResourceNum*/ ;
	}

	NextBase+=i6;

	while(i2+8192>BufSize){
		BufSize+=8192;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
	}



	////////////////////////////////////////
	// f[^ Gg
	////////////////////////////////////////

	DWORD dwDataEntrySchedule[100];
	int DataEntryScheduleNum;
	int CursorEntryBase;
	int CursorGroupEntryBase;
	int BitmapEntryBase;
	int IconEntryBase;
	int IconGroupEntryBase;

	DataEntryScheduleNum=0;

	//̃f[^Gg̈쐬

	//RT_CURSOR
	CursorEntryBase=DataEntryScheduleNum;
	for(i3=0;i3<CursorNum;i3++){
		dwDataEntrySchedule[DataEntryScheduleNum]=i2;
		DataEntryScheduleNum++;
		memset(buffer+i2,0,sizeof(IMAGE_RESOURCE_DATA_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DATA_ENTRY);
	}

	//RT_BITMAP
	BitmapEntryBase=DataEntryScheduleNum;
	for(i3=0;i3<static_cast<int>(compiler.resourceManager.bitmapResources.size());i3++){
		dwDataEntrySchedule[DataEntryScheduleNum]=i2;
		DataEntryScheduleNum++;
		memset(buffer+i2,0,sizeof(IMAGE_RESOURCE_DATA_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DATA_ENTRY);
	}

	//RT_ICON
	IconEntryBase=DataEntryScheduleNum;
	for(i3=0;i3<IconNum;i3++){
		dwDataEntrySchedule[DataEntryScheduleNum]=i2;
		DataEntryScheduleNum++;
		memset(buffer+i2,0,sizeof(IMAGE_RESOURCE_DATA_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DATA_ENTRY);
	}

	//RT_GROUP_CURSOR
	CursorGroupEntryBase=DataEntryScheduleNum;
	for(i3=0;i3<static_cast<int>(compiler.resourceManager.cursorResources.size());i3++){
		dwDataEntrySchedule[DataEntryScheduleNum]=i2;
		DataEntryScheduleNum++;
		memset(buffer+i2,0,sizeof(IMAGE_RESOURCE_DATA_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DATA_ENTRY);
	}

	//RT_GROUP_ICON
	IconGroupEntryBase=DataEntryScheduleNum;
	for(i3=0;i3<static_cast<int>(compiler.resourceManager.iconResources.size());i3++){
		dwDataEntrySchedule[DataEntryScheduleNum]=i2;
		DataEntryScheduleNum++;
		memset(buffer+i2,0,sizeof(IMAGE_RESOURCE_DATA_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DATA_ENTRY);
	}

	//RT_MANIFEST
	int XPManiEntryBase;
	XPManiEntryBase=DataEntryScheduleNum;
	i3 = 0;
	{
		dwDataEntrySchedule[DataEntryScheduleNum]=i2;
		DataEntryScheduleNum++;
		memset(buffer+i2,0,sizeof(IMAGE_RESOURCE_DATA_ENTRY));
		i2+=sizeof(IMAGE_RESOURCE_DATA_ENTRY);
	}

	i4=i2%8;
	if(i4){
		memset(buffer+i2,0,8-i4);
		i2+=8-i4;
	}

	while(i2+8192>BufSize){
		BufSize+=8192;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
	}


	///////////////////////////////////////
	// oCi f[^
	// f[^Gg̓eύX
	///////////////////////////////////////

	IMAGE_RESOURCE_DATA_ENTRY *pImgDataEntry;

	i7=0;

	//J[\\[X
	for(i3=0,i6=0;i3<static_cast<int>(compiler.resourceManager.cursorResources.size());i3++){
		hFile=CreateFile(compiler.resourceManager.cursorResources[i3].filepath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(23,compiler.resourceManager.cursorResources[i3].filepath.c_str(),-1);
			return buffer;
		}
		i4=GetFileSize(hFile,NULL);
		temporary=(char *)HeapAlloc(hHeap,0,i4);
		ReadFile(hFile,temporary,i4,(DWORD *)&i5,NULL);
		CloseHandle(hFile);

		pCursorDir=(CURSORDIR *)temporary;

		for(i5=0;i5<pCursorDir->idCount;i5++,i6++){
			pCursorDirEntry=(CURSORDIRENTRY *)(temporary+sizeof(CURSORDIR)+sizeof(CURSORDIRENTRY)*i5);

			//f[^Gg
			pImgDataEntry=(IMAGE_RESOURCE_DATA_ENTRY *)(buffer+dwDataEntrySchedule[CursorEntryBase+i6]);
			pImgDataEntry->OffsetToData=i2;
			pImgDataEntry->Size=pCursorDirEntry->dwBytesInRes+sizeof(WORD)*2;
			AddRSrcAddrSchedule(dwDataEntrySchedule[CursorEntryBase+i6]);

			//RT_CURSOR oCi f[^
			*(WORD *)(buffer+i2)=0x001F;
			i2+=sizeof(WORD);
			*(WORD *)(buffer+i2)=0x001F;
			i2+=sizeof(WORD);
			memcpy(buffer+i2,temporary+pCursorDirEntry->dwImageOffset,pCursorDirEntry->dwBytesInRes);
			i2+=pCursorDirEntry->dwBytesInRes;

			i4=i2%8;
			if(i4){
				memset(buffer+i2,0,8-i4);
				i2+=8-i4;
			}

			while(i2+8192>BufSize){
				BufSize+=8192;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
			}
		}

		//f[^Gg
		pImgDataEntry=(IMAGE_RESOURCE_DATA_ENTRY *)(buffer+dwDataEntrySchedule[CursorGroupEntryBase+i3]);
		pImgDataEntry->OffsetToData=i2;
		pImgDataEntry->Size=sizeof(CURSORDIR)+0xE*pCursorDir->idCount;
		AddRSrcAddrSchedule(dwDataEntrySchedule[CursorGroupEntryBase+i3]);

		//RT_GROUP_CURSORwb_f[^iCURSORDIRj
		memcpy(buffer+i2,temporary,sizeof(CURSORDIR));
		i2+=sizeof(CURSORDIR);

		for(i5=0;i5<pCursorDir->idCount;i5++,i7++){
			pCursorDirEntry=(CURSORDIRENTRY *)(temporary+sizeof(CURSORDIR)+sizeof(CURSORDIRENTRY)*i5);
			CursorDirEntry_Res.wWidth=pCursorDirEntry->bWidth;
			CursorDirEntry_Res.wHeight=CursorDirEntry_Res.wWidth*2;
			CursorDirEntry_Res.wXHotspot=pCursorDirEntry->wXHotspot;
			CursorDirEntry_Res.wYHotspot=pCursorDirEntry->wYHotspot;
			CursorDirEntry_Res.dwBytesInRes=pCursorDirEntry->dwBytesInRes+sizeof(WORD)*2;
			CursorDirEntry_Res.wCursorNum=i7+1;

			//RT_GROUP_CURSORwb_f[^iCURSORDIRENTRY_RESj
			memcpy(buffer+i2,&CursorDirEntry_Res,0xE);
			i2+=0xE;

			while(i2+8192>BufSize){
				BufSize+=8192;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
			}
		}
		i4=i2%8;
		if(i4){
			memset(buffer+i2,0,8-i4);
			i2+=8-i4;
		}

		HeapDefaultFree(temporary);
	}

	//rbg}bv\[X
	for(i3=0;i3<static_cast<int>(compiler.resourceManager.bitmapResources.size());i3++){
		hFile=CreateFile(compiler.resourceManager.bitmapResources[i3].filepath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(23,compiler.resourceManager.bitmapResources[i3].filepath.c_str(),-1);
			return buffer;
		}
		i4=GetFileSize(hFile,NULL);
		temporary=(char *)HeapAlloc(hHeap,0,i4);
		ReadFile(hFile,temporary,i4,(DWORD *)&i5,NULL);
		CloseHandle(hFile);

		BufSize+=i4;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);

		//f[^Gg
		pImgDataEntry=(IMAGE_RESOURCE_DATA_ENTRY *)(buffer+dwDataEntrySchedule[BitmapEntryBase+i3]);
		pImgDataEntry->OffsetToData=i2;
		pImgDataEntry->Size=i4-sizeof(BITMAPFILEHEADER);
		AddRSrcAddrSchedule(dwDataEntrySchedule[BitmapEntryBase+i3]);

		//RT_BITMAP oCi f[^
		memcpy(buffer+i2,temporary+sizeof(BITMAPFILEHEADER),i4-sizeof(BITMAPFILEHEADER));
		i2+=i4-sizeof(BITMAPFILEHEADER);

		HeapDefaultFree(temporary);
	}

	//ACR\[X
	for(i3=0,i6=0;i3<static_cast<int>(compiler.resourceManager.iconResources.size());i3++){
		hFile=CreateFile(compiler.resourceManager.iconResources[i3].filepath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(23,compiler.resourceManager.iconResources[i3].filepath.c_str(),-1);
			return buffer;
		}
		i4=GetFileSize(hFile,NULL);
		temporary=(char *)HeapAlloc(hHeap,0,i4);
		ReadFile(hFile,temporary,i4,(DWORD *)&i5,NULL);
		CloseHandle(hFile);

		pIconDir=(ICONDIR *)temporary;

		for(i5=0;i5<pIconDir->idCount;i5++,i6++){
			pIconDirEntry=(ICONDIRENTRY *)(temporary+sizeof(ICONDIR)+sizeof(ICONDIRENTRY)*i5);

			//f[^Gg
			pImgDataEntry=(IMAGE_RESOURCE_DATA_ENTRY *)(buffer+dwDataEntrySchedule[IconEntryBase+i6]);
			pImgDataEntry->OffsetToData=i2;
			pImgDataEntry->Size=pIconDirEntry->dwBytesInRes;
			AddRSrcAddrSchedule(dwDataEntrySchedule[IconEntryBase+i6]);

			//RT_ICON oCi f[^
			memcpy(buffer+i2,temporary+pIconDirEntry->dwImageOffset,pIconDirEntry->dwBytesInRes);
			i2+=pIconDirEntry->dwBytesInRes;

			i4=i2%8;
			if(i4){
				memset(buffer+i2,0,8-i4);
				i2+=8-i4;
			}

			while(i2+8192>BufSize){
				BufSize+=8192;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
			}
		}

		//f[^Gg
		pImgDataEntry=(IMAGE_RESOURCE_DATA_ENTRY *)(buffer+dwDataEntrySchedule[IconGroupEntryBase+i3]);
		pImgDataEntry->OffsetToData=i2;
		pImgDataEntry->Size=sizeof(ICONDIR)+0xE*pIconDir->idCount;
		AddRSrcAddrSchedule(dwDataEntrySchedule[IconGroupEntryBase+i3]);

		//RT_GROUP_ICONwb_f[^iICONDIRj
		memcpy(buffer+i2,temporary,sizeof(ICONDIR));
		i2+=sizeof(ICONDIR);

		for(i5=0;i5<pIconDir->idCount;i5++,i7++){
			pIconDirEntry=(ICONDIRENTRY *)(temporary+sizeof(ICONDIR)+sizeof(ICONDIRENTRY)*i5);
			IconDirEntry_Res.bWidth=pIconDirEntry->bWidth;
			IconDirEntry_Res.bHeight=pIconDirEntry->bHeight;
			IconDirEntry_Res.bColorCount=pIconDirEntry->bColorCount;
			IconDirEntry_Res.bReserved=0;
			IconDirEntry_Res.wPlanes=1;
			if(pIconDirEntry->bColorCount==16)
				IconDirEntry_Res.wBitCount=4;
			else if(pIconDirEntry->bColorCount==0)
				IconDirEntry_Res.wBitCount=8;
			IconDirEntry_Res.dwBytesInRes=pIconDirEntry->dwBytesInRes;
			IconDirEntry_Res.wIconNum=i7+1;

			//RT_GROUP_ICONwb_f[^iICONDIRENTRY_RESj
			memcpy(buffer+i2,&IconDirEntry_Res,0xE);
			i2+=0xE;

			while(i2+8192>BufSize){
				BufSize+=8192;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
			}
		}
		i4=i2%8;
		if(i4){
			memset(buffer+i2,0,8-i4);
			i2+=8-i4;
		}

		HeapDefaultFree(temporary);
	}

	//XPManifest\[X
	i3 = 0;
	if( !compiler.resourceManager.manifestFilePath.empty() )
	{
		hFile=CreateFile(compiler.resourceManager.manifestFilePath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			compiler.errorMessenger.Output(59,compiler.resourceManager.manifestFilePath.c_str(),-1);
			return buffer;
		}
		i4=GetFileSize(hFile,NULL);
		temporary=(char *)HeapAlloc(hHeap,0,i4+1);
		ReadFile(hFile,temporary,i4,(DWORD *)&i5,NULL);
		temporary[i4]=0;
		CloseHandle(hFile);

		//vbgtH[Zbg
#ifdef _AMD64_
		temporary=PermutationString(temporary,"#PLATFORM#","amd64");
#else
		temporary=PermutationString(temporary,"#PLATFORM#","x86");
#endif

		//AvP[VZbg
		char szAppliName[MAX_PATH];
		char temp2[MAX_PATH];
		_splitpath( program.GetOutputFilePath().c_str(),NULL,NULL,szAppliName,temp2);
		lstrcat(szAppliName,temp2);
		temporary=PermutationString(temporary,"#APPLI_FILE_NAME#",szAppliName);

		i4=lstrlen(temporary)+1;

		BufSize+=i4;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);

		//f[^Gg
		pImgDataEntry=(IMAGE_RESOURCE_DATA_ENTRY *)(buffer+dwDataEntrySchedule[XPManiEntryBase+i3]);
		pImgDataEntry->OffsetToData=i2;
		pImgDataEntry->Size=i4-1;	//NULL̓TCYɊ܂߂Ȃ
		AddRSrcAddrSchedule(dwDataEntrySchedule[XPManiEntryBase+i3]);

		//XMLf[^
		memcpy(buffer+i2,temporary,i4);
		i2+=i4;

		HeapDefaultFree(temporary);
	}

	*pLen=i2;

	return buffer;
}
