#include "common.h"
#include OPCODE_H_PATH	//opcode.h


//VOgIuWFNg
CDBConst CDBConst::obj;


CConstBase::CConstBase(char *Name){
	this->Name = (char *)malloc(lstrlen(Name)+1);
	lstrcpy(this->Name, Name);
}
CConstBase::~CConstBase(){
	free(Name);
	Name=0;
}

char *CConstBase::GetName(){
	return Name;
}



CConst::CConst(char *Name, int Type, _int64 i64data):CConstBase(Name)
{
	this->Type = Type;
	this->i64data = i64data;

	//AXg
	pNext = 0;
}
CConst::CConst(char *Name, int value):CConstBase(Name)
{
	Type = DEF_LONG;
	i64data = value;

	//AXg
	pNext = 0;
}
CConst::~CConst(){
	//ÃIuWFNgj
	if(pNext){
		delete pNext;
		pNext = 0;
	}
}

int CConst::GetType(){
	return Type;
}
_int64 CConst::GetWholeData(){
	return i64data;
}
double CConst::GetDoubleData(){
	double dbl;
	memcpy(&dbl,&i64data,sizeof(_int64));
	return dbl;
}



CConstMacro::CConstMacro(char *Name, char *Expression):CConstBase(Name)
{
}
CConstMacro::~CConstMacro(){
}





CDBConst::CDBConst(){
	memset(this,0,sizeof(CDBConst));

	ppHash = (CConst **)calloc(MAX_HASH*sizeof(CConst *),1);
	Init();
}
CDBConst::~CDBConst(){
	Free();

	free(ppHash);
}

//
void CDBConst::Free(){
	int i;
	for(i=0; i<MAX_HASH; i++){
		if(ppHash[i]){
			delete ppHash[i];
			ppHash[i] = 0;
		}
	}
}

//
void CDBConst::Init(){
	Free();
}

void AddConstData(char *Command);
void CDBConst::Add(char *buffer){
	int i;

	//O擾
	char Name[VN_SIZE];
	for(i=0;;i++){
		if(buffer[i]=='\0'){
			SetError(10,"Const",cp);
			return;
		}
		if(buffer[i]=='='||buffer[i]=='('){
			Name[i]=0;
			break;
		}
		Name[i]=buffer[i];
	}

	//d`FbN
	if(GetType(Name)){
		SetError(15,Name,cp);
		return;
	}

	if(buffer[i] == '('){
		//萔}N

		//
		AddConstData(buffer);
	}
	else{
		//ʂ̒萔
		char *Expression = buffer + i + 1;

		AddConst(Name,Expression);
	}
}

void CDBConst::AddConst(char *Name, CConst *newconst){
	int key = hash_default(Name);

	//nbVXgɒǉ
	if(ppHash[key]){
		CConst *pConst = ppHash[key];
		while(pConst->pNext){
			pConst = pConst->pNext;
		}

		pConst->pNext = newconst;
	}
	else{
		ppHash[key] = newconst;
	}
}
void CDBConst::AddConst(char *Name, char *Expression){
	_int64 i64data;
	Type resultType;
	if( !StaticCalculation(false, Expression, 0, &i64data, resultType) ){
		//ϐ̏ꍇ
		//Ȃis̈RpCdim錾ƂĈj
		return;
	}

	//el̏ꍇ
	//o^s

	CConst *newconst = new CConst(Name, resultType.GetBasicType(), i64data);

	AddConst(Name, newconst);
}
void CDBConst::AddConst(char *Name, int value){
	CConst *newconst = new CConst(Name, value);

	AddConst(Name, newconst);
}

CConst *CDBConst::GetObjectPtr(char *Name){
	//nbVl擾
	int key;
	key=hash_default(Name);

	//i[ʒu擾
	CConst *pConst;
	pConst=ppHash[key];
	while(pConst){
		if(lstrcmp(pConst->GetName(),Name)==0) break;

		pConst=pConst->pNext;
	}

	return pConst;
}


int CDBConst::GetType(char *Name){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return 0;

	return pConst->GetType();
}
_int64 CDBConst::GetWholeData(char *Name){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return 0;

	return pConst->GetWholeData();
}
double CDBConst::GetDoubleData(char *Name){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return 0;

	return pConst->GetDoubleData();
}
