#include "common.h"


int MakeWholeType(int size,int bSigned){
	switch(size){
		case 1:
			if(bSigned) return DEF_SBYTE;
			else return DEF_BYTE;
			break;
		case 2:
			if(bSigned) return DEF_INTEGER;
			else return DEF_WORD;
			break;
		case 4:
			if(bSigned) return DEF_LONG;
			else return DEF_DWORD;
			break;
		case 8:
			if(bSigned) return DEF_INT64;
			else return DEF_QWORD;
			break;
	}
	return 0;
}

int AutoBigCast(int BaseType,int CalcType){
	int type;
	type=CalcType;

	if(BaseType==0||BaseType==-1){
		//x[X^Cv̂Ƃ
		return type;
	}

	if(!IsWholeNumberType(type)){
		//^ł͂ȂƂ͈Öق̕ϊ͕KvȂ
		return type;
	}

	if(BaseType==DEF_OBJECT||BaseType==DEF_STRUCT){
		//x[X^CvIuWFNĝƂ͈Öق̕ϊ͕KvȂ
		return type;
	}

	int BaseTypeSize;
	BaseTypeSize=GetTypeSize(BaseType,-1);

	if(IsRealNumberType(BaseType)){
		if(GetTypeSize(CalcType,-1)<4)
			type=MakeWholeType(4,IsSignedType(CalcType));
	}
	else if(BaseTypeSize>GetTypeSize(CalcType,-1)){
		//v^̂قTCY傫Ƃ
		type=MakeWholeType(BaseTypeSize,IsSignedType(CalcType));
	}

	if(!type){
		extern int cp;
		SetError(300,NULL,cp);
	}

	return type;
}

BOOL CheckCalcType(int idCalc,int *type,int sp){
	//Zq̉EӁAӂ̌^`FbN
	extern int cp;

	//Zq擾
	char temporary[255];
	GetCalcName(idCalc,temporary);

	switch(idCalc){

		/////////////////////////////////////
		// ɑ΂_Z̓G[
		/////////////////////////////////////

		case CALC_XOR:
		case CALC_OR:
		case CALC_AND:
			if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
				//ꂩ̍̂Ƃ
				SetError(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_NOT:
			if(IsRealNumberType(type[sp-1])){
				//̂Ƃ
				SetError(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if(type[sp-1]&FLAG_CAST){
				SetError(48,temporary,cp);
				return 0;
			}
			break;



		/////////////////////////////////////
		// rZ̓`FbNڂȂ
		/////////////////////////////////////

		case CALC_PE:
		case CALC_QE:
		case CALC_NOTEQUAL:
		case CALC_EQUAL:
		case CALC_P:
		case CALC_Q:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;



		/////////////////////////////////////
		// ZpZ`FbN
		/////////////////////////////////////

		case CALC_ADDITION:
		case CALC_SUBTRACTION:
		case CALC_PRODUCT:
		case CALC_QUOTIENT:
		case CALC_POWER:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_SHL:
		case CALC_SHR:
		case CALC_MOD:
		case CALC_INTQUOTIENT:
			if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
				//ꂩ̍̂Ƃ
				SetError(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_AS:
			if((type[sp-1]&FLAG_CAST)==0){
				//^w肳ĂȂƂ̓G[
				SetError(47,NULL,cp);
				return 0;
			}
			break;

		case CALC_BYVAL:
			if(type[sp-1]&FLAG_CAST){
				//^w肳ĂȂƂ̓G[
				SetError(47,NULL,cp);
				return 0;
			}
			break;

		case CALC_MINUSMARK:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if(type[sp-1]&FLAG_CAST){
				SetError(48,temporary,cp);
				return 0;
			}
			break;
	}
	return 1;
}

int GetReturnType_OperatorProc(int idCalc,const Type &baseType,int *type,LONG_PTR *index_stack,int &sp){
	//I[o[[hꂽIy[^֐̖߂l擾
	CClass *pobj_c;
	pobj_c=(CClass *)index_stack[sp-2];

	std::vector<UserProc *> subs;
	pobj_c->EnumMethod( idCalc, subs );
	if( subs.size() == 0 ){
		return 0;
	}


	//̐
	BOOL bTwoTerm=1;
	if(idCalc==CALC_AS) bTwoTerm=0;



	/////////////////////////////////////////////
	// I[o[[hp̃p[^ݒ
	/////////////////////////////////////////////


	//_System_LocalThis
	Parameters params;

	if(bTwoTerm){
		params.push_back( new Parameter( "", Type( type[sp-1], index_stack[sp-1] ) ) );
	}


	//I[o[[h
	char temporary[255];
	if(idCalc==CALC_EQUAL) lstrcpy(temporary,"==");
	else GetCalcName(idCalc,temporary);
	UserProc *pUserProc = OverloadSolution( temporary, subs, params, baseType );

	if(bTwoTerm){
		delete params[0];
	}

	if(!pUserProc){
		return 0;
	}
	else{
		//I[o[[hĂȂAp[^vȂƂ
		if(params.size()!=pUserProc->Params().size()){
			return 0;
		}
	}

	sp--;
	type[sp-1]=pUserProc->ReturnType().GetBasicType();
	index_stack[sp-1]=pUserProc->ReturnType().GetIndex();

	return 1;
}

bool Operator_New_GetType(const char *Parameter,const Type &baseType, Type &resultType ){
	char TypeName[VN_SIZE],CreateParameter[VN_SIZE],objectSizeStr[VN_SIZE];
	int i,i2;

	i=0;

	if(Parameter[0]=='['){
		i=GetStringInBracket(objectSizeStr,Parameter);

		SlideString(objectSizeStr+1,-1);
		objectSizeStr[i-2]=0;
	}
	else objectSizeStr[0]=0;

	for(i2=0;;i++,i2++){
		if(Parameter[i]=='('){
			TypeName[i2]=0;

			//RXgN^ɓnp[^擾
			i2=GetStringInPare(CreateParameter,Parameter+i);
			RemoveStringPare(CreateParameter);
			i+=i2;
			if(Parameter[i]!='\0'){
				SetError(42,NULL,cp);
				return false;
			}
			break;
		}
		TypeName[i2]=Parameter[i];
		if(Parameter[i]=='\0'){
			CreateParameter[0]=0;
			break;
		}
	}

	if( !Type::StringToType( TypeName, resultType ) ){
		return false;
	}

	if( baseType.IsObject() ){
		resultType.SetBasicType( DEF_OBJECT );
	}
	else{
		resultType.SetBasicType( DEF_PTR_OBJECT );
	}
	return true;
}

bool NumOpe_GetType( const char *expression, const Type &baseType, Type &resultType ){
	extern int cp;
	int i,i2,i3,i4;
	char temporary[1024],temp2[1024],temp3[1024];

	if(expression[0]=='\0'){
		SetError(1,NULL,cp);
		return false;
	}

	if(expression[0]==1&& expression[1]==ESC_NEW ){
		//NewZqiIuWFNgj
		return Operator_New_GetType(expression+2,baseType, resultType );
	}


	/////////////////////////////////
	// vft|[hŎ擾
	/////////////////////////////////

	char *values[255];
	long calc[255];
	long stack[255];
	int pnum;
	if(!GetNumOpeElements(expression,&pnum,values,calc,stack)){
		for(i=0;i<pnum;i++){
			if(values[i]) HeapDefaultFree(values[i]);
		}
		return false;
	}



	////////////////////////////////
	// Z̃R[hJn
	////////////////////////////////

	BOOL bError;
	bError=0;

	//el݂̂̌vZǂ𔻕ʂ邽߂̃tO
	BOOL bLiteralCalculation=1;

	int sp;
	int type_stack[255];
	LONG_PTR index_stack[255];
	_int64 i64data;
	int idCalc;
	for(i=0,sp=0;i<pnum;i++){
		idCalc=calc[i]%100;

		if(idCalc){
			if(type_stack[sp-2]==DEF_OBJECT){
				//I[o[[hꂽIy[^Ăяo
				if(!GetReturnType_OperatorProc(idCalc,baseType,type_stack,index_stack,sp)){
					goto error;
				}

				continue;
			}

			if(!CheckCalcType(idCalc,type_stack,sp)) goto error;
		}

		switch(idCalc){
			//l
			case 0:
				index_stack[sp]=-1;

				char *term;
				term = values[i];

				if(term[0]=='\"'){
StrLiteral:

					if( baseType.IsStringObject() ){
						//v^CvIuWFNgłAString̎󂯓ꂪ\ȏꍇ
						extern CClass *pobj_StringClass;
						type_stack[sp]=DEF_OBJECT;
						index_stack[sp]=(LONG_PTR)pobj_StringClass;
						bLiteralCalculation=0;

						sp++;
						break;
					}

					type_stack[sp]=typeOfPtrChar;
					bLiteralCalculation=0;
				}
				else if((term[0]=='e'||term[0]=='E')&&
					(term[1]=='x'||term[1]=='X')&&
					term[2]=='\"'){
					//gŃeiGXP[vV[PX\j
					goto StrLiteral;
				}
				else if(IsVariableTopChar(term[0])||
					term[0]=='*'||
					(term[0]=='.'&&IsVariableTopChar(term[1]))){
					//////////////////
					// 炩̎ʎq

					//////////////////////////////////////
					// ֐iDLLA[U[`Agݍ݁j
					//////////////////////////////////////

					i2=GetCallProcName(term,temporary);
					if(term[i2]=='('){
						i4=GetStringInPare_RemovePare(temp2,term+i2+1);

						int idProc;
						void *pProc;
						idProc=GetProc(temporary,(void **)&pProc);

						if(idProc){
							//JbR")"ɑNULLłȂƂ
							if(term[i2+1+i4+1]!='\0'){
								if( term[i2+1+i4+1] == '.'
									|| term[i2+1+i4+1] == 1 && term[i2+1+i4+2] == ESC_PSMEM ){
										goto NonProc;
								}
								else{
									SetError(42,NULL,cp);
								}
							}


							////////////////
							// Ăяo
							////////////////

							Type resultType;
							if( !CallProc(idProc,pProc,temporary,temp2, resultType, false ) ){
								goto error;
							}
							if( resultType.IsNull() ){
								//߂l݂ȂƂ
								goto error;
							}

							type_stack[sp] = resultType.GetBasicType();
							index_stack[sp] = resultType.GetIndex();

							bLiteralCalculation=0;

							sp++;
							break;
						}
						else if(GetConstCalcBuffer(temporary,temp2,temp3)){
							/////////////////////////
							// }N֐
							/////////////////////////

							//JbR")"ɑNULLłȂƂ̓G[ɂ
							if(term[i2+1+i4+1]!='\0') SetError(42,NULL,cp);

							//}N֐̏ꍇ
							Type tempType;
							NumOpe_GetType(temp3,Type(),tempType);

							if(!IS_LITERAL(tempType.GetIndex())){
								//elł͂ȂƂ
								bLiteralCalculation=0;
							}

							type_stack[sp] = tempType.GetBasicType();
							index_stack[sp] = tempType.GetIndex(); 

							sp++;
							break;
						}
					}
NonProc:

					//CfNTigetANZTj
					char VarName[VN_SIZE],ArrayElements[VN_SIZE];
					GetArrayElement(term,VarName,ArrayElements);
					if(ArrayElements[0]){
						Type type;
						GetVarType(VarName,type,false);
						if( type.IsObject() ){
							if( !GetReturnTypeOfIndexerGetterProc( type.GetClass(),type) ){
								SetError(1,NULL,cp);
								goto error;
							}
							type_stack[sp]=type.GetBasicType();
							index_stack[sp]=type.GetIndex();
							bLiteralCalculation=0;

							sp++;
							break;
						}
					}


					// Nothing
					if( lstrcmp( term, "Nothing" ) == 0 ){
						type_stack[sp] = DEF_OBJECT;
						if( baseType.IsObject() ){
							index_stack[sp] = baseType.GetIndex();
						}
						else{
							index_stack[sp] = (LONG_PTR)pobj_DBClass->GetObjectClass();
						}
						bLiteralCalculation = 0;
						sp++;
						break;
					}


					Type varType;
					if( GetVarType(term,varType,0) ){
						//////////
						// ϐ
						//////////

						if( varType.GetBasicType() & FLAG_PTR ){
							//z|C^
							type_stack[sp]=GetPtrType( varType.GetBasicType()^FLAG_PTR );
						}
						else{
							type_stack[sp]=varType.GetBasicType();
						}
						index_stack[sp] = varType.GetIndex();

						bLiteralCalculation=0;
						sp++;
						break;
					}


					//////////////
					// 萔̏ꍇ
					//////////////

					i3 = CDBConst::obj.GetType(term);
					if(i3){
						type_stack[sp]=i3;
						if(IsRealNumberType(i3)){
							//
							goto Literal;
						}
						else if(IsWholeNumberType(i3)){
							//
							goto Literal;
						}
						else if(Is64Type(i3)){
							//64rbgl
							goto Literal;
						}
						else if(i3==DEF_STRING){
							//e
							goto StrLiteral;
						}
						else{
							SetError(1,NULL,0);
							goto error;
						}
					}


					//////////////
					// ^̏ꍇ
					//////////////

					LONG_PTR lp;
					i3=GetTypeFixed(term,&lp);
					if(i3!=-1){
						type_stack[sp]=i3|FLAG_CAST;
						index_stack[sp]=lp;
						sp++;
						break;
					}



					/////////////////////////////////
					// vpeBp̃\bh
					/////////////////////////////////

					//zvfr
					GetArrayElement(term,VarName,ArrayElements);

					if(GetSubHash(VarName,0)){
						Type tempType;
						GetReturnTypeOfPropertyMethod(term,NULL,tempType);

						//傫Ȍ^ւ̈Öق̕ϊ
						type_stack[sp]=tempType.GetBasicType();

						index_stack[sp]=tempType.GetIndex();
						bLiteralCalculation=0;

						sp++;
						break;
					}



					//Y鎯ʎqȂƂ̓G[ɂ
					bError=1;
					SetError(3,term,cp);
					type_stack[sp]=DEF_DOUBLE;
				}
				else{
					//el
					int base_type = 0;
					if( !baseType.IsNull() ) base_type = baseType.GetBasicType();
					type_stack[sp]=GetLiteralValue(term,&i64data,base_type);
Literal:
					if((long)i64data==0&&index_stack[sp]==-1) index_stack[sp]=LITERAL_NULL;
				}

				sp++;
				break;

			//_Zq
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_NOT:
				//values[sp-1]=Not values[sp-1]
				//NOTZq
				break;

			//rZq
			case CALC_PE:		//values[sp-2] <= values[sp-1]
			case CALC_QE:		//values[sp-2] >= values[sp-1]
			case CALC_P:		//values[sp-2] <  values[sp-1]
			case CALC_Q:		//values[sp-2] >  values[sp-1]
			case CALC_NOTEQUAL:	//values[sp-2] <> values[sp-1]
			case CALC_EQUAL:	//values[sp-2] =  values[sp-1]	
				sp--;
				type_stack[sp-1]=DEF_LONG;
				break;

			//rbgVtg
			case CALC_SHL:	//values[sp-2] << values[sp-1]
			case CALC_SHR:	//values[sp-2] >> values[sp-1]
				sp--;
				break;

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_MOD:
				//values[sp-2]%=values[sp-1]
				//]Z
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_QUOTIENT:
				//values[sp-2]/=values[sp-1];
				//Z
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_INTQUOTIENT:
				//values[sp-2]/=values[sp-1]
				//Z
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_MINUSMARK:
				//values[sp-1]=-values[sp-1]
				//]
				break;
			case CALC_POWER:
				//ׂ扉Zi_Ẑ݁j
				sp--;
				//
				break;
			case CALC_AS:
				//LXg
				type_stack[sp-2]=type_stack[sp-1]&(~FLAG_CAST);
				index_stack[sp-2]=index_stack[sp-1];

				sp--;
				break;

			case CALC_BYVAL:
				//|C^^Qƌ^
				if( PTR_LEVEL( type_stack[sp-1] ) <= 0 ){
					//|C^^ł͂ȂƂ
					SetError( 3, NULL, cp );
					goto error;
				}

				type_stack[sp-1] = PTR_LEVEL_DOWN( type_stack[sp-1] );
				break;
		}
	}

	if(bError) goto error;

	if(sp!=1){
		SetError(1,NULL,cp);
		goto error;
	}

	if(bLiteralCalculation){
		//EӒll̒萔̏ꍇ
		int base_type = 0;
		if( !baseType.IsNull() ) base_type = baseType.GetBasicType();
		Type tempType;
		StaticCalculation(true, expression,base_type,&i64data,tempType);

		type_stack[0]=tempType.GetBasicType();
		index_stack[0]=tempType.GetIndex();
	}
	else{
		//EӒll̒萔ł͂ȂƂ
		if(IS_LITERAL(index_stack[0])) index_stack[0]=-1;
	}

	resultType.SetType( type_stack[0], index_stack[0] );

	bool isSuccessful = true;
	goto finish;


	//////////////////
	// G[
	//////////////////

error:
	isSuccessful = false;
	goto finish;


finish:
	for(i=0;i<pnum;i++){
		if(values[i]) HeapDefaultFree(values[i]);
	}
	return isSuccessful;
}
