#include "stdafx.h"
#include <algorithm>
#include <boost/checked_delete.hpp>

CClass::CClass( const Symbol &symbol, const NamespaceScopesCollection &importedNamespaces )
	: ClassPrototype( symbol )
	, importedNamespaces( importedNamespaces )
	, classType( Class )
	, pSuperClass( NULL )
	, blittableType( Type() )
	, isReady( false )
	, fixedAlignment( 0 )
	, ConstructorMemberSubIndex( -1 )
	, DestructorMemberSubIndex( -1 )
	, vtblNum( 0 )
	, vtbl_offset( -1 )
	, comVtblOffset( 0 )
	, isCompilingConstructor( false )
	, isCompilingDestructor( false )
	, cacheSize( 0 )
{
}

CClass::CClass(
	const Symbol &symbol,
	const NamespaceScopesCollection &importedNamespaces,
	ClassType classType,
	const GenericTypes &formalGenericTypes,
	const Types &superClassActualTypeParameters,
	int ConstructorMemberSubIndex,
	int DestructorMemberSubIndex,
	int vtblNum,
	int fixedAlignment,
	const Types &expandedClassActualTypeParameters )
	: ClassPrototype( symbol )
	, importedNamespaces( importedNamespaces )
	, classType( classType )
	, formalGenericTypes( formalGenericTypes )
	, pSuperClass( NULL )
	, superClassActualTypeParameters( superClassActualTypeParameters )
	, blittableType( Type() )
	, isReady( false )
	, ConstructorMemberSubIndex( ConstructorMemberSubIndex )
	, DestructorMemberSubIndex( DestructorMemberSubIndex )
	, vtblNum( vtblNum )
	, fixedAlignment( fixedAlignment )
	, expandedClassActualTypeParameters( expandedClassActualTypeParameters )
	, vtbl_offset( -1 )
	, comVtblOffset( 0 )
	, isCompilingConstructor( false )
	, isCompilingDestructor( false )
	, cacheSize( 0 )
{
}

CClass::CClass()
	: ClassPrototype()
	, importedNamespaces()
	, classType()
	, pSuperClass( NULL )
	, blittableType( Type() )
	, isReady( false )
	, fixedAlignment( 0 )
	, ConstructorMemberSubIndex( -1 )
	, DestructorMemberSubIndex( -1 )
	, vtblNum( 0 )
	, vtbl_offset( -1 )
	, comVtblOffset( 0 )
	, isCompilingConstructor( false )
	, isCompilingDestructor( false )
	, cacheSize( 0 )
{
}

CClass::~CClass()
{
	using std::for_each;
	using boost::checked_deleter;
	// Io
	for_each( dynamicMembers.begin(), dynamicMembers.end(), checked_deleter<Member>() );
	// ÓIo
	for_each( staticMembers.begin(), staticMembers.end(), checked_deleter<Member>() );
	// C^[tFCX
	for_each( interfaces.begin(), interfaces.end(), checked_deleter<::Interface>() );
	// ev[gWJς݂̃NX
	for_each( expandedTemplateClasses.begin(), expandedTemplateClasses.end(), checked_deleter<ExpandedTemplateClass>() );
}

void CClass::Using() const
{
	if( this->IsUsing() )
	{
		// Ɏgp邱ƂɂȂĂ
		return;
	}

	Prototype::Using();

	// z֐ɂȂ郁\bhɎgp`FbN
	const CClass &_class = *this;
	BOOST_FOREACH( const CMethod *pMethod, _class.GetDynamicMethods() )
	{
		if( pMethod->IsVirtual() )
		{
			pMethod->GetUserProc().Using();
		}
	}

	// C^[tFCX\bhɎgp`FbN
	BOOST_FOREACH( const ::Interface *pInterface, _class.GetInterfaces() )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() )
		{
			pMethod->GetUserProc().Using();
		}
	}
}
bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsComInterface() const
{
	return classType == CClass::ComInterface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}


// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pSubClass ) const
{
	if( !pSubClass->HasSuperClass() )
	{
		return false;
	}

	const CClass *pTempClass = &pSubClass->GetSuperClass();
	while( pTempClass ){
		if( this == pTempClass ) return true;
		pTempClass = &pTempClass->GetSuperClass();
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pSubClass ) const
{
	if( IsEquals( pSubClass ) ) return true;
	return IsSubClass( pSubClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const ::Interface *pInterface, interfaces ){
		if( pInterfaceClass == &pInterface->GetClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine )
{
	//\bhRs[
	const Methods& inheritsClassMethods = inheritsClass.GetDynamicMethods();
	GetDynamicMethods().reserve( inheritsClassMethods.size() );
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsClassMethods ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		GetDynamicMethods().push_back( pMethod );
	}

	//z֐̐
	AddVtblNum( inheritsClass.GetVtblNum() );

	//p̃NXoƂĕێ
	SetSuperClass( &inheritsClass );
	SetSuperClassActualTypeParameters( actualTypeParameters );

	// C^[tFCXp
	const Interfaces& inheritsClassInterfaces = inheritsClass.GetInterfaces();
	interfaces.reserve( inheritsClassInterfaces.size() );
	BOOST_FOREACH( const ::Interface *pInterface, inheritsClassInterfaces )
	{
		interfaces.push_back( new ::Interface( *pInterface ) );
	}

	if( this->IsInterface() && inheritsClass.IsComInterface() )
	{
		// COMC^[tFCXpꍇCOMC^[tFCXɂ
		this->SetClassType( CClass::ComInterface );
	}

	return true;
}

bool CClass::InheritsInterface( const CClass &inheritsInterfaceClass, const Types &actualTypeParameters, int nowLine )
{
	if( !( this->IsInterface() || this->IsComInterface() ) )
	{
		Jenga::Throw( "C^[tFCXɑ΂CClass::InheritsInterface\bhĂ΂ꂽ" );
	}

	// C^[tFCXp
	return this->InheritsClass( inheritsInterfaceClass, actualTypeParameters, nowLine );
}

void CClass::AddDynamicMember( Member *pMember )
{
	dynamicMembers.push_back( pMember );
}
void CClass::AddStaticMember( Member *pMember )
{
	staticMembers.push_back( pMember );
}

bool CClass::DupliCheckAll(const char *name) const
{
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if(  name == pMethod->GetUserProc().GetName() ){
			return 1;
		}
	}

	return 0;
}
bool CClass::DupliCheckMember(const char *name) const
{
	//d`FbN

	if( this->HasSuperClass() )
	{
		if( this->GetSuperClass().DupliCheckMember( name ) )
		{
			// NXŏdꂽ
			return true;
		}
	}

	// Io
	BOOST_FOREACH( const Member *pMember, dynamicMembers )
	{
		if( GetName() == pMember->GetName() )
		{
			return true;
		}
	}

	// ÓIo
	BOOST_FOREACH( Member *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return true;
		}
	}

	return false;
}

const Member *CClass::FindDynamicMember( const char *memberName ) const
{
	if( this->HasSuperClass() )
	{
		// NXŌ
		const Member *result = this->GetSuperClass().FindDynamicMember( memberName );
		if( result )
		{
			return result;
		}
	}

	BOOST_FOREACH( Member *pMember, GetDynamicMembers() )
	{
		if( pMember->GetName() == memberName )
		{
			return pMember;
		}
	}
	return NULL;
}

void CClass::EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const
{
	// I\bh
	GetDynamicMethods().Enum( methodName, subs );

	// C^[tFCX \bh
	BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
	{
		pInterface->GetDynamicMethods().Enum( methodName, subs );
	}
}
const CMethod *CClass::GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const
{
	// I\bh
	const CMethod *result = GetDynamicMethods().GetMethodPtr( pUserProc );

	if( !result )
	{
		// C^[tFCX \bh
		BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
		{
			result = pInterface->GetDynamicMethods().GetMethodPtr( pUserProc );
			if( result )
			{
				return result;
			}
		}
	}

	return result;
}

void CClass::ResolveExpandedClassActualTypeParameter( Type &type ) const
{
	if( !this->IsExpanded() )
	{
		_ASSERTE( false );
	}

	if( !type.IsTypeParameter() )
	{
		// ^p[^ł͂Ȃꍇ
		return;
	}

	type = expandedClassActualTypeParameters[type.GetFormalTypeIndex()];
}

//TCY擾
int CClass::GetSize() const
{
	int resultSize = 0;

	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			alignment = this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			const CClass& super = this->GetSuperClass();
			// NX̃TCYǉ
			resultSize += super.GetSize();

			// NX̃ACg擾
			alignment = super.GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			resultSize += IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;
		}
	}

	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		const Type& memberType = pMember->GetType();
		// oTCY
		int tempMemberSize = memberType.GetSize();

		// ꎞACgZo
		int tempAlignment = tempMemberSize;
		if( memberType.IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = memberType.GetClass().GetAlignment();
		}

		// ACglăpfBOǉ
		if( GetFixedAlignment() && alignment < tempAlignment )
		{
			if( resultSize % alignment )
			{
				resultSize += alignment - ( resultSize % alignment );
			}
		}
		else
		{
			if( alignment < tempAlignment )
			{
				// őACgXV
				alignment = tempAlignment;
			}

			if( tempMemberSize == 0 )
			{
				if( !memberType.IsStruct() )
				{
					throw;
				}

				//oȂ\
				//ȂiItZbǧvZȂj
			}
			else{
				if( resultSize % tempAlignment )
				{
					resultSize += tempAlignment - ( resultSize % tempAlignment );
				}
			}
		}

		// oTCYZizlj
		resultSize += tempMemberSize * Variable::GetSubScriptCounts( pMember->GetSubscripts() );
	}

	if( alignment )
	{
		// ACglăpfBOǉ
		if( resultSize % alignment )
		{
			resultSize += alignment - ( resultSize % alignment );
		}
	}

	return resultSize;
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName ) const
{
	int resultSize = 0;

	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			alignment = this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			if( this->GetSuperClass().HasDynamicMember( memberName ) )
			{
				// NX̃o擾
				return this->GetSuperClass().GetMemberOffset( memberName );
			}

			// NX̃TCYǉ
			resultSize += this->GetSuperClass().GetSize();

			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			resultSize += IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;
		}
	}

	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		// oTCY
		int tempMemberSize = pMember->GetType().GetSize();

		// ꎞACgZo
		int tempAlignment = tempMemberSize;
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		// ACglăpfBOǉ
		if( GetFixedAlignment() && alignment < tempAlignment )
		{
			if( resultSize % alignment )
			{
				resultSize += alignment - ( resultSize % alignment );
			}
		}
		else
		{
			if( alignment < tempAlignment )
			{
				// őACgXV
				alignment = tempAlignment;
			}

			if( tempMemberSize == 0 )
			{
				if( !pMember->GetType().IsStruct() )
				{
					throw;
				}

				//oȂ\
				//ȂiItZbǧvZȂj
			}
			else{
				if( resultSize % tempAlignment )
				{
					resultSize += tempAlignment - ( resultSize % tempAlignment );
				}
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName )
			{
				return resultSize;
			}
		}

		// oTCYZizlj
		resultSize += tempMemberSize * Variable::GetSubScriptCounts( pMember->GetSubscripts() );
	}

	if( alignment )
	{
		// ACglăpfBOǉ
		if( resultSize % alignment )
		{
			resultSize += alignment - ( resultSize % alignment );
		}
	}

	return resultSize;
}
int CClass::GetAlignment() const
{
	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			return this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			alignment = PTR_SIZE;
		}
	}

	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		int tempAlignment = pMember->GetType().GetSize();
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		if( alignment < tempAlignment )
		{
			// őACgXV
			alignment = tempAlignment;
		}
	}

	return alignment;
}

void CClass::GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const
{
	vtblMasterListIndex = 0;

	vtblIndex = 0;
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( &pMethod->GetUserProc() == pUserProc )
		{
			return;
		}

		if( pMethod->IsVirtual() )
		{
			vtblIndex++;
		}
	}

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		vtblMasterListIndex++;

		vtblIndex = 0;
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if( &pMethod->GetUserProc() == pUserProc )
			{
				return;
			}

			if( pMethod->IsVirtual() )
			{
				vtblIndex++;
			}
		}
	}

	_ASSERT( false );
	throw;
}
int CClass::GetVtblMasterListIndex( const CClass *pClass ) const
{
	int result = 0;

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		result++;
		
		if( &pInterface->GetClass() == pClass )
		{
			return result;
		}
	}

	_ASSERT( false );
	throw;
}
long CClass::GetVtblMasterListOffset() const
{
	if( vtblMasterListOffset == -1 )
	{
		_ASSERT( false );
		throw;
	}

	return vtblMasterListOffset;
}
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if(pMethod->IsVirtual()){
				if(pMethod->IsAbstract()){
					return true;
				}
			}
		}
	}

	return false;
}

const CClass *Classes::FindEx( const Symbol &symbol ) const
{
	if( symbol.GetNamespaceScopes().size() == 0 && symbol.GetName() == "Object" )
	{
		return GetObjectClassPtr();
	}
	else if( symbol.GetNamespaceScopes().size() == 0 && symbol.GetName() == "String" )
	{
		return GetStringClassPtr();
	}

	std::vector<const CClass *> classes;
	const CClass *pClass = GetHashArrayElement( symbol.GetName().c_str() );
	while( pClass )
	{
		if( pClass->IsEqualSymbol( symbol.GetNamespaceScopes(), symbol.GetName() ) ){
			//OԂƃNXv
			classes.push_back( pClass );
		}
		pClass = pClass->GetChainNext();
	}
	if( classes.size() > 0 )
	{
		// ̖OԂ̒ɓ̃NX݂ꍇ̂ŁAANZX\ŏKwԐ[̂`CX
		pClass = classes.front();

		BOOST_FOREACH( const CClass *pTempClass, classes )
		{
			if( pClass->GetNamespaceScopes().size() < pTempClass->GetNamespaceScopes().size() )
			{
				pClass = pTempClass;
			}
		}

		return pClass;
	}

	return NULL;
}

const CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass )
	{
		// LbVĂ
		pStringClass = this->FindEx( Symbol( NamespaceScopes( "System" ), "String" ) );
	}
	return pStringClass;
}
const CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass )
	{
		// LbVĂ
		pObjectClass = this->FindEx( Symbol( NamespaceScopes( "System" ), "Object" ) );
	}
	return pObjectClass;
}
const CClass *Classes::GetInterfaceInfoClassPtr() const
{
	if( !pInterfaceInfo )
	{
		// LbVĂ
		pInterfaceInfo = this->FindEx( Symbol( NamespaceScopes( "ActiveBasic.Core" ), "InterfaceInfo" ) );
	}
	return pInterfaceInfo;
}

std::string CClass::GetStaticDefiningStringAsMemberNames() const
{
	std::string result;

	BOOST_FOREACH( const Member *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ',';
		}

		result += '\"' + pMember->GetName() + '\"';
	}

	return result;
}
std::string CClass::GetStaticDefiningStringAsMemberOffsets() const
{
	std::string result;

	BOOST_FOREACH( const Member *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ',';
		}

		int offset = this->GetMemberOffset( pMember->GetName().c_str() );

		char temporary[255];
		_itoa( offset, temporary, 16 );

		result += (std::string)"&H" + temporary;
	}

	return result;
}

void CClass::GetReferenceOffsetsInitializeBuffer( std::string &referenceOffsetsBuffer, int &numOfReference, int baseOffset ) const
{
	const CClass &thisClass = *this;
	BOOST_FOREACH( const Member *pMember, thisClass.GetDynamicMembers() )
	{
		if( pMember->GetType().IsObject() || pMember->GetType().IsPointer() )
		{
			if( referenceOffsetsBuffer.size() )
			{
				referenceOffsetsBuffer += ",";
			}

			char temp[255];
			sprintf( temp, "%d", baseOffset + thisClass.GetMemberOffset( pMember->GetName().c_str() ) );
			referenceOffsetsBuffer += temp;

			numOfReference++;
		}
		if( pMember->GetType().IsStruct() && !pMember->GetType().IsPointer() )
		{
			// \̂̎̂oɎƂ
			int baseOffset = thisClass.GetMemberOffset( pMember->GetName().c_str() );

			// \̃oGCɂ`FbNKvȎQƈʒuǉ
			pMember->GetType().GetClass().GetReferenceOffsetsInitializeBuffer( referenceOffsetsBuffer, numOfReference, baseOffset );
		}
	}
}

bool CClass::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	// ^p[^
	BOOST_FOREACH( GenericType &genericType, formalGenericTypes )
	{
		genericType.GetType().Resolve( resolver, resolveErrors );
	}

	// NX
	if( this->pSuperClass )
	{
		if( this->pSuperClass->IsNeedResolve() )
		{
			const CClass *pTempClass = resolver.meta.GetClasses().FindLike( this->pSuperClass );
			if( pTempClass )
			{
				this->pSuperClass = pTempClass;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pSuperClass->GetRelationalObjectModuleIndex(), this->pSuperClass->GetFullName() ) );
			}
		}
	}

	// NX̌^p[^ip[^j
	BOOST_FOREACH( Type &superClassActualTypeParameter, superClassActualTypeParameters )
	{
		superClassActualTypeParameter.Resolve( resolver, resolveErrors );
	}

	// Blittable^
	blittableType.Resolve( resolver, resolveErrors );

	// C^[tFCX
	BOOST_FOREACH( ::Interface *pInterface, interfaces )
	{
		pInterface->Resolve( resolver, resolveErrors );
	}

	// Io
	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		pMember->Resolve( resolver, resolveErrors );
	}

	// ÓIo
	BOOST_FOREACH( Member *pMember, staticMembers )
	{
		pMember->Resolve( resolver, resolveErrors );
	}

	// I\bh
	BOOST_FOREACH( CMethod *pMethod, GetDynamicMethods() )
	{
		pMethod->Resolve( resolver, resolveErrors );
	}

	// ÓI\bh
	BOOST_FOREACH( CMethod *pMethod, staticMethods )
	{
		pMethod->Resolve( resolver, resolveErrors );
	}

	// ev[gWJ̃NX
	BOOST_FOREACH( ActiveBasic::Common::Lexical::ExpandedTemplateClass *pExpandedTemplateClass, expandedTemplateClasses )
	{
		pExpandedTemplateClass->Resolve( resolver, resolveErrors );
	}

	return true;
}
