
#ifndef _ACTIVEBASIC_COMPILER_TYPE_H
#define _ACTIVEBASIC_COMPILER_TYPE_H

class Type{
	static const int basicTypeList[];
	static const string basicTypeNameList[];


	int basicType;
	union{
		LONG_PTR index;
		CClass *pClass;
	};

public:

	static bool StringToBasicType( const string &typeName, int &basicType );
	static bool StringToType( const string &typeName, Type &type );

	Type():
	  basicType( DEF_NON ),
	  index( -1 ){}
	Type( int basicType ):
	  basicType( basicType ),
	  index( -1 ){}

	Type( int basicType, LONG_PTR index ):
	  basicType( basicType ),
	  index( index ){}

	Type( int basicType, CClass &objClass ):
	  basicType( basicType ),
	  index( (LONG_PTR)&objClass ){}

	Type( const Type &type ):
	  basicType( type.basicType ),
	  index( type.index ){}

	int GetBasicType() const
	{
#ifdef _DEBUG
		if( basicType<-10000 ){
			DebugBreak();
		}
#endif
		return basicType;
	}
	LONG_PTR GetIndex() const
	{
		return index;
	}
	const CClass &GetClass() const
	{
		return *pClass;
	}

	void SetBasicType( int basicType ){
		this->basicType = basicType;
	}
	void SetIndex( LONG_PTR index ){
		this->index = index;
	}
	void SetNull(){
		SetBasicType( DEF_NON );
	}
	void SetType( int basicType, LONG_PTR index ){
		SetBasicType( basicType );
		SetIndex( index );
	}
	void SetType( int basicType, CClass *pClass ){
		SetBasicType( basicType );
		this->pClass = pClass;
	}

	void PtrLevelUp(){
		PTR_LEVEL_UP( basicType );
	}

	bool Equals( const Type &type ) const;

	bool IsNull() const;
	bool IsPointer() const;
	bool IsSigned() const;
	bool IsNaturalWhole() const;
	bool IsWhole() const;
	bool IsReal() const;
	bool Is64() const;
	bool IsProcPtr() const;
	bool IsStruct() const;

};

#endif //_ACTIVEBASIC_COMPILER_TYPE_H
