#include "common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

ParamImpl::ParamImpl(const char *buffer){
	///////////////////////////
	// p[^𐮗
	///////////////////////////

	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[VN_SIZE];

	i=0;
	ParmsNum=0;
	while(1){
		if(buffer[i]=='\0') break;

		for(i2=0;;i2++,i++){
			if(buffer[i]=='\"'){
				temporary[i2]=buffer[i];
				for(i++,i2++;;i++,i2++){
					temporary[i2]=buffer[i];
					if(buffer[i]=='\"') break;
				}
				continue;
			}

			if(buffer[i]=='('){
				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}

			if(buffer[i]==','||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(Parms[ParmsNum],temporary);
		ParmsNum++;

		if(buffer[i]==',') i++;
	}

	ReturnTypeInfo.type=DEF_NON;
	ReturnTypeInfo.u.lpIndex=-1;
}
ParamImpl::ParamImpl(const PARAMETER_INFO *pParamInfo,const int ParmNum){
	int i;
	for(i=0;i<ParmNum;i++){
		Parms[i]=0;
		types[i].type=pParamInfo[i].type;
		types[i].u.lpIndex=pParamInfo[i].u.index;
	}
	this->ParmsNum=ParmNum;

	ReturnTypeInfo.type=DEF_NON;
	ReturnTypeInfo.u.lpIndex=-1;
}
ParamImpl::ParamImpl(const Parameters &params){
	int count = 0;
	foreach( Parameter *pParam, params ){
		types[count].type = pParam->GetBasicType();
		types[count].u.lpIndex = pParam->GetIndex();
		count++;
	}
	this->ParmsNum=params.size();

	ReturnTypeInfo.type=DEF_NON;
	ReturnTypeInfo.u.lpIndex=-1;
}
ParamImpl::~ParamImpl(){
	int i2;

	//p[^
	for(i2=0;i2<ParmsNum;i2++){
		if(Parms[i2]==(char *)-1) continue;

		if(Parms[i2]) HeapDefaultFree(Parms[i2]);
	}
}

void ParamImpl::SetReturnType(TYPEINFO *pTypeInfo){
	ReturnTypeInfo=*pTypeInfo;
}

BOOL ParamImpl::_overload_check( Parameters &params,TYPEINFO *pReturnTypeInfo,int overload_level){
	//p[^ʂăI[o[[h

	//p[^̌sv̏ꍇ
	int max = (int)params.size();
	if(max!=ParmsNum) return 0;

	Type argType;
	for(int i=0;i<max;i++){
		Parameter &param = *params[i];

		if(Parms[i]){
			Type nullParam( DEF_NON );

			NumOpe_GetType(Parms[i],
				(overload_level==OVERLOAD_LEVEL0)? nullParam : param,
				argType);
		}
		else{
			argType.SetType( types[i].type, types[i].u.lpIndex );
		}

		if(argType.GetBasicType()!=param.GetBasicType()){
			if(overload_level==OVERLOAD_LEVEL1 || overload_level == OVERLOAD_LEVEL0){
				return 0;
			}
			else if(overload_level==OVERLOAD_LEVEL2){
				if(!(
					IsWholeNumberType(argType.GetBasicType())&&IsWholeNumberType(param.GetBasicType())||
					IsRealNumberType(argType.GetBasicType())&&IsRealNumberType(param.GetBasicType())
					)) return 0;
			}
			else if(overload_level==OVERLOAD_LEVEL3){
				if(argType.GetBasicType()==DEF_OBJECT||param.GetBasicType()==DEF_OBJECT) return 0;
			}
		}
		else{
			if(NATURAL_TYPE(argType.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(argType.GetBasicType())==DEF_STRUCT){
				if(argType.GetIndex()!=param.GetIndex()) return 0;
			}
		}
	}

	if(pReturnTypeInfo){
		//߂lrΏۂɂ
		if(ReturnTypeInfo.type==pReturnTypeInfo->type){
			if(NATURAL_TYPE(ReturnTypeInfo.type)==DEF_OBJECT
				|| NATURAL_TYPE(ReturnTypeInfo.type)==DEF_STRUCT ){
					if(ReturnTypeInfo.u.lpIndex != pReturnTypeInfo->u.lpIndex) return 0;
			}
		}
		else return 0;
	}

	return 1;
}

SubInfo *ParamImpl::OverloadSolutionWithReturnType( const char *name, std::vector<SubInfo *> &subs ){
	int sw=0;
	SubInfo *psi;
	psi=0;

	for( int level=OVERLOAD_MIN_LEVEL; level<=OVERLOAD_MAX_LEVEL; level++ ){
		foreach( SubInfo *temp_psi, subs ){

			TYPEINFO ReturnTypeInfo;
			ReturnTypeInfo.type=temp_psi->ReturnType;
			ReturnTypeInfo.u.lpIndex=temp_psi->u.ReturnIndex;

			//G[`FbN
			if(_overload_check(temp_psi->params,&ReturnTypeInfo,level)){
				if(sw){
					SetError(52,name,cp);
					return 0;
				}
				sw=1;

				psi = temp_psi;
				break;
			}
		}

		if( sw ) break;
	}

	if(!sw){
		SetError(52,name,cp);
		return 0;
	}

	return psi;
}
SubInfo *ParamImpl::OverloadSolution( const char *name, std::vector<SubInfo *> &subs ){
	int sw=0;
	SubInfo *psi;
	psi=0;

	for( int level=OVERLOAD_MIN_LEVEL; level<=OVERLOAD_MAX_LEVEL; level++ ){

		foreach( SubInfo *temp_psi, subs ){

			//G[`FbN
			if(_overload_check(temp_psi->params,NULL,level)){
				if(sw){
					return OverloadSolutionWithReturnType(name,subs);
				}
				sw=1;

				psi = temp_psi;
			}
		}

		if( sw ) break;
	}

	if(!sw){
		SubInfo *temp_psi;
		foreach( temp_psi, subs ){

			//G[`FbN
			if(temp_psi->params.size()==this->ParmsNum){
				if(sw){
					sw=0;
					break;
				}
				sw=1;

				psi=temp_psi;
			}
		}
	}

	if(!sw){
		SetError(52,name,cp);
		return 0;
	}

	return psi;
}

BOOL ParamImpl::ErrorCheck(const char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum){
	if(ParmsNum>pi_num){
		if(ppi[pi_num-1].type!=DEF_ELLIPSE){
			//p[^Ƃ
			SetError(10,FuncName,cp);
			return 0;
		}
	}
	else if(ParmsNum<pi_num){
		if(ParmsNum<SecondParmNum){
			if(ppi[ParmsNum].type==DEF_ELLIPSE){
				return 1;
			}

			//p[^ȂƂ
			SetError(10,FuncName,cp);
			return 0;
		}

		//ȗp[^ "0" w肷
		for(;ParmsNum < pi_num;ParmsNum++){
			extern HANDLE hHeap;
			char temporary[64];
			if(ppi[ParmsNum].bByVal) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[ParmsNum],temporary);
		}
	}

	return 1;
}
bool ParamImpl::ErrorCheck( const char *procName, const Parameters &params, int SecondParmNum ){
	if(ParmsNum>(int)params.size()){
		if(params[params.size()-1]->GetBasicType()!=DEF_ELLIPSE){
			//p[^Ƃ
			SetError(10,procName,cp);
			return false;
		}
	}
	else if(ParmsNum<(int)params.size()){
		if(ParmsNum<SecondParmNum){
			if(params[ParmsNum]->GetBasicType()==DEF_ELLIPSE){
				return true;
			}

			//p[^ȂƂ
			SetError(10,procName,cp);
			return false;
		}

		//ȗp[^ "0" w肷
		for(;ParmsNum < (int)params.size();ParmsNum++){
			extern HANDLE hHeap;
			char temporary[64];
			if(params[ParmsNum]->IsRef() == false) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[ParmsNum],temporary);
		}
	}

	return true;
}

void ParamImpl::MacroParameterSupport(PARAMETER_INFO *ppi){
	for(int i=0;i<ParmsNum;i++){
		if(Parms[i][0]=='\0'){
			extern HANDLE hHeap;
			char temporary[64];
			if(ppi[i].bByVal) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			HeapDefaultFree(Parms[i]);
			Parms[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[i],temporary);
		}
	}
}
void ParamImpl::MacroParameterSupport( const Parameters &params ){
	for(int i=0;i<ParmsNum;i++){
		if(Parms[i][0]=='\0'){
			extern HANDLE hHeap;
			char temporary[64];
			if( params[i]->IsRef() == false ) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			HeapDefaultFree(Parms[i]);
			Parms[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[i],temporary);
		}
	}
}
