#include "common.h"

const int Type::basicTypeList[] = {
	DEF_BYTE,
	DEF_SBYTE,
	DEF_WORD,
	DEF_INTEGER,
	DEF_DWORD,
	DEF_LONG,
	DEF_QWORD,
	DEF_INT64,

	DEF_SINGLE,
	DEF_DOUBLE,

	DEF_BOOLEAN,

	DEF_PTR_VOID,

	DEF_ANY,

	DEF_NON
};

const string Type::basicTypeNameList[] = {
	"Byte",
	"SByte",
	"Word",
	"Integer",
	"DWord",
	"Long",
	"QWord",
	"Int64",

	"Single",
	"Double",

	"Boolean",

	"VoidPtr",

	"Any",

	""
};

bool Type::StringToBasicType( const string &typeName, int &basicType ){
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeNameList[i] == typeName ){
			basicType = basicTypeList[i];
			return true;
		}
	}
	return false;
}
bool Type::StringToType( const string &typeName, Type &type ){
	type.index = -1;

	if( typeName[0] == '*' ){
		if( typeName.size() >= 3
			&& typeName[1] == 1 && ( typeName[2] == ESC_FUNCTION || typeName[2] == ESC_SUB ) ){
				//֐|C^i*Functionj
				type.basicType = DEF_PTR_PROC;
		}

		string nextTypeName = typeName.substr( 1 );

		if( !StringToType( nextTypeName, type ) ){
			return false;
		}

		type.PtrLevelUp();

		return true;
	}

	if( StringToBasicType( typeName, type.basicType ) ){
		// {^Ƃ
		return true;
	}


	////////////////////
	// TypeDefꂽ^
	////////////////////
	int i=pobj_DBTypeDef->check( typeName.c_str() );
	if(i!=-1){
		return StringToType( pobj_DBTypeDef->ppobj_TypeDef[i]->lpszBaseName, type );
	}

	//NX
	CClass *pobj_c = pobj_DBClass->check( typeName.c_str() );
	if(pobj_c){
		type.pClass = pobj_c;

		if( pobj_c->IsStructure() ){
			type.basicType = DEF_STRUCT;
		}
		else{
			type.basicType = DEF_OBJECT;
		}
		return true;
	}

	return false;
}


bool Type::Equals( const Type &type ) const
{
	if( basicType == type.basicType ){
		if( NATURAL_TYPE( basicType ) == DEF_OBJECT
			|| NATURAL_TYPE( basicType ) == DEF_STRUCT ){

				if( index == type.index ){
					return true;
				}

		}
		else{
			return true;
		}
	}
	return false;
}

bool Type::IsNull() const{
  if( basicType == DEF_NON ){
	  return true;
  }
  return false;
}
bool Type::IsPointer() const
{
	if(PTR_LEVEL( basicType )|| basicType == DEF_PTR_VOID || basicType == DEF_PTR_PROC
		|| ( basicType & FLAG_PTR ) ){
			return true;
	}

	return false;
}
bool Type::IsSigned() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_INTEGER:
		case DEF_LONG:
		case DEF_INT64:
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsNaturalWhole() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_INTEGER:
		case DEF_WORD:
		case DEF_LONG:
		case DEF_DWORD:
		case DEF_INT64:
		case DEF_QWORD:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsWhole() const
{
	return (
		IsNaturalWhole()
		|| IsPtrType( basicType )
		|| basicType == DEF_BOOLEAN
		);
}
bool Type::IsReal() const
{
	switch( basicType ){
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::Is64() const
{
	switch( basicType ){
		case DEF_QWORD:
		case DEF_INT64:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsProcPtr() const
{
	if( basicType == DEF_PTR_PROC ){
		return true;
	}
	return false;
}
bool Type::IsStruct() const
{
	if( basicType == DEF_STRUCT ){
		return true;
	}
	return false;
}
