#include "stdafx.h"

#include "../BasicCompiler_Common/common.h"


char *ReadBuffer_NonErrMsg( const std::string &path ){
	extern HANDLE hHeap;
	int i;
	DWORD dw;
	char *buffer;
	HANDLE hFile;

	hFile=CreateFile(path.c_str(),GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE) return 0;
	i=GetFileSize(hFile,0);
	buffer=(char *)HeapAlloc(hHeap,0,i+1);
	ReadFile(hFile,buffer,i,&dw,0);
	buffer[dw]=0;
	CloseHandle(hFile);
	return buffer;
}
_int8 WriteBuffer( const std::string &path, char *buffer,int length){
	extern HWND hOwnerEditor;
	HANDLE hFile;
	DWORD dw;
	hFile=CreateFile(path.c_str(),GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		char temporary[MAX_PATH];

		sprintf(temporary,"\"%s\" t@Cւ݂̏Ɏs܂B",path);
		MessageBox(hOwnerEditor,temporary,"G[",MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}
	if(length) WriteFile(hFile,buffer,length,&dw,NULL);
	CloseHandle(hFile);
	return 1;
}


///////////////////////////
// s̃f[^Ǘ
///////////////////////////

BOOL CNonVolatile::GetDataLine(char *name,char *parms){
	int i,i2,length;
	length=lstrlen(name);
	for(i=0;;i++){
		if(buffer[i]=='\0') break;
		if(i==0||buffer[i]=='\r'&&buffer[i+1]=='\n'){
			if(buffer[i]=='\r'&&buffer[i+1]=='\n') i+=2;
			if(memcmp(buffer+i,name,length)==0&&buffer[i+length]=='='){
				i+=length+1;
				for(i2=0;;i++,i2++){
					if(buffer[i]=='\r'&&buffer[i+1]=='\n'||buffer[i]=='\0'){
						parms[i2]=0;
						break;
					}
					parms[i2]=buffer[i];
				}
				return 1;
			}
		}
	}
	return 0;
}

BOOL CNonVolatile::GetWholeValue(char *name,int *pi32data){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	*pi32data=atoi(temporary);
	return 1;
}
BOOL CNonVolatile::Get3WholeValue(char *name,int *pd1,int *pd2,int *pd3){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%d,%d,%d",pd1,pd2,pd3);
	return 1;
}
BOOL CNonVolatile::GetRGBValue(char *name,COLORREF *prgb){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%x",prgb);
	return 1;
}
BOOL CNonVolatile::GetStringValue(char *name,char *str){
	if(!GetDataLine(name,str)) return 0;
	return 1;
}
BOOL CNonVolatile::GetRectValue(char *name,RECT *prc){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%d,%d,%d,%d",&prc->left,&prc->top,&prc->right,&prc->bottom);
	return 1;
}
BOOL CNonVolatile::GetPointValue(char *name,POINT *pos){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%d,%d",&pos->x,&pos->y);
	return 1;
}

void CNonVolatile::load(){
	extern HANDLE hHeap;
	int i;

	//J
	buffer=ReadBuffer_NonErrMsg( Program::GetAbcUserAppDir() + "\\compiler.ini" );
	if(!buffer){
		//WXgǂݍ
		OldLoad();
		return;
	}


	if(!GetWholeValue("IsShow_DefaultSystem_Var",&bShow_DefaultSystem_Var)) bShow_DefaultSystem_Var=0;
	if(!GetWholeValue("IsShow_Rad_Var",&bShow_Rad_Var)) bShow_Rad_Var=0;
	if(!GetWholeValue("IsShow_GUID_Var",&bShow_GUID_Var)) bShow_Rad_Var=0;

	extern int ScreenX,ScreenY;
	if(!GetPointValue("MainDlgPos",&MainDlgPos)){
		MainDlgPos.x=ScreenX/2-100;
		MainDlgPos.y=ScreenX/2-250;
	}

	if(!GetRectValue("VarDlgRect",&VarDlgRect)){
		VarDlgRect.left=ScreenX/2-390/2;
		VarDlgRect.top=ScreenY/2-270/2;
		VarDlgRect.right=ScreenX/2+390/2;
		VarDlgRect.bottom=ScreenY/2+270/2;
	}

	//EHb`Xg
	if(!GetWholeValue("WatchNum",&WatchNum)) WatchNum=0;

	ppWatchStr=(char **)HeapAlloc(hHeap,0,WatchNum*sizeof(char *)+1);
	for(i=0;i<WatchNum;i++){
		char temporary[VN_SIZE];
		sprintf(temporary,"Watch%03d",i);

		char temp2[VN_SIZE];
		GetStringValue(temporary,temp2);
		ppWatchStr[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
		lstrcpy(ppWatchStr[i],temp2);
	}


	HeapDefaultFree(buffer);
}
void CNonVolatile::OldLoad(){
	extern HANDLE hHeap;
	extern int ScreenX,ScreenY;

	int i;
	HKEY hKey;
	ULONG ulSize;
	char temporary[MAX_PATH],temp2[VN_SIZE];

	if(RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Discoversoft\\BasicCompiler",0,KEY_ALL_ACCESS,&hKey)!=ERROR_SUCCESS){
		bShow_DefaultSystem_Var=0;
		bShow_Rad_Var=0;
		bShow_GUID_Var=0;

		MainDlgPos.x=ScreenX/2-100;
		MainDlgPos.y=ScreenX/2-250;

		VarDlgRect.left=ScreenX/2-390/2;
		VarDlgRect.top=ScreenY/2-270/2;
		VarDlgRect.right=ScreenX/2+390/2;
		VarDlgRect.bottom=ScreenY/2+270/2;

		WatchNum=0;
		ppWatchStr=(char **)HeapAlloc(hHeap,0,1);
	}
	else{
		ulSize=sizeof(DWORD);
		if(RegQueryValueEx(hKey,"bShow_DefaultSystem_Var",NULL,NULL,(BYTE *)&bShow_DefaultSystem_Var,&ulSize)!=ERROR_SUCCESS)
			bShow_DefaultSystem_Var=0;

		ulSize=sizeof(DWORD);
		if(RegQueryValueEx(hKey,"bShow_Rad_Var",NULL,NULL,(BYTE *)&bShow_Rad_Var,&ulSize)!=ERROR_SUCCESS)
			bShow_Rad_Var=0;

		ulSize=sizeof(DWORD);
		if(RegQueryValueEx(hKey,"bShow_GUID_Var",NULL,NULL,(BYTE *)&bShow_GUID_Var,&ulSize)!=ERROR_SUCCESS)
			bShow_GUID_Var=0;

		ulSize=1024;
		if(RegQueryValueEx(hKey,"MainDlgPos",NULL,NULL,(unsigned char *)temporary,&ulSize)!=ERROR_SUCCESS){
			MainDlgPos.x=ScreenX/2-100;
			MainDlgPos.y=ScreenX/2-250;
		}
		else sscanf(temporary,"%d %d",
			&MainDlgPos.x,
			&MainDlgPos.y);

		ulSize=1024;
		if(RegQueryValueEx(hKey,"VarDlgRect",NULL,NULL,(unsigned char *)temporary,&ulSize)!=ERROR_SUCCESS){
			VarDlgRect.left=ScreenX/2-390/2;
			VarDlgRect.top=ScreenY/2-270/2;
			VarDlgRect.right=ScreenX/2+390/2;
			VarDlgRect.bottom=ScreenY/2+270/2;
		}
		else sscanf(temporary,"%d %d %d %d",
			&VarDlgRect.left,
			&VarDlgRect.top,
			&VarDlgRect.right,
			&VarDlgRect.bottom);

		ulSize=sizeof(DWORD);
		if(RegQueryValueEx(hKey,"WatchNum",NULL,NULL,(BYTE *)&WatchNum,&ulSize)!=ERROR_SUCCESS)
			WatchNum=0;
		ppWatchStr=(char **)HeapAlloc(hHeap,0,WatchNum*sizeof(char *)+1);
		for(i=0;i<WatchNum;i++){
			sprintf(temporary,"WathNum%03d",i);
			ulSize=VN_SIZE;
			if(RegQueryValueEx(hKey,temporary,NULL,NULL,(unsigned char *)temp2,&ulSize)!=ERROR_SUCCESS){
				WatchNum=i;
				break;
			}
			ppWatchStr[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(ppWatchStr[i],temp2);
		}
	}
}

void CNonVolatile::SetWholeValue(char *name,long i32data){
	sprintf(buffer+lstrlen(buffer),"%s=%d\r\n",name,i32data);
}
void CNonVolatile::Set3WholeValue(char *name,long d1,long d2,long d3){
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d,%d\r\n",name,d1,d2,d3);
}
void CNonVolatile::SetRGBValue(char *name,COLORREF rgb){
	sprintf(buffer+lstrlen(buffer),"%s=%x\r\n",name,rgb);
}
void CNonVolatile::SetStringValue(char *name,char *str){
	sprintf(buffer+lstrlen(buffer),"%s=%s\r\n",name,str);
}
void CNonVolatile::SetRectValue(char *name,RECT *prc){
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d,%d,%d\r\n",name,prc->left,prc->top,prc->right,prc->bottom);
}
void CNonVolatile::SetPointValue(char *name,POINT *pos){
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d\r\n",name,pos->x,pos->y);
}

void CNonVolatile::save(){
	int i;
	char temporary[MAX_PATH];

	// [Uۑp̃fBNg쐬
	Jenga::Common::Directory dir( Program::GetAbcUserAppDir(), true );


	extern HANDLE hHeap;
	buffer=(char *)HeapAlloc(hHeap,0,65536);
	buffer[0]=0;


	SetWholeValue("IsShow_DefaultSystem_Var",bShow_DefaultSystem_Var);
	SetWholeValue("IsShow_Rad_Var",bShow_Rad_Var);
	SetWholeValue("IsShow_GUID_Var",bShow_GUID_Var);

	SetPointValue("MainDlgPos",&MainDlgPos);

	SetRectValue("VarDlgRect",&VarDlgRect);

	//EHb`Xg
	SetWholeValue("WatchNum",WatchNum);
	for(i=0;i<WatchNum;i++){
		sprintf(temporary,"Watch%03d",i);
		SetStringValue(temporary,ppWatchStr[i]);
		HeapDefaultFree(ppWatchStr[i]);
	}
	HeapDefaultFree(ppWatchStr);


	//ۑ
	WriteBuffer(
		Program::GetAbcUserAppDir() + "\\compiler.ini",
		buffer,lstrlen(buffer));


	HeapDefaultFree(buffer);
}
