#include "stdafx.h"

#include "common.h"


#ifndef ListView_SetCheckState
   #define ListView_SetCheckState(hwndLV, i, fCheck) \
      ListView_SetItemState(hwndLV, i, \
      INDEXTOSTATEIMAGEMASK((fCheck)+1), LVIS_STATEIMAGEMASK)
#endif



COneExt::COneExt(BOOL bReg,char *lpszExtension,char *lpszNote,BOOL bWindowsSearch,COLORREF tab_color){
	m_bReg=bReg;
	lstrcpy(m_szExtension,lpszExtension);
	lstrcpy(m_szNote,lpszNote);
	m_bWindowsSearch=bWindowsSearch;
	TabColor=tab_color;
}
COneExt::~COneExt(){
}

CExtLink::CExtLink(){
	ppobj_ExtItems=(COneExt **)malloc(1);
	iExtItemNum=0;
}
CExtLink::~CExtLink(){
	int i;
	for(i=0;i<iExtItemNum;i++){
		delete ppobj_ExtItems[i];
	}
	free(ppobj_ExtItems);
	ppobj_ExtItems=0;
}

void CExtLink::load( const std::string &path )
{
	char *buffer;
	buffer=ReadBuffer_NonErrMsg(path);
	if(buffer){
		int i=0;
		char temporary[64],temp2[255],temp3[64],temp4[64];
		while(1){
			//֘AtȂǂ̃`FbN
			BOOL bReg;
			i=GetOneParameter(buffer,i,temporary);
			if(temporary[0]=='\0') break;
			bReg=atoi(temporary);

			//gq
			i=GetOneParameter(buffer,i,temporary);
			if(temporary[0]=='\0') break;

			//
			i=GetOneParameter(buffer,i,temp2);
			if(temp2[0]=='\0') break;

			//Windows
			i=GetOneParameter(buffer,i,temp3);
			if(temp3[0]=='\0') break;

			//^u̐F
			i=GetOneParameter(buffer,i,temp4);
			if(temp4[0]=='\0') break;

			DWORD dwColor;
			sscanf(temp4,"%x",&dwColor);

			add(bReg,temporary,temp2,atoi(temp3),(COLORREF)dwColor);

			if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
				i+=2;
			}
			else break;
		}

		HeapDefaultFree(buffer);
	}
	else{
		//ftHglZbg
		SetInitData();
	}
}
void CExtLink::save( const std::string &path )
{
	int i;
	char buffer[8192];
	buffer[0]=0;
	for(i=0;i<iExtItemNum;i++){
		sprintf(buffer+lstrlen(buffer),"%d,%s,%s,%d,%x\r\n",
			ppobj_ExtItems[i]->m_bReg,
			ppobj_ExtItems[i]->m_szExtension,
			ppobj_ExtItems[i]->m_szNote,
			ppobj_ExtItems[i]->m_bWindowsSearch,
			ppobj_ExtItems[i]->TabColor);
	}

	//ۑ
	WriteBuffer(path,buffer,lstrlen(buffer));
}

BOOL CExtLink::add(BOOL bReg,char *lpszExtension,char *lpszNote,BOOL bWindowsSearch,COLORREF tab_color){
	//d`FbN
	int i;
	for(i=0;i<iExtItemNum;i++){
		if(lstrcmpi(ppobj_ExtItems[i]->m_szExtension,lpszExtension)==0){
			return 0;
		}
	}

	ppobj_ExtItems=(COneExt **)realloc(ppobj_ExtItems,(iExtItemNum+1)*sizeof(COneExt*));
	ppobj_ExtItems[iExtItemNum]=new COneExt(bReg,lpszExtension,lpszNote,bWindowsSearch,tab_color);
	iExtItemNum++;

	return 1;
}
void CExtLink::del(char *lpszExtension){
	int i;
	for(i=0;i<iExtItemNum;i++){
		if(lstrcmpi(lpszExtension,ppobj_ExtItems[i]->m_szExtension)==0)
			break;
	}
	if(i==iExtItemNum) return;

	delete ppobj_ExtItems[i];

	iExtItemNum--;
	for(;i<iExtItemNum;i++){
		ppobj_ExtItems[i]=ppobj_ExtItems[i+1];
	}
}

void CExtLink::SetInitData(void){
	///////////////////////////////////
	// グp̒lZbg
	///////////////////////////////////

#ifdef THETEXT
	add(1,"txt","eLXg hLg",1,TABCOLOR_GRAY);
	add(0,"htm","HTML hLg",1,TABCOLOR_BLUE);
	add(0,"html","HTML hLg",1,TABCOLOR_BLUE);
	add(1,"cgi","CGI hLg",1,TABCOLOR_GREEN);
	add(1,"pl","Perl hLg",1,TABCOLOR_GREEN);
	add(1,"php","PHP hLg",1,TABCOLOR_RED);
	add(1,"tpl","ev[g hLg",1,TABCOLOR_YELLOW);
#else
	add(1,"ab","Basic \[XR[h",1,TABCOLOR_BLUE);
	add(1,"abp","Basic \[XR[h",1,TABCOLOR_BLUE);
	add(1,"bas","Basic \[XR[h",1,TABCOLOR_BLUE);
	add(1,"sbp","Tu\[XR[h",1,TABCOLOR_GREEN);
	add(1,"pj","ActiveBasic vWFNg hLg",0,TABCOLOR_GRAY);
#endif
}

void CExtLink::ResetListView(HWND hListView){
	ListView_DeleteAllItems(hListView);

	int i;
	for(i=0;  i < pobj_nv->pobj_ExtLink->iExtItemNum;  i++){
		LV_ITEM item;

		//gq
		item.mask=LVIF_TEXT;
		item.pszText=ppobj_ExtItems[i]->m_szExtension;
		item.iItem=i;
		item.iSubItem=0;
		ListView_InsertItem(hListView,&item);

		//
		item.pszText=ppobj_ExtItems[i]->m_szNote;
		item.iItem=i;
		item.iSubItem++;
		ListView_SetItem(hListView,&item);

		//Windows
		if(ppobj_ExtItems[i]->m_bWindowsSearch)
			item.pszText="L";
		else item.pszText="";
		item.iItem=i;
		item.iSubItem++;
		ListView_SetItem(hListView,&item);

		//^u̐F
		if(ppobj_ExtItems[i]->TabColor==TABCOLOR_GRAY)			item.pszText="DF";
		else if(ppobj_ExtItems[i]->TabColor==TABCOLOR_WHITE)	item.pszText="";
		else if(ppobj_ExtItems[i]->TabColor==TABCOLOR_RED)		item.pszText="";
		else if(ppobj_ExtItems[i]->TabColor==TABCOLOR_GREEN)	item.pszText="";
		else if(ppobj_ExtItems[i]->TabColor==TABCOLOR_BLUE)		item.pszText="";
		else if(ppobj_ExtItems[i]->TabColor==TABCOLOR_YELLOW)	item.pszText="F";
		else item.pszText="[U[ݒ";
		item.iItem=i;
		item.iSubItem++;
		ListView_SetItem(hListView,&item);

		//`FbN}[N
		ListView_SetCheckState(hListView,i,ppobj_ExtItems[i]->m_bReg);
	}
}

COLORREF CExtLink::GetTabColorFromFilePath( const std::string &filepath )
{
	//gqʂA^u̐F
	char szExt[255],*lpszTemp;
	_splitpath(filepath.c_str(),NULL,NULL,NULL,szExt);
	if(szExt[0]=='.') lpszTemp=szExt+1;
	else lpszTemp=szExt;
	for(int i=0;i<iExtItemNum;i++){
		if(lstrcmpi(lpszTemp,ppobj_ExtItems[i]->m_szExtension)==0){
			return ppobj_ExtItems[i]->TabColor;
		}
	}
	return TABCOLOR_GRAY;
}


BOOL CALLBACK DlgFileLinkAdd(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	static COneExt *pobj_OneExt;

	static int TabColor;
	switch(message){
		case WM_INITDIALOG:
			if(lParam){
				pobj_OneExt=(COneExt *)lParam;

				SetDlgItemText(hwnd,IDC_EXTENSION,pobj_OneExt->m_szExtension);
				SetDlgItemText(hwnd,IDC_NOTE,pobj_OneExt->m_szNote);
				TabColor=pobj_OneExt->TabColor;

				if(pobj_OneExt->m_bWindowsSearch)
					SendDlgItemMessage(hwnd,IDC_SEARCH_ON,BM_SETCHECK,BST_CHECKED,0);
				else
					SendDlgItemMessage(hwnd,IDC_SEARCH_OFF,BM_SETCHECK,BST_CHECKED,0);

				EnableWindow(GetDlgItem(hwnd,IDC_EXTENSION),0);

				SetFocus(GetDlgItem(hwnd,IDC_NOTE));
			}
			else{
				pobj_OneExt=0;
				TabColor=TABCOLOR_GRAY;

				SendDlgItemMessage(hwnd,IDC_SEARCH_ON,BM_SETCHECK,BST_CHECKED,0);

				SetFocus(GetDlgItem(hwnd,IDC_EXTENSION));
			}

			SendMessage(hwnd,WM_COMMAND,IDC_EXTENSION,0);

			break;
		case WM_DRAWITEM:
			LPDRAWITEMSTRUCT pds;
			pds=(LPDRAWITEMSTRUCT)lParam;

			HBRUSH hBrush,hOldBrush;

			if(wParam==IDC_COLOR_BUTTON){
				//////////////
				// F`
				//////////////

				//yƃuV𐶐
				HPEN hPen,hOldPen;
				hPen=(HPEN)GetStockObject(WHITE_PEN);
				hBrush=CreateSolidBrush(TabColor);

				//hԂ
				hOldPen=(HPEN)SelectObject(pds->hDC,hPen);
				hOldBrush=(HBRUSH)SelectObject(pds->hDC,hBrush);
				Rectangle(pds->hDC,0,0,pds->rcItem.right,pds->rcItem.bottom);
				SelectObject(pds->hDC,hOldPen);
				SelectObject(pds->hDC,hOldBrush);

				//uVj
				DeleteObject(hBrush);
			}
			return 1;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					char szExtension[64];
					GetDlgItemText(hwnd,IDC_EXTENSION,szExtension,64);

					char szNote[255];
					GetDlgItemText(hwnd,IDC_NOTE,szNote,255);

					BOOL bWindowsSearch;
					if(SendDlgItemMessage(hwnd,IDC_SEARCH_ON,BM_GETCHECK,0,0))
						bWindowsSearch=1;
					else bWindowsSearch=0;

					if(pobj_OneExt){
						//ύX
						lstrcpy(pobj_OneExt->m_szNote,szNote);
						pobj_OneExt->m_bWindowsSearch=bWindowsSearch;
						pobj_OneExt->TabColor=TabColor;
					}
					else{
						//ǉ
						if(!pobj_nv->pobj_ExtLink->add(1,szExtension,szNote,bWindowsSearch,TabColor)){
							char temporary[255];
							sprintf(temporary,"gq %s ͊ɃXgɑ݂܂B",szExtension);
							MessageBox(hwnd,temporary,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);

							return 1;
						}
					}

					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
				case IDC_COLOR_BUTTON:
					POINT pos;
					GetCursorPos(&pos);
					extern HMENU hTabColorMenu;
					TrackPopupMenu(hTabColorMenu,TPM_LEFTALIGN,pos.x,pos.y,0,hwnd,0);
					return 1;

				case IDC_EXTENSION:
					if(GetWindowTextLength(GetDlgItem(hwnd,IDC_EXTENSION)))
						EnableWindow(GetDlgItem(hwnd,IDOK),1);
					else
						EnableWindow(GetDlgItem(hwnd,IDOK),0);
					return 1;

				case IDM_USER_COLOR:
					COLORREF colorUser;
					colorUser=TabColor;
					{
						CHOOSECOLOR cc;
						COLORREF CusColors[16]={
							RGB(255,255,255),
							RGB(0,0,0),
							RGB(128,128,128),
							RGB(192,192,192),
							RGB(128,0,0),
							RGB(255,0,0),
							RGB(128,128,0),
							RGB(255,255,0),
							RGB(0,128,0),
							RGB(0,255,0),
							RGB(0,128,128),
							RGB(0,255,255),
							RGB(0,0,128),
							RGB(0,0,255),
							RGB(128,0,128),
							RGB(255,0,255)};
						cc.lStructSize=sizeof(CHOOSECOLOR);
						cc.hwndOwner=hwnd;
						cc.rgbResult=colorUser;
						cc.lpCustColors=CusColors;
						cc.Flags=CC_RGBINIT|CC_FULLOPEN;
						if(!ChooseColor(&cc)){
							return 0;
						}
						colorUser=cc.rgbResult;
					}
				case IDM_GRAY:
				case IDM_WHITE:
				case IDM_RED:
				case IDM_GREEN:
				case IDM_BLUE:
				case IDM_YELLOW:
					if(LOWORD(wParam)==IDM_GRAY)	TabColor=TABCOLOR_GRAY;
					if(LOWORD(wParam)==IDM_WHITE)	TabColor=TABCOLOR_WHITE;
					if(LOWORD(wParam)==IDM_RED)		TabColor=TABCOLOR_RED;
					if(LOWORD(wParam)==IDM_GREEN)	TabColor=TABCOLOR_GREEN;
					if(LOWORD(wParam)==IDM_BLUE)	TabColor=TABCOLOR_BLUE;
					if(LOWORD(wParam)==IDM_YELLOW)	TabColor=TABCOLOR_YELLOW;
					if(LOWORD(wParam)==IDM_USER_COLOR) TabColor=colorUser;
					InvalidateRect(GetDlgItem(hwnd,IDC_COLOR_BUTTON),NULL,0);
					return 1;
			}
			break;
	}
	return 0;
}

BOOL CALLBACK DlgLinkFile(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int i;
	HWND hListView;
	char temporary[255];
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);



			///////////////////////////
			// J̐ݒ
			///////////////////////////

			//gX^C
			DWORD dwStyle;
			hListView=GetDlgItem(hwnd,IDC_EXTENSION_LIST);
			dwStyle=ListView_GetExtendedListViewStyle(hListView);
			dwStyle|=LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_CHECKBOXES;
			ListView_SetExtendedListViewStyle(hListView,dwStyle);

			LV_COLUMN ListView_Column;
			ListView_Column.mask=LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			ListView_Column.fmt=LVCFMT_LEFT;

			ListView_Column.cx=50;
			ListView_Column.pszText="gq";
			ListView_Column.iSubItem=0;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=150;
			ListView_Column.pszText="";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=90;
			ListView_Column.pszText="Windows";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=80;
			ListView_Column.pszText="^u̐F";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);


			pobj_nv->pobj_ExtLink->ResetListView(hListView);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_ADD_BUTTON:
					if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_EXTENSION_ADD),hwnd,(DLGPROC)DlgFileLinkAdd,0)) return 1;

					pobj_nv->pobj_ExtLink->ResetListView(GetDlgItem(hwnd,IDC_EXTENSION_LIST));

					return 1;
				case IDC_EDIT_BUTTON:
					hListView=GetDlgItem(hwnd,IDC_EXTENSION_LIST);

					for(i=0;i<ListView_GetItemCount(hListView);i++){
						if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
							break;
						}
					}
					if(i==ListView_GetItemCount(hListView)) return 1;

					if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_EXTENSION_ADD),hwnd,(DLGPROC)DlgFileLinkAdd,(LPARAM)pobj_nv->pobj_ExtLink->ppobj_ExtItems[i])) return 1;

					pobj_nv->pobj_ExtLink->ResetListView(GetDlgItem(hwnd,IDC_EXTENSION_LIST));

					return 1;
				case IDC_DELETE_BUTTON:
					hListView=GetDlgItem(hwnd,IDC_EXTENSION_LIST);

					for(i=0;i<ListView_GetItemCount(hListView);i++){
						if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
							ListView_GetItemText(hListView,i,0,temporary,255);

							char temp2[255];
							sprintf(temp2,"%s Xg폜܂B",temporary);
							if(MessageBox(hwnd,temp2,APPLICATION_NAME,MB_OKCANCEL)==IDCANCEL) return 1;

							ListView_DeleteItem(hListView,i);

							pobj_nv->pobj_ExtLink->del(temporary);
							break;
						}
					}
					return 1;
				case IDOK:
					hListView=GetDlgItem(hwnd,IDC_EXTENSION_LIST);

					for(i=0;i<ListView_GetItemCount(hListView);i++){
						pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_bReg=ListView_GetCheckState(hListView,i);
					}

					if(MessageBox(hwnd,"w肳ꂽeŊgqɊւ郌WXgL[o^܂B낵łH",APPLICATION_NAME,MB_YESNO)==IDNO)
						return 1;

					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					hListView=GetDlgItem(hwnd,IDC_EXTENSION_LIST);

					for(i=0;i<ListView_GetItemCount(hListView);i++){
						pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_bReg=ListView_GetCheckState(hListView,i);
					}
					EndDialog(hwnd,0);
					return 1;
			}
			break;
		case WM_NOTIFY:
			hListView=GetDlgItem(hwnd,IDC_EXTENSION_LIST);

			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(hdr->hwndFrom==hListView&&hdr->code==NM_DBLCLK){
				SendMessage(hwnd,WM_COMMAND,IDC_EDIT_BUTTON,0);
			}
			break;
	}
	return 0;
}

HKEY ClassRoot_CreateKey(char *path,char *lpszData){
	HKEY hKey;
	RegCreateKeyEx(HKEY_CLASSES_ROOT,path,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
	RegSetValueEx(hKey,NULL,0,REG_SZ,(const unsigned char *)lpszData,lstrlen(lpszData));
	return hKey;
}
void ExtensionLink(HWND hwnd){
	int i;
	HKEY hKey;

	//Ԃ̏dNŊ֘At쓮Ȃ悤ɂ
	pobj_nv->save();

	if(DialogBox(hResInst,MAKEINTRESOURCE(IDD_EXTENSION_LINK),hwnd,(DLGPROC)DlgLinkFile)==0) return;

	char szApplicationPath[MAX_PATH];
	GetModuleFileName(hInst,szApplicationPath,MAX_PATH);

	char temporary[MAX_PATH],temp2[255],temp3[255];
	for(i=0;i<pobj_nv->pobj_ExtLink->iExtItemNum;i++){
		if(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_bReg==0) continue;

		//u.gqvL[
		sprintf(temp2,".%s",pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension);
		sprintf(temp3,"%sfile",pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension);
		hKey=ClassRoot_CreateKey(temp2,temp3);

		sprintf(temp2,"text/plain",pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension);
		RegSetValueEx(hKey,"Content Type",0,REG_SZ,(const unsigned char *)temp2,lstrlen(temp2));

		RegCloseKey(hKey);


		if(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_bWindowsSearch){
			//ΏۂɊ܂߂
			sprintf(temporary,".%s\\PersistentHandler",pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension);
			hKey=ClassRoot_CreateKey(temporary,"{5e941d80-bf96-11cd-b579-08002b30bfeb}");
			RegCloseKey(hKey);
		}
		else{
			//ΏۂɊ܂߂Ȃ
			sprintf(temporary,".%s\\PersistentHandler",pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension);
			RegDeleteKey(HKEY_CLASSES_ROOT,temporary);
		}


		//
		RegCreateKeyEx(HKEY_CLASSES_ROOT,temp3,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
		RegSetValueEx(hKey,NULL,0,REG_SZ,
			(const unsigned char *)pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szNote,
			lstrlen(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szNote));
		RegCloseKey(hKey);


		//AvP[VpX
		sprintf(temporary,"\"%s\" \"%%1\"",szApplicationPath);
		sprintf(temp2,"%s\\shell\\open\\command",temp3);
		RegCreateKeyEx(HKEY_CLASSES_ROOT,temp2,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
		RegSetValueEx(hKey,NULL,0,REG_SZ,(const unsigned char *)temporary,lstrlen(temporary));
		RegCloseKey(hKey);


#ifndef THETEXT
		/////////////////////
		// ACRݒ
		// ProjectEditor̂
		/////////////////////

		sprintf(temp2,"%s\\DefaultIcon",temp3);
		if(lstrcmpi(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension,"bas")==0){
			sprintf(temporary,"\"%s\",8",szApplicationPath);
			RegCreateKeyEx(HKEY_CLASSES_ROOT,temp2,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
			RegSetValueEx(hKey,NULL,0,REG_SZ,(const unsigned char *)temporary,lstrlen(temporary));
			RegCloseKey(hKey);
		}
		if(lstrcmpi(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension,"ab")==0||
			lstrcmpi(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension,"abp")==0){
			sprintf(temporary,"\"%s\",8",szApplicationPath);
			RegCreateKeyEx(HKEY_CLASSES_ROOT,temp2,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
			RegSetValueEx(hKey,NULL,0,REG_SZ,(const unsigned char *)temporary,lstrlen(temporary));
			RegCloseKey(hKey);
		}
		if(lstrcmpi(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension,"sbp")==0){
			sprintf(temporary,"\"%s\",9",szApplicationPath);
			RegCreateKeyEx(HKEY_CLASSES_ROOT,temp2,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
			RegSetValueEx(hKey,NULL,0,REG_SZ,(const unsigned char *)temporary,lstrlen(temporary));
			RegCloseKey(hKey);
		}
		if(lstrcmpi(pobj_nv->pobj_ExtLink->ppobj_ExtItems[i]->m_szExtension,"pj")==0){
			sprintf(temporary,"\"%s\",7",szApplicationPath);
			RegCreateKeyEx(HKEY_CLASSES_ROOT,temp2,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKey,NULL);
			RegSetValueEx(hKey,NULL,0,REG_SZ,(const unsigned char *)temporary,lstrlen(temporary));
			RegCloseKey(hKey);
		}
#endif
	}

	//ACR̊֘Atuɔf
	SHChangeNotify( SHCNE_ASSOCCHANGED, SHCNF_IDLIST, NULL, NULL );
}
