#include "common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

ParamImpl::ParamImpl(const char *buffer){
	///////////////////////////
	// p[^𐮗
	///////////////////////////

	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[VN_SIZE];

	i=0;
	ParmsNum=0;
	while(1){
		if(buffer[i]=='\0') break;

		for(i2=0;;i2++,i++){
			if(buffer[i]=='\"'){
				temporary[i2]=buffer[i];
				for(i++,i2++;;i++,i2++){
					temporary[i2]=buffer[i];
					if(buffer[i]=='\"') break;
				}
				continue;
			}

			if(buffer[i]=='('){
				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}

			if(buffer[i]==','||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(Parms[ParmsNum],temporary);
		ParmsNum++;

		if(buffer[i]==',') i++;
	}

	ReturnTypeInfo.type=DEF_NON;
	ReturnTypeInfo.u.lpIndex=-1;
}
ParamImpl::ParamImpl(const PARAMETER_INFO *pParamInfo,const int ParmNum){
	int i;
	for(i=0;i<ParmNum;i++){
		Parms[i]=0;
		types[i].type=pParamInfo[i].type;
		types[i].u.lpIndex=pParamInfo[i].u.index;
	}
	this->ParmsNum=ParmNum;

	ReturnTypeInfo.type=DEF_NON;
	ReturnTypeInfo.u.lpIndex=-1;
}
ParamImpl::~ParamImpl(){
	int i2;

	//p[^
	for(i2=0;i2<ParmsNum;i2++){
		if(Parms[i2]==(char *)-1) continue;

		if(Parms[i2]) HeapDefaultFree(Parms[i2]);
	}
}

void ParamImpl::SetReturnType(TYPEINFO *pTypeInfo){
	ReturnTypeInfo=*pTypeInfo;
}

BOOL ParamImpl::_overload_check(PARAMETER_INFO *ppi,int pi_num,TYPEINFO *pReturnTypeInfo,int overload_level){
	//p[^ʂăI[o[[h

	//p[^̌sv̏ꍇ
	if(pi_num!=ParmsNum) return 0;

	int i,type;
	LONG_PTR lpIndex;
	for(i=0;i<pi_num;i++){
		if(Parms[i]){
			TYPEINFO BaseType={ppi[i].type,ppi[i].u.index};
			type=NumOpe_GetType(Parms[i],
				(overload_level==OVERLOAD_LEVEL0) ? NULL : &BaseType,
				&lpIndex);
		}
		else{
			type=types[i].type;
			lpIndex=types[i].u.lpIndex;
		}

		if(type!=ppi[i].type){
			if(overload_level==OVERLOAD_LEVEL1 || overload_level == OVERLOAD_LEVEL0){
				return 0;
			}
			else if(overload_level==OVERLOAD_LEVEL2){
				if(!(
					IsWholeNumberType(type)&&IsWholeNumberType(ppi[i].type)||
					IsRealNumberType(type)&&IsRealNumberType(ppi[i].type)
					)) return 0;
			}
			else if(overload_level==OVERLOAD_LEVEL3){
				if(type==DEF_OBJECT||ppi[i].type==DEF_OBJECT) return 0;
			}
		}
		else{
			if(NATURAL_TYPE(type)==DEF_OBJECT || NATURAL_TYPE(type)==DEF_STRUCT){
				if(lpIndex!=ppi[i].u.index) return 0;
			}
		}
	}

	if(pReturnTypeInfo){
		//߂lrΏۂɂ
		if(ReturnTypeInfo.type==pReturnTypeInfo->type){
			if(NATURAL_TYPE(ReturnTypeInfo.type)==DEF_OBJECT
				|| NATURAL_TYPE(ReturnTypeInfo.type)==DEF_STRUCT ){
					if(ReturnTypeInfo.u.lpIndex != pReturnTypeInfo->u.lpIndex) return 0;
			}
		}
		else return 0;
	}

	return 1;
}

SUBINFO *ParamImpl::OverloadSolutionWithReturnType( const char *name, std::vector<SUBINFO *> &subs ){
	int sw=0;
	SUBINFO *psi;
	psi=0;

	for( int level=OVERLOAD_MIN_LEVEL; level<=OVERLOAD_MAX_LEVEL; level++ ){
		foreach( SUBINFO *temp_psi, subs ){

			TYPEINFO ReturnTypeInfo;
			ReturnTypeInfo.type=temp_psi->ReturnType;
			ReturnTypeInfo.u.lpIndex=temp_psi->u.ReturnIndex;

			//G[`FbN
			if(_overload_check(temp_psi->pParmInfo,temp_psi->ParmNum,&ReturnTypeInfo,level)){
				if(sw){
					SetError(52,name,cp);
					return 0;
				}
				sw=1;

				psi = temp_psi;
				break;
			}
		}

		if( sw ) break;
	}

	if(!sw){
		SetError(52,name,cp);
		return 0;
	}

	return psi;
}
SUBINFO *ParamImpl::OverloadSolution( const char *name, std::vector<SUBINFO *> &subs ){
	int sw=0;
	SUBINFO *psi;
	psi=0;

	for( int level=OVERLOAD_MIN_LEVEL; level<=OVERLOAD_MAX_LEVEL; level++ ){

		foreach( SUBINFO *temp_psi, subs ){

			//G[`FbN
			if(_overload_check(temp_psi->pParmInfo,temp_psi->ParmNum,NULL,level)){
				if(sw){
					return OverloadSolutionWithReturnType(name,subs);
				}
				sw=1;

				psi = temp_psi;
			}
		}

		if( sw ) break;
	}

	if(!sw){
		SUBINFO *temp_psi;
		foreach( temp_psi, subs ){

			//G[`FbN
			if(temp_psi->ParmNum==this->ParmsNum){
				if(sw){
					sw=0;
					break;
				}
				sw=1;

				psi=temp_psi;
			}
		}
	}

	if(!sw){
		SetError(52,name,cp);
		return 0;
	}

	return psi;
}

BOOL ParamImpl::ErrorCheck(const char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum){
	if(ParmsNum>pi_num){
		if(ppi[pi_num-1].type!=DEF_ELLIPSE){
			//p[^Ƃ
			SetError(10,FuncName,cp);
			return 0;
		}
	}
	else if(ParmsNum<pi_num){
		if(ParmsNum<SecondParmNum){
			if(ppi[ParmsNum].type==DEF_ELLIPSE){
				return 1;
			}

			//p[^ȂƂ
			SetError(10,FuncName,cp);
			return 0;
		}

		//ȗp[^ "0" w肷
		for(;ParmsNum < pi_num;ParmsNum++){
			extern HANDLE hHeap;
			char temporary[64];
			if(ppi[ParmsNum].bByVal) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[ParmsNum],temporary);
		}
	}

	return 1;
}

void ParamImpl::MacroParameterSupport(PARAMETER_INFO *ppi){
	int i;
	for(i=0;i<ParmsNum;i++){
		if(Parms[i][0]=='\0'){
			extern HANDLE hHeap;
			char temporary[64];
			if(ppi[i].bByVal) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			HeapDefaultFree(Parms[i]);
			Parms[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[i],temporary);
		}
	}
}
