#include "common.h"

const int Type::basicTypeList[] = {
	DEF_BYTE,
	DEF_SBYTE,
	DEF_WORD,
	DEF_INTEGER,
	DEF_DWORD,
	DEF_LONG,
	DEF_QWORD,
	DEF_INT64,

	DEF_SINGLE,
	DEF_DOUBLE,

	DEF_BOOLEAN,

	DEF_PTR_VOID,

	DEF_ANY,

	DEF_NON
};

const string Type::basicTypeNameList[] = {
	"Byte",
	"SByte",
	"Word",
	"Integer",
	"DWord",
	"Long",
	"QWord",
	"Int64",

	"Single",
	"Double",

	"Boolean",

	"VoidPtr",

	"Any",

	""
};

bool Type::StringToBasicType( const string &typeName, int &basicType ){
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeNameList[i] == typeName ){
			basicType = basicTypeList[i];
			return true;
		}
	}
	return false;
}
bool Type::StringToType( const string &typeName, Type &type ){
	type.index = -1;

	if( typeName[0] == '*' ){
		if( typeName.size() >= 3
			&& typeName[1] == 1 && ( typeName[2] == ESC_FUNCTION || typeName[2] == ESC_SUB ) ){
				//֐|C^i*Functionj
				type.basicType = DEF_PTR_PROC;
		}

		string nextTypeName = typeName.substr( 1 );

		if( !StringToType( nextTypeName, type ) ){
			return false;
		}

		type.PtrLevelUp();

		return true;
	}

	if( StringToBasicType( typeName, type.basicType ) ){
		// {^Ƃ
		return true;
	}


	////////////////////
	// TypeDefꂽ^
	////////////////////
	int i=pobj_DBTypeDef->check( typeName.c_str() );
	if(i!=-1){
		return StringToType( pobj_DBTypeDef->ppobj_TypeDef[i]->lpszBaseName, type );
	}

	//NX
	CClass *pobj_c = pobj_DBClass->check( typeName.c_str() );
	if(pobj_c){
		type.pClass = pobj_c;

		if( pobj_c->IsStructure() ){
			type.basicType = DEF_STRUCT;
		}
		else{
			type.basicType = DEF_OBJECT;
		}
		return true;
	}

	return false;
}
