#include "Type.h"

#ifndef _ACTIVEBASIC_COMPILER_PARAMETER_H
#define _ACTIVEBASIC_COMPILER_PARAMETER_H

class Parameter;
typedef vector<Parameter> Parameters;

class Parameter : public Type
{
	string varName;
	bool isRef;
	bool isArray;
	int subScripts[MAX_ARRAYDIM];

public:
	Parameter( const string &varName, const Type &type, bool isRef = false ):
		Type( type )
	{
		this->varName = varName;
		this->isRef = isRef;
		isArray = false;
	}
	~Parameter(){}

	void SetArray( const int *pSubScripts ){
		isArray = true;
		memcpy( this->subScripts, pSubScripts, sizeof(int) * MAX_ARRAYDIM );
	}

	bool IsRef(){
		return isRef;
	}
	bool IsArray(){
		return isArray;
	}
	int *GetSubScriptsPtr(){
		return subScripts;
	}

	bool Equals( const Parameter &param ) const
	{
		if( Type::Equals( param ) ){
			return true;
		}
		else{

			if( this->isRef && this->BasicType() == DEF_ANY &&
				param.isRef == false && param.IsPointer()
				||
				this->isRef == false && this->IsPointer() &&
				param.isRef && param.BasicType() == DEF_ANY ){
					/* ByRef var As Any
							
						var As VoidPtr
						͓
					*/
					return true;
			}
		}

		return false;
	}


	static bool Equals( const Parameters &paramsA, const Parameters paramsB ){
		if( paramsA.size() != paramsB.size() ){
			return false;
		}

		int max = (int)paramsA.size();
		for( int i=0; i<max; i++ ){
			if( !paramsA[i].Equals( paramsB[i] ) ){
				return false;
			}
		}

		return true;
	}
};

#endif //_ACTIVEBASIC_COMPILER_PARAMETER_H