
#ifndef _ACTIVEBASIC_COMPILER_TYPE_H
#define _ACTIVEBASIC_COMPILER_TYPE_H

class Type{
	int basicType;
	union{
		LONG_PTR index;
		CClass *pClass;
	};

	static const int basicTypeList[];
	static const string basicTypeNameList[];

public:

	Type( int basicType ):
	  basicType( basicType ),
	  index( -1 ){}

	Type( int basicType, LONG_PTR index ):
	  basicType( basicType ),
	  index( index ){}

	Type( int basicType, CClass &objClass ):
	  basicType( basicType ),
	  index( (LONG_PTR)&objClass ){}

	Type( const Type &type ):
	  basicType( type.basicType ),
	  index( type.index ){}

	int BasicType() const
	{
		return basicType;
	}
	LONG_PTR GetIndex() const
	{
		return index;
	}
	const CClass &GetClass() const
	{
		return *pClass;
	}

	void PtrLevelUp(){
		PTR_LEVEL_UP( basicType );
	}

	bool Equals( const Type &type ) const
	{
		if( basicType == type.basicType ){
			if( NATURAL_TYPE( basicType ) == DEF_OBJECT
				|| NATURAL_TYPE( basicType ) == DEF_STRUCT ){

					if( index == type.index ){
						return true;
					}

			}
			else{
				return true;
			}
		}
		return false;
	}

	bool IsPointer() const
	{
		if(PTR_LEVEL( basicType )|| basicType == DEF_PTR_VOID || basicType == DEF_PTR_PROC
			|| ( basicType & FLAG_PTR ) ){
				return true;
		}

		return false;
	}



	static bool StringToBasicType( const string &typeName, int &basicType );
	static bool StringToType( const string &typeName, Type &type );
};

#endif //_ACTIVEBASIC_COMPILER_TYPE_H