#include "stdafx.h"

Parameter::Parameter( const std::string &varName, const Type &type, bool isRef, const std::string initValue )
	: Type( type )
	, varName( varName )
	, isRef( isRef )
	, isArray( false )
	, initValue( initValue )
{
}

Parameter::Parameter( const Parameter &param, const Type &type )
	: Type( type )
	, varName( param.varName )
	, isRef( param.isRef )
	, isArray( param.isArray )
	, subscripts( param.subscripts )
	, initValue( param.initValue )
{
}

Parameter::Parameter( const Parameter &param )
	: Type( param )
	, varName( param.varName )
	, isRef( param.isRef )
	, isArray( param.isArray )
	, subscripts( param.subscripts )
	, initValue( param.initValue )
{
}

Parameter::Parameter()
{
}

Parameter::~Parameter()
{
}

bool Parameter::Equals( const Parameter &param, bool isContravariant ) const
{
	if( Type::Equals( param ) && this->isRef == param.isRef )
	{
		return true;
	}
	else
	{
		if( this->isRef && this->GetBasicType() == DEF_ANY &&
			param.isRef == false && param.IsPointer()
			||
			this->isRef == false && this->IsPointer() &&
			param.isRef && param.GetBasicType() == DEF_ANY )
		{
			/* ByRef var As Any
					
				var As VoidPtr
				͓
			*/
			return true;
		}
	}

	if( isContravariant )
	{
		// ψ
		if( this->IsContravariant( param ) && this->isRef == param.isRef )
		{
			// ψƂ
			return true;
		}
	}

	return false;
}
bool Parameter::Equals( const Types &actualTypeParametersForThisProc, const Parameter &param, bool isContravariant ) const
{
	if( Equals( param, isContravariant ) )
	{
		return true;
	}
	
	if( this->IsTypeParameter() )
	{
		// ^p[^Ƃ
		if( actualTypeParametersForThisProc[this->GetFormalTypeIndex()].Equals( param ) )
		{
			// ߂l
			return true;
		}
	}

	return false;
}

bool Parameters::Equals( const Parameters &params, bool isContravariant ) const
{
	if( this->size() != params.size() ){
		return false;
	}

	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		if( !(*this)[i]->Equals( *params[i], isContravariant ) ){
			return false;
		}
	}

	return true;
}
bool Parameters::Equals( const Types &actualTypeParametersForThisProc, const Parameters &params, bool isContravariant ) const
{
	if( this->size() != params.size() ){
		return false;
	}

	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		if( !(*this)[i]->Equals( actualTypeParametersForThisProc, *params[i], isContravariant ) ){
			return false;
		}
	}

	return true;
}
