#include "stdafx.h"

using namespace ActiveBasic::Compiler;

void LexicalAnalyzer::CollectDelegates( const char *source, Delegates &delegates )
{
	int i2;
	char temporary[VN_SIZE];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// Imports̃NA
	compiler.GetNamespaceSupporter().ClearImportedNamespaces();

	int length = lstrlen( source );
	for( int i=0; i<length; i++ )
	{
		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,i );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED )
		{
			// Imports̃NA
			compiler.GetNamespaceSupporter().ClearImportedNamespaces();
			continue;
		}

		else if( source[i] == 1 && source[i+1] == ESC_DELEGATE )
		{
			int nowLine = i;

			i += 2;
			if( !( source[i] == 1 && ( source[i+1] == ESC_SUB || source[i+1] == ESC_FUNCTION ) ) )
			{
				compiler.errorMessenger.Output(1,NULL,i);
				continue;
			}

			Procedure::Kind procKind = Procedure::Sub;
			if( source[i+1] == ESC_FUNCTION )
			{
				procKind = Procedure::Function;
			}
			i += 2;

			// O
			char name[VN_SIZE];
			GetIdentifierToken( name, source, i );

			if( source[i] != '(' )
			{
				compiler.errorMessenger.Output(1,NULL,nowLine);
				continue;
			}

			// p[^
			char paramStr[8192];
			i += GetStringInPare( paramStr, source + i, true );

			// ߂ľ^̕
			char returnTypeName[VN_SIZE] = "";
			if( source[i] == 1 && source[i+1] == ESC_AS )
			{
				i += 2;
				GetCommandToken( returnTypeName, source, i );

				if( procKind != Procedure::Function )
				{
					compiler.errorMessenger.Output(38,name,nowLine);
				}
			}
			else
			{
				if( procKind == Procedure::Function )
				{
					compiler.errorMessenger.Output(-104,name,nowLine);
					lstrcpy( returnTypeName, "Double" );
				}
			}

			delegates.Put( new Delegate( Symbol( namespaceScopes, name ), compiler.GetNamespaceSupporter().GetImportedNamespaces(), procKind, paramStr, returnTypeName, nowLine ) );
		}
	}
}

std::string LexicalAnalyzer::GenerateDelegatesSourceCode( const Delegates &delegates )
{
	std::string destSource = "";

	Jenga::Common::SourceTemplate sourceTemplate( ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\templates\\delegate_class.tab" );

	delegates.Iterator_Reset();
	while( delegates.Iterator_HasNext() )
	{
		const Delegate &dg = *delegates.Iterator_GetNext();

		if( dg.IsExternal() )
		{
			// ÓINCȕꍇ͔΂iɃCX^X`ς݂ł邽߁j
			continue;
		}

		std::map<std::string,std::string> values;

		if( dg.GetNamespaceScopes().size() )
		{
			std::string namespaceScopesCommandStr = "";
			std::string endNamespaceScopesCommandStr = "";
			BOOST_FOREACH( const std::string &namespaceStr, dg.GetNamespaceScopes() )
			{
				if( namespaceScopesCommandStr.size() )
				{
					namespaceScopesCommandStr += ":";
					endNamespaceScopesCommandStr += ":";
				}
				namespaceScopesCommandStr += "Namespace " + namespaceStr;
				endNamespaceScopesCommandStr += "End Namespace";
			}

			values.insert( std::map<std::string,std::string>::value_type(
				"#namespace_begin#",
				namespaceScopesCommandStr
			) );
			values.insert( std::map<std::string,std::string>::value_type(
				"#namespace_end#",
				endNamespaceScopesCommandStr
			) );
		}
		else
		{
			values.insert( std::map<std::string,std::string>::value_type( "#namespace_begin#", "" ) );
			values.insert( std::map<std::string,std::string>::value_type( "#namespace_end#", "" ) );
		}

		values.insert( std::map<std::string,std::string>::value_type( "#name#", dg.GetName() ) );

		if( dg.IsFunction() )
		{
			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_begin#",
				(std::string)"Function Call(" + dg.GetParamStr() + ") As " + dg.GetReturnTypeName()
			) );

			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_end#",
				"End Function"
			) );

			values.insert( std::map<std::string,std::string>::value_type( "#result#", "Call=" ) );
		}
		else
		{
			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_begin#",
				(std::string)"Sub Call(" + dg.GetParamStr() + ")"
			) );

			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_end#",
				"End Sub"
			) );

			values.insert( std::map<std::string,std::string>::value_type( "#result#", "" ) );
		}

		// Ăяo̎쐬
		Jenga::Common::Strings paramVarNames;
		LexicalAnalyzer::ExtractParameterVarNames( dg.GetParamStr().c_str(), paramVarNames, dg.GetSourceIndex() );
		std::string tempParamStrForCall;
		BOOST_FOREACH( const std::string &varName, paramVarNames )
		{
			if( !tempParamStrForCall.empty() )
			{
				tempParamStrForCall += ",";
			}
			tempParamStrForCall += varName;
		}
		values.insert( std::map<std::string,std::string>::value_type( "#params#", tempParamStrForCall ) );

		destSource += sourceTemplate.GetResult( values );
	}
/*
	std::ofstream ofs( ( Jenga::Common::Environment::GetAppDir() + "\\generated_delegate_code.log" ).c_str() );
	ofs << destSource;
	ofs.close();
	*/

	return destSource;
}

void LexicalAnalyzer::RefleshDelegateParameterAndReturnType( Delegate &dg )
{
	if( dg.IsExternal() )
	{
		// OQƂ̏ꍇ̓tbVsv
		return;
	}

	compiler.GetNamespaceSupporter().SetImportedNamespaces( dg.GetImportedNamespaces() );
	compiler.GetNamespaceSupporter().SetLivingNamespaceScopes( dg.GetNamespaceScopes() );

	// p[^
	Jenga::Common::Strings parameterStrings;
	SplitParameter( dg.GetParamStr(), parameterStrings );
	ActiveBasic::Compiler::LexicalAnalyzer::AnalyzeParameter( dg.GetParameters(), parameterStrings, dg.GetSourceIndex() );

	// Ip[^
	dg.GetDynamicParams() = dg.GetParameters();
	dg.GetDynamicParams().insert( dg.GetDynamicParams().begin(), new Parameter( "_System_LocalThis", Type( DEF_PTR_VOID ) ) );

	if( dg.IsFunction() )
	{
		// ߂l擾
		Type returnType;
		if( !compiler.StringToType( dg.GetReturnTypeName(), returnType ) )
		{
			compiler.errorMessenger.Output(3,dg.GetReturnTypeName(),dg.GetSourceIndex());
		}
		else
		{
			dg.SetReturnType( returnType );
		}
	}
}

void LexicalAnalyzer::RefleshDelegatesParameterAndReturnType( Delegates &delegates )
{
	delegates.Iterator_Reset();
	while( delegates.Iterator_HasNext() )
	{
		Delegate &dg = *delegates.Iterator_GetNext();
		RefleshDelegateParameterAndReturnType( dg );
	}
}
