#include "stdafx.h"


using namespace ActiveBasic::Common::Lexical;


NamespaceScopes::NamespaceScopes( const std::string &namespaceStr ){
	if( namespaceStr.size() == 0 ){
		return;
	}

	std::string::size_type i = 0;
	while( true ){
		std::string::size_type i2 = namespaceStr.find( '.', i );

		std::string tempName = namespaceStr.substr( i, i2-i );

		push_back( tempName );

		if( i2 == std::string::npos ){
			break;
		}

		i = i2 + 1;
	}
}

NamespaceScopes NamespaceScopes::operator+ ( const NamespaceScopes &namespaceScopes ) const
{
	NamespaceScopes result = *this;
	BOOST_FOREACH( const std::string &name, namespaceScopes )
	{
		result.push_back( name );
	}
	return result;
}

bool NamespaceScopes::IsEqual( const NamespaceScopes &namespaceScopes ) const
{
	if( this->size() != namespaceScopes.size() )
	{
		return false;
	}

	for( int i=static_cast<int>(this->size()-1); i>=0; i-- )
	{
		if( (*this)[i] != namespaceScopes[i] )
		{
			return false;
		}
	}

	return true;
}

void NamespaceScopesCollection::SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const
{
	NamespaceScopes namespaceScopes( fullName );
	bool hasSimpleName = false;
	while( namespaceScopes.size() > 0 ){
		if( IsExist( namespaceScopes ) ){
			break;
		}
		namespaceScopes.pop_back();

		hasSimpleName = true;
	}

	strcpy( namespaceStr, namespaceScopes.ToString().c_str() );

	bool hasNamespace = false;
	if( namespaceStr[0] ){
		hasNamespace = true;
	}

	int dotLength = 0;
	if( hasSimpleName && hasNamespace ){
		dotLength = 1;
	}

	strcpy( simpleName, fullName + strlen( namespaceStr ) + dotLength );
}

