#include "stdafx.h"

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;

BOOL IsPtrType(int type){
	if(type==-1) return 0;

	if(PTR_LEVEL(type)||type==DEF_PTR_VOID||type==DEF_PTR_PROC||
		(type&FLAG_PTR) ) return 1;

	return 0;
}
BOOL IsSignedType(int type){
	switch(type){
		case DEF_SBYTE:
		case DEF_INTEGER:
		case DEF_LONG:
		case DEF_INT64:
		case DEF_SINGLE:
		case DEF_DOUBLE:
		case DEF_CHAR:
			return 1;
		default:
			break;
	}
	return 0;
}
BOOL IsNaturalWholeNumberType(int type){
	switch(type){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_INTEGER:
		case DEF_WORD:
		case DEF_LONG:
		case DEF_DWORD:
		case DEF_INT64:
		case DEF_QWORD:
		case DEF_CHAR:
			return 1;
		default:
			break;
	}
	return 0;
}
BOOL IsWholeNumberType(int type){
	return (
		IsNaturalWholeNumberType(type)
		|| IsPtrType(type)
		|| type == DEF_BOOLEAN
		);
}
BOOL IsRealNumberType(int type){
	switch(type){
		case DEF_DOUBLE:
		case DEF_SINGLE:
			return 1;
		default:
			break;
	}
	return 0;
}
BOOL Is64Type(int type){
	switch(type){
		case DEF_INT64:
		case DEF_QWORD:
			return 1;
		default:
			break;
	}
#ifdef _AMD64_
	return IsPtrType(type);
#else
	return 0;
#endif
}
int GetSignedType(int type){
	switch(type){
		case DEF_BYTE:
			return DEF_SBYTE;
		case DEF_WORD:
			return DEF_INTEGER;
		case DEF_DWORD:
			return DEF_LONG;
		case DEF_QWORD:
			return DEF_INT64;
		default:
			break;
	}
#ifdef _AMD64_
	if(IsPtrType(type)) return DEF_INT64;
#else
	if(IsPtrType(type)) return DEF_LONG;
#endif
	return type;
}
int GetUnsignedType(int type){
	switch(type){
		case DEF_SBYTE:
			return DEF_BYTE;
		case DEF_INTEGER:
			return DEF_WORD;
		case DEF_LONG:
			return DEF_DWORD;
		case DEF_INT64:
			return DEF_QWORD;
		case DEF_CHAR:
			if( compiler.IsUnicode() ) return DEF_WORD;
			return DEF_BYTE;
	}
	return type;
}
int GetPtrType(int type){
	return MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)+1);
}
BOOL GetTypeName(int type,LONG_PTR lpIndex,char *name){
	if(PTR_LEVEL(type)){
		//|C^^
		name[0]='*';
		return GetTypeName(MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)-1),lpIndex,name+1);
	}

	//^
	if(type==DEF_SBYTE)				lstrcpy(name,"SByte");
	else if(type==DEF_BYTE)			lstrcpy(name,"Byte");
	else if(type==DEF_INTEGER)		lstrcpy(name,"Integer");
	else if(type==DEF_WORD)			lstrcpy(name,"Word");
	else if(type==DEF_LONG)			lstrcpy(name,"Long");
	else if(type==DEF_DWORD)		lstrcpy(name,"DWord");
	else if(type==DEF_INT64)		lstrcpy(name,"Int64");
	else if(type==DEF_QWORD)		lstrcpy(name,"QWord");

	//^
	else if(type==DEF_SINGLE)		lstrcpy(name,"Single");
	else if(type==DEF_DOUBLE)		lstrcpy(name,"Double");

	//^
	//else if(type==DEF_CHAR)				lstrcpy(name,"Char");

	//bool^
	else if(type==DEF_BOOLEAN)		lstrcpy(name,"Boolean");

	//IuWFNg
	else if(type==DEF_OBJECT || type==DEF_STRUCT){
		if(lpIndex==0) lstrcpy(name,"non");
		else{
			lstrcpy(name,((CClass *)lpIndex)->GetName().c_str());
		}
	}

	//|C^^
	else if(type==DEF_PTR_VOID)		lstrcpy(name,"VoidPtr");

	else if(type==DEF_PTR_PROC){
		if(lpIndex==-1) lstrcpy(name,"VoidPtr");
		else{
			if( compiler.GetObjectModule().meta.GetProcPointers()[lpIndex]->ReturnType().IsNull() )
				lstrcpy(name,"*Sub");
			else lstrcpy(name,"*Function");
		}
	}

	else{
		extern int cp;
		compiler.errorMessenger.Output(1,NULL,cp);
		return 0;
	}
	return 1;
}

Type GetStringTypeInfo(){
	Type type( DEF_OBJECT, *compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr() );
	return type;
}

void GetWithName(char *buffer){
	extern WithInfos withInfos;
	buffer[0]=0;
	BOOST_FOREACH( const WithInfo &withInfo, withInfos )
	{
		lstrcat( buffer, withInfo.name.c_str() );
	}
}

void GetWithName(std::string& buffer){
	extern WithInfos withInfos;
	std::string tmp;
	tmp.reserve(1024);
	BOOST_FOREACH( const WithInfo &withInfo, withInfos )
	{
		tmp+=withInfo.name;
	}
	tmp.swap(buffer);
}

void GetArrange(char *variable,char *variAnswer, Subscripts &subscripts ){
	extern int cp;
	int i,i2,i4;
	double dbl;
	_int64 i64data;
	BOOL bBracket;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(variable[i]=='('||variable[i]=='['){
			if(variable[i]=='[') bBracket=1;
			else bBracket=0;

			variAnswer[i]=0;
			for(i++,i2=0;;i++,i2++){
				if(variable[i]==','){
					temporary[i2]=0;

					Type resultType;
					if( !StaticCalculation(true, temporary,0,&i64data,resultType) ){
						return;
					}
					if(resultType.IsReal()){
						memcpy(&dbl,&i64data,sizeof(double));
						i64data=(_int64)dbl;
					}

					if(i64data<0)
					{
						//error
						subscripts.push_back( 0 );
					}
					else
					{
						subscripts.push_back( (int)i64data );
					}
					i2=-1;
					continue;
				}
				if(variable[i]=='('){
					i4=GetStringInPare(temporary+i2,variable+i);
					i2+=i4-1;
					i+=i4-1;
					continue;
				}
				if(variable[i]=='['){
					i4=GetStringInBracket(temporary+i2,variable+i);
					i2+=i4-1;
					i+=i4-1;
					continue;
				}
				if(variable[i]==')'&&bBracket==0||
					variable[i]==']'&&bBracket){
					temporary[i2]=0;
					if(i2==0){
						subscripts.push_back( -2 );
						break;
					}

					Type resultType;
					if( !StaticCalculation(true, temporary,0,&i64data,resultType) ){
						return;
					}
					if(resultType.IsReal()){
						memcpy(&dbl,&i64data,sizeof(double));
						i64data=(_int64)dbl;
					}

					if(i64data<0){
						//error
						subscripts.push_back( 0 );
					}
					else
					{
						subscripts.push_back( (int)i64data );
					}
					break;
				}
				if(variable[i]=='\"'){
					compiler.errorMessenger.Output(1,NULL,cp);
					return;
				}
				temporary[i2]=variable[i];
			}
			break;
		}
		variAnswer[i]=variable[i];
		if(variable[i]=='\0'){
			break;
		}
	}
}


BOOL GetVarFormatString( char *buffer,char *array,char *array2,char *NestMember,ReferenceKind &refType, PareOrBracket *pPareOrBracket ){
	extern int cp;
	int i,i2,i3;
	char cPare_Open,cPare_Close;

	array[0]=0;
	array2[0]=0;
	NestMember[0]=0;
	for(i=0;;i++){
		if(buffer[i]=='\"'){
			for(i++;;i++){
				if(IsDBCSLeadByte(buffer[i])){
					i++;
					continue;
				}
				if(buffer[i]=='\"') break;
			}
		}
		if(buffer[i]=='['||buffer[i]=='('){
			if(buffer[i]=='['){
				cPare_Open='[';
				cPare_Close=']';
			}
			else{
				cPare_Open='(';
				cPare_Close=')';
			}

			if( pPareOrBracket )
			{
				// []Ȃ̂A()Ȃ̂`
				if( cPare_Open == '[' )
				{
					*pPareOrBracket = Bracket;
				}
				else
				{
					*pPareOrBracket = Pare;
				}
			}

			buffer[i]=0;
			for(i++,i2=0;;i++,i2++){
				if(buffer[i]==cPare_Open){
					if(cPare_Open=='[') i3=GetStringInBracket(array+i2,buffer+i);
					else i3=GetStringInPare(array+i2,buffer+i);
					i+=i3-1;
					i2+=i3-1;
					continue;
				}
				if(buffer[i]==cPare_Close){
					array[i2]=0;
					break;
				}
				array[i2]=buffer[i];
			}
			if(buffer[i+1]==cPare_Open){
				for(i+=2,i2=0;;i++,i2++){
					if(buffer[i]==cPare_Open){
						if(cPare_Open=='[') i3=GetStringInBracket(array2+i2,buffer+i);
						else i3=GetStringInPare(array2+i2,buffer+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}
					if(buffer[i]==cPare_Close){
						array2[i2]=0;
						break;
					}
					array2[i2]=buffer[i];
				}
				if(buffer[i+1]==cPare_Open){
					compiler.errorMessenger.Output(14,buffer,cp);
					return 0;
				}
			}
			continue;
		}
		if(buffer[i]=='.'){
			lstrcpy(NestMember,buffer+i+1);
			refType = RefDot;
			buffer[i]=0;
			break;
		}
		if(buffer[i]==1&&buffer[i+1]==ESC_PSMEM){
			lstrcpy(NestMember,buffer+i+2);
			refType = RefPointer;
			buffer[i]=0;
			break;
		}
		if(buffer[i]=='\0') break;
	}
	return 1;
}

void GetArrayElement( const char *buffer,char *variable,char *array_element){
	array_element[0]=0;

	if(buffer[lstrlen(buffer)-1]!=']'){
		lstrcpy(variable,buffer);
		return;
	}

	int i,i2;
	for(i=0;;i++){
		if(buffer[i]=='\0') break;
		if(buffer[i]=='['){
			i2=GetStringInBracket(array_element,buffer+i);
			i+=i2-1;
			continue;
		}
	}

	lstrcpy(variable,buffer);
	variable[lstrlen(variable)-lstrlen(array_element)]=0;

	RemoveStringBracket(array_element);
}

BOOL CheckVarNameError(char *name,int nowLine){
	int i2;

	if(!IsVariableTopChar(name[0])){
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return 0;
	}
	for(i2=1;;i2++){
		if(name[i2]=='\0') break;
		if(!IsVariableChar(name[i2])){
			compiler.errorMessenger.Output(1,NULL,nowLine);
			return 0;
		}
	}
	return 1;
}

int JumpSubScripts( const Subscripts &subscripts ){
	//DIMŒ`ꂽ񂾔z̐AhXi߂
	int i, i2;
	for( i=0,i2=1; i<(int)subscripts.size(); i++ ){
		i2 *= subscripts[i] + 1;
	}
	return i2;
}


bool GetMemberType( const Type &classType, const char *lpszMember, Type &resultType, BOOL bPrivateAccess, bool isErrorEnabled)
{
	const CClass &objClass = classType.GetClass();

	extern int cp;

	//NXAz̍\vf͂
	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];		//2z
	char NestMember[VN_SIZE];	//qo
	ReferenceKind refType = RefNon;
	lstrcpy(VarName,lpszMember);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember,refType)) return false;

	const Member *pMember = objClass.FindDynamicMember( VarName );
	if( !pMember ){
		if(isErrorEnabled) compiler.errorMessenger.Output(103,VarName,cp);
		return false;
	}

	//ANZVreB`FbN
	if( compiler.IsCompilingClass() && &objClass == &compiler.GetCompilingClass() ){
		//NXIuWFNg̏ꍇ̓vCx[gANZXeF
		if( pMember->IsNoneAccess() ){
			if(isErrorEnabled) compiler.errorMessenger.Output(107,VarName,cp);
			return false;
		}
	}
	else{
		if(( bPrivateAccess==0 && pMember->IsPrivate() )||
			pMember->IsNoneAccess() ){
			if(isErrorEnabled) compiler.errorMessenger.Output(107,VarName,cp);
			return false;
		}
		else if( bPrivateAccess==0 && pMember->IsProtected() ){
			if(isErrorEnabled) compiler.errorMessenger.Output(108,VarName,cp);
			return false;
		}
	}

	resultType = pMember->GetType();

	// ^p[^
	ResolveFormalGenericTypeParameter( resultType, classType );


	//|C^ϐ̏ꍇ
	if( resultType.IsPointer() ){
		if( pMember->GetSubscripts().size() == 0 ){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(isErrorEnabled) compiler.errorMessenger.Output(16,lpszMember,cp);
			return false;
		}
	}

	if(array[0]){
		//zItZbg
		if( pMember->GetSubscripts().size() <= 0 )
		{
			// zł͂Ȃoɔzw
			return false;
		}
	}
	else if( pMember->GetSubscripts().size() > 0 ){
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
	}

	if( refType != RefNon ){
		//q\̏ꍇ

		return GetMemberType( pMember->GetType(),
			NestMember,
			resultType,
			0,
			isErrorEnabled);
	}

	if(lpPtrOffset[0]){
		if( resultType.PtrLevel() ){
			resultType.PtrLevelDown();
		}
		else{
			//G[
			if(isErrorEnabled) compiler.errorMessenger.Output(1,NULL,cp);
			return false;
		}
	}

	return true;
}
bool GetVarType( const char *nameBuffer, Type &resultType, bool isErrorEnabled){
	char variable[VN_SIZE];

	if(nameBuffer[0]=='.'){
		GetWithName(variable);
		lstrcat(variable,nameBuffer);
	}
	else lstrcpy(variable,nameBuffer);

	// OԂ𕪗
	char namespaceStr[VN_SIZE]="", simpleName[VN_SIZE];
	compiler.GetObjectModule().meta.GetNamespaces().SplitNamespace( variable, namespaceStr, simpleName );

	// 擪IuWFNg܂̓NXƓqoɕ
	ReferenceKind refType;
	char member[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];
	GetVarFormatString(simpleName,array,lpPtrOffset,member,refType);

	// OԂ𕪗Ăꍇ͌
	char VarName[VN_SIZE];
	if( namespaceStr[0] ){
		sprintf( VarName, "%s.%s", namespaceStr, simpleName );
	}
	else{
		lstrcpy( VarName, simpleName );
	}

	const Variable *pVar = NULL;

	if( compiler.IsLocalAreaCompiling() ){
		/////////////////
		// [Jϐ
		/////////////////

		pVar = compiler.GetCompilingUserProc().GetLocalVars().BackSearch(
			LexicalAnalyzer::FullNameToSymbol( VarName ),
			compiler.codeGenerator.lexicalScopes.GetNowLevel()
		);
		if( pVar ){
			goto ok;
		}
	}

	if( compiler.IsCompilingClass() ){
		///////////////////////
		// NXo̎Q
		///////////////////////

		if(lstrcmpi(variable,"This")==0){
			//ThisIuWFNg
			resultType.SetType( DEF_OBJECT, &compiler.GetCompilingClass() );
			return true;
		}

		if(memicmp(variable,"This.",5)==0){
			//ThisIuWFNg̃oQƂƂ
			SlideString(variable+5,-5);
			lstrcpy(VarName,variable);
		}
		else{
			//NX̓IoQƂƂiʏj

			if( !compiler.GetCompilingClass().HasDynamicMember( VarName ) )
			{
				goto NonClassMember;
			}
		}

		return GetMemberType(
			Type( DEF_OBJECT, compiler.GetCompilingClass() ),
			variable,
			resultType,
			1,
			isErrorEnabled
		);
	}

NonClassMember:

	//////////////////////////
	// ÓI[Jϐ
	// "Static.Object.Method.Variable"
	//////////////////////////

	char temporary[VN_SIZE];
	if( compiler.IsLocalAreaCompiling() ){
		GetNowStaticVarFullName(VarName,temporary);

		pVar = compiler.GetObjectModule().meta.GetGlobalVars().Find( LexicalAnalyzer::FullNameToSymbol( temporary ) );
		if( pVar ){
			goto ok;
		}
	}


	//////////////////////////
	// NX̐ÓIo
	//////////////////////////

	if(member[0]){
		lstrcpy(temporary,member);
		char tempMember[VN_SIZE];
		char tempArray[VN_SIZE];
		{
			ReferenceKind refType;
			GetVarFormatString(temporary,tempArray,lpPtrOffset,tempMember,refType);
		}

		const TypeDef *pTypeDef = compiler.GetObjectModule().meta.GetTypeDefs().Find( LexicalAnalyzer::FullNameToSymbol( VarName ) );
		if( pTypeDef )
		{
			// TypeDef̌^Ƃ
			lstrcpy( VarName, pTypeDef->GetBaseName().c_str() );
		}

		char temp2[VN_SIZE];
		sprintf(temp2,"%s.%s",VarName,temporary);

		pVar = compiler.GetObjectModule().meta.GetGlobalVars().Find( LexicalAnalyzer::FullNameToSymbol( temp2 ) );
		if( pVar ){
			lstrcpy(member,tempMember);
			lstrcpy(array,tempArray);
			goto ok;
		}
	}

	if( compiler.IsCompilingClass() ){
		//g̃NXÓIoQƂꍇ
		char temp2[VN_SIZE];
		sprintf(temp2,"%s.%s",compiler.GetCompilingClass().GetName().c_str(),VarName);

		pVar = compiler.GetObjectModule().meta.GetGlobalVars().Find( LexicalAnalyzer::FullNameToSymbol( temp2 ) );
		if( pVar ){
			goto ok;
		}
	}


	////////////////////
	// O[oϐ
	////////////////////

	pVar = compiler.GetObjectModule().meta.GetGlobalVars().BackSearch(
		LexicalAnalyzer::FullNameToSymbol( VarName ),
		compiler.codeGenerator.lexicalScopes.GetNowLevel()
	);
	if( pVar ){
		goto ok;
	}

	//ϐƂČȂƂ
	if(isErrorEnabled) compiler.errorMessenger.Output(3,variable,cp);
	return false;

ok:

	//|C^ϐ̏ꍇ
	if( pVar->GetType().IsPointer() ){
		if( !pVar->IsArray() ){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(isErrorEnabled) compiler.errorMessenger.Output(16,variable,cp);
			return false;
		}
	}

	resultType = pVar->GetType();

	if(member[0]){
		if( NATURAL_TYPE( resultType.GetBasicType() )==DEF_OBJECT
			|| NATURAL_TYPE( resultType.GetBasicType() )==DEF_STRUCT)
		{
			return GetMemberType(resultType,member,resultType,0,isErrorEnabled);
		}
	}

	if( array[0] == 0 && pVar->GetSubscripts().size() > 0 ){
		//z̐擪|C^ꍇ
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
	}

	if(lpPtrOffset[0]){
		if( resultType.PtrLevel() ){
			resultType.PtrLevelDown();
		}
		else{
			//G[
			if(isErrorEnabled) compiler.errorMessenger.Output(1,NULL,cp);
			return false;
		}
	}

	return true;
}

bool GetVarOffsetReadOnly(const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType, Subscripts *pResultSubscripts )
{
	//ǂݎpŕϐփANZX
	return GetVarOffset(
		true,		//G[\L
		false,		//݃ANZX͖
		NameBuffer,
		pRelativeVar,
		resultType,
		pResultSubscripts
	);
}
bool GetVarOffsetReadWrite(const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType, Subscripts *pResultSubscripts )
{
	//ǂݏpŕϐփANZX
	return GetVarOffset(
		true,		//G[\L
		true,		//݃ANZX
		NameBuffer,
		pRelativeVar,
		resultType,
		pResultSubscripts
	);
}



bool GetDimentionFormat( const char *buffer,
						char *VarName,
						Subscripts &subscripts,
						Type &type,
						char *InitBuf,
						char *ConstractParameter ){
	int i,i2,i3,IsStr;
	char variable[VN_SIZE],temporary[8192];

	for(i=0;;i++){
		if((buffer[i]==1&&buffer[i+1]==ESC_AS)||
			buffer[i]=='='||
			buffer[i]=='\0'){
			variable[i]=0;
			break;
		}
		variable[i]=buffer[i];
	}

	if(buffer[i]=='='){
		////////////////////////////////////
		// f[^w肳ꂢƂ
		////////////////////////////////////
		i++;

		if( buffer[i]=='[' ){
			// \f[^̏ꍇ

			i3=GetStringInBracket(InitBuf,buffer+i);
			i+=i3;
		}
		else{
			// f[^̏ꍇ

			for(i2=0,IsStr=0;;i++,i2++){
				if(buffer[i]=='\"') IsStr^=1;
				if(buffer[i]=='('&&IsStr==0){
					i3=GetStringInPare(InitBuf+i2,buffer+i);
					i+=i3-1;
					i2+=i3-1;
					continue;
				}
				if(buffer[i]=='['&&IsStr==0){
					i3=GetStringInBracket(InitBuf+i2,buffer+i);
					i+=i3-1;
					i2+=i3-1;
					continue;
				}
				if((buffer[i]==','&&IsStr==0)||
					buffer[i]=='\0'){
					InitBuf[i2]=0;
					break;
				}
				InitBuf[i2]=buffer[i];
			}
		}
	}
	else{
		//f[^Ȃ
		InitBuf[0]=0;
	}

	ConstractParameter[0]=0;
	if(buffer[i]==1&&buffer[i+1]==ESC_AS){
		/////////////////////////////
		// "As `" ɂ^w肠
		/////////////////////////////

		for(i+=2,i2=0;;i++,i2++){
			if(buffer[i]=='('||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		if(temporary[0]=='*'&&
			temporary[1]==1&&
			(temporary[2]==ESC_FUNCTION||temporary[2]==ESC_SUB)){
			if(buffer[i]!='('){
				compiler.errorMessenger.Output(10,temporary,cp);
				return false;
			}
			i3=GetStringInPare(temporary+3,buffer+i);
			i+=i3;
			i2+=i3;

			if(temporary[2]==ESC_FUNCTION&&buffer[i]==1&&buffer[i+1]==ESC_AS){
				temporary[i2++]=buffer[i++];
				temporary[i2++]=buffer[i++];
				for(;;i++,i2++){
					if(!IsVariableChar(buffer[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=buffer[i];
				}
			}
		}

		ActiveBasic::Compiler::Error::StringToTypeErrorCode::EnumType result = compiler.StringToTypeEx( temporary, type, true );
		if( result != ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful )
		{
			if( result == ActiveBasic::Compiler::Error::StringToTypeErrorCode::FailedResolveGenericType )
			{
				compiler.errorMessenger.Output(143,temporary,cp);
			}
			else
			{
				compiler.errorMessenger.Output(3,temporary,cp);
			}
			return false;
		}

		if(buffer[i]=='('){
			//RXgN^ɓnp[^擾
			i2=GetStringInPare(ConstractParameter,buffer+i);
			i+=i2;
			RemoveStringPare(ConstractParameter);

			if( !type.IsObject() ){
				compiler.errorMessenger.Output(112,variable,cp);
				return false;
			}
		}
	}
	else{
		/////////////////
		// AswȂ
		/////////////////

		if( InitBuf[0] == '\0' ){
			//AswAlwȂꍇ
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(variable) );

			i2=lstrlen(variable)-1;
			if(i2>=0){
				if(!(variable[i2]=='#'||variable[i2]=='!'||variable[i2]=='%'||variable[i2]=='$'))
					compiler.errorMessenger.Output(-103,variable,cp);
			}
		}
		else{
			//ľ^𔻕ʂĎIɌ^t
			if( !NumOpe_GetType( InitBuf, GetStringTypeInfo(), type ) ){
				// G[̏ꍇ
				return false;
			}

			if( IS_LITERAL( type.GetIndex() ) ){
				type.SetIndex( -1 );
			}
		}

	}

	if( InitBuf[0] != '\0' && ConstractParameter[0] != '\0' ){
		//lƃRXgN^p[^ɌĂяoĂƂ
		compiler.errorMessenger.Output(132, NULL, cp);
	}

	GetArrange(variable,VarName,subscripts);
	return true;
}

BOOL GetNowStaticVarFullName(char *VarName,char *FullName){
	if( compiler.IsGlobalAreaCompiling() ){
		// O[öRpĈƂ
		return 0;
	}

	const UserProc &proc = compiler.GetCompilingUserProc();

	//Static
	lstrcpy(FullName,"Static%");

	//NX
	if( compiler.IsCompilingClass() ){
		lstrcat(FullName,compiler.GetCompilingClass().GetName().c_str());
		lstrcat(FullName,"%");
	}

	//֐i܂̓\bhj
	lstrcat(FullName,proc.GetName().c_str());
	lstrcat(FullName,"%");

	//ID
	char temp[255];
	sprintf(temp,"%x",proc.GetId());
	lstrcat(FullName,temp);
	lstrcat(FullName,"%");

	//ϐ
	lstrcat(FullName,VarName);

	return 1;
}


void AddGlobalVariable( const char *name, const Subscripts &subscripts, const Type &type,const char *InitBuf,const char *ConstractParameter,DWORD dwFlag){
	/////////////////////////
	// O[oϐǉ
	/////////////////////////

	if( compiler.GetObjectModule().meta.GetGlobalVars().DuplicateCheck( LexicalAnalyzer::FullNameToSymbol( name ), compiler.codeGenerator.lexicalScopes.GetNowLevel() ) ){
		//Qd`̃G[
		compiler.errorMessenger.Output(15,name,cp);
		return;
	}

	bool isConst = ( dwFlag & DIMFLAG_CONST ) ? true:false;

	Variable *pVar = new Variable(
		Symbol( compiler.GetNamespaceSupporter().GetLivingNamespaceScopes(), name ),
		type,
		isConst,
		false,
		ConstractParameter,
		( InitBuf[0] != 0 || dwFlag == DIMFLAG_INITDEBUGVAR )
	);

	if( subscripts.size() > 0 ){
		//z񂠂
		pVar->SetArray( subscripts );
	}

	//LVJXR[v
	pVar->SetScopeLevel( compiler.codeGenerator.lexicalScopes.GetNowLevel() );
	pVar->SetScopeStartAddress( compiler.codeGenerator.lexicalScopes.GetStartAddress() );
	pVar->isLiving = true;

	//G[p
	pVar->source_code_address=cp;

	// ϐǉ
	compiler.GetObjectModule().meta.GetGlobalVars().Add( pVar );

	if(InitBuf[0]){
		int result = 0;
		if( !pVar->GetType().IsObject() ){
			result = SetInitGlobalData(pVar->GetOffsetAddress(),
				pVar->GetType(),
				pVar->GetSubscripts(),
				InitBuf);
		}

		if(!result){
			//IȎꍇ͑Zs

			//̂݁A݃ANZX
			if( isConst ){
				pVar->ConstOff();
			}

			//
			char temporary[8192];
			sprintf(temporary,"%s=%s",name,InitBuf);
			OpcodeCalc(temporary);

			//ANZXɖ߂
			if( isConst ){
				pVar->ConstOn();
			}
		}
	}


	if( type.IsObject() ){
		//fXgN^̗ptOIɂ
		const CMethod *method = type.GetClass().GetDestructorMethod();
		if( method ){
			method->GetUserProc().Using();
		}
	}
}

void dim(char *Parameter,DWORD dwFlags){
	int i2;
	char VarName[VN_SIZE];

	i2 = 0;

	if( Parameter[i2] == 1 && Parameter[i2+1] == ESC_BYREF ){
		//Qƌ^
		compiler.errorMessenger.OutputFatalError();
		Parameter += 2;
	}

	if(dwFlags & DIMFLAG_CONST){

		//////////////////////////////////
		// 萔ϐ̏ꍇl
		//////////////////////////////////
		for(;;i2++){
			if(Parameter[i2] == '=' ||
				Parameter[i2] == 1 && Parameter[i2] == ESC_AS ||
				Parameter[i2] =='('){
					VarName[i2] = 0;
					break;
			}
			VarName[i2] = Parameter[i2];
		}

		//萔ƂQd`ĂȂꍇ͔o
		if(compiler.GetObjectModule().meta.GetGlobalConsts().GetBasicType( ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( VarName ) )){
			return;
		}

		//萔}NƂĒ`Ăꍇ͔o
		if( compiler.GetObjectModule().meta.GetGlobalConstMacros().IsExistDuplicationKeyName( VarName ) )
		{
			return;
		}
	}


	//\
	Type type;
	char InitBuf[8192];
	char ConstractParameter[VN_SIZE];
	Subscripts subscripts;
	if(!GetDimentionFormat(Parameter, VarName,subscripts,type,InitBuf,ConstractParameter))
		return;


	//萔ƂQd`ĂȂ𒲂ׂ
	if(compiler.GetObjectModule().meta.GetGlobalConsts().GetBasicType( ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( VarName ) )){
		compiler.errorMessenger.Output(15,VarName,cp);
		return;
	}

	//萔}NƂĒ`Ăꍇ
	if( compiler.GetObjectModule().meta.GetGlobalConstMacros().IsExistDuplicationKeyName( VarName ) ){
		compiler.errorMessenger.Output(15,VarName,cp);
		return;
	}

	if( type.IsObject() ){
		if( type.GetClass().IsBlittableType() ){
			// Blittable^̂Ƃ͊{^ƂĈ
			// ARpC̃\bhBlittable^NXɑĂȂ
			if( compiler.IsLocalAreaCompiling()
				&& compiler.GetCompilingUserProc().HasParentClass()
				&& compiler.GetCompilingUserProc().GetParentClass().IsBlittableType() )
			{
				// RpC̃\bhBlittable^NXɑĂ
			}
			else{
				type = type.GetClass().GetBlittableType();
			}
		}
	}

	if(dwFlags&DIMFLAG_STATIC)
	{
		if( compiler.IsGlobalAreaCompiling() )
		{
			compiler.errorMessenger.Output(60,NULL,cp);
			return;
		}

		/////////////////////
		// Staticϐ
		// "Static.Object.Method.Variable"
		/////////////////////

		char temporary[VN_SIZE];
		GetNowStaticVarFullName(VarName,temporary);

		dim( temporary,subscripts,type,InitBuf,ConstractParameter,dwFlags );

		/*
		Note: ÓIϐ̃RXgN^Ăяo
			_System_InitStaticLocalVariables֐ňꊇčs
		*/
	}
	else{
		dim( VarName,subscripts,type,InitBuf,ConstractParameter,dwFlags );
	}
}
void OpcodeDim(char *Parameter,DWORD dwFlags){
	int i,i2,i3,IsStr=0;
	char temporary[8192];

	for(i=0,i2=0;;i++,i2++){
		if(Parameter[i]=='\"') IsStr^=1;
		if(Parameter[i]=='('&&IsStr==0){
			i3=GetStringInPare(temporary+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		if(Parameter[i]=='['&&IsStr==0){
			i3=GetStringInBracket(temporary+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		if( Parameter[i] == '<' && IsStr == 0 )
		{
			if( IsGenericTypeSourcePart( Parameter + i ) )
			{
				// WFlNX\
				i3=GetStringInGenericBracket(temporary+i2,Parameter+i);
				i+=i3-1;
				i2+=i3-1;
				continue;
			}
			else
			{
				// ʍ\
			}
		}
		if((Parameter[i]==','&&IsStr==0)||
			Parameter[i]=='\0'){
			temporary[i2]=0;

			dim(temporary,dwFlags);

			if(Parameter[i]=='\0') break;
			i2=-1;
			continue;
		}
		temporary[i2]=Parameter[i];
	}
}

void DebugVariable(void)
{
	char temporary[255];
	if( compiler.GetObjectModule().meta.GetGlobalVars().Find( LexicalAnalyzer::FullNameToSymbol( "_DebugSys_dwThreadID" ) ) == NULL )
	{
		// `̏ꍇ͒`
		sprintf(temporary,"_DebugSys_dwThreadID[255]%c%cDWord",1,ESC_AS);
		OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
		sprintf(temporary,"_DebugSys_ProcNum[255]%c%cDWord",1,ESC_AS);
		OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
		sprintf(temporary,"_DebugSys_lplpObp[255]%c%c*ULONG_PTR",1,ESC_AS);
		OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
		sprintf(temporary,"_DebugSys_lplpSpBase[255]%c%c*ULONG_PTR",1,ESC_AS);
		OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
	}
}
