#include "stdafx.h"

#include "Common.h"

extern HFONT hFont_TextEdit;
extern int font_width,font_height;

class CDrawReserve{
	int x,y;
	COLORREF NowColor,NowBackColor;
	int bNowUnder;
	char *lpszBuffer;
	int length;
	int m_WndNum;
	HDC hdc;
	HBITMAP hMemBmp,hOldBitmap;
	HFONT hOldFont;
	SIZE ClientSize;
	int iControlTabSpace;
	int iOnePage_CharHeight;
	int iLineNumberTextCount;
	int iMax_OneLine_TextLength;
public:
	HDC memdc;
	CDrawReserve(int WndNum,HDC _hDC,int cx,int cy,int ctrl_tab_space,int nMaxOnePageChar,int linenum_textcount){
		m_WndNum=WndNum;
		x=-1;
		y=-1;
		bNowUnder=0;
		hdc=_hDC;
		ClientSize.cx=cx;
		ClientSize.cy=cy;
		iControlTabSpace=ctrl_tab_space;
		iOnePage_CharHeight=nMaxOnePageChar;
		iMax_OneLine_TextLength=cx/font_width+1;
		iLineNumberTextCount=linenum_textcount;
		memdc=CreateCompatibleDC(hdc);
		hMemBmp=CreateCompatibleBitmap(hdc,cx,cy);
		hOldBitmap=(HBITMAP)SelectObject(memdc,hMemBmp);

		//wiFŃʂ
		HBRUSH hBrush,hOldBrush;
		hBrush=CreateSolidBrush(tci.rgbBackground);
		hOldBrush=(HBRUSH)SelectObject(memdc,hBrush);
		PatBlt(memdc,0,0,cx,cy,PATCOPY);
		DeleteObject(hBrush);

		//wirbg}bv
#ifdef THETEXT
		if(pobj_DBTheme->hBackBmp){
			HDC memdc2;
			memdc2=CreateCompatibleDC(memdc);
			SelectObject(memdc2,pobj_DBTheme->hBackBmp);
			BitBlt(memdc,
				cx-(pobj_DBTheme->sizeBackBmp.cx),
				cy-(pobj_DBTheme->sizeBackBmp.cy),
				pobj_DBTheme->sizeBackBmp.cx,pobj_DBTheme->sizeBackBmp.cy,
				memdc2,0,0,SRCCOPY);
			DeleteDC(memdc2);
		}
#endif

		//tHgݒ
		extern HFONT hFont_TextEdit;
		hOldFont=(HFONT)SelectObject(memdc,hFont_TextEdit);

		lpszBuffer=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
		length=0;
	}
	~CDrawReserve(){
		SelectObject(memdc,hOldBitmap);
		DeleteObject(hMemBmp);

		SelectObject(memdc,hOldFont);

		DeleteDC(memdc);

		HeapDefaultFree(lpszBuffer);
	}

	void draw(){
		if(length==0) return;
		SetTextColor(memdc,NowColor);
		if(NowBackColor==tci.rgbBackground){
			SetBkMode(memdc,TRANSPARENT);
		}
		else{
			SetBkMode(memdc,OPAQUE);
			SetBkColor(memdc,NowBackColor);
		}

		HFONT hBeforeFont;
		if(bNowUnder){
			//ttHgɐݒ
			extern HFONT hFont_HyperLink_TextEdit;
			hBeforeFont=(HFONT)SelectObject(memdc,hFont_HyperLink_TextEdit);
		}

		int offset=0;
		if(x<0){
			offset=-x;

			//[̑Sp̕邽߂10oCg̗]T
			offset-=10;
			if(offset<0) offset=0;

			length-=offset;
			if(length<0) return;
		}

		if(length>iMax_OneLine_TextLength+10){
			length=iMax_OneLine_TextLength+10;
		}

		int i;
		int *lpDxWidths;
		lpDxWidths=(int *)malloc((length+1)*sizeof(int));
		for(i=0;i<length+1;i++){
			lpDxWidths[i]=font_width;
		}
		ExtTextOut(memdc,
			(x+offset)*(font_width)     +iControlTabSpace,
			y*font_height,
			0,NULL,
			lpszBuffer+offset,length,
			lpDxWidths);

		if(bNowUnder){
			SelectObject(memdc,hBeforeFont);
		}

		free(lpDxWidths);
	}

	void DrawReserve(int nXStart,int nYStart,COLORREF NextColor,COLORREF NextBackColor,BOOL bUnder,LPSTR lpString,int cbString){
		if(nYStart!=y || NextColor!=NowColor || NextBackColor!=NowBackColor || bUnder!=bNowUnder){
			//`
			draw();

			x=nXStart;
			y=nYStart;
			NowColor=NextColor;
			NowBackColor=NextBackColor;
			bNowUnder=bUnder;

			lpszBuffer[0]=0;
			length=0;
		}

		//\
		lpszBuffer=(char *)HeapReAlloc(hHeap,0,lpszBuffer,length+cbString+1);
		memcpy(lpszBuffer+length,lpString,cbString);
		length+=cbString;
		lpszBuffer[length]=0;
	}

	void finish(int BaseY){
		draw();

		HBRUSH hBrush,hOldBrush;
		if(pobj_nv->bEditor_LineNumber){
			hBrush=CreateSolidBrush(RGB(220,220,220));
			hOldBrush=(HBRUSH)SelectObject(memdc,hBrush);


			/////////////////////////////////////////////////////
			// GfB^ʍ[̃Rg[^u̍sԍ`
			/////////////////////////////////////////////////////

			//DFœhԂ
			PatBlt(memdc,
				0,
				0,
				iControlTabSpace,
				ClientSize.cy,
				PATCOPY);

			extern HFONT hFont_LineNumber;
			int LineNumberFontHeight;

			HFONT hOldFont;
			hOldFont=(HFONT)SelectObject(memdc,hFont_LineNumber);
			SetTextColor(memdc,RGB(60,60,60));
			SetBkColor(memdc,RGB(220,220,220));

			SIZE size;
			GetTextExtentPoint32(memdc,"A",1,&size);
			LineNumberFontHeight=size.cy;


			//u[N|Cg̕`
			BreakPointsPerFile *pobj_FileBreakPoint=0;
			if( projectInfo.IsOpened() ){
				pobj_FileBreakPoint=
					projectInfo.pobj_DBBreakPoint->EnumLines(MdiInfo[m_WndNum]->path.c_str());
			}
			else{
				extern CDBBreakPoint *pobj_DBBreakPoint;
				pobj_FileBreakPoint=pobj_DBBreakPoint->EnumLines(MdiInfo[m_WndNum]->path.c_str());
			}


			int i,i2;
			char temporary[255],temp2[255];
			if(y<iOnePage_CharHeight) i2=y;
			else i2=iOnePage_CharHeight;
			for(i=0;i<=i2;i++){

				BOOL bBreakPoint;
				bBreakPoint=0;
				if(pobj_FileBreakPoint){
					if(pobj_FileBreakPoint->check(i-BaseY)){
						bBreakPoint=1;
					}
				}

				if(bBreakPoint){
					DrawIconEx(memdc,3,i*font_height+(font_height-16)/2,
						(HICON)LoadImage(hIconResInst,MAKEINTRESOURCE(IDI_BREAKPOINT_FLAG),IMAGE_ICON,16,16,LR_SHARED),
						16,16,0,NULL,DI_NORMAL);
				}
				else{
					sprintf(temp2,"%%%dd:",iLineNumberTextCount);
					sprintf(temporary,temp2,(i-BaseY)+1);

					TextOut(memdc,
						3,
						i*font_height+(font_height-LineNumberFontHeight)/2,
						temporary,
						lstrlen(temporary));
				}
			}

			SelectObject(memdc,hOldFont);


			//uVj
			SelectObject(memdc,hOldBrush);
			DeleteObject(hBrush);
		}
		else{
			////////////////////////////////////////////
			// GfB^ʍ[̃Rg[^u`
			// sԍ͔\
			////////////////////////////////////////////

			hBrush=CreateSolidBrush(RGB(220,220,220));
			hOldBrush=(HBRUSH)SelectObject(memdc,hBrush);

			PatBlt(memdc,
				0,
				0,
				iControlTabSpace,
				ClientSize.cy,
				PATCOPY);

			SelectObject(memdc,hOldBrush);
			DeleteObject(hBrush);
		}


		//DC̓eʂɕ`
		BitBlt(hdc,0,0,ClientSize.cx,ClientSize.cy,memdc,0,0,SRCCOPY);
	}
};

void TextEdit_DrawBuffer(HDC hdc,int WndNum){
	int i,i2;
	int x,y;
	int BaseX,BaseY,CharX;
	char *pBuf,temporary[255];
	HWND hEdit;


	//wi[hAJ[̐ݒ
	COLORREF DefaultBackColor,CaretBackColor;
	DefaultBackColor=tci.rgbBackground;

	RECT ClientRect;
	hEdit=GetWindow(MdiInfo[WndNum]->hwnd,GW_CHILD);
	GetClientRect(hEdit,&ClientRect);

	//GfB^ʍ[̃Rg[^u
	int iControlTabSpace;
	int iLineNumberTextCount;
	iControlTabSpace=MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace;
	iLineNumberTextCount=MdiInfo[WndNum]->pMdiTextEdit->iLineNumberTextCount;

	//y[Wɕ\łs擾
	int OnePage_CharHeight;
	OnePage_CharHeight=(ClientRect.bottom/font_height)+1;

	//`pNX
	CDrawReserve obj_dr(
		WndNum,
		hdc,
		ClientRect.right-ClientRect.left,ClientRect.bottom-ClientRect.top,
		iControlTabSpace,
		OnePage_CharHeight,
		iLineNumberTextCount);


	//eLXgobt@R[hŎQƂ₷悤Ƀ|C^ϐ𗘗p
	pBuf=MdiInfo[WndNum]->pMdiTextEdit->buffer;

	//I͈͂擾
	CHARRANGE CharRange;
	TextEdit_GetSel(WndNum,&CharRange);

	//x[X`|WV擾(P)
	BaseX=0;
	BaseY=0;
	GetScrollBaseCaretPos(MdiInfo[WndNum],&BaseX,&BaseY);

	if(pobj_nv->bEditor_CaretLine_BackGround){
		//J[\s̐Fς
		CaretBackColor=tci.rgbCursorBack;
	}
	else{
		//J[\s̐FςȂ
		CaretBackColor=tci.rgbBackground;
	}
	HBRUSH hCaretBackBrush;
	hCaretBackBrush=CreateSolidBrush(CaretBackColor);

	BOOL IsStr=0;
	DWORD dwComment=0;
	BOOL bMultiLineComment;
	COLORREF NextColor,NextBackColor;
	int MaxX=0;
	x=BaseX;
	y=BaseY;
	CharX=0;	//[牽ڂ
	int bHyperLinkUnderBar=0;	//nCp[Np̕\XCb`
	for(i=0;;i++){
		if(pBuf[i]=='\0'){
			if(0<=y&&y<=OnePage_CharHeight){
				if(MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.y==y-BaseY){
					////////////////////////////////////
					// J[\sł͗]hԂ
					////////////////////////////////////

					HBRUSH hTempBrush;
					hTempBrush=(HBRUSH)SelectObject(obj_dr.memdc,hCaretBackBrush);

					//I[R[hE̓uVœhԂ
					PatBlt(obj_dr.memdc,
						x*font_width     +iControlTabSpace,
						y*font_height,
						ClientRect.right-(x*font_width     +iControlTabSpace),
						font_height,
						PATCOPY);

					//J[\s
					SelectObject(obj_dr.memdc,hTempBrush);
				}

				//sԍ[sɂ\悤ɂ邽߂ɕ`\s
				obj_dr.DrawReserve(
					x,
					y,
					NULL,
					NULL,
					bHyperLinkUnderBar,
					"",0);
			}

			if(MaxX<CharX) MaxX=CharX;

			break;
		}

		if(IsRightTurn(pBuf,i,x)){
			/////////////////
			// ܂Ԃ
			/////////////////

			if(MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.y==y-BaseY){
				///////////////////////////////////////////////////////////
				//sR[hE͔uVœhԂiJ[\spj
				///////////////////////////////////////////////////////////

				HBRUSH hTempBrush;

				//J[\s
				hTempBrush=(HBRUSH)SelectObject(obj_dr.memdc,hCaretBackBrush);

				PatBlt(obj_dr.memdc,
					x*font_width     +iControlTabSpace,
					y*font_height,
					ClientRect.right-(x*font_width     +iControlTabSpace),
					font_height,
					PATCOPY);

				//J[\s
				SelectObject(obj_dr.memdc,hTempBrush);
			}

			y++;

			x=BaseX;
			CharX=0;
			i--;
			continue;
		}

		if(MdiInfo[WndNum]->DocType==WNDTYPE_BASIC){

			if(pBuf[i]=='\"'&&dwComment==0) IsStr^=1;

			//sɓnRgl
			if( memicmp( pBuf+i, ActiveBasic::IDE::Program::ablang->GetSyntax().commentMultiBegin.c_str(), ActiveBasic::IDE::Program::ablang->GetSyntax().commentMultiBegin.size() ) == 0
				&& IsStr == 0
				&& dwComment == 0 )
			{
				// /*
				dwComment=12;
				bMultiLineComment=1;
			}
			if( memicmp( pBuf+i, ActiveBasic::IDE::Program::ablang->GetSyntax().commentMultiEnd.c_str(), ActiveBasic::IDE::Program::ablang->GetSyntax().commentMultiEnd.size() ) == 0
				&& dwComment == 10
				&& bMultiLineComment )
			{
				// */
				dwComment=3;
			}

			//PsRg
			if( memicmp( pBuf+i, ActiveBasic::IDE::Program::ablang->GetSyntax().commentSingle.c_str(), ActiveBasic::IDE::Program::ablang->GetSyntax().commentSingle.size() ) == 0
				&& dwComment == 0
				&& IsStr == 0 )
			{
				// '
				dwComment=10;
				bMultiLineComment=0;
			}

			if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
				//PsRgł̉śARg
				if(dwComment&&bMultiLineComment==0){
					IsStr=0;
					dwComment=0;
				}
			}
			if(dwComment!=0&&dwComment!=10) dwComment--;
		}
		if(MdiInfo[WndNum]->DocType==WNDTYPE_HTML){
			//sɓnRgl
			if(pBuf[i]=='<'&&pBuf[i+1]=='!'&&pBuf[i+2]=='-'&&pBuf[i+3]=='-'&&IsStr==0&&dwComment==0){
				dwComment=10;
			}
			if(pBuf[i]=='-'&&pBuf[i+1]=='-'&&pBuf[i+2]=='>'&&
				dwComment){
				dwComment=4;
			}
			if(dwComment!=0&&dwComment!=10) dwComment--;
		}

		//nCp[Np
		if(MdiInfo[WndNum]->pMdiTextEdit->iUnderStart<=i&&i<MdiInfo[WndNum]->pMdiTextEdit->iUnderEnd)
			bHyperLinkUnderBar=1;
		else bHyperLinkUnderBar=0;

		if(0<=y&&y<=OnePage_CharHeight){
			//////////////////////////////////
			// \y[Wł͕Pʂŕ`
			//////////////////////////////////
			//i2ɕ`悷镶i[

			NextBackColor=DefaultBackColor;
			if(dwComment){
				//sɓnRg
				NextColor=tci.rgbComment;
			}
			else{
				//ʏJ[
				NextColor=MdiInfo[WndNum]->pMdiTextEdit->pColorRef[i];
			}

			if(CharRange.cpMin<=i&&i<CharRange.cpMax){
				//IĂobt@͔]\
				NextColor=NextColor^0x00FFFFFF;
				NextBackColor=NextBackColor^0x00FFFFFF;
			}
			else{
				if(MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.y==y-BaseY){
					//J[\s
					NextBackColor=CaretBackColor;
				}
			}

			if(IsDBCSLeadByte(pBuf[i])){
				//}`oCg
				i2=2;
				obj_dr.DrawReserve(
					x,
					y,
					NextColor,
					NextBackColor,
					bHyperLinkUnderBar,
					pBuf+i,i2);

				i++;
			}
			else if(pBuf[i]=='\t'){
				//^u
				int tab;
				tab=pobj_nv->TabSize;

				if((x-BaseX)%tab==0) i2=tab;
				else i2=tab-(x-BaseX)%tab;
				memset(temporary,' ',i2);
				temporary[i2]=0;

				obj_dr.DrawReserve(
					x,
					y,
					NextColor,
					NextBackColor,
					bHyperLinkUnderBar,
					temporary,i2);
			}
			else if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
				//s1Xy[X󔒂`悵Ăi]\邽߁j
				i2=1;
				temporary[0]=' ';
				temporary[1]=0;
				obj_dr.DrawReserve(
					x,
					y,
					NextColor,
					NextBackColor,
					bHyperLinkUnderBar,
					temporary,i2);


				if(MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.y==y-BaseY){
					///////////////////////////////////////////////////////////
					//sR[hE͔uVœhԂiJ[\spj
					///////////////////////////////////////////////////////////

					HBRUSH hTempBrush;

					//J[\s
					hTempBrush=(HBRUSH)SelectObject(obj_dr.memdc,hCaretBackBrush);

					PatBlt(obj_dr.memdc,
						(x+i2)*font_width     +iControlTabSpace,
						y*font_height,
						ClientRect.right-((x+i2)*font_width     +iControlTabSpace),
						font_height,
						PATCOPY);

					//J[\s
					SelectObject(obj_dr.memdc,hTempBrush);
				}
			}
			else{
				//ʏ̃L
				i2=1;
				obj_dr.DrawReserve(
					x,
					y,
					NextColor,
					NextBackColor,
					bHyperLinkUnderBar,
					pBuf+i,i2);
			}
		}
		else{
			////////////////////////////////////////
			// \y[Wł͕̌vZs
			////////////////////////////////////////
			//i2ɕ`悷镶i[

			if(IsDBCSLeadByte(pBuf[i])){
				//}`oCg
				i2=2;
				i++;
			}
			else if(pBuf[i]=='\t'){
				//^u
				int tab;
				tab=pobj_nv->TabSize;

				if((x-BaseX)%tab==0) i2=tab;
				else i2=tab-(x-BaseX)%tab;
			}
			else{
				//ʏ̃Lis܂ށj
				i2=1;
			}
		}

		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
			y++;

			if(MaxX<CharX) MaxX=CharX;

			x=BaseX;
			CharX=0;

			i++;
		}
		else{
			x+=i2;
			CharX+=i2;
		}
	}

	obj_dr.finish(BaseY);

	DeleteObject(hCaretBackBrush);


	//////////////////////////////////
	// XN[o[͈̔͂Zbg
	//////////////////////////////////

	if(pobj_nv->bRightTurn){
		MaxX=0;
	}

	ResetScrollbar(WndNum,MaxX,(-BaseY)+y);
}
